/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.MavenProjectPropsImpl;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.model.io.jdom.NetbeansBuildActionJDOMWriter;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Reader;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class CustomizerProviderImpl
implements CustomizerProvider {
    private final NbMavenProjectImpl project;
    private ModelHandle handle;
    private static final String BROKEN_NBACTIONS = "BROKENNBACTIONS";
    public static ModelAccessor ACCESSOR = null;

    public CustomizerProviderImpl(NbMavenProjectImpl project) {
        this.project = project;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String preselectedCategory) {
        this.showCustomizer(preselectedCategory, null);
    }

    public void showCustomizer(String preselectedCategory, String preselectedSubCategory) {
        try {
            this.init();
            try {
                this.handle.getPOMModel().sync();
            }
            catch (IOException ex) {
                Logger.getLogger(CustomizerProviderImpl.class.getName()).log(Level.INFO, "Error while syncing the editor document with model for pom.xml file", ex);
            }
            if (!this.handle.getPOMModel().getState().equals((Object)Model.State.VALID)) {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerProviderImpl.class, (String)"ERR_MissingPOM"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                return;
            }
            this.handle.getPOMModel().startTransaction();
            ((MavenProjectPropsImpl)this.project.getLookup().lookup(MavenProjectPropsImpl.class)).startTransaction();
            OptionListener listener = new OptionListener();
            Lookup context = Lookups.fixed((Object[])new Object[]{this.project, this.handle});
            Dialog dialog = ProjectCustomizer.createCustomizerDialog((String)"Projects/org-netbeans-modules-maven/Customizer", (Lookup)context, (String)preselectedCategory, (ActionListener)listener, (ActionListener)listener, (HelpCtx)new HelpCtx("maven_settings"));
            dialog.addWindowListener(listener);
            listener.setDialog(dialog);
            dialog.setTitle(MessageFormat.format(NbBundle.getMessage(CustomizerProviderImpl.class, (String)"TIT_Project_Properties"), ProjectUtils.getInformation((Project)this.project).getDisplayName()));
            dialog.setModal(true);
            dialog.setVisible(true);
        }
        catch (FileNotFoundException ex) {
            if ("No pom file exists.".equals(ex.getMessage())) {
                return;
            }
            Logger.getLogger(CustomizerProviderImpl.class.getName()).log(Level.SEVERE, "Cannot show project customizer", ex);
        }
        catch (IOException ex) {
            Logger.getLogger(CustomizerProviderImpl.class.getName()).log(Level.SEVERE, "Cannot show project customizer", ex);
        }
        catch (XmlPullParserException ex) {
            Logger.getLogger(CustomizerProviderImpl.class.getName()).log(Level.SEVERE, "Cannot show project customizer", ex);
        }
    }

    private void init() throws XmlPullParserException, IOException {
        FileObject pom = FileUtil.toFileObject((File)this.project.getPOMFile());
        if (pom == null || !pom.isValid()) {
            throw new FileNotFoundException("No pom file exists.");
        }
        ModelSource source = Utilities.createModelSource((FileObject)pom);
        POMModel model = POMModelFactory.getDefault().getModel(source);
        HashMap<String, ActionToGoalMapping> mapps = new HashMap<String, ActionToGoalMapping>();
        NetbeansBuildActionXpp3Reader reader = new NetbeansBuildActionXpp3Reader();
        ArrayList<ModelHandle.Configuration> configs = new ArrayList<ModelHandle.Configuration>();
        ModelHandle.Configuration active = null;
        M2ConfigProvider provider = (M2ConfigProvider)this.project.getLookup().lookup(M2ConfigProvider.class);
        M2Configuration act = provider.getActiveConfiguration();
        M2Configuration defconfig = provider.getDefaultConfig();
        mapps.put(defconfig.getId(), reader.read(new StringReader(defconfig.getRawMappingsAsString())));
        ModelHandle.Configuration c = ModelHandle.createDefaultConfiguration();
        configs.add(c);
        if (act.equals(defconfig)) {
            active = c;
        }
        for (M2Configuration config : provider.getSharedConfigurations()) {
            mapps.put(config.getId(), reader.read(new StringReader(config.getRawMappingsAsString())));
            c = ModelHandle.createCustomConfiguration(config.getId());
            c.setActivatedProfiles(config.getActivatedProfiles());
            c.setShared(true);
            configs.add(c);
            if (!act.equals(config)) continue;
            active = c;
        }
        for (M2Configuration config : provider.getNonSharedConfigurations()) {
            mapps.put(config.getId(), reader.read(new StringReader(config.getRawMappingsAsString())));
            c = ModelHandle.createCustomConfiguration(config.getId());
            c.setActivatedProfiles(config.getActivatedProfiles());
            c.setShared(false);
            configs.add(c);
            if (!act.equals(config)) continue;
            active = c;
        }
        for (M2Configuration config : provider.getProfileConfigurations()) {
            mapps.put(config.getId(), reader.read(new StringReader(config.getRawMappingsAsString())));
            c = ModelHandle.createProfileConfiguration(config.getId());
            configs.add(c);
            if (!act.equals(config)) continue;
            active = c;
        }
        if (active == null) {
            active = (ModelHandle.Configuration)configs.get(0);
        }
        this.handle = ACCESSOR.createHandle(model, this.project.getOriginalMavenProject(), mapps, configs, active, this.project.getAuxProps());
    }

    public static void writeAll(ModelHandle handle, NbMavenProjectImpl project) throws IOException {
        boolean performConfigsInvokedReload = false;
        M2ConfigProvider prv = (M2ConfigProvider)project.getLookup().lookup(M2ConfigProvider.class);
        if (handle.isModified(handle.getConfigurations())) {
            ArrayList<M2Configuration> shared = new ArrayList<M2Configuration>();
            ArrayList<M2Configuration> nonshared = new ArrayList<M2Configuration>();
            for (ModelHandle.Configuration mdlConf : handle.getConfigurations()) {
                if (mdlConf.isDefault() || mdlConf.isProfileBased()) continue;
                M2Configuration c = new M2Configuration(mdlConf.getId(), project);
                c.setActivatedProfiles(mdlConf.getActivatedProfiles());
                if (mdlConf.isShared()) {
                    shared.add(c);
                    continue;
                }
                nonshared.add(c);
            }
            prv.setConfigurations(shared, nonshared, true);
            performConfigsInvokedReload = true;
        }
        Utilities.saveChanges((AbstractDocumentModel)handle.getPOMModel());
        if (handle.isModified(handle.getActionMappings())) {
            CustomizerProviderImpl.writeNbActionsModel(project, handle.getActionMappings(), M2Configuration.getFileNameExt("%%DEFAULT%%"));
        }
        String id = handle.getActiveConfiguration() != null ? handle.getActiveConfiguration().getId() : "%%DEFAULT%%";
        for (M2Configuration m2 : prv.getConfigurations()) {
            if (!id.equals(m2.getId())) continue;
            prv.setActiveConfiguration(m2);
        }
        for (ModelHandle.Configuration c : handle.getConfigurations()) {
            if (!handle.isModified(handle.getActionMappings(c))) continue;
            CustomizerProviderImpl.writeNbActionsModel(project, handle.getActionMappings(c), M2Configuration.getFileNameExt(c.getId()));
        }
        if (performConfigsInvokedReload) {
            NbMavenProject.fireMavenProjectReload(project);
        }
    }

    public static void writeNbActionsModel(FileObject pomDir, ActionToGoalMapping mapping, String path) throws IOException {
        CustomizerProviderImpl.writeNbActionsModel(null, pomDir, mapping, path);
    }

    public static void writeNbActionsModel(Project project, ActionToGoalMapping mapping, String path) throws IOException {
        CustomizerProviderImpl.writeNbActionsModel(project, project.getProjectDirectory(), mapping, path);
    }

    private static void writeNbActionsModel(final Project project, final FileObject pomDir, final ActionToGoalMapping mapping, final String path) throws IOException {
        pomDir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                DefaultJDOMFactory factory = new DefaultJDOMFactory();
                InputStream inStr = null;
                FileLock lock = null;
                OutputStreamWriter outStr = null;
                try {
                    Document doc;
                    FileObject fo = pomDir.getFileObject(path);
                    if (fo == null) {
                        fo = pomDir.createData(path);
                        doc = factory.document(factory.element("actions"));
                    } else {
                        inStr = fo.getInputStream();
                        SAXBuilder builder = new SAXBuilder();
                        doc = builder.build(inStr);
                        inStr.close();
                        inStr = null;
                    }
                    lock = fo.lock();
                    NetbeansBuildActionJDOMWriter writer = new NetbeansBuildActionJDOMWriter();
                    String encoding = mapping.getModelEncoding() != null ? mapping.getModelEncoding() : "UTF-8";
                    outStr = new OutputStreamWriter(fo.getOutputStream(lock), encoding);
                    Format form = Format.getRawFormat().setEncoding(encoding);
                    form = form.setLineSeparator(System.getProperty("line.separator"));
                    List<NetbeansActionMapping> maps = mapping.getActions();
                    for (NetbeansActionMapping m : maps) {
                        m.setPackagings(null);
                    }
                    writer.write(mapping, doc, outStr, form);
                }
                catch (JDOMException exc) {
                    try {
                        ProblemReporterImpl impl;
                        ProblemReporterImpl problemReporterImpl = impl = project != null ? (ProblemReporterImpl)project.getLookup().lookup(ProblemReporterImpl.class) : null;
                        if (impl != null && !impl.hasReportWithId(CustomizerProviderImpl.BROKEN_NBACTIONS)) {
                            ProblemReport rep = new ProblemReport(5, NbBundle.getMessage(CustomizerProviderImpl.class, (String)"TXT_Problem_Broken_Actions"), NbBundle.getMessage(CustomizerProviderImpl.class, (String)"DESC_Problem_Broken_Actions", (Object)exc.getMessage()), new OpenActions(pomDir.getFileObject(path)));
                            rep.setId(CustomizerProviderImpl.BROKEN_NBACTIONS);
                            impl.addReport(rep);
                        }
                        Logger.getLogger(CustomizerProviderImpl.class.getName()).log(Level.INFO, exc.getMessage(), exc);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(inStr);
                        IOUtil.close(outStr);
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        throw throwable;
                    }
                    IOUtil.close((InputStream)inStr);
                    IOUtil.close(outStr);
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
                IOUtil.close((InputStream)inStr);
                IOUtil.close((Writer)outStr);
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        });
    }

    static {
        Class<ModelHandle> c = ModelHandle.class;
        try {
            Class.forName(c.getName(), true, c.getClassLoader());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class OpenActions
    extends AbstractAction {
        private FileObject fo;

        OpenActions(FileObject file) {
            this.putValue("Name", NbBundle.getMessage(CustomizerProviderImpl.class, (String)"TXT_OPEN_FILE"));
            this.fo = file;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.fo != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)this.fo);
                    EditCookie edit = (EditCookie)dobj.getCookie(EditCookie.class);
                    edit.edit();
                }
                catch (DataObjectNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    static interface SubCategoryProvider {
        public void showSubCategory(String var1);
    }

    private class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private Dialog dialog;
        private boolean weAreSaving = false;

        OptionListener() {
        }

        void setDialog(Dialog dlg) {
            this.dialog = dlg;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SwingUtilities.isEventDispatchThread()) {
                if (this.dialog != null) {
                    this.dialog.setVisible(false);
                    this.dialog.dispose();
                    this.dialog = null;
                    this.weAreSaving = true;
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CustomizerProviderImpl.this.handle.getPOMModel().isIntransaction()) {
                            if (CustomizerProviderImpl.this.handle.isModified(CustomizerProviderImpl.this.handle.getPOMModel())) {
                                CustomizerProviderImpl.this.handle.getPOMModel().endTransaction();
                            } else {
                                CustomizerProviderImpl.this.handle.getPOMModel().rollbackTransaction();
                            }
                        }
                        try {
                            CustomizerProviderImpl.this.project.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                                public void run() throws IOException {
                                    ((MavenProjectPropsImpl)CustomizerProviderImpl.this.project.getLookup().lookup(MavenProjectPropsImpl.class)).commitTransaction();
                                    CustomizerProviderImpl.writeAll(CustomizerProviderImpl.this.handle, CustomizerProviderImpl.this.project);
                                }
                            });
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (!this.weAreSaving) {
                ((MavenProjectPropsImpl)CustomizerProviderImpl.this.project.getLookup().lookup(MavenProjectPropsImpl.class)).cancelTransaction();
                if (CustomizerProviderImpl.this.handle.getPOMModel().isIntransaction()) {
                    CustomizerProviderImpl.this.handle.getPOMModel().rollbackTransaction();
                }
                assert (!CustomizerProviderImpl.this.handle.getPOMModel().isIntransaction());
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (this.dialog != null) {
                this.dialog.setVisible(false);
                this.dialog.dispose();
                this.dialog = null;
            }
        }
    }

    public static abstract class ModelAccessor {
        public abstract ModelHandle createHandle(POMModel var1, MavenProject var2, Map<String, ActionToGoalMapping> var3, List<ModelHandle.Configuration> var4, ModelHandle.Configuration var5, MavenProjectPropsImpl var6);
    }
}

