/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.configurations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class M2Configuration
extends AbstractMavenActionsProvider
implements ProjectConfiguration,
Comparable<M2Configuration> {
    public static final String DEFAULT = "%%DEFAULT%%";
    @NonNull
    private final String id;
    private List<String> profiles;
    private final NbMavenProjectImpl project;
    public static final String FILENAME = "nbactions.xml";
    public static final String FILENAME_PREFIX = "nbactions-";
    public static final String FILENAME_SUFFIX = ".xml";
    private Date lastModified = new Date();
    private boolean lastTimeExists = true;
    private final Map<String, String> properties = new HashMap<String, String>();

    static M2Configuration createDefault(NbMavenProjectImpl prj) {
        return new M2Configuration(DEFAULT, prj);
    }

    public M2Configuration(String id, NbMavenProjectImpl proj) {
        assert (id != null);
        this.id = id;
        this.project = proj;
        this.profiles = Collections.emptyList();
    }

    public String getDisplayName() {
        if (DEFAULT.equals(this.id)) {
            return NbBundle.getMessage(M2Configuration.class, (String)"TXT_DefaultConfig");
        }
        return this.id;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public void setActivatedProfiles(List<String> profs) {
        this.profiles = profs;
    }

    public List<String> getActivatedProfiles() {
        return this.profiles;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static String getFileNameExt(String id) {
        if (DEFAULT.equals(id)) {
            return FILENAME;
        }
        return FILENAME_PREFIX + id + FILENAME_SUFFIX;
    }

    public boolean equals(Object obj) {
        return obj instanceof M2Configuration && this.id.equals(((M2Configuration)obj).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }

    @Override
    public int compareTo(M2Configuration o) {
        return this.id.compareTo(o.id);
    }

    @Override
    public InputStream getActionDefinitionStream() {
        FileObject fo = this.project.getProjectDirectory().getFileObject(M2Configuration.getFileNameExt(this.id));
        boolean bl = this.lastTimeExists = fo != null;
        if (fo != null) {
            try {
                this.lastModified = fo.lastModified();
                return fo.getInputStream();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        this.lastModified = new Date();
        return null;
    }

    public NetbeansActionMapping[] getCustomMappings() {
        NetbeansActionMapping[] fallbackActions = new NetbeansActionMapping[]{};
        try {
            ArrayList<NetbeansActionMapping> toRet = new ArrayList<NetbeansActionMapping>();
            Reader read = this.performDynamicSubstitutions(Collections.<String, String>emptyMap(), this.getRawMappingsAsString());
            ActionToGoalMapping mapping = this.reader.read(read);
            for (NetbeansActionMapping mapp : mapping.getActions()) {
                if (!mapp.getActionName().startsWith("CUSTOM-")) continue;
                toRet.add(mapp);
            }
            return toRet.toArray(new NetbeansActionMapping[toRet.size()]);
        }
        catch (XmlPullParserException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return fallbackActions;
    }

    @Override
    protected boolean reloadStream() {
        FileObject fo = this.project.getProjectDirectory().getFileObject(M2Configuration.getFileNameExt(this.id));
        boolean prevExists = this.lastTimeExists;
        this.lastTimeExists = fo != null;
        return fo == null && prevExists || fo != null && fo.lastModified().after(this.lastModified);
    }
}

