/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.embedder.ArtifactFixer;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.openide.util.Exceptions;
import org.sonatype.aether.artifact.Artifact;

public class NbArtifactFixer
implements ArtifactFixer {
    public static final String FALLBACK_NAME = "F@LLB@CK";
    private static Map<String, File> fallbackPOMs = new HashMap<String, File>();

    public File resolve(Artifact artifact) {
        NbMavenProjectImpl mavenProject;
        if (!artifact.getExtension().equals("pom")) {
            return null;
        }
        if (!artifact.getClassifier().isEmpty()) {
            return null;
        }
        ArtifactRepository local = EmbedderFactory.getProjectEmbedder().getLocalRepository();
        if (local.getLayout() != null && new File(local.getBasedir(), local.pathOf((org.apache.maven.artifact.Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), null, artifact.getExtension(), artifact.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler(artifact.getExtension())))).exists()) {
            return null;
        }
        Project owner = MavenFileOwnerQueryImpl.getInstance().getOwner(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        if (owner != null && (mavenProject = (NbMavenProjectImpl)owner.getLookup().lookup(NbMavenProjectImpl.class)) != null) {
            return mavenProject.getPOMFile();
        }
        try {
            return NbArtifactFixer.createFallbackPOM(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        }
        catch (IOException x) {
            Exceptions.printStackTrace((Throwable)x);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized File createFallbackPOM(String groupId, String artifactId, String version) throws IOException {
        String k = groupId + ':' + artifactId + ':' + version;
        File fallbackPOM = fallbackPOMs.get(k);
        if (fallbackPOM == null) {
            fallbackPOM = File.createTempFile("fallback", ".pom");
            fallbackPOM.deleteOnExit();
            PrintWriter w = new PrintWriter(fallbackPOM);
            try {
                w.println("<project>");
                w.println("<modelVersion>4.0.0</modelVersion>");
                w.println("<groupId>" + groupId + "</groupId>");
                w.println("<artifactId>" + artifactId + "</artifactId>");
                w.println("<packaging>pom</packaging>");
                w.println("<version>" + version + "</version>");
                w.println("<name>F@LLB@CK</name>");
                w.println("</project>");
                w.flush();
            }
            finally {
                w.close();
            }
            fallbackPOMs.put(k, fallbackPOM);
        }
        return fallbackPOM;
    }
}

