/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.binding;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeKind;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.ObjectProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.Validator;
import org.jdesktop.beansbinding.ext.BeanAdapterFactory;
import org.jdesktop.swingbinding.JComboBoxBinding;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.form.BindingDescriptor;
import org.netbeans.modules.form.BindingDesignSupport;
import org.netbeans.modules.form.BindingProperty;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaBinding;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.modules.nbform.project.ClassSourceResolver;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class BindingDesignSupportImpl
implements BindingDesignSupport {
    private FormModel formModel;
    private Map<MetaBinding, List<Binding>> bindingsMap = new HashMap<MetaBinding, List<Binding>>();
    private Map<MetaBinding, Binding> modelBindings = new HashMap<MetaBinding, Binding>();
    private Map<Binding, BindingGroup> bindingToGroup = new HashMap<Binding, BindingGroup>();
    private BindingGroup bindingGroup;

    BindingDesignSupportImpl(FormModel model) {
        this.formModel = model;
        this.bindingGroup = new BindingGroup();
        this.bindingGroup.bind();
        this.formModel.addFormModelListener((FormModelListener)new ModelListener());
    }

    private void changeBinding(MetaBinding oldBinding, MetaBinding newBinding) {
        if (oldBinding != null) {
            this.removeBindings(oldBinding);
        }
    }

    public void changeBindingInModel(MetaBinding oldBinding, MetaBinding newBinding) {
        if (oldBinding != null) {
            this.removeBindingInModel(oldBinding);
        }
        if (newBinding != null) {
            this.addBindingInModel(newBinding);
        }
    }

    public String elWrap(String path) {
        return path == null ? null : "${" + path + "}";
    }

    public boolean isSimpleExpression(String expression) {
        return BindingDesignSupportImpl.isSimpleExpression0(expression);
    }

    private static boolean isSimpleExpression0(String expression) {
        return expression.startsWith("${") && expression.endsWith("}");
    }

    public String unwrapSimpleExpression(String expression) {
        return BindingDesignSupportImpl.unwrapSimpleExpression0(expression);
    }

    private static String unwrapSimpleExpression0(String expression) {
        if (BindingDesignSupportImpl.isSimpleExpression0(expression)) {
            expression = expression.substring(2, expression.length() - 1);
        }
        return expression;
    }

    private static boolean hasRelativeType(Class clazz, String property) {
        return ("elements".equals(property) || property.startsWith("selectedElement")) && (JTable.class.isAssignableFrom(clazz) || JList.class.isAssignableFrom(clazz)) || "selectedItem".equals(property) && JComboBox.class.isAssignableFrom(clazz);
    }

    public List<BindingDescriptor>[] getBindingDescriptors(RADComponent component) {
        BeanDescriptor beanDescriptor = component.getBeanInfo().getBeanDescriptor();
        List<BindingDescriptor>[] descs = this.getBindingDescriptors(null, beanDescriptor, false);
        Class beanClass = component.getBeanClass();
        if (JTextComponent.class.isAssignableFrom(beanClass)) {
            descs[0] = this.filterDescriptors(descs[0], "text_");
        } else if (JTable.class.isAssignableFrom(beanClass) || JList.class.isAssignableFrom(beanClass) || JComboBox.class.isAssignableFrom(beanClass)) {
            descs[0] = this.filterDescriptors(descs[0], "selectedElement_");
            descs[0] = this.filterDescriptors(descs[0], "selectedElements_");
            BindingDescriptor desc = new BindingDescriptor("elements", List.class);
            descs[0].add(0, desc);
        } else if (JSlider.class.isAssignableFrom(beanClass)) {
            descs[0] = this.filterDescriptors(descs[0], "value_");
        }
        return descs;
    }

    private List<BindingDescriptor> filterDescriptors(List<BindingDescriptor> descs, String forbiddenPrefix) {
        LinkedList<BindingDescriptor> filtered = new LinkedList<BindingDescriptor>();
        for (BindingDescriptor bd : descs) {
            if (bd.getPath().startsWith(forbiddenPrefix)) continue;
            filtered.add(bd);
        }
        return filtered;
    }

    private List<PropertyDescriptor> getSpecialBindingDescriptors(Class clazz) {
        List descs = BeanAdapterFactory.getAdapterPropertyDescriptors((Class)clazz);
        try {
            if (JComboBox.class.isAssignableFrom(clazz)) {
                PropertyDescriptor desc = new PropertyDescriptor("selectedItem", JComboBox.class);
                descs.add(desc);
            } else if (JSpinner.class.isAssignableFrom(clazz)) {
                PropertyDescriptor desc = new PropertyDescriptor("value", JSpinner.class);
                descs.add(desc);
            } else if (JFormattedTextField.class.isAssignableFrom(clazz)) {
                for (PropertyDescriptor pd : descs) {
                    if (!"text".equals(pd.getName())) continue;
                    descs.remove(pd);
                    break;
                }
                PropertyDescriptor desc = new PropertyDescriptor("value", JFormattedTextField.class);
                descs.add(desc);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
        }
        return descs;
    }

    private List<BindingDescriptor>[] getBindingDescriptors(FormUtils.TypeHelper type, BeanDescriptor beanDescriptor, boolean includeReadOnly) {
        PropertyDescriptor[] pds;
        Class<?> beanClass = beanDescriptor.getBeanClass();
        LinkedList<BindingDescriptor> bindingList = new LinkedList<BindingDescriptor>();
        LinkedList prefList = new LinkedList();
        LinkedList observableList = new LinkedList();
        LinkedList nonObservableList = new LinkedList();
        Object[] propsCats = FormUtils.getPropertiesCategoryClsf(beanClass, (BeanDescriptor)beanDescriptor);
        try {
            pds = FormUtils.getBeanInfo(beanClass).getPropertyDescriptors();
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
            pds = new PropertyDescriptor[]{};
        }
        List<PropertyDescriptor> specialPds = this.getSpecialBindingDescriptors(beanClass);
        HashMap<String, PropertyDescriptor> pathToDesc = new HashMap<String, PropertyDescriptor>();
        if (Utilities.isMac()) {
            try {
                for (PropertyDescriptor pd : FormUtils.getBeanInfo(beanClass, (int)3).getPropertyDescriptors()) {
                    pathToDesc.put(pd.getName(), pd);
                }
            }
            catch (IntrospectionException iex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, iex.getMessage(), iex);
            }
        }
        for (PropertyDescriptor pd : pds) {
            pathToDesc.put(pd.getName(), pd);
        }
        for (PropertyDescriptor pd : specialPds) {
            if (pathToDesc.get(pd.getName()) == null) continue;
            pathToDesc.remove(pd.getName());
        }
        LinkedList<PropertyDescriptor> allPds = new LinkedList<PropertyDescriptor>(specialPds);
        allPds.addAll(pathToDesc.values());
        int count = 0;
        for (PropertyDescriptor pd : allPds) {
            BindingDescriptor bd;
            Type retType;
            Method method;
            LinkedList<Object> list;
            if (count++ < specialPds.size()) {
                list = bindingList;
            } else {
                Object propCat;
                if (!includeReadOnly && pd.getWriteMethod() == null || (propCat = FormUtils.getPropertyCategory((FeatureDescriptor)pd, (Object[])propsCats)) == FormUtils.PROP_HIDDEN) continue;
                list = pd.isBound() ? (propCat == FormUtils.PROP_PREFERRED ? prefList : observableList) : nonObservableList;
            }
            if ((method = pd.getReadMethod()) != null && "getClass".equals(method.getName()) || (retType = method == null ? pd.getPropertyType() : method.getGenericReturnType()) == null) continue;
            if (type == null) {
                bd = new BindingDescriptor(pd.getName(), retType);
            } else {
                FormUtils.TypeHelper t = new FormUtils.TypeHelper(retType, type.getActualTypeArgs()).normalize();
                bd = new BindingDescriptor(pd.getName(), t);
            }
            bd.setDisplayName(pd.getDisplayName());
            bd.setShortDescription(pd.getShortDescription());
            if (BindingDesignSupportImpl.hasRelativeType(beanClass, bd.getPath())) {
                bd.markTypeAsRelative();
            }
            list.add(bd);
        }
        if (bindingList.isEmpty()) {
            bindingList = prefList;
        } else {
            observableList.addAll(prefList);
        }
        Comparator<BindingDescriptor> bdComparator = new Comparator<BindingDescriptor>(){

            @Override
            public int compare(BindingDescriptor o1, BindingDescriptor o2) {
                String path1 = o1.getPath();
                String path2 = o2.getPath();
                return path1.compareToIgnoreCase(path2);
            }
        };
        Collections.sort(bindingList, bdComparator);
        Collections.sort(observableList, bdComparator);
        Collections.sort(nonObservableList, bdComparator);
        return new List[]{bindingList, observableList, nonObservableList};
    }

    public List<BindingDescriptor> getAllBindingDescriptors(FormUtils.TypeHelper type) {
        List<BindingDescriptor>[] descs = this.getBindingDescriptors(type);
        LinkedList<BindingDescriptor> list = new LinkedList<BindingDescriptor>();
        for (int i = 0; i < descs.length; ++i) {
            list.addAll(descs[i]);
        }
        return list;
    }

    public List<BindingDescriptor>[] getBindingDescriptors(FormUtils.TypeHelper type) {
        Class clazz;
        List<BindingDescriptor> typesFromSource = Collections.emptyList();
        Class binarySuperClass = null;
        if (type.getType() == null) {
            FileObject fileInProject = FormEditor.getFormDataObject((FormModel)this.formModel).getPrimaryFile();
            ClassPath cp = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/source");
            final LinkedList<BindingDescriptor> types = new LinkedList<BindingDescriptor>();
            final String[] superClass = new String[]{type.getName()};
            do {
                String typeName = superClass[0];
                final String resourceName = typeName.replace('.', '/') + ".java";
                int lastDot = typeName.lastIndexOf(46);
                lastDot = lastDot == -1 ? 0 : lastDot;
                final String simpleTypeName = typeName.substring(lastDot + 1);
                FileObject fob = cp.findResource(resourceName);
                if (fob == null) {
                    try {
                        binarySuperClass = ClassPathUtils.loadClass((String)typeName, (FileObject)fileInProject);
                    }
                    catch (ClassNotFoundException cnfex) {}
                    break;
                }
                JavaSource source = JavaSource.forFileObject((FileObject)fob);
                try {
                    source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                        public void run(CompilationController cc) throws Exception {
                            cc.toPhase(JavaSource.Phase.RESOLVED);
                            CompilationUnitTree cu = cc.getCompilationUnit();
                            ClassTree clazz = null;
                            for (Tree tree : cu.getTypeDecls()) {
                                ClassTree candidate;
                                if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !(candidate = (ClassTree)tree).getSimpleName().toString().equals(simpleTypeName)) continue;
                                clazz = candidate;
                                break;
                            }
                            if (clazz == null) {
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "ClassTree not found in {0}", resourceName);
                                superClass[0] = Object.class.getName();
                                return;
                            }
                            for (Tree tree : clazz.getMembers()) {
                                FormUtils.TypeHelper type;
                                String propName;
                                Set<Modifier> modifiers;
                                MethodTree method;
                                if (tree.getKind() != Tree.Kind.METHOD || !(method = (MethodTree)tree).getParameters().isEmpty() || (modifiers = method.getModifiers().getFlags()).contains((Object)Modifier.STATIC) || !modifiers.contains((Object)Modifier.PUBLIC)) continue;
                                String methodName = method.getName().toString();
                                Tree returnType = method.getReturnType();
                                if (methodName.startsWith("get")) {
                                    propName = methodName.substring(3);
                                } else {
                                    if (!methodName.startsWith("is") || returnType.getKind() != Tree.Kind.PRIMITIVE_TYPE || ((PrimitiveTypeTree)returnType).getPrimitiveTypeKind() != TypeKind.BOOLEAN) continue;
                                    propName = methodName.substring(2);
                                }
                                if (propName.length() == 0) continue;
                                if (propName.length() == 1 || Character.isLowerCase(propName.charAt(1))) {
                                    propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
                                }
                                if (returnType.getKind() == Tree.Kind.PRIMITIVE_TYPE) {
                                    PrimitiveTypeTree ptree = (PrimitiveTypeTree)returnType;
                                    if (ptree.getPrimitiveTypeKind() == TypeKind.VOID) continue;
                                    type = new FormUtils.TypeHelper(ptree.toString());
                                } else {
                                    type = BindingDesignSupportImpl.treeToType(cc, returnType, BindingDesignSupportImpl.this.formModel);
                                }
                                types.add(0, new BindingDescriptor(propName, type));
                            }
                            Tree superTree = clazz.getExtendsClause();
                            FormUtils.TypeHelper typeHelper = BindingDesignSupportImpl.treeToType(cc, superTree, BindingDesignSupportImpl.this.formModel);
                            String typeName = typeHelper.getName();
                            superClass[0] = typeName == null ? FormUtils.typeToClass((FormUtils.TypeHelper)typeHelper).getName() : typeName;
                        }

                        public void cancel() {
                        }
                    }, true);
                }
                catch (IOException ioex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, ioex.getMessage(), ioex);
                }
            } while (!Object.class.getName().equals(superClass[0]));
            typesFromSource = types;
        }
        List[] list = new List[]{Collections.emptyList(), typesFromSource, Collections.emptyList()};
        Class clazz2 = clazz = type.getType() == null ? binarySuperClass : FormUtils.typeToClass((FormUtils.TypeHelper)type);
        if (!(clazz == null || clazz.getName().startsWith("java.lang.") || Collection.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.isArray())) {
            try {
                BeanInfo beanInfo = FormUtils.getBeanInfo((Class)clazz);
                List<BindingDescriptor>[] typesFromBinary = this.getBindingDescriptors(type, beanInfo.getBeanDescriptor(), true);
                Map[] maps = new Map[3];
                for (int i = 0; i < 3; ++i) {
                    maps[i] = BindingDesignSupportImpl.listToMap(typesFromBinary[i]);
                }
                for (BindingDescriptor descriptor : typesFromSource) {
                    int i;
                    String path = descriptor.getPath();
                    for (i = 0; i < 3 && !maps[i].containsKey(path); ++i) {
                    }
                    if (i == 3) {
                        i = 1;
                    }
                    maps[i].put(path, descriptor);
                }
                for (int i = 0; i < 3; ++i) {
                    list[i] = new LinkedList(maps[i].values());
                }
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
            }
        }
        return list;
    }

    private static FormUtils.TypeHelper treeToType(CompilationController cc, Tree tree, FormModel model) {
        String typeName = Object.class.getName();
        HashMap<String, FormUtils.TypeHelper> map = null;
        if (tree != null) {
            TreePath path;
            Element el;
            CompilationUnitTree cu = cc.getCompilationUnit();
            Trees trees = cc.getTrees();
            if (tree.getKind() == Tree.Kind.EXTENDS_WILDCARD) {
                tree = ((WildcardTree)tree).getBound();
            }
            if ((el = trees.getElement(path = trees.getPath(cu, tree))) != null && (el.getKind() == ElementKind.CLASS || el.getKind() == ElementKind.INTERFACE)) {
                TypeElement tel = (TypeElement)el;
                typeName = tel.getQualifiedName().toString();
                if (tree.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                    List<? extends Tree> params = ((ParameterizedTypeTree)tree).getTypeArguments();
                    List<? extends TypeParameterElement> elems = tel.getTypeParameters();
                    map = new HashMap<String, FormUtils.TypeHelper>();
                    for (int i = 0; i < params.size() && i < elems.size(); ++i) {
                        Tree param = params.get(0);
                        FormUtils.TypeHelper paramType = BindingDesignSupportImpl.treeToType(cc, param, model);
                        TypeParameterElement elem = elems.get(0);
                        map.put(elem.toString(), paramType);
                    }
                }
            }
        }
        FormUtils.TypeHelper type = new FormUtils.TypeHelper(typeName, map);
        if (typeName.indexOf(46) != -1) {
            try {
                Class clazz = FormUtils.loadClass((String)typeName, (FormModel)model);
                type = new FormUtils.TypeHelper((Type)clazz, map);
            }
            catch (ClassNotFoundException cnfex) {
                // empty catch block
            }
        }
        return type;
    }

    private static Map<String, BindingDescriptor> listToMap(List<BindingDescriptor> list) {
        TreeMap<String, BindingDescriptor> map = new TreeMap<String, BindingDescriptor>();
        for (BindingDescriptor descriptor : list) {
            String path = descriptor.getPath();
            map.put(path, descriptor);
        }
        return map;
    }

    public FormUtils.TypeHelper determineType(RADComponent comp) {
        FormUtils.TypeHelper type;
        if (comp.getFormModel().getTopRADComponent() == comp) {
            FileObject fob = FormEditor.getFormDataObject((FormModel)comp.getFormModel()).getPrimaryFile();
            ClassPath cp = ClassPath.getClassPath((FileObject)fob, (String)"classpath/source");
            String className = cp.getResourceName(fob, '.', false);
            type = new FormUtils.TypeHelper(className);
        } else {
            Class clazz;
            Class t = null;
            HashMap<String, FormUtils.TypeHelper> newMap = null;
            t = clazz = comp.getBeanClass();
            if (clazz.getTypeParameters().length == 1) {
                try {
                    FormUtils.TypeHelper elemType = BindingDesignSupportImpl.determineTypeParameter(comp);
                    if (elemType != null) {
                        newMap = new HashMap<String, FormUtils.TypeHelper>();
                        newMap.put(clazz.getTypeParameters()[0].getName(), elemType);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                }
            }
            type = new FormUtils.TypeHelper((Type)t, newMap);
        }
        return type;
    }

    static FormUtils.TypeHelper determineTypeParameter(final RADComponent comp) {
        FormUtils.TypeHelper[] result;
        block7: {
            Class clazz;
            FileObject fob = FormEditor.getFormDataObject((FormModel)comp.getFormModel()).getPrimaryFile();
            JavaSource source = JavaSource.forFileObject((FileObject)fob);
            final String varName = comp.getName();
            result = new FormUtils.TypeHelper[1];
            try {
                source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        ParameterizedTypeTree parameterizedTypeTree;
                        List<? extends Tree> args;
                        Tree type;
                        cc.toPhase(JavaSource.Phase.RESOLVED);
                        CompilationUnitTree cu = cc.getCompilationUnit();
                        ClassTree clazz = null;
                        for (Tree tree : cu.getTypeDecls()) {
                            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                            clazz = (ClassTree)tree;
                            break;
                        }
                        Node.Property prop = comp.getSyntheticProperty("useLocalVariable");
                        Object object = prop.getValue();
                        VariableTree variable = null;
                        if (Boolean.TRUE.equals(object)) {
                            for (Tree tree : clazz.getMembers()) {
                                MethodTree method;
                                String methodName;
                                if (tree.getKind() != Tree.Kind.METHOD || !"initComponents".equals(methodName = (method = (MethodTree)tree).getName().toString())) continue;
                                for (StatementTree statementTree : method.getBody().getStatements()) {
                                    VariableTree var;
                                    if (statementTree.getKind() != Tree.Kind.VARIABLE || !varName.equals((var = (VariableTree)statementTree).getName().toString())) continue;
                                    variable = var;
                                }
                            }
                        } else {
                            for (Tree tree : clazz.getMembers()) {
                                VariableTree var;
                                if (tree.getKind() != Tree.Kind.VARIABLE || !varName.equals((var = (VariableTree)tree).getName().toString())) continue;
                                variable = var;
                            }
                        }
                        if (variable != null && (type = variable.getType()).getKind() == Tree.Kind.PARAMETERIZED_TYPE && (args = (parameterizedTypeTree = (ParameterizedTypeTree)type).getTypeArguments()).size() == 1) {
                            Tree tree = args.get(0);
                            result[0] = BindingDesignSupportImpl.treeToType(cc, tree, comp.getFormModel());
                        }
                    }

                    public void cancel() {
                    }
                }, true);
            }
            catch (IOException ioex) {
                Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, ioex.getMessage(), ioex);
            }
            if (result[0] == null && (clazz = comp.getBeanClass()).getTypeParameters().length == 1) {
                try {
                    String type;
                    Object value = comp.getSyntheticProperty("typeParameters").getValue();
                    if (!(value instanceof String) || !(type = (String)value).startsWith("<")) break block7;
                    type = type.substring(1, type.length() - 1);
                    HashMap<String, FormUtils.TypeHelper> newMap = new HashMap<String, FormUtils.TypeHelper>();
                    try {
                        Class elemType = ClassPathUtils.loadClass((String)type, (FileObject)FormEditor.getFormDataObject((FormModel)comp.getFormModel()).getFormFile());
                        newMap.put(clazz.getTypeParameters()[0].getName(), new FormUtils.TypeHelper((Type)elemType));
                    }
                    catch (ClassNotFoundException cnfex) {
                        newMap.put(clazz.getTypeParameters()[0].getName(), new FormUtils.TypeHelper(type));
                    }
                    result[0] = new FormUtils.TypeHelper(type, newMap);
                }
                catch (Exception ex) {
                    Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                }
            }
        }
        return result[0];
    }

    public FormUtils.TypeHelper determineType(RADComponent comp, String sourcePath) {
        String[] path = BindingDesignSupportImpl.parsePath(sourcePath);
        FormUtils.TypeHelper type = this.determineType(comp);
        for (int i = 0; i < path.length; ++i) {
            String pathItem = path[i];
            List<BindingDescriptor> descriptors = this.getAllBindingDescriptors(type);
            BindingDescriptor descriptor = BindingDesignSupportImpl.findDescriptor(descriptors, pathItem);
            if (descriptor == null) {
                return new FormUtils.TypeHelper();
            }
            type = descriptor.getGenericValueType();
            if (type != null || !JTable.class.isAssignableFrom(comp.getBeanClass()) && !JList.class.isAssignableFrom(comp.getBeanClass()) && !JComboBox.class.isAssignableFrom(comp.getBeanClass())) continue;
            MetaBinding binding = comp.getBindingProperty("elements").getValue();
            if (binding != null) {
                RADComponent subComp = binding.getSource();
                String subSourcePath = binding.getSourcePath();
                subSourcePath = subSourcePath == null ? null : this.unwrapSimpleExpression(subSourcePath);
                FormUtils.TypeHelper t = this.determineType(subComp, subSourcePath);
                if (JComboBox.class.isAssignableFrom(comp.getBeanClass())) {
                    if (!"selectedItem".equals(pathItem)) continue;
                    type = t.typeOfElement();
                    continue;
                }
                if ("selectedElement".equals(pathItem) || pathItem.startsWith("selectedElement_")) {
                    type = t.typeOfElement();
                    continue;
                }
                if (!pathItem.startsWith("selectedElements") && !"elements".equals(pathItem)) continue;
                type = t;
                continue;
            }
            type = new FormUtils.TypeHelper();
        }
        return type;
    }

    private static BindingDescriptor findDescriptor(List<BindingDescriptor> descriptors, String path) {
        for (BindingDescriptor descriptor : descriptors) {
            if (!descriptor.getPath().equals(path)) continue;
            return descriptor;
        }
        return null;
    }

    private static String[] parsePath(String path) {
        int index;
        if (path == null) {
            return new String[0];
        }
        LinkedList<String> pathItems = new LinkedList<String>();
        while ((index = path.indexOf(46)) != -1) {
            pathItems.add(path.substring(0, index));
            path = path.substring(index + 1);
        }
        pathItems.add(path);
        return pathItems.toArray(new String[pathItems.size()]);
    }

    void establishUpdatedBindings(RADComponent metacomp, boolean recursive, Map map, BindingGroup group, boolean inModel) {
        for (MetaBinding bindingDef : BindingDesignSupportImpl.collectBindingDefs(metacomp, recursive)) {
            Object target;
            RADComponent sourceComp = bindingDef.getSource();
            RADComponent targetComp = bindingDef.getTarget();
            if (!sourceComp.isInModel() || !targetComp.isInModel()) continue;
            if (inModel) {
                this.addBindingInModel(bindingDef);
                continue;
            }
            Object source = null;
            if (map != null) {
                source = map.get(sourceComp.getId());
            }
            if (source == null) {
                source = sourceComp.getBeanInstance();
            }
            Object object = target = map != null ? map.get(targetComp.getId()) : targetComp.getBeanInstance();
            if (source == null || target == null) continue;
            this.addBinding(bindingDef, source, target, group, false);
        }
    }

    static void establishOneOffBindings(RADComponent metacomp, boolean recursive, Map map, BindingGroup group) {
        for (MetaBinding bindingDef : BindingDesignSupportImpl.collectBindingDefs(metacomp, recursive)) {
            Object target;
            RADComponent sourceComp = bindingDef.getSource();
            RADComponent targetComp = bindingDef.getTarget();
            Object source = null;
            if (map != null) {
                source = map.get(sourceComp.getId());
            }
            if (source == null) {
                source = sourceComp.getBeanInstance();
            }
            Object object = target = map != null ? map.get(targetComp.getId()) : targetComp.getBeanInstance();
            if (source == null || target == null) continue;
            BindingDesignSupportImpl.createBinding(bindingDef, source, target, group, null);
        }
    }

    private void releaseBindings(RADComponent metacomp, boolean recursive) {
        for (MetaBinding bindingDef : BindingDesignSupportImpl.collectBindingDefs(metacomp, recursive)) {
            this.removeBindings(bindingDef);
        }
    }

    private static Collection<MetaBinding> collectBindingDefs(RADComponent metacomp, boolean recursive) {
        Collection<MetaBinding> col = BindingDesignSupportImpl.collectBindingDefs(metacomp, recursive, null);
        if (col == null) {
            col = Collections.emptyList();
        }
        return col;
    }

    private static Collection<MetaBinding> collectBindingDefs(RADComponent metacomp, boolean recursive, Collection<MetaBinding> col) {
        for (BindingProperty bindingProperty : metacomp.getKnownBindingProperties()) {
            MetaBinding bindingDef = bindingProperty.getValue();
            if (bindingDef == null) continue;
            if (col == null) {
                col = new LinkedList<MetaBinding>();
            }
            col.add(bindingDef);
        }
        if (recursive && metacomp instanceof ComponentContainer) {
            for (BindingProperty bindingProperty : ((ComponentContainer)metacomp).getSubBeans()) {
                col = BindingDesignSupportImpl.collectBindingDefs((RADComponent)bindingProperty, recursive, col);
            }
        }
        return col;
    }

    private void addBindingInModel(MetaBinding bindingDef) {
        this.addBinding(bindingDef, bindingDef.getSource().getBeanInstance(), bindingDef.getTarget().getBeanInstance(), this.bindingGroup, true);
    }

    void addBinding(MetaBinding bindingDef, Object source, Object target, BindingGroup group, boolean inModel) {
        if (inModel) {
            if (this.modelBindings.get(bindingDef) == null) {
                this.modelBindings.put(bindingDef, BindingDesignSupportImpl.createBinding(bindingDef, source, target, group, this.bindingToGroup));
            }
        } else {
            List<Binding> establishedBindings = this.bindingsMap.get(bindingDef);
            if (establishedBindings != null) {
                for (Binding binding : establishedBindings) {
                    if (binding.getSourceObject() != source || binding.getTargetObject() != target) continue;
                    return;
                }
            } else {
                establishedBindings = new LinkedList<Binding>();
                this.bindingsMap.put(bindingDef, establishedBindings);
            }
            establishedBindings.add(BindingDesignSupportImpl.createBinding(bindingDef, source, target, group, this.bindingToGroup));
        }
    }

    private static String actualTargetPath(MetaBinding bindingDef) {
        String value;
        Class targetClass;
        String targetPath = bindingDef.getTargetPath();
        if ("text".equals(targetPath)) {
            Class targetClass2 = bindingDef.getTarget().getBeanClass();
            if (JTextComponent.class.isAssignableFrom(targetClass2)) {
                String strategy = bindingDef.getParameter("javax.swing.binding.ParameterKeys.TEXT_CHANGE_STRATEGY");
                if ("javax.swing.binding.TextChangeStrategy.ON_ACTION_OR_FOCUS_LOST".equals(strategy)) {
                    targetPath = targetPath + "_ON_ACTION_OR_FOCUS_LOST";
                } else if ("javax.swing.binding.TextChangeStrategy.ON_FOCUS_LOST".equals(strategy)) {
                    targetPath = targetPath + "_ON_FOCUS_LOST";
                }
            }
        } else if ("selectedElement".equals(targetPath) || "selectedElements".equals(targetPath)) {
            String value2;
            Class targetClass3 = bindingDef.getTarget().getBeanClass();
            if ((JList.class.isAssignableFrom(targetClass3) || JTable.class.isAssignableFrom(targetClass3) || JComboBox.class.isAssignableFrom(targetClass3)) && "Y".equals(value2 = bindingDef.getParameter("IGNORE_ADJUSTING"))) {
                targetPath = targetPath + "_IGNORE_ADJUSTING";
            }
        } else if ("value".equals(targetPath) && JSlider.class.isAssignableFrom(targetClass = bindingDef.getTarget().getBeanClass()) && "Y".equals(value = bindingDef.getParameter("IGNORE_ADJUSTING"))) {
            targetPath = targetPath + "_IGNORE_ADJUSTING";
        }
        return targetPath;
    }

    private static void generateTargetProperty(MetaBinding bindingDef, StringBuilder buf) {
        String targetPath = BindingDesignSupportImpl.actualTargetPath(bindingDef);
        String property = BeanProperty.class.getName() + ".create(\"" + targetPath + "\")";
        buf.append(property);
    }

    private static Property createTargetProperty(MetaBinding bindingDef) {
        String targetPath = BindingDesignSupportImpl.actualTargetPath(bindingDef);
        BeanProperty property = BeanProperty.create((String)targetPath);
        return property;
    }

    public String generateBinding(BindingProperty prop, StringBuilder buf, BindingDesignSupport.CodeGeneratorContext generator) {
        String variable;
        MetaBinding bindingDef = prop.getValue();
        int updateStrategy = bindingDef.getUpdateStrategy();
        String strategy = AutoBinding.class.getName() + ".UpdateStrategy.";
        strategy = updateStrategy == 1 ? strategy + "READ" : (updateStrategy == 2 ? strategy + "READ_ONCE" : strategy + "READ_WRITE");
        strategy = strategy + ", ";
        RADComponent target = bindingDef.getTarget();
        Class targetClass = target.getBeanClass();
        String targetPath = bindingDef.getTargetPath();
        String sourcePath = bindingDef.getSourcePath();
        Class sourceClass = bindingDef.getSource().getBeanClass();
        if ("elements".equals(targetPath) && JTable.class.isAssignableFrom(targetClass) && (List.class.isAssignableFrom(sourceClass) || sourcePath != null)) {
            String elVariable = BindingDesignSupportImpl.elVariableHelper(sourcePath, buf, generator);
            variable = generator.getBindingDescriptionVariable(JTableBinding.class, buf, false);
            if (variable == null) {
                variable = generator.getBindingDescriptionVariable(JTableBinding.class, buf, true);
                buf.append(' ');
            }
            buf.append(variable);
            buf.append(" = ");
            buf.append(SwingBindings.class.getName()).append(".createJTableBinding(");
            buf.append(strategy);
            buf.append(generator.getExpressionJavaString(bindingDef.getSource().getCodeExpression(), "this"));
            buf.append(", ");
            if (sourcePath != null) {
                buf.append(elVariable);
                buf.append(", ");
            }
            buf.append(generator.getExpressionJavaString(bindingDef.getTarget().getCodeExpression(), "this"));
            BindingDesignSupportImpl.buildBindingNameCode(prop, buf);
            buf.append(");\n");
            if (bindingDef.hasSubBindings()) {
                for (MetaBinding sub : bindingDef.getSubBindings()) {
                    String editable;
                    String columnClass;
                    String columnVariable = generator.getBindingDescriptionVariable(JTableBinding.ColumnBinding.class, buf, false);
                    if (columnVariable == null) {
                        columnVariable = generator.getBindingDescriptionVariable(JTableBinding.ColumnBinding.class, buf, true);
                        buf.append(' ');
                    }
                    buf.append(columnVariable);
                    buf.append(" = ");
                    buf.append(variable);
                    String subSourcePath = sub.getSourcePath();
                    buf.append(".addColumnBinding(");
                    if (subSourcePath == null || "null".equals(subSourcePath)) {
                        buf.append(ObjectProperty.class.getName());
                        buf.append(".create()");
                    } else {
                        buf.append(ELProperty.class.getName());
                        buf.append(".create(\"");
                        buf.append(subSourcePath);
                        buf.append("\")");
                    }
                    buf.append(");\n");
                    String title = sub.getParameter("NAME");
                    if (title == null && this.isSimpleExpression(title = subSourcePath)) {
                        title = this.unwrapSimpleExpression(title);
                        title = this.capitalize(title);
                    }
                    if (title != null && !"null".equals(title)) {
                        buf.append(columnVariable);
                        buf.append(".setColumnName(\"");
                        buf.append(title);
                        buf.append("\");\n");
                    }
                    if ((columnClass = sub.getParameter("javax.swing.binding.ParameterKeys.COLUMN_CLASS")) != null) {
                        buf.append(columnVariable);
                        buf.append(".setColumnClass(");
                        buf.append(columnClass);
                        buf.append(");\n");
                    }
                    if ((editable = sub.getParameter("javax.swing.binding.ParameterKeys.EDITABLE")) == null) continue;
                    buf.append(columnVariable);
                    buf.append(".setEditable(");
                    buf.append(editable);
                    buf.append(");\n");
                }
            }
        } else if ("elements".equals(targetPath) && JList.class.isAssignableFrom(targetClass) && (List.class.isAssignableFrom(sourceClass) || sourcePath != null)) {
            String elVariable = BindingDesignSupportImpl.elVariableHelper(sourcePath, buf, generator);
            variable = generator.getBindingDescriptionVariable(JListBinding.class, buf, false);
            if (variable == null) {
                variable = generator.getBindingDescriptionVariable(JListBinding.class, buf, true);
                buf.append(' ');
            }
            buf.append(variable);
            buf.append(" = ");
            buf.append(SwingBindings.class.getName()).append(".createJListBinding(");
            buf.append(strategy);
            buf.append(generator.getExpressionJavaString(bindingDef.getSource().getCodeExpression(), "this"));
            buf.append(", ");
            if (sourcePath != null) {
                buf.append(elVariable);
                buf.append(", ");
            }
            buf.append(generator.getExpressionJavaString(bindingDef.getTarget().getCodeExpression(), "this"));
            BindingDesignSupportImpl.buildBindingNameCode(prop, buf);
            buf.append(");\n");
            String detailPath = bindingDef.getParameter("DISPLAY");
            if (detailPath != null) {
                buf.append(variable);
                buf.append(".setDetailBinding(");
                buf.append(ELProperty.class.getName());
                buf.append(".create(\"");
                buf.append(detailPath);
                buf.append("\"));\n");
            }
        } else if ("elements".equals(targetPath) && JComboBox.class.isAssignableFrom(targetClass) && (List.class.isAssignableFrom(sourceClass) || sourcePath != null)) {
            String elVariable = BindingDesignSupportImpl.elVariableHelper(sourcePath, buf, generator);
            variable = generator.getBindingDescriptionVariable(JComboBoxBinding.class, buf, false);
            if (variable == null) {
                variable = generator.getBindingDescriptionVariable(JComboBoxBinding.class, buf, true);
                buf.append(' ');
            }
            buf.append(variable);
            buf.append(" = ");
            buf.append(SwingBindings.class.getName()).append(".createJComboBoxBinding(");
            buf.append(strategy);
            buf.append(generator.getExpressionJavaString(bindingDef.getSource().getCodeExpression(), "this"));
            buf.append(", ");
            if (sourcePath != null) {
                buf.append(elVariable);
                buf.append(", ");
            }
            buf.append(generator.getExpressionJavaString(bindingDef.getTarget().getCodeExpression(), "this"));
            BindingDesignSupportImpl.buildBindingNameCode(prop, buf);
            buf.append(");\n");
        } else {
            variable = generator.getBindingDescriptionVariable(Binding.class, buf, false);
            StringBuilder sb = new StringBuilder();
            if (variable == null) {
                variable = generator.getBindingDescriptionVariable(Binding.class, buf, true);
                buf.append(' ');
                buf.append((CharSequence)sb);
            }
            buf.append(variable);
            buf.append(" = ");
            buf.append(Bindings.class.getName()).append((CharSequence)sb).append(".createAutoBinding(");
            buf.append(strategy);
            BindingDesignSupportImpl.buildBindingParamsCode(prop, buf, generator);
        }
        return variable;
    }

    private static ELProperty createELProperty(String path) {
        ELProperty property;
        try {
            property = ELProperty.create((String)path);
        }
        catch (Exception ex) {
            Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            property = ELProperty.create((String)"error");
        }
        return property;
    }

    private static String elVariableHelper(String sourcePath, StringBuilder buf, BindingDesignSupport.CodeGeneratorContext generator) {
        String elVariable = null;
        if (sourcePath != null) {
            elVariable = generator.getBindingDescriptionVariable(ELProperty.class, buf, false);
            if (elVariable == null) {
                elVariable = generator.getBindingDescriptionVariable(ELProperty.class, buf, true);
                buf.append(' ');
            }
            buf.append(elVariable);
            buf.append(" = ");
            buf.append(ELProperty.class.getName());
            buf.append(".create(\"");
            buf.append(sourcePath);
            buf.append("\");\n");
        }
        return elVariable;
    }

    private static void buildBindingParamsCode(BindingProperty prop, StringBuilder buf, BindingDesignSupport.CodeGeneratorContext generator) {
        MetaBinding bindingDef = prop.getValue();
        String sourcePath = bindingDef.getSourcePath();
        String targetPath = bindingDef.getTargetPath();
        buf.append(generator.getExpressionJavaString(bindingDef.getSource().getCodeExpression(), "this"));
        buf.append(", ");
        if (sourcePath != null) {
            buf.append(ELProperty.class.getName());
            buf.append(".create(\"");
            buf.append(sourcePath);
            buf.append("\")");
        } else {
            buf.append(ObjectProperty.class.getName());
            buf.append(".create()");
        }
        buf.append(", ");
        buf.append(generator.getExpressionJavaString(bindingDef.getTarget().getCodeExpression(), "this"));
        buf.append(", ");
        if (targetPath != null) {
            BindingDesignSupportImpl.generateTargetProperty(bindingDef, buf);
        } else {
            buf.append(ObjectProperty.class.getName());
            buf.append(".create()");
        }
        BindingDesignSupportImpl.buildBindingNameCode(prop, buf);
        buf.append(");\n");
    }

    private static void buildBindingNameCode(BindingProperty prop, StringBuilder buf) {
        MetaBinding bindingDef = prop.getValue();
        if (bindingDef.isNameSpecified()) {
            try {
                FormProperty property = prop.getNameProperty();
                Object value = property.getValue();
                if (value != null) {
                    buf.append(", ");
                    buf.append(property.getJavaInitializationString());
                }
            }
            catch (IllegalAccessException iaex) {
                Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, iaex.getMessage(), iaex);
            }
            catch (InvocationTargetException itex) {
                Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, itex.getMessage(), itex);
            }
        }
    }

    private static Binding createBinding0(MetaBinding bindingDef, Object source, Object target, BindingGroup group) {
        AutoBinding binding;
        String name = null;
        if (bindingDef.isNameSpecified()) {
            BindingProperty prop = bindingDef.getTarget().getBindingProperty(bindingDef.getTargetPath());
            FormProperty nameProp = prop.getNameProperty();
            try {
                Object value = nameProp.getRealValue();
                if (value != null && value instanceof String) {
                    name = (String)value;
                }
            }
            catch (IllegalAccessException iaex) {
                Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, iaex.getMessage(), iaex);
            }
            catch (InvocationTargetException itex) {
                Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, itex.getMessage(), itex);
            }
            if (name != null && group.getBinding(name) != null) {
                Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, "More than one binding with name: {0}", name);
                name = null;
            }
        }
        AutoBinding.UpdateStrategy updateStrategy = AutoBinding.UpdateStrategy.READ_WRITE;
        switch (bindingDef.getUpdateStrategy()) {
            case 0: {
                updateStrategy = AutoBinding.UpdateStrategy.READ_WRITE;
                break;
            }
            case 1: {
                updateStrategy = AutoBinding.UpdateStrategy.READ;
                break;
            }
            case 2: {
                updateStrategy = AutoBinding.UpdateStrategy.READ_ONCE;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Property targetProperty = BindingDesignSupportImpl.createTargetProperty(bindingDef);
        ObjectProperty sourceProperty = bindingDef.getSourcePath() == null ? ObjectProperty.create() : BindingDesignSupportImpl.createELProperty(bindingDef.getSourcePath());
        RADComponent targetComp = bindingDef.getTarget();
        String targetPath = bindingDef.getTargetPath();
        String sourcePath = bindingDef.getSourcePath();
        if ("elements".equals(targetPath) && JTable.class.isAssignableFrom(targetComp.getBeanClass()) && (source instanceof List || sourcePath != null)) {
            JTableBinding tableBinding = sourcePath == null ? SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)updateStrategy, (List)((List)source), (JTable)((JTable)target), (String)name) : SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)updateStrategy, (Object)source, (Property)sourceProperty, (JTable)((JTable)target), (String)name);
            if (bindingDef.hasSubBindings()) {
                Collection subBindings = bindingDef.getSubBindings();
                for (MetaBinding sub : subBindings) {
                    String editable;
                    String subSourcePath = sub.getSourcePath();
                    Object prop = subSourcePath == null || "null".equals(subSourcePath) ? ObjectProperty.create() : BindingDesignSupportImpl.createELProperty(subSourcePath);
                    JTableBinding.ColumnBinding columnBinding = tableBinding.addColumnBinding((Property)prop);
                    String title = sub.getParameter("NAME");
                    if (title == null && BindingDesignSupportImpl.isSimpleExpression0(title = sub.getSourcePath())) {
                        title = BindingDesignSupportImpl.unwrapSimpleExpression0(title);
                        title = BindingDesignSupportImpl.capitalize0(title);
                    }
                    columnBinding.setColumnName(title);
                    String columnClass = sub.getParameter("javax.swing.binding.ParameterKeys.COLUMN_CLASS");
                    if (columnClass != null) {
                        try {
                            if (columnClass != null && columnClass.trim().endsWith(".class")) {
                                columnClass = columnClass.trim();
                                columnClass = columnClass.substring(0, columnClass.length() - 6);
                            }
                            if (columnClass.indexOf(46) == -1) {
                                String prefix = "";
                                while (columnClass.endsWith("[]")) {
                                    columnClass = columnClass.substring(0, columnClass.length() - 2);
                                    prefix = prefix + "[";
                                }
                                if ("".equals(prefix)) {
                                    columnClass = "java.lang." + columnClass;
                                } else {
                                    String suffix = columnClass;
                                    if (columnClass.equals("boolean")) {
                                        suffix = "Z";
                                    } else if (columnClass.equals("byte")) {
                                        suffix = "B";
                                    } else if (columnClass.equals("char")) {
                                        suffix = "C";
                                    } else if (columnClass.equals("char")) {
                                        suffix = "D";
                                    } else if (columnClass.equals("float")) {
                                        suffix = "F";
                                    } else if (columnClass.equals("int")) {
                                        suffix = "I";
                                    } else if (columnClass.equals("long")) {
                                        suffix = "J";
                                    } else if (columnClass.equals("short")) {
                                        suffix = "S";
                                    } else {
                                        prefix = prefix + "L";
                                        if (suffix.indexOf(46) == -1) {
                                            suffix = "java.lang." + suffix;
                                        }
                                        suffix = suffix + ";";
                                    }
                                    columnClass = prefix + suffix;
                                }
                            }
                            Class clazz = FormUtils.loadClass((String)columnClass, (FormModel)bindingDef.getSource().getFormModel());
                            columnBinding.setColumnClass(clazz);
                        }
                        catch (ClassNotFoundException cnfex) {
                            Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, cnfex.getMessage(), cnfex);
                        }
                    }
                    if ((editable = sub.getParameter("javax.swing.binding.ParameterKeys.EDITABLE")) == null) continue;
                    Boolean value = "false".equals(editable) ? Boolean.FALSE : Boolean.TRUE;
                    columnBinding.setEditable(value.booleanValue());
                }
            }
            binding = tableBinding;
        } else if ("elements".equals(targetPath) && JList.class.isAssignableFrom(targetComp.getBeanClass()) && (source instanceof List || sourcePath != null)) {
            JListBinding listBinding = sourcePath == null ? SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)updateStrategy, (List)((List)source), (JList)((JList)target), (String)name) : SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)updateStrategy, (Object)source, (Property)sourceProperty, (JList)((JList)target), (String)name);
            String detailPath = bindingDef.getParameter("DISPLAY");
            if (detailPath != null) {
                listBinding.setDetailBinding((Property)BindingDesignSupportImpl.createELProperty(detailPath));
            }
            binding = listBinding;
        } else if ("elements".equals(targetPath) && JComboBox.class.isAssignableFrom(targetComp.getBeanClass()) && (source instanceof List || sourcePath != null)) {
            JComboBoxBinding comboBinding = sourcePath == null ? SwingBindings.createJComboBoxBinding((AutoBinding.UpdateStrategy)updateStrategy, (List)((List)source), (JComboBox)((JComboBox)target), (String)name) : SwingBindings.createJComboBoxBinding((AutoBinding.UpdateStrategy)updateStrategy, (Object)source, (Property)sourceProperty, (JComboBox)((JComboBox)target), (String)name);
            binding = comboBinding;
        } else {
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)updateStrategy, (Object)source, (Property)sourceProperty, (Object)target, (Property)targetProperty, (String)name);
        }
        return binding;
    }

    private static Binding createBinding(MetaBinding bindingDef, Object source, Object target, BindingGroup group, Map<Binding, BindingGroup> bindingToGroup) {
        Object value;
        BindingProperty prop;
        Binding binding = BindingDesignSupportImpl.createBinding0(bindingDef, source, target, group);
        if (bindingDef.isNullValueSpecified()) {
            prop = bindingDef.getTarget().getBindingProperty(bindingDef.getTargetPath());
            FormProperty nullProp = prop.getNullValueProperty();
            try {
                value = nullProp.getRealValue();
                if (value != null && value != FormDesignValue.IGNORED_VALUE) {
                    binding.setSourceNullValue(value);
                }
            }
            catch (IllegalAccessException iaex) {
                Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, iaex.getMessage(), iaex);
            }
            catch (InvocationTargetException itex) {
                Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, itex.getMessage(), itex);
            }
        }
        if (bindingDef.isIncompletePathValueSpecified()) {
            prop = bindingDef.getTarget().getBindingProperty(bindingDef.getTargetPath());
            FormProperty incompleteProp = prop.getIncompleteValueProperty();
            try {
                value = incompleteProp.getRealValue();
                if (value != null && value != FormDesignValue.IGNORED_VALUE) {
                    binding.setSourceUnreadableValue(value);
                }
            }
            catch (IllegalAccessException iaex) {
                Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, iaex.getMessage(), iaex);
            }
            catch (InvocationTargetException itex) {
                Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, itex.getMessage(), itex);
            }
        }
        if (bindingDef.isConverterSpecified()) {
            prop = bindingDef.getTarget().getBindingProperty(bindingDef.getTargetPath());
            FormProperty converterProp = prop.getConverterProperty();
            try {
                value = converterProp.getRealValue();
                if (value != null && value instanceof Converter) {
                    binding.setConverter((Converter)value);
                }
            }
            catch (IllegalAccessException iaex) {
                Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, iaex.getMessage(), iaex);
            }
            catch (InvocationTargetException itex) {
                Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, itex.getMessage(), itex);
            }
        }
        if (bindingDef.isValidatorSpecified()) {
            prop = bindingDef.getTarget().getBindingProperty(bindingDef.getTargetPath());
            FormProperty validatorProp = prop.getValidatorProperty();
            try {
                value = validatorProp.getRealValue();
                if (value != null && value instanceof Validator) {
                    binding.setValidator((Validator)value);
                }
            }
            catch (IllegalAccessException iaex) {
                Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, iaex.getMessage(), iaex);
            }
            catch (InvocationTargetException itex) {
                Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, itex.getMessage(), itex);
            }
        }
        group.addBinding(binding);
        if (bindingToGroup != null) {
            bindingToGroup.put(binding, group);
        }
        try {
            binding.bind();
        }
        catch (Exception ex) {
            Logger.getLogger(BindingDesignSupportImpl.class.getName()).log(Level.INFO, ex.getMessage(), ex);
        }
        return binding;
    }

    private void removeBindings(MetaBinding bindingDef) {
        this.removeBindingInModel(bindingDef);
        List<Binding> establishedBindings = this.bindingsMap.get(bindingDef);
        if (establishedBindings != null) {
            for (Binding binding : establishedBindings) {
                this.removeBinding(binding);
            }
            this.bindingsMap.remove(bindingDef);
        }
    }

    private void removeBinding(Binding binding) {
        BindingGroup group = this.bindingToGroup.remove(binding);
        if (binding.isBound()) {
            binding.unbind();
        }
        group.removeBinding(binding);
    }

    private void removeBindingInModel(MetaBinding bindingDef) {
        Binding binding = this.modelBindings.remove(bindingDef);
        if (binding != null) {
            this.removeBinding(binding);
        }
    }

    public String capitalize(String title) {
        return BindingDesignSupportImpl.capitalize0(title);
    }

    static String capitalize0(String title) {
        StringBuilder builder = new StringBuilder(title);
        boolean lastWasUpper = false;
        for (int i = 0; i < builder.length(); ++i) {
            char aChar = builder.charAt(i);
            if (i == 0) {
                builder.setCharAt(i, Character.toUpperCase(aChar));
                lastWasUpper = true;
                continue;
            }
            if (Character.isUpperCase(aChar)) {
                if (!lastWasUpper) {
                    builder.insert(i, ' ');
                }
                lastWasUpper = true;
                ++i;
                continue;
            }
            lastWasUpper = false;
        }
        return builder.toString();
    }

    public BindingDesignSupport.BindingVisualReplicator createReplicator() {
        return new BindingVisualReplicatorImpl();
    }

    public Class getBindingGroupClass() {
        return BindingGroup.class;
    }

    public Class getConverterClass() {
        return Converter.class;
    }

    public Class getValidatorClass() {
        return Validator.class;
    }

    public boolean updateProjectForBeansBinding() {
        FormEditor formEditor = FormEditor.getFormEditor((FormModel)this.formModel);
        if (formEditor != null && !ClassPathUtils.isOnClassPath((FileObject)formEditor.getFormDataObject().getFormFile(), (String)Binding.class.getName())) {
            try {
                Library lib = LibraryManager.getDefault().getLibrary("beans-binding");
                if (lib == null) {
                    return false;
                }
                ClassSource cs = new ClassSource("", new ClassSource.Entry[]{new ClassSourceResolver.LibraryEntry(lib)});
                return Boolean.TRUE == ClassPathUtils.updateProject((FileObject)formEditor.getFormDataObject().getFormFile(), (ClassSource)cs);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return false;
    }

    static class ModifiableBoolean {
        boolean value;

        ModifiableBoolean() {
        }
    }

    private class ModelListener
    implements FormModelListener {
        private ModelListener() {
        }

        public void formChanged(FormModelEvent[] events) {
            if (events == null) {
                return;
            }
            block5: for (int i = 0; i < events.length; ++i) {
                FormModelEvent ev = events[i];
                switch (ev.getChangeType()) {
                    case 16: {
                        if (ev.getSubPropertyName() != null) continue block5;
                        BindingDesignSupportImpl.this.changeBinding(ev.getOldBinding(), ev.getNewBinding());
                        continue block5;
                    }
                    case 8: {
                        BindingDesignSupportImpl.this.releaseBindings(ev.getComponent(), true);
                        continue block5;
                    }
                    case 7: {
                        if (ev.getCreatedDeleted()) continue block5;
                        BindingDesignSupportImpl.this.establishUpdatedBindings(ev.getComponent(), true, null, BindingDesignSupportImpl.this.bindingGroup, true);
                    }
                }
            }
        }
    }

    private class BindingVisualReplicatorImpl
    implements BindingDesignSupport.BindingVisualReplicator {
        private BindingGroup group = new BindingGroup();

        BindingVisualReplicatorImpl() {
            this.group.bind();
        }

        public void addBinding(MetaBinding bindingDef, Object source, Object target, boolean inModel) {
            BindingDesignSupportImpl.this.addBinding(bindingDef, source, target, this.group, inModel);
        }

        public void establishUpdatedBindings(RADComponent metacomp, boolean recursive, Map map, boolean inModel) {
            BindingDesignSupportImpl.this.establishUpdatedBindings(metacomp, recursive, map, this.group, inModel);
        }

        public void establishOneOffBindings(RADComponent metacomp, boolean recursive, Map map) {
            BindingDesignSupportImpl.establishOneOffBindings(metacomp, recursive, map, this.group);
        }
    }
}

