/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;

public final class RepositoryInfo {
    static final String DEFAULT_INDEX_SUFFIX = ".index/";
    private final String id;
    private final String type;
    @NonNull
    private final String name;
    private final String repositoryPath;
    private final String repositoryUrl;
    private final String indexUpdateUrl;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public RepositoryInfo(String id, String type, @NullAllowed String name, String repositoryPath, String repositoryUrl) throws URISyntaxException {
        this(id, type, name, repositoryPath, repositoryUrl, null);
    }

    RepositoryInfo(String id, String type, @NullAllowed String name, String repositoryPath, String repositoryUrl, String indexUpdateUrl) throws URISyntaxException {
        this.id = id;
        this.type = type;
        this.name = name != null ? name : id;
        this.repositoryPath = repositoryPath;
        if (repositoryUrl != null && !repositoryUrl.endsWith("/")) {
            repositoryUrl = repositoryUrl + "/";
        }
        if (repositoryUrl != null) {
            new URI(repositoryUrl);
        }
        this.repositoryUrl = repositoryUrl;
        String string = this.indexUpdateUrl = indexUpdateUrl != null ? indexUpdateUrl : (repositoryUrl != null ? repositoryUrl + DEFAULT_INDEX_SUFFIX : null);
        if (!this.isLocal() ^ this.isRemoteDownloadable()) {
            throw new IllegalArgumentException("Cannot have both local and remote index fields filled in. Repository: " + id + " Path=" + repositoryPath + " Remote URL:" + indexUpdateUrl);
        }
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    @CheckForNull
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @CheckForNull
    public String getIndexUpdateUrl() {
        return this.indexUpdateUrl;
    }

    public boolean isRemoteDownloadable() {
        return this.indexUpdateUrl != null;
    }

    public boolean isLocal() {
        return this.repositoryPath != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener cl) {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.add(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener cl) {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.remove(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeIndex() {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }
    }

    public String toString() {
        return this.id;
    }
}

