/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.index.ArtifactInfo;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class PluginIndexManager {
    private static final Logger LOG = Logger.getLogger(PluginIndexManager.class.getName());

    public static Set<String> getPluginGoalNames(Set<String> groups) throws Exception {
        TreeSet<String> result = new TreeSet<String>();
        for (String groupId : groups) {
            block1: for (String artifactId : RepositoryQueries.filterPluginArtifactIds(groupId, "", null)) {
                for (NBVersionInfo v : RepositoryQueries.getVersions(groupId, artifactId, null)) {
                    File jar;
                    Document pluginXml;
                    if (v.getVersion().endsWith("-SNAPSHOT") && !v.getRepoId().equals("local") || (pluginXml = PluginIndexManager.loadPluginXml(jar = RepositoryUtil.downloadArtifact(v))) == null) continue;
                    Element root = pluginXml.getDocumentElement();
                    Element goalPrefix = XMLUtil.findElement((Element)root, (String)"goalPrefix", null);
                    if (goalPrefix == null) {
                        LOG.log(Level.WARNING, "no goalPrefix in {0}", jar);
                        continue;
                    }
                    Element mojos = XMLUtil.findElement((Element)root, (String)"mojos", null);
                    if (mojos == null) {
                        LOG.log(Level.WARNING, "no mojos in {0}", jar);
                        continue;
                    }
                    for (Element mojo : XMLUtil.findSubElements((Element)mojos)) {
                        if (!mojo.getTagName().equals("mojo")) continue;
                        Element goal = XMLUtil.findElement((Element)mojo, (String)"goal", null);
                        if (goal == null) {
                            LOG.log(Level.WARNING, "mojo missing goal in {0}", jar);
                            continue;
                        }
                        result.add(XMLUtil.findText((Node)goalPrefix).trim() + ':' + XMLUtil.findText((Node)goal).trim());
                    }
                    continue block1;
                }
            }
        }
        LOG.log(Level.FINE, "found goal names: {0}", result);
        return result;
    }

    public static Set<String> getPluginGoals(String groupId, String artifactId, String version) throws Exception {
        assert (groupId != null && artifactId != null && version != null);
        for (NBVersionInfo v : RepositoryQueries.getVersions(groupId, artifactId, null)) {
            File jar;
            Document pluginXml;
            if (!v.getVersion().equals(version) || (pluginXml = PluginIndexManager.loadPluginXml(jar = RepositoryUtil.downloadArtifact(v))) == null) continue;
            Element root = pluginXml.getDocumentElement();
            Element mojos = XMLUtil.findElement((Element)root, (String)"mojos", null);
            if (mojos == null) {
                LOG.log(Level.WARNING, "no mojos in {0}", jar);
                continue;
            }
            TreeSet<String> goals = new TreeSet<String>();
            for (Element mojo : XMLUtil.findSubElements((Element)mojos)) {
                if (!mojo.getTagName().equals("mojo")) continue;
                Element goal = XMLUtil.findElement((Element)mojo, (String)"goal", null);
                if (goal == null) {
                    LOG.log(Level.WARNING, "mojo missing goal in {0}", jar);
                    continue;
                }
                goals.add(XMLUtil.findText((Node)goal).trim());
            }
            LOG.log(Level.FINE, "found goals: {0}", goals);
            return goals;
        }
        return Collections.emptySet();
    }

    @CheckForNull
    public static Set<ParameterDetail> getPluginParameters(String groupId, String artifactId, String version, @NullAllowed String mojo) throws Exception {
        assert (groupId != null && artifactId != null && version != null);
        for (NBVersionInfo v : RepositoryQueries.getVersions(groupId, artifactId, null)) {
            File jar;
            Document pluginXml;
            if (!v.getVersion().equals(version) || (pluginXml = PluginIndexManager.loadPluginXml(jar = RepositoryUtil.downloadArtifact(v))) == null) continue;
            Element root = pluginXml.getDocumentElement();
            Element mojos = XMLUtil.findElement((Element)root, (String)"mojos", null);
            if (mojos == null) {
                LOG.log(Level.WARNING, "no mojos in {0}", jar);
                continue;
            }
            TreeSet<ParameterDetail> params = new TreeSet<ParameterDetail>(new Comparator<ParameterDetail>(){

                @Override
                public int compare(ParameterDetail o1, ParameterDetail o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (Element mojoEl : XMLUtil.findSubElements((Element)mojos)) {
                if (!mojoEl.getTagName().equals("mojo")) continue;
                Element goal = XMLUtil.findElement((Element)mojoEl, (String)"goal", null);
                if (goal == null) {
                    LOG.log(Level.WARNING, "mojo missing goal in {0}", jar);
                    continue;
                }
                if (mojo != null && !mojo.equals(XMLUtil.findText((Node)goal).trim())) continue;
                Element parameters = XMLUtil.findElement((Element)mojoEl, (String)"parameters", null);
                Element configuration = XMLUtil.findElement((Element)mojoEl, (String)"configuration", null);
                if (parameters == null) continue;
                for (Element parameter : XMLUtil.findSubElements((Element)parameters)) {
                    Element sample;
                    if (!parameter.getTagName().equals("parameter")) continue;
                    Element name = XMLUtil.findElement((Element)parameter, (String)"name", null);
                    if (name == null) {
                        LOG.log(Level.WARNING, "parameter missing name in {0}", jar);
                        continue;
                    }
                    Element description = XMLUtil.findElement((Element)parameter, (String)"description", null);
                    if (description == null) {
                        LOG.log(Level.WARNING, "parameter missing description in {0}", jar);
                        continue;
                    }
                    Element required = XMLUtil.findElement((Element)parameter, (String)"required", null);
                    if (required == null) {
                        LOG.log(Level.WARNING, "parameter missing required in {0}", jar);
                        continue;
                    }
                    String defaultValue = null;
                    String expression = null;
                    if (configuration != null && (sample = XMLUtil.findElement((Element)configuration, (String)XMLUtil.findText((Node)name), null)) != null) {
                        String expressionWithSheBraces;
                        defaultValue = sample.getAttribute("default-value");
                        if (defaultValue.isEmpty()) {
                            defaultValue = null;
                        }
                        if ((expressionWithSheBraces = XMLUtil.findText((Node)sample)) != null && expressionWithSheBraces.matches("[$][{].+[}]")) {
                            expression = expressionWithSheBraces.substring(2, expressionWithSheBraces.length() - 1);
                        }
                    }
                    params.add(new ParameterDetail(XMLUtil.findText((Node)name), expression, defaultValue, Boolean.parseBoolean(XMLUtil.findText((Node)required)), XMLUtil.findText((Node)description)));
                }
            }
            LOG.log(Level.FINE, "for mojo {0} found params {1}", new Object[]{mojo, params});
            return params;
        }
        return null;
    }

    public static Set<String> getPluginsForGoalPrefix(String prefix) throws Exception {
        assert (prefix != null);
        TreeSet<String> result = new TreeSet<String>();
        QueryField qf = new QueryField();
        qf.setField(ArtifactInfo.PLUGIN_PREFIX);
        qf.setValue(prefix);
        qf.setOccur(0);
        qf.setMatch(0);
        for (NBVersionInfo v : RepositoryQueries.find(Collections.singletonList(qf), null)) {
            result.add(v.getGroupId() + '|' + v.getArtifactId() + '|' + v.getVersion());
        }
        LOG.log(Level.FINE, "found plugins {0}", result);
        return result;
    }

    public static Map<String, List<String>> getLifecyclePlugins(String packaging, @NullAllowed String mvnVersion, String[] extensionPlugins) throws Exception {
        Map<String, List<String>> phases;
        assert (packaging != null);
        URL standard = MavenEmbedder.class.getClassLoader().getResource("META-INF/plexus/artifact-handlers.xml");
        if (standard != null && (phases = PluginIndexManager.parsePhases(standard.toString(), packaging)) != null) {
            return phases;
        }
        for (String extensionPlugin : extensionPlugins) {
            Map<String, List<String>> phases2;
            String[] gav = extensionPlugin.split(":", 3);
            MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
            Artifact art = online.createArtifact(gav[0], gav[1], gav[2], "maven-plugin");
            online.resolve(art, Collections.emptyList(), online.getLocalRepository());
            File jar = art.getFile();
            if (!jar.isFile() || (phases2 = PluginIndexManager.parsePhases("jar:" + jar.toURI() + "!/META-INF/plexus/components.xml", packaging)) == null) continue;
            return phases2;
        }
        return Collections.emptyMap();
    }

    private static Map<String, List<String>> parsePhases(String u, String packaging) throws Exception {
        Document doc = XMLUtil.parse((InputSource)new InputSource(u), (boolean)false, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
        for (Element componentsEl : XMLUtil.findSubElements((Element)doc.getDocumentElement())) {
            for (Element componentEl : XMLUtil.findSubElements((Element)componentsEl)) {
                if (!XMLUtil.findText((Node)XMLUtil.findElement((Element)componentEl, (String)"role", null)).trim().equals("org.apache.maven.lifecycle.mapping.LifecycleMapping") || !XMLUtil.findText((Node)XMLUtil.findElement((Element)componentEl, (String)"implementation", null)).trim().equals("org.apache.maven.lifecycle.mapping.DefaultLifecycleMapping") || !XMLUtil.findText((Node)XMLUtil.findElement((Element)componentEl, (String)"role-hint", null)).trim().equals(packaging)) continue;
                for (Element configurationEl : XMLUtil.findSubElements((Element)componentEl)) {
                    if (!configurationEl.getTagName().equals("configuration")) continue;
                    Element phases = XMLUtil.findElement((Element)configurationEl, (String)"phases", null);
                    if (phases == null) {
                        block3: for (Element lifecyclesEl : XMLUtil.findSubElements((Element)configurationEl)) {
                            if (!lifecyclesEl.getTagName().equals("lifecycles")) continue;
                            for (Element lifecycleEl : XMLUtil.findSubElements((Element)lifecyclesEl)) {
                                if (!XMLUtil.findText((Node)XMLUtil.findElement((Element)lifecycleEl, (String)"id", null)).trim().equals("default")) continue;
                                phases = XMLUtil.findElement((Element)lifecycleEl, (String)"phases", null);
                                continue block3;
                            }
                        }
                    }
                    if (phases == null) continue;
                    LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
                    for (Element phase : XMLUtil.findSubElements((Element)phases)) {
                        ArrayList<String> plugins = new ArrayList<String>();
                        for (String plugin : XMLUtil.findText((Node)phase).split(",")) {
                            String[] gavMojo = plugin.trim().split(":", 4);
                            plugins.add(gavMojo[0] + ':' + gavMojo[1] + ':' + (gavMojo.length == 4 ? gavMojo[3] : gavMojo[2]));
                        }
                        result.put(phase.getTagName(), plugins);
                    }
                    LOG.log(Level.FINE, "for {0} found in {1}: {2}", new Object[]{packaging, u, result});
                    return result;
                }
            }
        }
        return null;
    }

    @CheckForNull
    private static Document loadPluginXml(File jar) {
        if (!jar.isFile() || !jar.getName().endsWith(".jar")) {
            return null;
        }
        LOG.log(Level.FINER, "parsing plugin.xml from {0}", jar);
        try {
            return XMLUtil.parse((InputSource)new InputSource("jar:" + jar.toURI() + "!/META-INF/maven/plugin.xml"), (boolean)false, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
        }
        catch (Exception x) {
            LOG.log(Level.FINE, "could not parse " + jar, x.toString());
            return null;
        }
    }

    private PluginIndexManager() {
    }

    public static class ParameterDetail {
        private String name;
        @NullAllowed
        private String expression;
        @NullAllowed
        private String defaultValue;
        private boolean required;
        private String description;

        private ParameterDetail(String name, @NullAllowed String expression, @NullAllowed String defaultValue, boolean required, String description) {
            this.name = name;
            this.expression = expression;
            this.defaultValue = defaultValue;
            this.required = required;
            this.description = description;
        }

        @CheckForNull
        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        @CheckForNull
        public String getExpression() {
            return this.expression;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getHtmlDetails(boolean includeName) {
            return "<html><body>" + (includeName ? "<h4>" + NbBundle.getMessage(PluginIndexManager.class, (String)"TXT_LBL_PARAMETER") + this.getName() + "</h4>" : "") + "<b>" + NbBundle.getMessage(PluginIndexManager.class, (String)"LBL_Expression") + "</b>" + (this.getExpression() != null ? "${" + this.getExpression() + "}" : NbBundle.getMessage(PluginIndexManager.class, (String)"LBL_Undefined")) + "<br>" + "<b>" + NbBundle.getMessage(PluginIndexManager.class, (String)"LBL_DefaultValue") + "</b>" + (this.getDefaultValue() != null ? this.getDefaultValue() : NbBundle.getMessage(PluginIndexManager.class, (String)"LBL_Undefined")) + "<br><b>" + NbBundle.getMessage(PluginIndexManager.class, (String)"LBL_Description") + "</b><br>" + this.getDescription() + "</body></html>";
        }

        public String toString() {
            return "<" + this.name + ">" + (this.expression != null ? "${" + this.expression + "}" : "") + (this.defaultValue != null ? "=" + this.defaultValue : "") + "</>";
        }
    }
}

