/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.index.ArtifactAvailablility;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactContextProducer;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.GroupedSearchRequest;
import org.apache.maven.index.GroupedSearchResponse;
import org.apache.maven.index.Grouping;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.SearchEngine;
import org.apache.maven.index.artifact.ArtifactPackagingMapper;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.creator.AbstractIndexCreator;
import org.apache.maven.index.expr.StringSearchExpression;
import org.apache.maven.index.search.grouping.GGrouping;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.WagonHelper;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.indexer.ArtifactDependencyIndexCreator;
import org.netbeans.modules.maven.indexer.Cancellation;
import org.netbeans.modules.maven.indexer.ClassDependencyIndexCreator;
import org.netbeans.modules.maven.indexer.CustomArtifactContextProducer;
import org.netbeans.modules.maven.indexer.NotifyingIndexCreator;
import org.netbeans.modules.maven.indexer.RemoteIndexTransferListener;
import org.netbeans.modules.maven.indexer.RepositoryIndexerListener;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.spi.ArchetypeQueries;
import org.netbeans.modules.maven.indexer.spi.BaseQueries;
import org.netbeans.modules.maven.indexer.spi.ChecksumQueries;
import org.netbeans.modules.maven.indexer.spi.ClassUsageQuery;
import org.netbeans.modules.maven.indexer.spi.ClassesQuery;
import org.netbeans.modules.maven.indexer.spi.ContextLoadedQuery;
import org.netbeans.modules.maven.indexer.spi.DependencyInfoQueries;
import org.netbeans.modules.maven.indexer.spi.GenericFindQuery;
import org.netbeans.modules.maven.indexer.spi.RepositoryIndexerImplementation;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.util.repository.DefaultMirrorSelector;

public class NexusRepositoryIndexerImpl
implements RepositoryIndexerImplementation,
BaseQueries,
ChecksumQueries,
ArchetypeQueries,
DependencyInfoQueries,
ClassesQuery,
ClassUsageQuery,
GenericFindQuery,
ContextLoadedQuery {
    private PlexusContainer embedder;
    private ArtifactRepository repository;
    private NexusIndexer indexer;
    private SearchEngine searcher;
    private IndexUpdater remoteIndexUpdater;
    private ArtifactContextProducer contextProducer;
    private boolean inited = false;
    private static final Logger LOGGER = Logger.getLogger(NexusRepositoryIndexerImpl.class.getName());
    private static final HashMap<String, Mutex> repoMutexMap = new HashMap(4);
    private Lookup lookup = Lookups.singleton((Object)this);
    static final int MAX_RESULT_COUNT = 512;

    private Mutex getRepoMutex(RepositoryInfo repo) {
        return this.getRepoMutex(repo.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mutex getRepoMutex(String repoId) {
        HashMap<String, Mutex> hashMap = repoMutexMap;
        synchronized (hashMap) {
            Mutex m = repoMutexMap.get(repoId);
            if (m == null) {
                m = new Mutex();
                repoMutexMap.put(repoId, m);
            }
            return m;
        }
    }

    @Override
    public String getType() {
        return "nexus";
    }

    @Override
    public Lookup getCapabilityLookup() {
        return this.lookup;
    }

    private void initIndexer() {
        if (!this.inited) {
            try {
                DefaultContainerConfiguration config = new DefaultContainerConfiguration();
                ClassWorld world = new ClassWorld();
                ClassRealm embedderRealm = world.newRealm("maven.embedder", MavenEmbedder.class.getClassLoader());
                ClassLoader indexerLoader = NexusRepositoryIndexerImpl.class.getClassLoader();
                ClassRealm indexerRealm = world.newRealm("maven.indexer", indexerLoader);
                ClassRealm plexusRealm = world.newRealm("plexus.core", indexerLoader);
                plexusRealm.importFrom(embedderRealm.getId(), "META-INF/plexus");
                plexusRealm.importFrom(embedderRealm.getId(), "META-INF/maven");
                plexusRealm.importFrom(indexerRealm.getId(), "META-INF/plexus");
                plexusRealm.importFrom(indexerRealm.getId(), "META-INF/maven");
                config.setClassWorld(world);
                this.embedder = new DefaultPlexusContainer((ContainerConfiguration)config);
                ComponentDescriptor desc = new ComponentDescriptor();
                desc.setRoleClass(ArtifactContextProducer.class);
                desc.setImplementationClass(CustomArtifactContextProducer.class);
                ComponentRequirement req = new ComponentRequirement();
                req.setFieldName("mapper");
                req.setRole(ArtifactPackagingMapper.class.getName());
                desc.addRequirement(req);
                this.embedder.addComponentDescriptor(desc);
                this.repository = EmbedderFactory.getProjectEmbedder().getLocalRepository();
                this.indexer = (NexusIndexer)this.embedder.lookup(NexusIndexer.class);
                this.searcher = (SearchEngine)this.embedder.lookup(SearchEngine.class);
                this.remoteIndexUpdater = (IndexUpdater)this.embedder.lookup(IndexUpdater.class);
                this.contextProducer = (ArtifactContextProducer)this.embedder.lookup(ArtifactContextProducer.class);
                this.inited = true;
            }
            catch (Exception x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadIndexingContext(RepositoryInfo info) throws IOException {
        block16: {
            block17: {
                if (!NexusRepositoryIndexerImpl.$assertionsDisabled && !this.getRepoMutex(info).isWriteAccess()) {
                    throw new AssertionError();
                }
                this.initIndexer();
                context = this.indexer.getIndexingContexts().get(info.getId());
                indexUpdateUrl = this.findIndexUpdateUrlConsideringMirrors(info);
                if (context == null) ** GOTO lbl20
                contexturl = context.getIndexUpdateUrl();
                contextfile = context.getRepository();
                v0 = repofile = info.getRepositoryPath() != null ? new File(info.getRepositoryPath()) : null;
                if (Utilities.compareObjects((Object)contexturl, (Object)indexUpdateUrl)) break block17;
                NexusRepositoryIndexerImpl.LOGGER.log(Level.FINE, "Remote context changed: {0}, unload/load", info.getId());
                this.unloadIndexingContext(new RepositoryInfo[]{info});
                ** GOTO lbl20
            }
            if (Utilities.compareObjects((Object)contextfile, (Object)repofile)) {
                NexusRepositoryIndexerImpl.LOGGER.log(Level.FINER, "Skipping Context: {0}, already loaded.", info.getId());
            } else {
                NexusRepositoryIndexerImpl.LOGGER.log(Level.FINE, "Local context changed: {0}, unload/load", info.getId());
                this.unloadIndexingContext(new RepositoryInfo[]{info});
lbl20:
                // 3 sources

                NexusRepositoryIndexerImpl.LOGGER.log(Level.FINE, "Loading Context: {0}", info.getId());
                loc = new File(this.getDefaultIndexLocation(), info.getId());
                index = false;
                if (!loc.exists() || loc.listFiles().length <= 0) {
                    index = true;
                    NexusRepositoryIndexerImpl.LOGGER.log(Level.FINER, "Index Not Available: {0} at: {1}", new Object[]{info.getId(), loc.getAbsolutePath()});
                }
                creators = new ArrayList<AbstractIndexCreator>();
                try {
                    creators.addAll(this.embedder.lookupList(IndexCreator.class));
                }
                catch (ComponentLookupException x) {
                    throw new IOException(x);
                }
                if (info.isLocal()) {
                    creators.add(new ArtifactDependencyIndexCreator());
                    creators.add(new ClassDependencyIndexCreator());
                } else {
                    creators.add(new NotifyingIndexCreator());
                }
                try {
                    this.indexer.addIndexingContextForced(info.getId(), info.getId(), info.isLocal() != false ? new File(info.getRepositoryPath()) : null, loc, info.isRemoteDownloadable() != false ? info.getRepositoryUrl() : null, info.isRemoteDownloadable() != false ? indexUpdateUrl : null, creators);
                    NexusRepositoryIndexerImpl.LOGGER.log(Level.FINE, "using index creators: {0}", creators);
                }
                catch (IOException ex) {
                    NexusRepositoryIndexerImpl.LOGGER.log(Level.INFO, "Found a broken index at " + loc + " with loaded contexts " + this.indexer.getIndexingContexts().keySet(), ex);
                    break block16;
                }
                if (index) {
                    this.indexLoadedRepo(info, true);
                }
            }
        }
        currents = new HashSet<String>();
        for (RepositoryInfo info2 : RepositoryPreferences.getInstance().getRepositoryInfos()) {
            currents.add(info2.getId());
        }
        toRemove = new HashSet<String>(this.indexer.getIndexingContexts().keySet());
        toRemove.removeAll(currents);
        if (!toRemove.isEmpty()) {
            for (final String repo : toRemove) {
                try {
                    this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            NexusRepositoryIndexerImpl.this.unloadIndexingContext(repo);
                            return null;
                        }
                    });
                }
                catch (MutexException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private String findIndexUpdateUrlConsideringMirrors(RepositoryInfo info) {
        String direct = info.getIndexUpdateUrl();
        if (direct == null) {
            return null;
        }
        MavenEmbedder embedder2 = EmbedderFactory.getOnlineEmbedder();
        DefaultMirrorSelector selectorNoGroups = new DefaultMirrorSelector();
        DefaultMirrorSelector selectorWithGroups = new DefaultMirrorSelector();
        for (Mirror mirror : embedder2.getSettings().getMirrors()) {
            String mirrorOf = mirror.getMirrorOf();
            if (!mirrorOf.contains("*")) {
                selectorNoGroups.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirrorOf, mirror.getMirrorOfLayouts());
            }
            selectorWithGroups.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirrorOf, mirror.getMirrorOfLayouts());
        }
        RemoteRepository original = new RemoteRepository(info.getId(), "default", info.getRepositoryUrl());
        RemoteRepository mirrored = selectorNoGroups.getMirror(original);
        if (mirrored != null) {
            String index = this.addIndex(mirrored.getUrl());
            LOGGER.log(Level.FINE, "Mirroring {0} to {1}", new Object[]{direct, index});
            return index;
        }
        mirrored = selectorWithGroups.getMirror(original);
        if (mirrored != null) {
            LOGGER.log(Level.WARNING, "Will not mirror {0} to {1}", new Object[]{direct, this.addIndex(mirrored.getUrl())});
        } else {
            LOGGER.log(Level.FINE, "No mirror for {0}", direct);
        }
        return direct;
    }

    private String addIndex(String baseURL) {
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        return baseURL + ".index/";
    }

    private Collection<IndexingContext> getContexts(RepositoryInfo[] allrepos) {
        ArrayList<IndexingContext> toRet = new ArrayList<IndexingContext>();
        for (RepositoryInfo info : allrepos) {
            assert (this.getRepoMutex(info).isWriteAccess());
            IndexingContext context = this.indexer.getIndexingContexts().get(info.getId());
            if (context != null) {
                toRet.add(context);
                continue;
            }
            LOGGER.log(Level.WARNING, "The context ''{0}'' is not loaded.", info.getId());
        }
        return toRet;
    }

    private FlatSearchResponse repeatedFlatSearch(FlatSearchRequest fsr, Collection<IndexingContext> contexts, boolean shouldThrow) throws IOException {
        BooleanClause[] c;
        int MAX_MAX_CLAUSE = 2048;
        Query q = fsr.getQuery();
        if (q instanceof BooleanQuery && (c = ((BooleanQuery)q).getClauses()).length == 1) {
            Query q1 = c[0].getQuery();
            if (q1 instanceof PrefixQuery && "u".equals(((PrefixQuery)q1).getPrefix().field())) {
                MAX_MAX_CLAUSE = 65536;
            } else if (q1 instanceof TermQuery && "p".equals(((TermQuery)q1).getTerm().field())) {
                MAX_MAX_CLAUSE = 65536;
            }
        }
        int oldMax = BooleanQuery.getMaxClauseCount();
        try {
            int max = oldMax;
            while (true) {
                try {
                    BooleanQuery.setMaxClauseCount((int)max);
                    FlatSearchResponse response = this.searcher.searchFlatPaged(fsr, contexts);
                    LOGGER.log(Level.FINE, "passed on {0} clauses processing {1} with {2} hits", new Object[]{max, q, response.getTotalHitsCount()});
                    FlatSearchResponse flatSearchResponse = response;
                    return flatSearchResponse;
                }
                catch (BooleanQuery.TooManyClauses exc) {
                    block13: {
                        LOGGER.log(Level.FINE, "TooManyClauses on {0} clauses processing {1}", new Object[]{max, q});
                        if ((max *= 2) <= MAX_MAX_CLAUSE) break block13;
                        if (shouldThrow) {
                            throw exc;
                        }
                        LOGGER.log(Level.WARNING, "Encountered more than {0} clauses processing {1}", new Object[]{MAX_MAX_CLAUSE, q});
                        FlatSearchResponse flatSearchResponse = null;
                        BooleanQuery.setMaxClauseCount((int)oldMax);
                        return flatSearchResponse;
                    }
                    continue;
                }
                break;
            }
        }
        finally {
            BooleanQuery.setMaxClauseCount((int)oldMax);
        }
    }

    private void unloadIndexingContext(RepositoryInfo ... repos) throws IOException {
        for (RepositoryInfo repo : repos) {
            assert (this.getRepoMutex(repo).isWriteAccess());
            LOGGER.log(Level.FINER, "Unloading Context: {0}", repo.getId());
            IndexingContext ic = this.indexer.getIndexingContexts().get(repo.getId());
            if (ic == null) continue;
            this.indexer.removeIndexingContext(ic, false);
        }
    }

    private void unloadIndexingContext(String repo) throws IOException {
        assert (this.getRepoMutex(repo).isWriteAccess());
        LOGGER.log(Level.FINE, "Unloading Context: {0}", repo);
        IndexingContext ic = this.indexer.getIndexingContexts().get(repo);
        if (ic != null) {
            this.indexer.removeIndexingContext(ic, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexLoadedRepo(RepositoryInfo repo, boolean updateLocal) throws IOException {
        block24: {
            assert (this.getRepoMutex(repo).isWriteAccess());
            try {
                Map<String, IndexingContext> indexingContexts = this.indexer.getIndexingContexts();
                IndexingContext indexingContext = indexingContexts.get(repo.getId());
                if (indexingContext == null) {
                    LOGGER.log(Level.WARNING, "Indexing context could not be found: {0}", repo.getId());
                    return;
                }
                if (repo.isRemoteDownloadable()) {
                    LOGGER.log(Level.FINE, "Indexing Remote Repository: {0}", repo.getId());
                    RemoteIndexTransferListener listener = new RemoteIndexTransferListener(repo);
                    try {
                        String protocol = URI.create(indexingContext.getIndexUpdateUrl()).getScheme();
                        SettingsDecryptionResult settings = ((SettingsDecrypter)this.embedder.lookup(SettingsDecrypter.class)).decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(EmbedderFactory.getOnlineEmbedder().getSettings()));
                        AuthenticationInfo wagonAuth = null;
                        for (Server server : settings.getServers()) {
                            if (!repo.getId().equals(server.getId())) continue;
                            wagonAuth = new AuthenticationInfo();
                            wagonAuth.setUserName(server.getUsername());
                            wagonAuth.setPassword(server.getPassword());
                            wagonAuth.setPassphrase(server.getPassphrase());
                            wagonAuth.setPrivateKey(server.getPrivateKey());
                            break;
                        }
                        ProxyInfo wagonProxy = null;
                        for (Proxy proxy : settings.getProxies()) {
                            if (!proxy.isActive()) continue;
                            wagonProxy = new ProxyInfo();
                            wagonProxy.setHost(proxy.getHost());
                            wagonProxy.setPort(proxy.getPort());
                            wagonProxy.setNonProxyHosts(proxy.getNonProxyHosts());
                            wagonProxy.setUserName(proxy.getUsername());
                            wagonProxy.setPassword(proxy.getPassword());
                            wagonProxy.setType(protocol);
                            break;
                        }
                        WagonHelper.WagonFetcher fetcher = new WagonHelper.WagonFetcher((Wagon)this.embedder.lookup(Wagon.class, protocol), listener, wagonAuth, wagonProxy);
                        listener.setFetcher(fetcher);
                        IndexUpdateRequest iur = new IndexUpdateRequest(indexingContext, fetcher);
                        NotifyingIndexCreator nic = null;
                        for (IndexCreator ic : indexingContext.getIndexCreators()) {
                            if (!(ic instanceof NotifyingIndexCreator)) continue;
                            nic = (NotifyingIndexCreator)ic;
                            break;
                        }
                        if (nic != null) {
                            nic.start(listener);
                        }
                        try {
                            this.remoteIndexUpdater.fetchAndUpdateIndex(iur);
                            break block24;
                        }
                        finally {
                            if (nic != null) {
                                nic.end();
                            }
                        }
                    }
                    finally {
                        listener.close();
                    }
                }
                LOGGER.log(Level.FINE, "Indexing Local Repository: {0}", repo.getId());
                RepositoryIndexerListener listener = new RepositoryIndexerListener(indexingContext);
                try {
                    this.indexer.scan(indexingContext, listener, updateLocal);
                }
                finally {
                    listener.close();
                }
            }
            catch (Cancellation x) {
                throw new IOException("canceled indexing");
            }
            catch (ComponentLookupException x) {
                throw new IOException("could not find protocol handler for " + repo.getRepositoryUrl(), x);
            }
            finally {
                RepositoryPreferences.getInstance().setLastIndexUpdate(repo.getId(), new Date());
                this.fireChangeIndex(repo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexRepo(final RepositoryInfo repo) {
        LOGGER.log(Level.FINER, "Indexing Context: {0}", repo);
        try {
            RemoteIndexTransferListener.addToActive(Thread.currentThread());
            this.getRepoMutex(repo).writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    try {
                        NexusRepositoryIndexerImpl.this.initIndexer();
                        IndexingContext cntx = NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts().get(repo.getId());
                        if (cntx != null) {
                            NexusRepositoryIndexerImpl.this.indexer.removeIndexingContext(cntx, true);
                        }
                        NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                        NexusRepositoryIndexerImpl.this.indexLoadedRepo(repo, false);
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.INFO, "could not (re-)index " + repo.getId(), x);
                    }
                    return null;
                }
            });
        }
        finally {
            RemoteIndexTransferListener.removeFromActive(Thread.currentThread());
        }
    }

    public void shutdownAll() {
        LOGGER.fine("Shutting Down All Contexts");
        try {
            if (this.inited) {
                for (IndexingContext ic : this.indexer.getIndexingContexts().values()) {
                    LOGGER.log(Level.FINER, "Shutting Down: {0}", ic.getId());
                    this.indexer.removeIndexingContext(ic, false);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void updateIndexWithArtifacts(final RepositoryInfo repo, final Collection<Artifact> artifacts) {
        try {
            this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                    Map<String, IndexingContext> indexingContexts = NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts();
                    IndexingContext indexingContext = indexingContexts.get(repo.getId());
                    if (indexingContext == null) {
                        LOGGER.log(Level.WARNING, "Indexing context could not be created: {0}", repo.getId());
                        return null;
                    }
                    for (Artifact artifact : artifacts) {
                        File art;
                        String absolutePath;
                        if (artifact.getFile() != null) {
                            absolutePath = artifact.getFile().getAbsolutePath();
                        } else {
                            if (artifact.getVersion() == null) continue;
                            absolutePath = repo.getRepositoryPath() + File.separator + NexusRepositoryIndexerImpl.this.repository.pathOf(artifact);
                        }
                        if (!(art = new File(absolutePath)).exists()) continue;
                        ArtifactContext ac = NexusRepositoryIndexerImpl.this.contextProducer.getArtifactContext(indexingContext, art);
                        NexusRepositoryIndexerImpl.this.indexer.addArtifactToIndex(ac, indexingContext);
                    }
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fireChangeIndex(repo);
    }

    @Override
    public void deleteArtifactFromIndex(final RepositoryInfo repo, final Artifact artifact) {
        try {
            this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    String absolutePath;
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                    Map<String, IndexingContext> indexingContexts = NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts();
                    IndexingContext indexingContext = indexingContexts.get(repo.getId());
                    if (indexingContext == null) {
                        LOGGER.log(Level.WARNING, "Indexing context chould not be created: {0}", repo.getId());
                        return null;
                    }
                    if (artifact.getFile() != null) {
                        absolutePath = artifact.getFile().getAbsolutePath();
                    } else if (artifact.getVersion() != null) {
                        absolutePath = repo.getRepositoryPath() + File.separator + NexusRepositoryIndexerImpl.this.repository.pathOf(artifact);
                    } else {
                        return null;
                    }
                    String extension = artifact.getArtifactHandler().getExtension();
                    String pomPath = absolutePath.substring(0, absolutePath.length() - extension.length());
                    pomPath = pomPath + "pom";
                    File pom = new File(pomPath);
                    if (pom.exists()) {
                        NexusRepositoryIndexerImpl.this.indexer.deleteArtifactFromIndex(NexusRepositoryIndexerImpl.this.contextProducer.getArtifactContext(indexingContext, pom), indexingContext);
                    }
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fireChangeIndex(repo);
    }

    private void fireChangeIndex(final RepositoryInfo repo) {
        if (this.getRepoMutex(repo).isWriteAccess()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    NexusRepositoryIndexerImpl.this.fireChangeIndex(repo);
                }
            });
            return;
        }
        assert (!this.getRepoMutex(repo).isWriteAccess() && !this.getRepoMutex(repo).isReadAccess());
        repo.fireChangeIndex();
    }

    private File getDefaultIndexLocation() {
        return Places.getCacheSubdirectory((String)"mavenindex");
    }

    @Override
    public Set<String> getGroups(List<RepositoryInfo> repos) {
        return this.filterGroupIds("", repos);
    }

    private void iterate(List<RepositoryInfo> repos, final RepoAction action) {
        for (final RepositoryInfo repo : repos) {
            this.getRepoMutex(repo).writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    try {
                        action.run(repo);
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.INFO, "could not process " + repo.getId(), x);
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public Set<String> filterGroupIds(final String prefix, List<RepositoryInfo> repos) {
        final TreeSet<String> groups = new TreeSet<String>();
        final ArrayList<RepositoryInfo> slowCheck = new ArrayList<RepositoryInfo>();
        this.iterate(repos, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo) throws IOException {
                NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                IndexingContext context = NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts().get(repo.getId());
                if (context == null) {
                    return;
                }
                Set<String> all = context.getAllGroups();
                if (all.size() > 0) {
                    if (prefix.length() == 0) {
                        groups.addAll(all);
                    } else {
                        for (String gr : all) {
                            if (!gr.startsWith(prefix)) continue;
                            groups.add(gr);
                        }
                    }
                } else {
                    slowCheck.add(repo);
                }
            }
        });
        this.iterate(slowCheck, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo) throws IOException {
                BooleanQuery bq = new BooleanQuery();
                bq.add(new BooleanClause((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, prefix)), BooleanClause.Occur.MUST));
                GroupedSearchRequest gsr = new GroupedSearchRequest((Query)bq, (Grouping)new GGrouping(), new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareTo(o2);
                    }
                });
                GroupedSearchResponse response = NexusRepositoryIndexerImpl.this.searcher.searchGrouped(gsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}));
                groups.addAll(response.getResults().keySet());
            }
        });
        return groups;
    }

    @Override
    public List<NBVersionInfo> getRecords(final String groupId, final String artifactId, final String version, List<RepositoryInfo> repos) {
        final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
        this.iterate(repos, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo) throws IOException {
                NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                BooleanQuery bq = new BooleanQuery();
                String id = groupId + "|" + artifactId + "|" + version + "|";
                bq.add(new BooleanClause((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id)), BooleanClause.Occur.MUST));
                FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                fsr.setCount(512);
                FlatSearchResponse response = NexusRepositoryIndexerImpl.this.searcher.searchFlatPaged(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}));
                infos.addAll(NexusRepositoryIndexerImpl.convertToNBVersionInfo(response.getResults()));
            }
        });
        return infos;
    }

    @Override
    public Set<String> getArtifacts(final String groupId, List<RepositoryInfo> repos) {
        final TreeSet<String> artifacts = new TreeSet<String>();
        this.iterate(repos, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo) throws IOException {
                BooleanQuery bq = new BooleanQuery();
                NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                String id = groupId + "|";
                bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST));
                FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                if (response != null) {
                    for (ArtifactInfo artifactInfo : response.getResults()) {
                        artifacts.add(artifactInfo.artifactId);
                    }
                }
            }
        });
        return artifacts;
    }

    @Override
    public List<NBVersionInfo> getVersions(final String groupId, final String artifactId, List<RepositoryInfo> repos) {
        final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
        this.iterate(repos, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo) throws IOException {
                NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                BooleanQuery bq = new BooleanQuery();
                String id = groupId + "|" + artifactId + "|";
                bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST));
                FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                if (response != null) {
                    infos.addAll(NexusRepositoryIndexerImpl.convertToNBVersionInfo(response.getResults()));
                }
            }
        });
        return infos;
    }

    @Override
    public List<NBVersionInfo> findVersionsByClass(final String className, List<RepositoryInfo> repos) {
        final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
        this.iterate(repos, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo) throws IOException {
                NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                String clsname = className.replace(".", "/");
                FlatSearchRequest fsr = new FlatSearchRequest(NexusRepositoryIndexerImpl.setBooleanRewrite(NexusRepositoryIndexerImpl.this.indexer.constructQuery(MAVEN.CLASSNAMES, new StringSearchExpression(clsname.toLowerCase()))), ArtifactInfo.VERSION_COMPARATOR);
                fsr.setCount(512);
                FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                if (response != null) {
                    infos.addAll(NexusRepositoryIndexerImpl.convertToNBVersionInfo(NexusRepositoryIndexerImpl.this.postProcessClasses(response.getResults(), clsname)));
                }
            }
        });
        return infos;
    }

    @Override
    public List<ClassUsageQuery.ClassUsageResult> findClassUsages(final String className, List<RepositoryInfo> repos) {
        ArrayList<RepositoryInfo> localRepos = new ArrayList<RepositoryInfo>();
        for (RepositoryInfo repo : repos) {
            if (!repo.isLocal()) continue;
            localRepos.add(repo);
        }
        final ArrayList<ClassUsageQuery.ClassUsageResult> results = new ArrayList<ClassUsageQuery.ClassUsageResult>();
        this.iterate(localRepos, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo) throws IOException {
                NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                ClassDependencyIndexCreator.search(className, NexusRepositoryIndexerImpl.this.indexer, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), results);
            }
        });
        Collections.sort(results, new Comparator<ClassUsageQuery.ClassUsageResult>(){

            @Override
            public int compare(ClassUsageQuery.ClassUsageResult r1, ClassUsageQuery.ClassUsageResult r2) {
                return r1.getArtifact().compareTo(r2.getArtifact());
            }
        });
        return results;
    }

    @Override
    public List<NBVersionInfo> findDependencyUsage(String groupId, String artifactId, String version, List<RepositoryInfo> repos) {
        final Query q = ArtifactDependencyIndexCreator.query(groupId, artifactId, version);
        final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
        this.iterate(repos, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo) throws IOException {
                NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                FlatSearchRequest fsr = new FlatSearchRequest(q, ArtifactInfo.VERSION_COMPARATOR);
                fsr.setCount(512);
                FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                if (response != null) {
                    infos.addAll(NexusRepositoryIndexerImpl.convertToNBVersionInfo(response.getResults()));
                }
            }
        });
        return infos;
    }

    @Override
    public List<NBVersionInfo> findBySHA1(final String sha1, List<RepositoryInfo> repos) {
        final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
        this.iterate(repos, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo) throws IOException {
                NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                BooleanQuery bq = new BooleanQuery();
                bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite(NexusRepositoryIndexerImpl.this.indexer.constructQuery(MAVEN.SHA1, new StringSearchExpression(sha1))), BooleanClause.Occur.SHOULD));
                FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                fsr.setCount(512);
                FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                if (response != null) {
                    infos.addAll(NexusRepositoryIndexerImpl.convertToNBVersionInfo(response.getResults()));
                }
            }
        });
        return infos;
    }

    @Override
    public List<NBVersionInfo> findArchetypes(List<RepositoryInfo> repos) {
        final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
        this.iterate(repos, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo) throws IOException {
                NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                BooleanQuery bq = new BooleanQuery();
                bq.add(new BooleanClause((Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, "maven-archetype")), BooleanClause.Occur.MUST));
                FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                fsr.setCount(512);
                FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                if (response != null) {
                    List<NBVersionInfo> results = NexusRepositoryIndexerImpl.convertToNBVersionInfo(response.getResults());
                    infos.addAll(results);
                }
            }
        });
        return infos;
    }

    @Override
    public Set<String> filterPluginArtifactIds(final String groupId, final String prefix, List<RepositoryInfo> repos) {
        final TreeSet<String> artifacts = new TreeSet<String>();
        this.iterate(repos, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo) throws IOException {
                NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                BooleanQuery bq = new BooleanQuery();
                String id = groupId + "|" + prefix;
                bq.add(new BooleanClause((Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, "maven-plugin")), BooleanClause.Occur.MUST));
                bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST));
                FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                fsr.setCount(512);
                FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                if (response != null) {
                    for (ArtifactInfo artifactInfo : response.getResults()) {
                        artifacts.add(artifactInfo.artifactId);
                    }
                }
            }
        });
        return artifacts;
    }

    @Override
    public Set<String> filterPluginGroupIds(final String prefix, List<RepositoryInfo> repos) {
        final TreeSet<String> artifacts = new TreeSet<String>();
        this.iterate(repos, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo) throws IOException {
                NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                BooleanQuery bq = new BooleanQuery();
                bq.add(new BooleanClause((Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, "maven-plugin")), BooleanClause.Occur.MUST));
                if (prefix.length() > 0) {
                    bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((Query)new PrefixQuery(new Term(ArtifactInfo.GROUP_ID, prefix))), BooleanClause.Occur.MUST));
                }
                FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                fsr.setCount(512);
                FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                if (response != null) {
                    for (ArtifactInfo artifactInfo : response.getResults()) {
                        artifacts.add(artifactInfo.groupId);
                    }
                }
            }
        });
        return artifacts;
    }

    @Override
    public Set<String> filterArtifactIdForGroupId(final String groupId, final String prefix, List<RepositoryInfo> repos) {
        final TreeSet<String> artifacts = new TreeSet<String>();
        this.iterate(repos, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo) throws IOException {
                NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                BooleanQuery bq = new BooleanQuery();
                String id = groupId + "|" + prefix;
                bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST));
                FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                fsr.setCount(512);
                FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                if (response != null) {
                    for (ArtifactInfo artifactInfo : response.getResults()) {
                        artifacts.add(artifactInfo.artifactId);
                    }
                }
            }
        });
        return artifacts;
    }

    @Override
    public List<NBVersionInfo> find(final List<QueryField> fields, List<RepositoryInfo> repos) {
        final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
        this.iterate(repos, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo) throws IOException {
                NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                BooleanQuery bq = new BooleanQuery();
                for (QueryField field : fields) {
                    Object q;
                    BooleanClause.Occur occur;
                    BooleanClause.Occur occur2 = occur = field.getOccur() == 1 ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST;
                    String fieldName = NexusRepositoryIndexerImpl.this.toNexusField(field.getField());
                    if (fieldName == null) continue;
                    if (ArtifactInfo.NAMES.equals(fieldName)) {
                        String clsname = field.getValue().replace(".", "/");
                        q = NexusRepositoryIndexerImpl.this.indexer.constructQuery(MAVEN.CLASSNAMES, new StringSearchExpression(clsname.toLowerCase()));
                    } else {
                        q = ArtifactInfo.ARTIFACT_ID.equals(fieldName) ? NexusRepositoryIndexerImpl.this.indexer.constructQuery(MAVEN.ARTIFACT_ID, new StringSearchExpression(field.getValue())) : (field.getMatch() == 0 ? new TermQuery(new Term(fieldName, field.getValue())) : new PrefixQuery(new Term(fieldName, field.getValue())));
                    }
                    bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite(q), occur));
                }
                FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                if (response != null) {
                    infos.addAll(NexusRepositoryIndexerImpl.convertToNBVersionInfo(response.getResults()));
                }
            }
        });
        return infos;
    }

    @Override
    public List<RepositoryInfo> getLoaded(List<RepositoryInfo> repos) {
        ArrayList<RepositoryInfo> toRet = new ArrayList<RepositoryInfo>(repos.size());
        for (RepositoryInfo repo : repos) {
            File timestamp;
            File loc = new File(this.getDefaultIndexLocation(), repo.getId());
            if (!loc.exists() || !(timestamp = new File(loc, "timestamp")).exists()) continue;
            toRet.add(repo);
        }
        return toRet;
    }

    private String toNexusField(String field) {
        if ("artifactId".equals(field)) {
            return ArtifactInfo.ARTIFACT_ID;
        }
        if ("groupId".equals(field)) {
            return ArtifactInfo.GROUP_ID;
        }
        if ("version".equals(field)) {
            return ArtifactInfo.VERSION;
        }
        if ("classes".equals(field)) {
            return ArtifactInfo.NAMES;
        }
        if ("name".equals(field)) {
            return ArtifactInfo.NAME;
        }
        if ("description".equals(field)) {
            return ArtifactInfo.DESCRIPTION;
        }
        if ("packaging".equals(field)) {
            return ArtifactInfo.PACKAGING;
        }
        return field;
    }

    private Collection<ArtifactInfo> postProcessClasses(Collection<ArtifactInfo> artifactInfos, String classname) {
        int patter = 40;
        boolean isPath = classname.contains("/");
        if (isPath) {
            return artifactInfos;
        }
        String pattStr = ".*/" + classname + "$.*";
        Pattern patt = Pattern.compile(pattStr, patter);
        Iterator<ArtifactInfo> it = artifactInfos.iterator();
        while (it.hasNext()) {
            ArtifactInfo ai = it.next();
            Matcher m = patt.matcher(ai.classNames);
            if (m.matches()) continue;
            it.remove();
        }
        return artifactInfos;
    }

    static List<NBVersionInfo> convertToNBVersionInfo(Collection<ArtifactInfo> artifactInfos) {
        ArrayList<NBVersionInfo> bVersionInfos = new ArrayList<NBVersionInfo>();
        for (ArtifactInfo ai : artifactInfos) {
            if ("javadoc".equals(ai.classifier) || "sources".equals(ai.classifier)) continue;
            NBVersionInfo nbvi = new NBVersionInfo(ai.repository, ai.groupId, ai.artifactId, ai.version, ai.fextension, ai.packaging, ai.name, ai.description, ai.classifier);
            nbvi.setJavadocExists(ai.javadocExists == ArtifactAvailablility.PRESENT);
            nbvi.setSourcesExists(ai.sourcesExists == ArtifactAvailablility.PRESENT);
            nbvi.setSignatureExists(ai.signatureExists == ArtifactAvailablility.PRESENT);
            nbvi.setLastModified(ai.lastModified);
            nbvi.setSize(ai.size);
            bVersionInfos.add(nbvi);
        }
        return bVersionInfos;
    }

    private static Query setBooleanRewrite(Query q) {
        if (q instanceof MultiTermQuery) {
            ((MultiTermQuery)q).setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE);
        } else if (q instanceof BooleanQuery) {
            for (BooleanClause c : ((BooleanQuery)q).getClauses()) {
                NexusRepositoryIndexerImpl.setBooleanRewrite(c.getQuery());
            }
        }
        return q;
    }

    private static interface RepoAction {
        public void run(RepositoryInfo var1) throws IOException;
    }
}

