/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.Field;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.IndexerFieldVersion;
import org.apache.maven.index.creator.AbstractIndexCreator;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;

class ArtifactDependencyIndexCreator
extends AbstractIndexCreator {
    private static final Logger LOG = Logger.getLogger(ArtifactDependencyIndexCreator.class.getName());
    private static final String NS = "urn:NbIndexCreator";
    private static final String NB_DEPENDENCY_GROUP = "nbdg";
    private static final String NB_DEPENDENCY_ARTIFACT = "nbda";
    private static final String NB_DEPENDENCY_VERSION = "nbdv";
    private static IndexerField FLD_NB_DEPENDENCY_GROUP = new IndexerField(new Field(null, "urn:NbIndexCreator", "nbdg", "Dependency group"), IndexerFieldVersion.V3, "nbdg", "Dependency group", Field.Store.NO, Field.Index.NOT_ANALYZED);
    private static IndexerField FLD_NB_DEPENDENCY_ARTIFACT = new IndexerField(new Field(null, "urn:NbIndexCreator", "nbda", "Dependency artifact"), IndexerFieldVersion.V3, "nbda", "Dependency artifact", Field.Store.NO, Field.Index.NOT_ANALYZED);
    private static IndexerField FLD_NB_DEPENDENCY_VERSION = new IndexerField(new Field(null, "urn:NbIndexCreator", "nbdv", "Dependency version"), IndexerFieldVersion.V3, "nbdv", "Dependency version", Field.Store.NO, Field.Index.NOT_ANALYZED);
    private final List<ArtifactRepository> remoteRepos;
    private final Map<ArtifactInfo, List<Dependency>> dependenciesByArtifact = new WeakHashMap<ArtifactInfo, List<Dependency>>();

    ArtifactDependencyIndexCreator() {
        super(ArtifactDependencyIndexCreator.class.getName(), Arrays.asList("min"));
        this.remoteRepos = new ArrayList<ArtifactRepository>();
        for (RepositoryInfo info : RepositoryPreferences.getInstance().getRepositoryInfos()) {
            if (info.isLocal()) continue;
            this.remoteRepos.add((ArtifactRepository)new MavenArtifactRepository(info.getId(), info.getRepositoryUrl(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(), new ArtifactRepositoryPolicy()));
        }
    }

    @Override
    public void populateArtifactInfo(ArtifactContext context) throws IOException {
        ArtifactInfo ai = context.getArtifactInfo();
        if (ai.classifier != null) {
            return;
        }
        try {
            MavenProject mp = this.load(ai);
            if (mp != null) {
                List dependencies = mp.getDependencies();
                LOG.log(Level.FINER, "Successfully loaded project model from repository for {0} with {1} dependencies", new Object[]{ai, dependencies.size()});
                this.dependenciesByArtifact.put(ai, dependencies);
            }
        }
        catch (InvalidArtifactRTException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void updateDocument(ArtifactInfo ai, Document doc) {
        List<Dependency> dependencies = this.dependenciesByArtifact.get(ai);
        if (dependencies != null) {
            for (Dependency d : dependencies) {
                doc.add((Fieldable)FLD_NB_DEPENDENCY_GROUP.toField(d.getGroupId()));
                doc.add((Fieldable)FLD_NB_DEPENDENCY_ARTIFACT.toField(d.getArtifactId()));
                doc.add((Fieldable)FLD_NB_DEPENDENCY_VERSION.toField(d.getVersion()));
            }
        }
    }

    static Query query(String groupId, String artifactId, String version) {
        BooleanQuery q = new BooleanQuery();
        q.add(new BooleanClause((Query)new TermQuery(new Term(NB_DEPENDENCY_GROUP, groupId)), BooleanClause.Occur.MUST));
        q.add(new BooleanClause((Query)new TermQuery(new Term(NB_DEPENDENCY_ARTIFACT, artifactId)), BooleanClause.Occur.MUST));
        q.add(new BooleanClause((Query)new TermQuery(new Term(NB_DEPENDENCY_VERSION, version)), BooleanClause.Occur.MUST));
        return q;
    }

    @Override
    public Collection<IndexerField> getIndexerFields() {
        return Arrays.asList(FLD_NB_DEPENDENCY_GROUP, FLD_NB_DEPENDENCY_ARTIFACT, FLD_NB_DEPENDENCY_VERSION);
    }

    private MavenProject load(ArtifactInfo ai) {
        try {
            MavenEmbedder embedder = EmbedderFactory.getProjectEmbedder();
            Artifact projectArtifact = embedder.createArtifact(ai.groupId, ai.artifactId, ai.version, ai.packaging != null ? ai.packaging : "jar");
            DefaultProjectBuildingRequest dpbr = new DefaultProjectBuildingRequest();
            dpbr.setLocalRepository(embedder.getLocalRepository());
            dpbr.setRemoteRepositories(this.remoteRepos);
            dpbr.setValidationLevel(0);
            dpbr.setSystemProperties(embedder.getSystemProperties());
            ProjectBuildingResult res = embedder.buildProject(projectArtifact, (ProjectBuildingRequest)dpbr);
            if (res.getProject() != null) {
                return res.getProject();
            }
            LOG.log(Level.FINER, "No project model from repository for {0}: {1}", new Object[]{ai, res.getProblems()});
        }
        catch (ProjectBuildingException ex) {
            LOG.log(Level.FINER, "Failed to load project model from repository for {0}: {1}", new Object[]{ai, ex});
        }
        catch (Exception exception) {
            LOG.log(Level.FINER, "Failed to load project model from repository for " + ai, exception);
        }
        return null;
    }

    @Override
    public boolean updateArtifactInfo(Document doc, ArtifactInfo ai) {
        return false;
    }
}

