/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.css.lib.api.model.Namespace;
import org.netbeans.modules.css.lib.api.model.Rule;
import org.netbeans.modules.css.lib.nbparser.CssParser;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;

public final class Stylesheet {
    private static final Logger LOGGER = Logger.getLogger(Stylesheet.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private final List<Rule> rules = new ArrayList<Rule>(10);
    final Collection<String> imported_files = new ArrayList<String>();
    private final List<Namespace> namespaces = new ArrayList<Namespace>();
    private Snapshot snapshot;
    private FileObject fileObject;

    public static Stylesheet create(CssParserResult result) {
        return new Stylesheet(result.getSnapshot(), result.getParseTree());
    }

    private Stylesheet(Snapshot snapshot, Node root) {
        this.snapshot = snapshot;
        this.fileObject = snapshot.getSource().getFileObject();
        if (root != null) {
            this.updateModel(snapshot, root);
        }
    }

    public List<Rule> rules() {
        return this.rules;
    }

    public List<Namespace> getNamespaces() {
        return this.namespaces;
    }

    private Collection<FileObject> getImportedFiles() {
        FileObject sourceFile = this.snapshot.getSource().getFileObject();
        if (sourceFile == null) {
            return Collections.emptyList();
        }
        FileObject baseFolder = sourceFile.getParent();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (String fileNamePath : this.imported_files) {
            FileObject file = baseFolder.getFileObject(fileNamePath);
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    public Collection<Stylesheet> getImportedFileModels() {
        HashSet<Stylesheet> models = new HashSet<Stylesheet>();
        this.processModels(models, this);
        return models;
    }

    private void processModels(Collection<Stylesheet> models, Stylesheet model) {
        for (FileObject importedFile : model.getImportedFiles()) {
            if (!importedFile.isValid() || !importedFile.getMIMEType().equals("text/x-css")) continue;
            try {
                Stylesheet created = CssParser.parse(this.snapshot).getModel();
                if (created == null || !models.add(created)) continue;
                this.processModels(models, created);
            }
            catch (ParseException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rule ruleForOffset(int offset) {
        List<Rule> list = this.rules;
        synchronized (list) {
            if (this.rules != null) {
                for (Rule rule : this.rules()) {
                    if (rule.getRuleNameOffset() > offset || rule.getRuleCloseBracketOffset() < offset) continue;
                    return rule;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateModel(final Snapshot snapshot, Node root) {
        List<Rule> list = this.rules;
        synchronized (list) {
            NodeVisitor styleRuleVisitor = new NodeVisitor(){

                @Override
                public boolean visit(Node node) {
                    switch (node.type()) {
                        case ruleSet: {
                            Stylesheet.this.rules.add(new Rule(snapshot, node));
                            break;
                        }
                        case imports: {
                            Node importedFile = NodeUtil.query(node, "resourceIdentifier");
                            if (importedFile == null) break;
                            Stylesheet.this.imported_files.add(WebUtils.unquotedValue((CharSequence)importedFile.image()));
                            break;
                        }
                        case namespace: {
                            Stylesheet.this.namespaces.add(new Namespace(snapshot, node));
                        }
                    }
                    return false;
                }
            };
            styleRuleVisitor.visitChildren(root);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Stylesheet other = (Stylesheet)obj;
        return this.fileObject == other.fileObject || this.fileObject != null && this.fileObject.equals(other.fileObject);
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.fileObject != null ? this.fileObject.hashCode() : 0);
        return hash;
    }
}

