/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.util;

import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Flag;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.prop.schematron.SchematronProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JingTask
extends Task {
    private File schemaFile;
    private File src;
    private final List filesets = new ArrayList();
    private PropertyMapBuilder properties = new PropertyMapBuilder();
    private boolean failOnError = true;
    private SchemaReader schemaReader = null;

    public JingTask() {
        RngProperty.CHECK_ID_IDREF.add(this.properties);
    }

    public void execute() throws BuildException {
        if (this.schemaFile == null) {
            throw new BuildException("There must be an rngFile or schemaFile attribute", this.getLocation());
        }
        if (this.src == null && this.filesets.size() == 0) {
            throw new BuildException("There must be a file attribute or a fileset child element", this.getLocation());
        }
        LogErrorHandler eh = new LogErrorHandler();
        boolean hadError = false;
        try {
            ValidationDriver driver = new ValidationDriver(this.properties.toPropertyMap(), this.schemaReader);
            if (!driver.loadSchema(ValidationDriver.fileInputSource(this.schemaFile))) {
                hadError = true;
            } else {
                if (this.src != null && !driver.validate(ValidationDriver.fileInputSource(this.src))) {
                    hadError = true;
                }
                for (int i = 0; i < this.filesets.size(); ++i) {
                    FileSet fs = (FileSet)this.filesets.get(i);
                    DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                    File dir = fs.getDir(this.getProject());
                    String[] srcs = ds.getIncludedFiles();
                    for (int j = 0; j < srcs.length; ++j) {
                        if (driver.validate(ValidationDriver.fileInputSource(new File(dir, srcs[j])))) continue;
                        hadError = true;
                    }
                }
            }
        }
        catch (SAXException e) {
            hadError = true;
            ((ErrorHandlerImpl)eh).printException(e);
        }
        catch (IOException e) {
            hadError = true;
            ((ErrorHandlerImpl)eh).printException(e);
        }
        if (hadError && this.failOnError) {
            throw new BuildException("Validation failed, messages should have been provided.", this.getLocation());
        }
    }

    public void setRngfile(String rngFilename) {
        this.schemaFile = this.getProject().resolveFile(rngFilename);
    }

    public void setSchemafile(String schemaFilename) {
        this.schemaFile = this.getProject().resolveFile(schemaFilename);
    }

    public void setFile(File file) {
        this.src = file;
    }

    public void setCheckid(boolean checkid) {
        this.properties.put(RngProperty.CHECK_ID_IDREF, checkid ? Flag.PRESENT : null);
    }

    public void setCompactsyntax(boolean compactsyntax) {
        this.schemaReader = compactsyntax ? CompactSchemaReader.getInstance() : null;
    }

    public void setFeasible(boolean feasible) {
        this.properties.put(RngProperty.FEASIBLE, feasible ? Flag.PRESENT : null);
    }

    public void setPhase(String phase) {
        SchematronProperty.PHASE.put(this.properties, phase);
    }

    public void setFailonerror(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    private class LogErrorHandler
    extends ErrorHandlerImpl {
        int logLevel = 0;

        private LogErrorHandler() {
        }

        public void warning(SAXParseException e) throws SAXParseException {
            this.logLevel = 1;
            super.warning(e);
        }

        public void error(SAXParseException e) {
            this.logLevel = 0;
            super.error(e);
        }

        public void printException(Throwable e) {
            this.logLevel = 0;
            super.printException(e);
        }

        public void print(String message) {
            JingTask.this.log(message, this.logLevel);
        }
    }
}

