/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AbstractPatternFunction;
import com.thaiopensource.relaxng.impl.BinaryPattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.xml.util.Name;
import java.util.HashMap;
import java.util.Map;

class FindElementFunction
extends AbstractPatternFunction {
    private final ValidatorPatternBuilder builder;
    private final Name name;
    private final Map processed = new HashMap();
    private int specificity = -1;
    private Pattern pattern = null;

    public static Pattern findElement(ValidatorPatternBuilder builder, Name name, Pattern start) {
        FindElementFunction f = new FindElementFunction(builder, name);
        start.apply(f);
        if (f.pattern == null) {
            return builder.makeNotAllowed();
        }
        return f.pattern;
    }

    private FindElementFunction(ValidatorPatternBuilder builder, Name name) {
        this.builder = builder;
        this.name = name;
    }

    private boolean haveProcessed(Pattern p) {
        if (this.processed.get(p) != null) {
            return true;
        }
        this.processed.put(p, p);
        return false;
    }

    private Object caseBinary(BinaryPattern p) {
        if (!this.haveProcessed(p)) {
            p.getOperand1().apply(this);
            p.getOperand2().apply(this);
        }
        return null;
    }

    public Object caseGroup(GroupPattern p) {
        return this.caseBinary(p);
    }

    public Object caseInterleave(InterleavePattern p) {
        return this.caseBinary(p);
    }

    public Object caseChoice(ChoicePattern p) {
        return this.caseBinary(p);
    }

    public Object caseOneOrMore(OneOrMorePattern p) {
        if (!this.haveProcessed(p)) {
            p.getOperand().apply(this);
        }
        return null;
    }

    public Object caseElement(ElementPattern p) {
        if (!this.haveProcessed(p)) {
            int s = p.getNameClass().containsSpecificity(this.name);
            if (s > this.specificity) {
                this.specificity = s;
                this.pattern = p.getContent();
            } else if (s == this.specificity && s != -1) {
                this.pattern = this.builder.makeChoice(this.pattern, p.getContent());
            }
            p.getContent().apply(this);
        }
        return null;
    }

    public Object caseOther(Pattern p) {
        return null;
    }
}

