/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.impl.facesmodel;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class JSFConfigModelUtilities {
    private static final Logger LOGGER = Logger.getLogger(JSFConfigModelUtilities.class.getName());

    private JSFConfigModelUtilities() {
    }

    public static void saveChanges(DocumentModel<?> model) throws IOException {
        if (model.isIntransaction()) {
            model.endTransaction();
        }
        model.sync();
        DataObject dobj = (DataObject)model.getModelSource().getLookup().lookup(DataObject.class);
        if (dobj == null) {
            FileObject fParentFo;
            final Document doc = (Document)model.getModelSource().getLookup().lookup(Document.class);
            final File file = (File)model.getModelSource().getLookup().lookup(File.class);
            LOGGER.log(Level.FINE, "saving changes in {0}", file);
            File parent = file.getParentFile();
            FileObject parentFo = FileUtil.toFileObject((File)parent);
            if (parentFo == null) {
                parent.mkdirs();
                FileUtil.refreshFor((File[])new File[]{parent});
                parentFo = FileUtil.toFileObject((File)parent);
            }
            if ((fParentFo = parentFo) != null) {
                FileSystem fs = parentFo.getFileSystem();
                fs.runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        String text;
                        try {
                            text = doc.getText(0, doc.getLength());
                        }
                        catch (BadLocationException x) {
                            throw new IOException(x);
                        }
                        FileObject fo = fParentFo.getFileObject(file.getName());
                        if (fo == null) {
                            fo = fParentFo.createData(file.getName());
                        }
                        OutputStream os = fo.getOutputStream();
                        try {
                            os.write(text.getBytes(FileEncodingQuery.getEncoding((FileObject)fo)));
                        }
                        finally {
                            os.close();
                        }
                    }
                });
            }
        } else {
            SaveCookie save = (SaveCookie)dobj.getLookup().lookup(SaveCookie.class);
            if (save != null) {
                LOGGER.log(Level.FINE, "saving changes in {0}", dobj);
                save.save();
            } else {
                LOGGER.log(Level.FINE, "no changes in {0}", dobj);
            }
        }
    }
}

