/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.javadoc.hints.JavadocGenerator;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class GenerateJavadocFix
implements Fix {
    private static final int NOPOS = -2;
    private String name;
    private final ElementHandle handle;
    private final FileObject file;
    private Position position;
    private final SourceVersion spec;

    GenerateJavadocFix(String name, ElementHandle handle, FileObject file, SourceVersion spec) {
        this.name = name;
        this.handle = handle;
        this.file = file;
        this.spec = spec;
    }

    public String getText() {
        return NbBundle.getMessage(GenerateJavadocFix.class, (String)"MISSING_JAVADOC_HINT", (Object)this.name);
    }

    public ChangeInfo implement() {
        return this.implement(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeInfo implement(final boolean open) {
        final String[] javadocForDocument = new String[1];
        final Document[] docs = new Document[1];
        final JavadocGenerator gen = new JavadocGenerator(this.spec);
        gen.updateSettings(this.file);
        JavaSource js = JavaSource.forFileObject((FileObject)this.file);
        try {
            js.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                public void run(WorkingCopy wc) throws Exception {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    Element elm = GenerateJavadocFix.this.handle.resolve((CompilationInfo)wc);
                    Tree t = null;
                    if (elm != null) {
                        t = wc.getTrees().getTree(elm);
                    }
                    if (t != null) {
                        String javadocTxt;
                        javadocForDocument[0] = javadocTxt = gen.generateComment(elm, (CompilationInfo)wc);
                        docs[0] = wc.getDocument();
                        if (docs[0] == null) {
                            return;
                        }
                        GenerateJavadocFix.this.position = docs[0].createPosition((int)wc.getTrees().getSourcePositions().getStartPosition(wc.getCompilationUnit(), t));
                    }
                }
            }).commit();
        }
        catch (IOException ex) {
            Logger.getLogger(GenerateJavadocFix.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        if (docs[0] == null) {
            return null;
        }
        final Indent indent = Indent.get((Document)docs[0]);
        final Reformat reformat = Reformat.get((Document)docs[0]);
        try {
            indent.lock();
            reformat.lock();
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)docs[0]), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        String iJavadoc = javadocForDocument[0];
                        int begin = GenerateJavadocFix.this.position.getOffset();
                        Position[] reformatSpan = null;
                        if (GenerateJavadocFix.makeJavadocAloneOnLine(docs[0], begin)) {
                            iJavadoc = '\n' + iJavadoc;
                            int[] span = GenerateJavadocFix.findReformatSpan(docs[0], begin);
                            reformatSpan = new Position[]{docs[0].createPosition(span[0]), docs[0].createPosition(span[1])};
                        }
                        docs[0].insertString(begin, iJavadoc, null);
                        int offset = iJavadoc.indexOf("/**");
                        offset = iJavadoc.indexOf("\n", offset + 1);
                        offset = iJavadoc.indexOf("\n", offset + 1);
                        Position openPos = docs[0].createPosition(begin + offset);
                        indent.reindent(begin, begin + iJavadoc.length() + 1);
                        if (reformatSpan != null) {
                            reformat.reformat(reformatSpan[0].getOffset(), reformatSpan[1].getOffset());
                        }
                        if (open) {
                            JavadocUtilities.open(GenerateJavadocFix.this.file, openPos.getOffset());
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        catch (BadLocationException ex) {
            Logger.getLogger(GenerateJavadocFix.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            reformat.unlock();
            indent.unlock();
        }
        return null;
    }

    private static boolean makeJavadocAloneOnLine(Document doc, int javadocBegin) throws BadLocationException {
        CharSequence txt = (CharSequence)doc.getProperty(CharSequence.class);
        if (txt == null) {
            txt = doc.getText(0, javadocBegin);
        }
        if (javadocBegin - 1 >= txt.length()) {
            return false;
        }
        for (int i = javadocBegin - 1; i >= 0; --i) {
            char c = txt.charAt(i);
            if (Character.isWhitespace(c)) {
                if (c != '\n') continue;
                break;
            }
            return true;
        }
        return false;
    }

    private static int[] findReformatSpan(Document doc, int javadocBegin) throws BadLocationException {
        char c;
        int[] span = new int[]{javadocBegin, javadocBegin};
        CharSequence txt = (CharSequence)doc.getProperty(CharSequence.class);
        if (txt == null) {
            txt = doc.getText(0, doc.getLength());
        }
        while (span[0] > 0 && (c = txt.charAt(span[0])) != '\n') {
            span[0] = span[0] - 1;
        }
        while (span[1] < txt.length() - 1 && (c = txt.charAt(span[1])) != '\n') {
            span[1] = span[1] + 1;
        }
        return span;
    }
}

