/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.debugging;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintRegistry;
import org.netbeans.modules.java.hints.declarative.Utilities;
import org.netbeans.modules.java.hints.declarative.debugging.HintWrapper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class DebugTopComponent
extends TopComponent {
    private static DebugTopComponent instance;
    private static final String PREFERRED_ID = "DebugTopComponent";
    private JEditorPane code;
    private JComboBox files;
    private JScrollPane jScrollPane1;
    private Collection<? extends HintWrapper> hints = Collections.emptyList();

    public DebugTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(DebugTopComponent.class, (String)"CTL_DebugTopComponent"));
        this.setToolTipText(NbBundle.getMessage(DebugTopComponent.class, (String)"HINT_DebugTopComponent"));
        this.code.setEditorKit((EditorKit)MimeLookup.getLookup((String)"text/x-javahints").lookup(EditorKit.class));
        Document doc = this.code.getEditorKit().createDefaultDocument();
        doc.putProperty("mimeType", "text/x-javahints");
        this.code.setDocument(doc);
    }

    private void initComponents() {
        this.files = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.code = new JEditorPane();
        this.files.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.files.setRenderer(new FileRenderer());
        this.files.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebugTopComponent.this.filesActionPerformed(evt);
            }
        });
        this.code.setContentType("text/x-javahints");
        this.jScrollPane1.setViewportView(this.code);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.files, GroupLayout.Alignment.TRAILING, 0, 376, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 376, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.files, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 246, Short.MAX_VALUE).addContainerGap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filesActionPerformed(ActionEvent evt) {
        DebugTopComponent debugTopComponent = this;
        synchronized (debugTopComponent) {
            FileObject selected = (FileObject)this.files.getSelectedItem();
            String spec = Utilities.readFile(selected);
            this.code.setText(spec);
            try {
                Rectangle r = this.code.modelToView(0);
                if (r != null) {
                    this.code.scrollRectToVisible(r);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.hints = HintWrapper.parse(selected, spec);
        }
    }

    @NonNull
    public synchronized Collection<? extends HintWrapper> getHints() {
        return this.hints;
    }

    public Document getDocument() {
        return this.code.getDocument();
    }

    public static synchronized DebugTopComponent getDefault() {
        if (instance == null) {
            instance = new DebugTopComponent();
        }
        return instance;
    }

    public static synchronized DebugTopComponent getExistingInstance() {
        return instance;
    }

    public static synchronized DebugTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(DebugTopComponent.class.getName()).warning("Cannot find DebugTopComponent component. It will not be located properly in the window system.");
            return DebugTopComponent.getDefault();
        }
        if (win instanceof DebugTopComponent) {
            return (DebugTopComponent)win;
        }
        Logger.getLogger(DebugTopComponent.class.getName()).warning("There seem to be multiple components with the 'DebugTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return DebugTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        DefaultComboBoxModel<FileObject> dlm = new DefaultComboBoxModel<FileObject>();
        for (FileObject fileObject : DeclarativeHintRegistry.findAllFiles()) {
            dlm.addElement(fileObject);
        }
        this.files.setModel(dlm);
        if (dlm.getSize() > 0) {
            this.files.setSelectedIndex(0);
        }
    }

    public synchronized void componentClosed() {
        this.files.setModel(new DefaultComboBoxModel());
        this.code.setText("");
        this.hints = Collections.emptyList();
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private static final class FileRenderer
    extends DefaultListCellRenderer {
        private FileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof FileObject) {
                value = FileUtil.getFileDisplayName((FileObject)((FileObject)value));
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

