/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative;

import com.sun.source.util.TreePath;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.hints.declarative.APIAccessor;
import org.netbeans.modules.java.hints.declarative.Condition;
import org.netbeans.modules.java.hints.declarative.DeclarativeFix;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintTokenId;
import org.netbeans.modules.java.hints.declarative.conditionapi.Context;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescription;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;

class DeclarativeHintsWorker
implements HintDescription.Worker {
    private final String displayName;
    private final List<Condition> conditions;
    private final String imports;
    private final List<DeclarativeFix> fixes;
    private final Map<String, String> options;
    private final String primarySuppressWarningsKey;

    public DeclarativeHintsWorker(String displayName, List<Condition> conditions, String imports, List<DeclarativeFix> fixes, Map<String, String> options, String primarySuppressWarningsKey) {
        this.displayName = displayName;
        this.conditions = conditions;
        this.imports = imports;
        this.fixes = fixes;
        this.options = options;
        this.primarySuppressWarningsKey = primarySuppressWarningsKey;
    }

    String getDisplayName() {
        return this.displayName;
    }

    List<DeclarativeFix> getFixes() {
        return this.fixes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends ErrorDescription> createErrors(HintContext ctx) {
        Context context = new Context(ctx);
        context.enterScope();
        for (Condition c : this.conditions) {
            if (c.holds(context, true)) continue;
            return null;
        }
        LinkedList<Fix> editorFixes = new LinkedList<Fix>();
        block6: for (DeclarativeFix fix : this.fixes) {
            context.enterScope();
            try {
                boolean empty;
                for (Condition c : fix.getConditions()) {
                    if (c instanceof Condition.Otherwise) {
                        if (!editorFixes.isEmpty()) continue block6;
                        continue;
                    }
                    if (!c.holds(context, false)) continue block6;
                }
                DeclarativeHintsWorker.reportErrorWarning(ctx, fix.getOptions());
                TokenSequence ts = TokenHierarchy.create((CharSequence)fix.getPattern(), (boolean)false, DeclarativeHintTokenId.language(), EnumSet.of(DeclarativeHintTokenId.BLOCK_COMMENT, DeclarativeHintTokenId.LINE_COMMENT, DeclarativeHintTokenId.WHITESPACE), null).tokenSequence(DeclarativeHintTokenId.language());
                boolean bl = empty = !ts.moveNext();
                if (empty) {
                    if ((fix.getOptions().containsKey("error") || fix.getOptions().containsKey("warning")) && !fix.getOptions().containsKey("remove-from-parent")) continue;
                    editorFixes.add(JavaFix.removeFromParent((HintContext)ctx, (TreePath)ctx.getPath()));
                    continue;
                }
                editorFixes.add(JavaFix.rewriteFix((CompilationInfo)ctx.getInfo(), (String)fix.getDisplayName(), (TreePath)ctx.getPath(), (String)fix.getPattern(), APIAccessor.IMPL.getVariables(context), APIAccessor.IMPL.getMultiVariables(context), APIAccessor.IMPL.getVariableNames(context), (Map)ctx.getConstraints(), fix.getOptions(), (String[])new String[]{this.imports}));
            }
            finally {
                context.leaveScope();
            }
        }
        context.leaveScope();
        ErrorDescription ed = ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)this.displayName, (Fix[])editorFixes.toArray(new Fix[0]));
        if (ed == null) {
            return null;
        }
        return Collections.singletonList(ed);
    }

    private static void reportErrorWarning(HintContext ctx, Map<String, String> options) {
        String warningText;
        String errorText = options.get("error");
        if (errorText != null) {
            ctx.reportMessage(HintContext.MessageKind.ERROR, errorText);
        }
        if ((warningText = options.get("warning")) != null) {
            ctx.reportMessage(HintContext.MessageKind.WARNING, warningText);
        }
    }
}

