/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.rest.client.ClientJavaSourceHelper;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.nodes.RestServiceNode;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.ActiveEditorDrop;

public class ResourceToEditorDrop
implements ActiveEditorDrop {
    RestServiceNode resourceNode;

    public ResourceToEditorDrop(RestServiceNode restServiceNode) {
        this.resourceNode = restServiceNode;
    }

    public boolean handleTransfer(JTextComponent jTextComponent) {
        Object object = jTextComponent.getDocument().getProperty("mimeType");
        RestServiceDescription restServiceDescription = (RestServiceDescription)this.resourceNode.getLookup().lookup(RestServiceDescription.class);
        if (restServiceDescription != null && object != null && "text/x-java".equals(object)) {
            try {
                FileObject fileObject = NbEditorUtilities.getFileObject((Document)jTextComponent.getDocument());
                if (fileObject != null) {
                    ClientJavaSourceHelper.generateJerseyClient((Node)this.resourceNode, fileObject, restServiceDescription.getName() + "_JerseyClient");
                    Object[] objectArray = new Object[]{"JAX-RS", "DRAG & DROP REST RESOURCE"};
                    LogUtils.logWsAction((Object[])objectArray);
                    return true;
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().log(exception.getLocalizedMessage());
            }
        }
        return false;
    }
}

