/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen.model;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.codegen.model.EntityClassInfo;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBeanModel;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.openide.util.Exceptions;

public class EntityResourceModelBuilder {
    private Map<String, EntityClassInfo> entityClassInfoMap = new HashMap<String, EntityClassInfo>();
    EntityResourceBeanModel model;

    public EntityResourceModelBuilder(Project project, Collection<String> collection) {
        for (String string : collection) {
            try {
                EntityClassInfo entityClassInfo = null;
                JavaSource javaSource = SourceGroupSupport.getJavaSourceFromClassName(string, project);
                if (javaSource != null) {
                    entityClassInfo = new EntityClassInfo(string, project, this, javaSource);
                }
                if (entityClassInfo == null || entityClassInfo.getFieldInfos().isEmpty()) continue;
                this.entityClassInfoMap.put(string, entityClassInfo);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public Set<EntityClassInfo> getEntityInfos() {
        return new HashSet<EntityClassInfo>(this.entityClassInfoMap.values());
    }

    public Set<String> getAllEntityNames() {
        return this.entityClassInfoMap.keySet();
    }

    public EntityClassInfo getEntityClassInfo(String string) {
        return this.entityClassInfoMap.get(string);
    }

    public EntityResourceBeanModel build() {
        this.model = new EntityResourceBeanModel(this);
        try {
            for (Map.Entry<String, EntityClassInfo> entry : this.entityClassInfoMap.entrySet()) {
                String string = entry.getKey();
                EntityClassInfo entityClassInfo = entry.getValue();
                this.model.addEntityInfo(string, entityClassInfo);
                this.computeRelationships(entityClassInfo);
            }
            this.model.setValid(true);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            this.model.setValid(false);
        }
        return this.model;
    }

    private void computeRelationships(EntityClassInfo entityClassInfo) {
        for (EntityClassInfo.FieldInfo fieldInfo : entityClassInfo.getFieldInfos()) {
            EntityClassInfo entityClassInfo2;
            String string;
            if (!fieldInfo.isRelationship()) continue;
            if (fieldInfo.isOneToMany() || fieldInfo.isManyToMany()) {
                string = fieldInfo.getTypeArg();
                entityClassInfo2 = this.entityClassInfoMap.get(string);
                this.model.addEntityInfo(string, entityClassInfo2);
                continue;
            }
            string = fieldInfo.getType();
            entityClassInfo2 = this.entityClassInfoMap.get(string);
            this.model.addEntityInfo(string, entityClassInfo2);
        }
    }
}

