/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.rest.client.Wadl2JavaHelper;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.model.oauth.AuthorizationType;
import org.netbeans.modules.websvc.saas.model.oauth.DynamicUrlType;
import org.netbeans.modules.websvc.saas.model.oauth.FlowType;
import org.netbeans.modules.websvc.saas.model.oauth.Metadata;
import org.netbeans.modules.websvc.saas.model.oauth.MethodType;
import org.netbeans.modules.websvc.saas.model.oauth.ParamType;
import org.netbeans.modules.websvc.saas.model.oauth.SignatureMethodType;

public class OAuthHelper {
    private static final String OAUTH_LOGIN_COMMENT = "You need to call this method at the beginning to authorize the application to work with user data.\nThe method obtains the OAuth access token string, that is appended to each API request later.";
    private static final String OAUTH_INIT_COMMENT = "The method sets the OAuth parameters for webResource.\nThe method needs to be called after login() method, or when the webResource path is changed";
    private static final String OAUTH_INIT_WEB_COMMENT = "The method sets the OAuth parameters for webResource.";
    private static final String OAUTH_UNIQUE_COMMENT = "The method increases OAuth nonce and timestamp parameters to make each request unique.\nThe method should be called when repetitive requests are sent to service API provider:\n<pre>\n   client.initOauth();\n   client.getXXX(...);\n   client.makeOAuthRequestUnique();\n   client.getYYY(...);\n   client.makeOAuthRequestUnique();\n   client.getZZZ(...);\n</pre>";

    static ClassTree addOAuthMethods(String string, WorkingCopy workingCopy, ClassTree classTree, Metadata metadata, String string2) {
        ArrayList<VariableTree> arrayList;
        Object object;
        ArrayList<VariableTree> arrayList2;
        Object object2;
        Object object3;
        ClassTree classTree2 = classTree;
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.PRIVATE));
        ModifiersTree modifiersTree2 = treeMaker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        HashSet<Modifier> hashSet = new HashSet<Modifier>();
        hashSet.add(Modifier.PRIVATE);
        hashSet.add(Modifier.STATIC);
        ModifiersTree modifiersTree3 = treeMaker.Modifiers(hashSet);
        hashSet.add(Modifier.FINAL);
        ModifiersTree modifiersTree4 = treeMaker.Modifiers(hashSet);
        IdentifierTree identifierTree = treeMaker.Identifier((CharSequence)"String");
        FlowType flowType = metadata.getFlow();
        MethodType methodType = flowType.getRequestToken();
        MethodType methodType2 = flowType.getAccessToken();
        ExpressionTree expressionTree = JavaSourceHelper.createTypeTree(workingCopy, "com.sun.jersey.api.client.UniformInterfaceException");
        ExpressionTree expressionTree2 = JavaSourceHelper.createTypeTree(workingCopy, "java.io.IOException");
        String string3 = metadata.getBaseUrl();
        VariableTree variableTree = treeMaker.Variable(modifiersTree4, (CharSequence)"OAUTH_BASE_URL", (Tree)identifierTree, (ExpressionTree)treeMaker.Literal((Object)string3));
        int n = 3;
        classTree2 = treeMaker.insertClassMember(classTree2, ++n, (Tree)variableTree);
        variableTree = treeMaker.Variable(modifiersTree4, (CharSequence)"CONSUMER_KEY", (Tree)identifierTree, (ExpressionTree)treeMaker.Literal((Object)""));
        String string4 = "Please, specify the consumer_key string obtained from service API pages";
        treeMaker.addComment((Tree)variableTree, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)string4), true);
        classTree2 = treeMaker.insertClassMember(classTree2, ++n, (Tree)variableTree);
        variableTree = treeMaker.Variable(modifiersTree4, (CharSequence)"CONSUMER_SECRET", (Tree)identifierTree, (ExpressionTree)treeMaker.Literal((Object)""));
        string4 = "Please, specify the consumer_secret string obtained from service API pages";
        treeMaker.addComment((Tree)variableTree, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)string4), true);
        classTree2 = treeMaker.insertClassMember(classTree2, ++n, (Tree)variableTree);
        if (OAuthHelper.isCallback(methodType)) {
            variableTree = treeMaker.Variable(modifiersTree4, (CharSequence)"CALLBACK_PAGE_URL", (Tree)identifierTree, (ExpressionTree)treeMaker.Literal((Object)""));
            string4 = "Please, specify the full URL of your callback page (e.g. http://www.myapplication.org/OAuthCallback)";
            treeMaker.addComment((Tree)variableTree, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)string4), true);
            classTree2 = treeMaker.insertClassMember(classTree2, ++n, (Tree)variableTree);
        }
        ExpressionTree expressionTree3 = JavaSourceHelper.createTypeTree(workingCopy, "com.sun.jersey.oauth.signature.OAuthParameters");
        variableTree = treeMaker.Variable(modifiersTree, (CharSequence)"oauth_params", (Tree)expressionTree3, null);
        classTree2 = treeMaker.insertClassMember(classTree2, ++n, (Tree)variableTree);
        expressionTree3 = JavaSourceHelper.createTypeTree(workingCopy, "com.sun.jersey.oauth.signature.OAuthSecrets");
        variableTree = treeMaker.Variable(modifiersTree, (CharSequence)"oauth_secrets", (Tree)expressionTree3, null);
        classTree2 = treeMaker.insertClassMember(classTree2, ++n, (Tree)variableTree);
        expressionTree3 = JavaSourceHelper.createTypeTree(workingCopy, "com.sun.jersey.oauth.client.OAuthClientFilter");
        variableTree = treeMaker.Variable(modifiersTree, (CharSequence)"oauth_filter", (Tree)expressionTree3, null);
        classTree2 = treeMaker.insertClassMember(classTree2, ++n, (Tree)variableTree);
        if ("desktop".equals(string)) {
            variableTree = treeMaker.Variable(modifiersTree, (CharSequence)"oauth_access_token", (Tree)identifierTree, null);
            classTree2 = treeMaker.insertClassMember(classTree2, ++n, (Tree)variableTree);
            variableTree = treeMaker.Variable(modifiersTree, (CharSequence)"oauth_access_token_secret", (Tree)identifierTree, null);
            classTree2 = treeMaker.insertClassMember(classTree2, ++n, (Tree)variableTree);
        }
        ModifiersTree modifiersTree5 = treeMaker.Modifiers(Collections.emptySet());
        if ("desktop".equals(string)) {
            object3 = new ArrayList<ExpressionTree>();
            object3.add(expressionTree2);
            object3.add(expressionTree);
            object2 = treeMaker.Method(modifiersTree2, (CharSequence)"login", (Tree)treeMaker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), (List)object3, OAuthHelper.getLoginBody(metadata), null);
            string4 = OAUTH_LOGIN_COMMENT;
            treeMaker.addComment((Tree)object2, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)string4), true);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object2);
            arrayList2 = OAuthHelper.getResponseType(workingCopy, methodType);
            object2 = treeMaker.Method(modifiersTree, (CharSequence)"getOAuthRequestToken", (Tree)((Object)arrayList2), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(expressionTree), OAuthHelper.getRequestTokenBody(metadata), null);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object2);
            object = OAuthHelper.getResponseType(workingCopy, methodType2);
            arrayList = new ArrayList();
            VariableTree variableTree2 = treeMaker.Variable(modifiersTree5, (CharSequence)"requestTokenResponse", (Tree)((Object)arrayList2), null);
            arrayList.add(variableTree2);
            if (methodType2.isVerifier().booleanValue()) {
                variableTree2 = treeMaker.Variable(modifiersTree5, (CharSequence)"oauth_verifier", (Tree)identifierTree, null);
                arrayList.add(variableTree2);
            }
            object2 = treeMaker.Method(modifiersTree, (CharSequence)"getOAuthAccessToken", (Tree)object, Collections.emptyList(), (List)arrayList, Collections.singletonList(expressionTree), OAuthHelper.getAccessTokenBody(metadata), null);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object2);
            object2 = treeMaker.Method(modifiersTree2, (CharSequence)"initOAuth", (Tree)treeMaker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), OAuthHelper.getInitOAuthBody(metadata), null);
            string4 = OAUTH_INIT_COMMENT;
            treeMaker.addComment((Tree)object2, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)string4), true);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object2);
            if (OAuthHelper.isTimestamp(metadata) || OAuthHelper.isNonce(metadata)) {
                object2 = treeMaker.Method(modifiersTree2, (CharSequence)"makeOAuthRequestUnique", (Tree)treeMaker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), OAuthHelper.getBodyForUniqueRequest(metadata), null);
                string4 = OAUTH_UNIQUE_COMMENT;
                treeMaker.addComment((Tree)object2, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)string4), true);
                classTree2 = treeMaker.addClassMember(classTree2, (Tree)object2);
            }
            VariableTree variableTree3 = treeMaker.Variable(modifiersTree5, (CharSequence)"requestTokenResponse", arrayList2, null);
            object2 = treeMaker.Method(modifiersTree, (CharSequence)"authorizeConsumer", (Tree)(methodType2.isVerifier() != false ? treeMaker.Identifier((CharSequence)"java.lang.String") : treeMaker.Identifier((CharSequence)"void")), Collections.emptyList(), Collections.singletonList(variableTree3), Collections.singletonList(expressionTree2), OAuthHelper.getAuthorizeConsumerBody(metadata), null);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object2);
        } else if ("web".equals(string)) {
            hashSet = new HashSet();
            hashSet.add(Modifier.PUBLIC);
            hashSet.add(Modifier.STATIC);
            object3 = treeMaker.Modifiers(hashSet);
            object2 = OAuthHelper.getResponseType(workingCopy, methodType);
            arrayList2 = new ArrayList();
            object = treeMaker.Method(modifiersTree3, (CharSequence)"getOAuthRequestToken", (Tree)object2, Collections.emptyList(), (List)arrayList2, Collections.singletonList(expressionTree), OAuthHelper.getRequestTokenBodyWeb(metadata), null);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object);
            arrayList = OAuthHelper.getResponseType(workingCopy, methodType2);
            ExpressionTree expressionTree4 = JavaSourceHelper.createTypeTree(workingCopy, "javax.servlet.http.HttpSession");
            VariableTree variableTree4 = treeMaker.Variable(modifiersTree5, (CharSequence)"session", (Tree)expressionTree4, null);
            arrayList2.add(variableTree4);
            if (methodType2.isVerifier().booleanValue()) {
                variableTree4 = treeMaker.Variable(modifiersTree5, (CharSequence)"oauth_verifier", (Tree)identifierTree, null);
                arrayList2.add(variableTree4);
            }
            object = treeMaker.Method(modifiersTree3, (CharSequence)"getOAuthAccessToken", (Tree)((Object)arrayList), Collections.emptyList(), (List)arrayList2, Collections.singletonList(expressionTree), OAuthHelper.getAccessTokenBodyWeb(metadata), null);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object);
            arrayList2 = new ArrayList<VariableTree>();
            expressionTree4 = JavaSourceHelper.createTypeTree(workingCopy, "javax.servlet.http.HttpServletRequest");
            variableTree4 = treeMaker.Variable(modifiersTree5, (CharSequence)"request", (Tree)expressionTree4, null);
            arrayList2.add(variableTree4);
            expressionTree4 = JavaSourceHelper.createTypeTree(workingCopy, "javax.servlet.http.HttpServletResponse");
            variableTree4 = treeMaker.Variable(modifiersTree5, (CharSequence)"response", (Tree)expressionTree4, null);
            arrayList2.add(variableTree4);
            object = treeMaker.Method(modifiersTree2, (CharSequence)"initOAuth", (Tree)treeMaker.Identifier((CharSequence)"void"), Collections.emptyList(), arrayList2, Collections.singletonList(expressionTree2), OAuthHelper.getInitOAuthBodyWeb(metadata), null);
            string4 = OAUTH_INIT_WEB_COMMENT;
            treeMaker.addComment((Tree)object, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)string4), true);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object);
            if (OAuthHelper.isTimestamp(metadata) || OAuthHelper.isNonce(metadata)) {
                object = treeMaker.Method(modifiersTree2, (CharSequence)"makeOAuthRequestUnique", (Tree)treeMaker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), OAuthHelper.getBodyForUniqueRequest(metadata), null);
                string4 = OAUTH_UNIQUE_COMMENT;
                treeMaker.addComment((Tree)object, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)string4), true);
                classTree2 = treeMaker.addClassMember(classTree2, (Tree)object);
            }
            expressionTree4 = JavaSourceHelper.createTypeTree(workingCopy, "javax.servlet.http.HttpServletRequest");
            variableTree4 = treeMaker.Variable(modifiersTree5, (CharSequence)"request", (Tree)expressionTree4, null);
            object = treeMaker.Method((ModifiersTree)object3, (CharSequence)"logout", (Tree)treeMaker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.singletonList(variableTree4), Collections.emptyList(), OAuthHelper.getLogoutBodyWeb(metadata), null);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object);
        } else if ("nb-module".equals(string)) {
            hashSet = new HashSet();
            hashSet.add(Modifier.PUBLIC);
            hashSet.add(Modifier.STATIC);
            object3 = treeMaker.Modifiers(hashSet);
            object2 = treeMaker.Method((ModifiersTree)object3, (CharSequence)"login", (Tree)treeMaker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(expressionTree), OAuthHelper.getLoginBodyNb(metadata, string2), null);
            string4 = OAUTH_LOGIN_COMMENT;
            treeMaker.addComment((Tree)object2, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)string4), true);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object2);
            object2 = treeMaker.Method((ModifiersTree)object3, (CharSequence)"logout", (Tree)treeMaker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), OAuthHelper.getLogoutBodyNb(metadata, string2), null);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object2);
            arrayList2 = OAuthHelper.getResponseType(workingCopy, methodType);
            object2 = treeMaker.Method(modifiersTree3, (CharSequence)"getOAuthRequestToken", (Tree)((Object)arrayList2), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(expressionTree), OAuthHelper.getRequestTokenBodyWeb(metadata), null);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object2);
            object = OAuthHelper.getResponseType(workingCopy, methodType);
            arrayList = new ArrayList<VariableTree>();
            VariableTree variableTree5 = treeMaker.Variable(modifiersTree5, (CharSequence)"requestTokenResponse", arrayList2, null);
            arrayList.add(variableTree5);
            if (methodType2.isVerifier().booleanValue()) {
                variableTree5 = treeMaker.Variable(modifiersTree5, (CharSequence)"oauth_verifier", (Tree)identifierTree, null);
                arrayList.add(variableTree5);
            }
            object2 = treeMaker.Method(modifiersTree3, (CharSequence)"getOAuthAccessToken", (Tree)object, Collections.emptyList(), arrayList, Collections.singletonList(expressionTree), OAuthHelper.getAccessTokenBodyNb(metadata), null);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object2);
            object2 = treeMaker.Method(modifiersTree2, (CharSequence)"initOAuth", (Tree)treeMaker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), OAuthHelper.getInitOAuthBodyNb(metadata), null);
            string4 = OAUTH_INIT_COMMENT;
            treeMaker.addComment((Tree)object2, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)string4), true);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object2);
            if (OAuthHelper.isTimestamp(metadata) || OAuthHelper.isNonce(metadata)) {
                object2 = treeMaker.Method(modifiersTree2, (CharSequence)"makeOAuthRequestUnique", (Tree)treeMaker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), OAuthHelper.getBodyForUniqueRequest(metadata), null);
                string4 = OAUTH_UNIQUE_COMMENT;
                treeMaker.addComment((Tree)object2, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)string4), true);
                classTree2 = treeMaker.addClassMember(classTree2, (Tree)object2);
            }
            variableTree5 = treeMaker.Variable(modifiersTree5, (CharSequence)"requestTokenResponse", arrayList2, null);
            object2 = treeMaker.Method(modifiersTree3, (CharSequence)"authorizeConsumer", (Tree)treeMaker.Identifier((CharSequence)"java.lang.String"), Collections.emptyList(), Collections.singletonList(variableTree5), Collections.emptyList(), OAuthHelper.getAuthorizeConsumerBodyNb(metadata), null);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object2);
        }
        if (OAuthHelper.needXPath(methodType)) {
            object3 = methodType.getResponseStyle();
            object2 = new ArrayList();
            arrayList2 = treeMaker.Variable(modifiersTree5, (CharSequence)"response", (Tree)identifierTree, null);
            object2.add(arrayList2);
            object = "JSON".equals(object3) ? "jsonPath" : "xPath";
            arrayList2 = treeMaker.Variable(modifiersTree5, (CharSequence)object, (Tree)identifierTree, null);
            object2.add(arrayList2);
            arrayList = treeMaker.Method(modifiersTree3, (CharSequence)("JSON".equals(object3) ? "jsonSearch" : "xPathSearch"), (Tree)identifierTree, Collections.emptyList(), (List)object2, Collections.emptyList(), OAuthHelper.getBodyForSearchMethod("JSON".equals(object3) ? "JSON" : "XML"), null);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)((Object)arrayList));
        }
        return classTree2;
    }

    private static String getSignatureMethod(Metadata metadata, MethodType methodType) {
        SignatureMethodType signatureMethodType;
        String string = null;
        string = methodType == null ? metadata.getSignatureMethod().value() : ((signatureMethodType = methodType.getSignatureMethod()) == null ? metadata.getSignatureMethod().value() : signatureMethodType.value());
        return "com.sun.jersey.oauth.signature." + string + ".NAME";
    }

    private static String getVersion(Metadata metadata) {
        String string = metadata.getVersion();
        return string == null ? "1.0" : string;
    }

    private static String getVersion(MethodType methodType) {
        String string = methodType.getVersion();
        return string == null ? "1.0" : string;
    }

    private static boolean isNonce(Metadata metadata) {
        Boolean bl = metadata.isNonce();
        return !Boolean.FALSE.equals(bl);
    }

    private static boolean isNonce(MethodType methodType) {
        Boolean bl = methodType.isNonce();
        return !Boolean.FALSE.equals(bl);
    }

    private static boolean isTimestamp(Metadata metadata) {
        Boolean bl = metadata.isTimestamp();
        return !Boolean.FALSE.equals(bl);
    }

    private static boolean isTimestamp(MethodType methodType) {
        Boolean bl = methodType.isTimestamp();
        return !Boolean.FALSE.equals(bl);
    }

    private static boolean isCallback(MethodType methodType) {
        Boolean bl = methodType.isCallback();
        return Boolean.TRUE.equals(bl);
    }

    private static boolean isVerifier(MethodType methodType) {
        Boolean bl = methodType.isVerifier();
        return Boolean.TRUE.equals(bl);
    }

    private static String getRequestTokenBody(Metadata metadata) {
        MethodType methodType = metadata.getFlow().getRequestToken();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        String string = OAuthHelper.getWebResourceMethod(methodType);
        stringBuffer.append("WebResource resource = client.resource(OAUTH_BASE_URL)." + string);
        stringBuffer.append("oauth_params = new OAuthParameters().consumerKey(CONSUMER_KEY)");
        stringBuffer.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(metadata, methodType) + ")");
        stringBuffer.append(".version(\"" + OAuthHelper.getVersion(methodType) + "\")");
        if (OAuthHelper.isNonce(methodType)) {
            stringBuffer.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(methodType)) {
            stringBuffer.append(".timestamp()");
        }
        if (OAuthHelper.isCallback(methodType)) {
            stringBuffer.append(".callback(CALLBACK_PAGE_URL)");
        }
        stringBuffer.append(";");
        stringBuffer.append("oauth_secrets = new OAuthSecrets().consumerSecret(CONSUMER_SECRET);");
        stringBuffer.append("oauth_filter = new OAuthClientFilter(client.getProviders(), oauth_params, oauth_secrets);");
        stringBuffer.append("resource.addFilter(oauth_filter);");
        stringBuffer.append("return resource.get(" + OAuthHelper.getResponseClass(methodType.getResponseStyle(), true) + ");");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getAccessTokenBody(Metadata metadata) {
        MethodType methodType = metadata.getFlow().getRequestToken();
        MethodType methodType2 = metadata.getFlow().getAccessToken();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        String string = OAuthHelper.getWebResourceMethod(methodType2);
        stringBuffer.append("WebResource resource = client.resource(OAUTH_BASE_URL)." + string);
        stringBuffer.append("oauth_params.token(" + OAuthHelper.getParamFromResponse(metadata, methodType.getResponseStyle(), "requestTokenResponse", "oauth_token") + ")");
        stringBuffer.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(metadata, methodType2) + ")");
        stringBuffer.append(".version(\"" + OAuthHelper.getVersion(methodType2) + "\")");
        if (OAuthHelper.isNonce(methodType2)) {
            stringBuffer.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(methodType2)) {
            stringBuffer.append(".timestamp()");
        }
        if (OAuthHelper.isCallback(methodType)) {
            stringBuffer.append(".callback(null)");
        }
        if (OAuthHelper.isVerifier(methodType2)) {
            stringBuffer.append(".verifier(oauth_verifier)");
        }
        stringBuffer.append(";");
        stringBuffer.append("oauth_secrets.tokenSecret(" + OAuthHelper.getParamFromResponse(metadata, methodType.getResponseStyle(), "requestTokenResponse", "oauth_token_secret") + ");");
        stringBuffer.append("resource.addFilter(oauth_filter);");
        stringBuffer.append("return resource.get(" + OAuthHelper.getResponseClass(methodType2.getResponseStyle(), true) + ");");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getInitOAuthBody(Metadata metadata) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("oauth_params = new OAuthParameters().consumerKey(CONSUMER_KEY).token(oauth_access_token)");
        stringBuffer.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(metadata, null) + ")");
        stringBuffer.append(".version(\"" + OAuthHelper.getVersion(metadata) + "\")");
        if (OAuthHelper.isNonce(metadata)) {
            stringBuffer.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(metadata)) {
            stringBuffer.append(".timestamp()");
        }
        stringBuffer.append(";");
        stringBuffer.append("oauth_secrets = new OAuthSecrets().consumerSecret(CONSUMER_SECRET).tokenSecret(oauth_access_token_secret);");
        stringBuffer.append("oauth_filter = new OAuthClientFilter(client.getProviders(), oauth_params, oauth_secrets);");
        stringBuffer.append("webResource.addFilter(oauth_filter);");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getAuthorizeConsumerBody(Metadata metadata) {
        MethodType methodType = metadata.getFlow().getAccessToken();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("try {");
        stringBuffer.append("java.awt.Desktop.getDesktop().browse(new java.net.URI(" + OAuthHelper.getAuthorizationUrl(metadata) + "));");
        stringBuffer.append("} catch (java.net.URISyntaxException ex) {");
        stringBuffer.append("ex.printStackTrace();");
        stringBuffer.append("}");
        if (methodType.isVerifier().booleanValue()) {
            stringBuffer.append("java.io.BufferedReader br = null;");
            stringBuffer.append("String oauth_verifier = null;");
            stringBuffer.append("try {");
            stringBuffer.append("br = new java.io.BufferedReader(new java.io.InputStreamReader(System.in));");
            stringBuffer.append("System.out.print(\"Type oauth_verifier string (taken from callback page url):\");");
            stringBuffer.append("oauth_verifier=br.readLine();");
            stringBuffer.append("} finally { br.close(); }");
            stringBuffer.append("return oauth_verifier;");
        } else {
            stringBuffer.append("System.out.print(\"After you authorize the application press <Enter>:\");System.in.read();");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getLoginBody(Metadata metadata) {
        MethodType methodType = metadata.getFlow().getRequestToken();
        MethodType methodType2 = metadata.getFlow().getAccessToken();
        String string = methodType2.isVerifier() != false ? "String oauth_verifier = " : "";
        String string2 = methodType2.isVerifier() != false ? ", oauth_verifier" : "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append(OAuthHelper.getResponseClass(methodType.getResponseStyle(), false) + " requestTokenResponse = getOAuthRequestToken();");
        stringBuffer.append(string + "authorizeConsumer(requestTokenResponse);");
        stringBuffer.append(OAuthHelper.getResponseClass(methodType2.getResponseStyle(), false) + " accessTokenResponse = getOAuthAccessToken(requestTokenResponse" + string2 + ");");
        stringBuffer.append("oauth_access_token_secret = " + OAuthHelper.getParamFromResponse(metadata, methodType2.getResponseStyle(), "accessTokenResponse", "oauth_token_secret") + ";");
        stringBuffer.append("oauth_access_token  = " + OAuthHelper.getParamFromResponse(metadata, methodType2.getResponseStyle(), "accessTokenResponse", "oauth_token") + ";");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getWebResourceMethod(MethodType methodType) {
        String string = methodType.getRequestStyle();
        String string2 = null;
        if ("PATH".equals(string)) {
            string2 = "path(\"" + methodType.getMethodName() + "\")";
        } else if ("HEADER".equals(string)) {
            String string3 = methodType.getRequestParam();
            if (string3 == null) {
                string3 = "method";
            }
            string2 = "header(\"" + string3 + "\",\"" + methodType.getMethodName() + "\")";
        } else {
            String string4 = methodType.getRequestParam();
            if (string4 == null) {
                string4 = "method";
            }
            string2 = "queryParam(\"" + string4 + "\",\"" + methodType.getMethodName() + "\")";
        }
        return string2;
    }

    private static String getResponseClass(String string, boolean bl) {
        String string2 = "String";
        if ("FORM".equals(string)) {
            string2 = "Form";
        }
        return bl ? string2 + ".class" : string2;
    }

    private static String getAuthorizationUrl(Metadata metadata) {
        AuthorizationType authorizationType = metadata.getFlow().getAuthorization();
        if (authorizationType.getFixedUrl() != null) {
            StringBuffer stringBuffer = new StringBuffer(authorizationType.getFixedUrl().getUrl());
            List list = authorizationType.getParam();
            if (list.size() > 0) {
                stringBuffer.append("?");
            }
            int n = 0;
            for (ParamType paramType : authorizationType.getParam()) {
                if (n++ > 0) {
                    stringBuffer.append("+\"&");
                }
                String string = paramType.getParamName();
                String string2 = paramType.getOauthName();
                if (string == null) {
                    string = string2;
                }
                String string3 = OAuthHelper.getParamFromResponse(metadata, metadata.getFlow().getRequestToken().getResponseStyle(), "requestTokenResponse", string2);
                stringBuffer.append(string + "=\"+" + string3);
            }
            return "\"" + stringBuffer.toString() + (list.size() == 0 ? "\"" : "");
        }
        DynamicUrlType dynamicUrlType = authorizationType.getDynamicUrl();
        return OAuthHelper.getParamFromResponse(metadata, metadata.getFlow().getRequestToken().getResponseStyle(), "requestTokenResponse", dynamicUrlType.getAuthParamName());
    }

    private static String getParamFromResponse(Metadata metadata, String string, String string2, String string3) {
        String string4;
        if ("FORM".equals(string)) {
            return string2 + ".getFirst(\"" + string3 + "\")";
        }
        if ("XML".equals(string)) {
            String string5 = OAuthHelper.getXPathForParam(metadata, string3);
            if (string5 != null) {
                return "xPathSearch(" + string2 + ",\"" + string5 + "\")";
            }
        } else if ("JSON".equals(string) && (string4 = OAuthHelper.getXPathForParam(metadata, string3)) != null) {
            return "jsonSearch(" + string2 + ",\"" + string4 + "\")";
        }
        return "";
    }

    private static ExpressionTree getResponseType(WorkingCopy workingCopy, MethodType methodType) {
        String string = methodType.getResponseStyle();
        if ("FORM".equals(string)) {
            return JavaSourceHelper.createTypeTree(workingCopy, "com.sun.jersey.api.representation.Form");
        }
        return workingCopy.getTreeMaker().Identifier((CharSequence)"java.lang.String");
    }

    private static String getRequestTokenBodyWeb(Metadata metadata) {
        MethodType methodType = metadata.getFlow().getRequestToken();
        String string = OAuthHelper.getWebResourceMethod(methodType);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("Client reqTokenClient = new Client();");
        stringBuffer.append("WebResource resource = reqTokenClient.resource(OAUTH_BASE_URL)." + string);
        stringBuffer.append("OAuthParameters o_params = new OAuthParameters().consumerKey(CONSUMER_KEY)");
        stringBuffer.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(metadata, methodType) + ")");
        stringBuffer.append(".version(\"" + OAuthHelper.getVersion(methodType) + "\")");
        if (OAuthHelper.isNonce(methodType)) {
            stringBuffer.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(methodType)) {
            stringBuffer.append(".timestamp()");
        }
        if (OAuthHelper.isCallback(methodType)) {
            stringBuffer.append(".callback(CALLBACK_PAGE_URL)");
        }
        stringBuffer.append(";");
        stringBuffer.append("OAuthSecrets o_secrets = new OAuthSecrets().consumerSecret(CONSUMER_SECRET);");
        stringBuffer.append("OAuthClientFilter o_filter = new OAuthClientFilter(reqTokenClient.getProviders(), o_params, o_secrets);");
        stringBuffer.append("resource.addFilter(o_filter);");
        stringBuffer.append("return resource.get(" + OAuthHelper.getResponseClass(methodType.getResponseStyle(), true) + ");");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getAccessTokenBodyWeb(Metadata metadata) {
        MethodType methodType = metadata.getFlow().getAccessToken();
        String string = OAuthHelper.getWebResourceMethod(methodType);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("Client accessTokenClient = new Client();");
        stringBuffer.append("WebResource resource = accessTokenClient.resource(OAUTH_BASE_URL)." + string);
        stringBuffer.append("OAuthParameters o_params = new OAuthParameters().consumerKey(CONSUMER_KEY)");
        stringBuffer.append(".token((String)session.getAttribute(\"oauth_token\"))");
        stringBuffer.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(metadata, methodType) + ")");
        stringBuffer.append(".version(\"" + OAuthHelper.getVersion(methodType) + "\")");
        if (OAuthHelper.isNonce(methodType)) {
            stringBuffer.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(methodType)) {
            stringBuffer.append(".timestamp()");
        }
        if (OAuthHelper.isVerifier(methodType)) {
            stringBuffer.append(".verifier(oauth_verifier)");
        }
        stringBuffer.append(";");
        stringBuffer.append("OAuthSecrets o_secrets = new OAuthSecrets().consumerSecret(CONSUMER_SECRET).tokenSecret((String)session.getAttribute(\"oauth_token_secret\"));");
        stringBuffer.append("OAuthClientFilter o_filter = new OAuthClientFilter(accessTokenClient.getProviders(), o_params, o_secrets);");
        stringBuffer.append("resource.addFilter(o_filter);");
        stringBuffer.append("return resource.get(" + OAuthHelper.getResponseClass(methodType.getResponseStyle(), true) + ");");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getAccessTokenBodyNb(Metadata metadata) {
        MethodType methodType = metadata.getFlow().getRequestToken();
        MethodType methodType2 = metadata.getFlow().getAccessToken();
        String string = OAuthHelper.getWebResourceMethod(methodType2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("Client accessTokenClient = new Client();");
        stringBuffer.append("WebResource resource = accessTokenClient.resource(OAUTH_BASE_URL)." + string);
        stringBuffer.append("OAuthParameters o_params = new OAuthParameters().consumerKey(CONSUMER_KEY)");
        stringBuffer.append(".token(" + OAuthHelper.getParamFromResponse(metadata, methodType.getResponseStyle(), "requestTokenResponse", "oauth_token") + ")");
        stringBuffer.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(metadata, methodType2) + ")");
        stringBuffer.append(".version(\"" + OAuthHelper.getVersion(methodType2) + "\")");
        if (OAuthHelper.isNonce(methodType2)) {
            stringBuffer.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(methodType2)) {
            stringBuffer.append(".timestamp()");
        }
        if (OAuthHelper.isVerifier(methodType2)) {
            stringBuffer.append(".verifier(oauth_verifier)");
        }
        stringBuffer.append(";");
        stringBuffer.append("OAuthSecrets o_secrets = new OAuthSecrets().consumerSecret(CONSUMER_SECRET).tokenSecret(" + OAuthHelper.getParamFromResponse(metadata, methodType.getResponseStyle(), "requestTokenResponse", "oauth_token_secret") + ");");
        stringBuffer.append("OAuthClientFilter o_filter = new OAuthClientFilter(accessTokenClient.getProviders(), o_params, o_secrets);");
        stringBuffer.append("resource.addFilter(o_filter);");
        stringBuffer.append("return resource.get(" + OAuthHelper.getResponseClass(methodType2.getResponseStyle(), true) + ");");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getInitOAuthBodyWeb(Metadata metadata) {
        MethodType methodType = metadata.getFlow().getAccessToken();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("HttpSession session = request.getSession();");
        stringBuffer.append("if ((String)session.getAttribute(\"oauth_token\") == null) {");
        stringBuffer.append("    response.sendRedirect(request.getContextPath() + \"/OAuthLogin\");");
        stringBuffer.append("} else {");
        stringBuffer.append("oauth_params = new OAuthParameters().consumerKey(CONSUMER_KEY).token((String)session.getAttribute(\"oauth_token\"))");
        stringBuffer.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(metadata, null) + ")");
        stringBuffer.append(".version(\"" + OAuthHelper.getVersion(metadata) + "\")");
        if (OAuthHelper.isNonce(metadata)) {
            stringBuffer.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(metadata)) {
            stringBuffer.append(".timestamp()");
        }
        stringBuffer.append(";");
        stringBuffer.append("oauth_secrets = new OAuthSecrets().consumerSecret(CONSUMER_SECRET).tokenSecret((String)session.getAttribute(\"oauth_token_secret\"));");
        stringBuffer.append("oauth_filter = new OAuthClientFilter(client.getProviders(), oauth_params, oauth_secrets);");
        stringBuffer.append("webResource.addFilter(oauth_filter);");
        stringBuffer.append("}");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getInitOAuthBodyNb(Metadata metadata) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("java.util.prefs.Preferences prefs = org.openide.util.NbPreferences.forModule(this.getClass());");
        stringBuffer.append("String oauth_token = prefs.get(\"oauth_token\", null);");
        stringBuffer.append("String oauth_token_secret = prefs.get(\"oauth_token_secret\", null);");
        stringBuffer.append("if (oauth_token == null || oauth_token_secret == null) {");
        stringBuffer.append("    org.openide.DialogDisplayer.getDefault().notify(new org.openide.NotifyDescriptor.Message(\"You have to call the login() method first to authorize the application to access user data.\"));");
        stringBuffer.append("} else {");
        stringBuffer.append("oauth_params = new OAuthParameters().consumerKey(CONSUMER_KEY).token(oauth_token)");
        stringBuffer.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(metadata, null) + ")");
        stringBuffer.append(".version(\"" + OAuthHelper.getVersion(metadata) + "\")");
        if (OAuthHelper.isNonce(metadata)) {
            stringBuffer.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(metadata)) {
            stringBuffer.append(".timestamp()");
        }
        stringBuffer.append(";");
        stringBuffer.append("oauth_secrets = new OAuthSecrets().consumerSecret(CONSUMER_SECRET).tokenSecret(oauth_token_secret);");
        stringBuffer.append("oauth_filter = new OAuthClientFilter(client.getProviders(), oauth_params, oauth_secrets);");
        stringBuffer.append("webResource.addFilter(oauth_filter);");
        stringBuffer.append("}");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getBodyForUniqueRequest(Metadata metadata) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("if (oauth_params != null) {");
        if (OAuthHelper.isNonce(metadata)) {
            stringBuffer.append("oauth_params.nonce()");
            if (OAuthHelper.isTimestamp(metadata)) {
                stringBuffer.append(".timestamp();");
            }
        } else if (OAuthHelper.isTimestamp(metadata)) {
            stringBuffer.append("oauth_params.timestamp();");
        }
        stringBuffer.append("}");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getLoginBodyNb(Metadata metadata, String string) {
        MethodType methodType = metadata.getFlow().getRequestToken();
        MethodType methodType2 = metadata.getFlow().getAccessToken();
        String string2 = methodType2.isVerifier() != false ? "String oauth_verifier = " : "";
        String string3 = methodType2.isVerifier() != false ? ", oauth_verifier" : "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append(OAuthHelper.getResponseClass(methodType.getResponseStyle(), false) + " requestTokenResponse = getOAuthRequestToken();");
        stringBuffer.append(string2 + "authorizeConsumer(requestTokenResponse);");
        stringBuffer.append(OAuthHelper.getResponseClass(methodType2.getResponseStyle(), false) + " accessTokenResponse = getOAuthAccessToken(requestTokenResponse" + string3 + ");");
        stringBuffer.append("java.util.prefs.Preferences prefs = org.openide.util.NbPreferences.forModule(" + string + ".class);");
        stringBuffer.append("prefs.put(\"oauth_token\", " + OAuthHelper.getParamFromResponse(metadata, methodType2.getResponseStyle(), "accessTokenResponse", "oauth_token") + ");");
        stringBuffer.append("prefs.put(\"oauth_token_secret\", " + OAuthHelper.getParamFromResponse(metadata, methodType2.getResponseStyle(), "accessTokenResponse", "oauth_token_secret") + ");");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getLogoutBodyWeb(Metadata metadata) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("HttpSession session = request.getSession();");
        stringBuffer.append("session.removeAttribute(\"oauth_token\");");
        stringBuffer.append("session.removeAttribute(\"oauth_token_secret\");");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getLogoutBodyNb(Metadata metadata, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("java.util.prefs.Preferences prefs = org.openide.util.NbPreferences.forModule(" + string + ".class);");
        stringBuffer.append("prefs.remove(\"oauth_token\");");
        stringBuffer.append("prefs.remove(\"oauth_token_secret\");");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getAuthorizeConsumerBodyNb(Metadata metadata) {
        String string = Wadl2JavaHelper.getMethodBody("Templates/SaaSServices/OAuthAuthorizationPanelNb.java");
        MethodType methodType = metadata.getFlow().getAccessToken();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append(string);
        stringBuffer.append("String oauth_verifier = null;");
        stringBuffer.append("String loginUrl = " + OAuthHelper.getAuthorizationUrl(metadata) + ";");
        stringBuffer.append("DialogPanel dialogPanel = new DialogPanel(loginUrl);");
        stringBuffer.append("org.openide.DialogDescriptor dd = new org.openide.DialogDescriptor(dialogPanel, \"OAuth Authentication Dialog\");");
        stringBuffer.append("org.openide.DialogDisplayer.getDefault().notify(dd);");
        stringBuffer.append("if (dd.getValue() == org.openide.DialogDescriptor.OK_OPTION) {");
        stringBuffer.append("    oauth_verifier = dialogPanel.getVerifier();");
        stringBuffer.append("}");
        stringBuffer.append("return oauth_verifier;");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    static ClassTree addOAuthServlets(WorkingCopy workingCopy, ClassTree classTree, Metadata metadata, String string, boolean bl) {
        Tree tree;
        Object object;
        ClassTree classTree2 = classTree;
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        TypeElement typeElement = workingCopy.getElements().getTypeElement("javax.servlet.annotation.WebServlet");
        HashSet<Modifier> hashSet = new HashSet<Modifier>();
        hashSet.add(Modifier.PUBLIC);
        hashSet.add(Modifier.STATIC);
        ModifiersTree modifiersTree = treeMaker.Modifiers(hashSet);
        String string2 = "OAuthLoginServlet";
        if (bl && typeElement != null) {
            object = new ArrayList();
            object.add(treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"name"), (ExpressionTree)treeMaker.Literal((Object)string2)));
            object.add(treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"urlPatterns"), (ExpressionTree)treeMaker.Literal((Object)"/OAuthLogin")));
            tree = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)typeElement), (List)object);
            modifiersTree = treeMaker.addModifiersAnnotation(modifiersTree, (AnnotationTree)tree);
        }
        object = JavaSourceHelper.createTypeTree(workingCopy, "javax.servlet.http.HttpServlet");
        tree = treeMaker.Class(modifiersTree, (CharSequence)string2, Collections.emptyList(), (Tree)object, Collections.emptyList(), Collections.emptyList());
        ModifiersTree modifiersTree2 = treeMaker.Modifiers(Collections.singleton(Modifier.PROTECTED));
        ModifiersTree modifiersTree3 = treeMaker.Modifiers(Collections.emptySet());
        ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
        ExpressionTree expressionTree = JavaSourceHelper.createTypeTree(workingCopy, "javax.servlet.http.HttpServletRequest");
        VariableTree variableTree = treeMaker.Variable(modifiersTree3, (CharSequence)"request", (Tree)expressionTree, null);
        arrayList.add(variableTree);
        expressionTree = JavaSourceHelper.createTypeTree(workingCopy, "javax.servlet.http.HttpServletResponse");
        variableTree = treeMaker.Variable(modifiersTree3, (CharSequence)"response", (Tree)expressionTree, null);
        arrayList.add(variableTree);
        ArrayList<ExpressionTree> arrayList2 = new ArrayList<ExpressionTree>();
        ExpressionTree expressionTree2 = JavaSourceHelper.createTypeTree(workingCopy, "javax.servlet.ServletException");
        ExpressionTree expressionTree3 = JavaSourceHelper.createTypeTree(workingCopy, "java.io.IOException");
        arrayList2.add(expressionTree2);
        arrayList2.add(expressionTree3);
        MethodTree methodTree = treeMaker.Method(modifiersTree2, (CharSequence)"doGet", (Tree)treeMaker.Identifier((CharSequence)"void"), Collections.emptyList(), arrayList, arrayList2, OAuthHelper.getOAuthLoginBody(metadata), null);
        ClassTree classTree3 = treeMaker.addClassMember(tree, (Tree)methodTree);
        classTree2 = treeMaker.addClassMember(classTree2, (Tree)classTree3);
        modifiersTree = treeMaker.Modifiers(hashSet);
        string2 = "OAuthCallbackServlet";
        if (bl && typeElement != null) {
            ArrayList<AssignmentTree> arrayList3 = new ArrayList<AssignmentTree>();
            arrayList3.add(treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"name"), (ExpressionTree)treeMaker.Literal((Object)string2)));
            arrayList3.add(treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"urlPatterns"), (ExpressionTree)treeMaker.Literal((Object)"/OAuthCallback")));
            AnnotationTree annotationTree = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)typeElement), arrayList3);
            modifiersTree = treeMaker.addModifiersAnnotation(modifiersTree, annotationTree);
        }
        tree = treeMaker.Class(modifiersTree, (CharSequence)string2, Collections.emptyList(), (Tree)object, Collections.emptyList(), Collections.emptyList());
        methodTree = treeMaker.Method(modifiersTree2, (CharSequence)"doGet", (Tree)treeMaker.Identifier((CharSequence)"void"), Collections.emptyList(), arrayList, arrayList2, OAuthHelper.getOAuthCallbackBody(metadata, string), null);
        classTree3 = treeMaker.addClassMember(tree, (Tree)methodTree);
        classTree2 = treeMaker.addClassMember(classTree2, (Tree)classTree3);
        return classTree2;
    }

    private static String getOAuthLoginBody(Metadata metadata) {
        String string = metadata.getFlow().getRequestToken().getResponseStyle();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("response.setContentType(\"text/html;charset=UTF-8\");");
        stringBuffer.append("java.io.PrintWriter out = response.getWriter();");
        stringBuffer.append("try {");
        stringBuffer.append(OAuthHelper.getResponseClass(string, false) + " requestTokenResponse = null;");
        stringBuffer.append("UniformInterfaceException uiEx = null;");
        stringBuffer.append("try {");
        stringBuffer.append("    requestTokenResponse = getOAuthRequestToken();");
        stringBuffer.append("    javax.servlet.http.HttpSession session = request.getSession(true);");
        stringBuffer.append("    session.setAttribute(\"oauth_token\", " + OAuthHelper.getParamFromResponse(metadata, string, "requestTokenResponse", "oauth_token") + ");");
        stringBuffer.append("    session.setAttribute(\"oauth_token_secret\", " + OAuthHelper.getParamFromResponse(metadata, string, "requestTokenResponse", "oauth_token_secret") + ");");
        stringBuffer.append("} catch (UniformInterfaceException ex) ");
        stringBuffer.append("    uiEx = ex;");
        stringBuffer.append("}");
        stringBuffer.append("out.println(\"<html>\");");
        stringBuffer.append("out.println(\"<head>\");");
        stringBuffer.append("out.println(\"<title>OAuth Login Servlet</title>\");");
        stringBuffer.append("out.println(\"</head>\");");
        stringBuffer.append("out.println(\"<body>\");");
        stringBuffer.append("out.println(\"<h1>OAuth Login Servlet at \" + request.getContextPath() + \"</h1>\");");
        stringBuffer.append("if (uiEx == null) {");
        stringBuffer.append("out.println(\"<a href='\"+" + OAuthHelper.getAuthorizationUrl(metadata) + "+\"'>");
        stringBuffer.append("Click at this link to authorize the application to access your data</a>\");");
        stringBuffer.append("} else {");
        stringBuffer.append("out.println(\"Problem to get request token: \"+uiEx.getResponse()+\": \"+uiEx.getResponse().getEntity(String.class));");
        stringBuffer.append("}");
        stringBuffer.append("out.println(\"</body>\");");
        stringBuffer.append("out.println(\"</html>\");");
        stringBuffer.append("} finally {");
        stringBuffer.append("    out.close();");
        stringBuffer.append("}");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getOAuthCallbackBody(Metadata metadata, String string) {
        String string2 = metadata.getFlow().getAccessToken().getResponseStyle();
        boolean bl = OAuthHelper.isVerifier(metadata.getFlow().getAccessToken());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("response.setContentType(\"text/html;charset=UTF-8\");");
        stringBuffer.append("java.io.PrintWriter out = response.getWriter();");
        stringBuffer.append("try {");
        if (bl) {
            stringBuffer.append("String oauth_verifier = request.getParameter(\"oauth_verifier\");");
        }
        stringBuffer.append(OAuthHelper.getResponseClass(string2, false) + " accessTokenResponse = null;");
        stringBuffer.append("UniformInterfaceException uiEx = null;");
        stringBuffer.append("try {");
        stringBuffer.append("    javax.servlet.http.HttpSession session = request.getSession(true);");
        stringBuffer.append("    accessTokenResponse = getOAuthAccessToken(session" + (bl ? ", oauth_verifier" : "") + ");");
        stringBuffer.append("    session.setAttribute(\"oauth_token\", " + OAuthHelper.getParamFromResponse(metadata, string2, "accessTokenResponse", "oauth_token") + ");");
        stringBuffer.append("    session.setAttribute(\"oauth_token_secret\", " + OAuthHelper.getParamFromResponse(metadata, string2, "accessTokenResponse", "oauth_token_secret") + ");");
        stringBuffer.append("} catch (UniformInterfaceException ex) {");
        stringBuffer.append("    uiEx = ex;");
        stringBuffer.append("}");
        stringBuffer.append("out.println(\"<html>\");");
        stringBuffer.append("out.println(\"<head>\");");
        stringBuffer.append("out.println(\"<title>OAuth Callback Servlet</title>\");");
        stringBuffer.append("out.println(\"</head>\");");
        stringBuffer.append("out.println(\"<body>\");");
        stringBuffer.append("out.println(\"<h1>OAuth Callback Servlet at \" + request.getContextPath() + \"</h1>\");");
        stringBuffer.append("if (uiEx == null) {");
        stringBuffer.append("    out.println(\"Now, you have successfully authorized this application to access your data.<br><br>\");");
        stringBuffer.append("    out.println(\"Usage: <p><pre>\");");
        stringBuffer.append("    out.println(\"   " + string + " client = new " + string + "(...);\");");
        stringBuffer.append("    out.println(\"   client.initOAuth(httpServletRequest, httpServletResponse);\");");
        stringBuffer.append("    out.println(\"   // call any method\");");
        stringBuffer.append("    out.println(\"   client.close();\");");
        stringBuffer.append("    out.println(\"</pre></p>\");");
        stringBuffer.append("} else {");
        stringBuffer.append("    out.println(\"Problem to get access token: \"+uiEx.getResponse()+\": \"+uiEx.getResponse().getEntity(String.class));");
        stringBuffer.append("}");
        stringBuffer.append("out.println(\"</body>\");");
        stringBuffer.append("out.println(\"</html>\");");
        stringBuffer.append("} finally {");
        stringBuffer.append("    out.close();");
        stringBuffer.append("}");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static boolean needXPath(MethodType methodType) {
        return !"FORM".equals(methodType.getResponseStyle());
    }

    private static String getXPathForParam(Metadata metadata, String string) {
        for (ParamType paramType : metadata.getParam()) {
            if (!string.equals(paramType.getOauthName())) continue;
            return paramType.getXpath();
        }
        return null;
    }

    private static String getBodyForSearchMethod(String string) {
        return Wadl2JavaHelper.getMethodBody("Templates/SaaSServices/OAuthSearch" + string + ".method");
    }
}

