/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.status;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.WorkingCopyAttributesCache;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.diff.DiffAction;
import org.netbeans.modules.subversion.ui.status.VersioningPanel;
import org.netbeans.modules.subversion.ui.update.ResolveConflictsAction;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SyncFileNode
extends AbstractNode {
    private SvnFileNode node;
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_PATH = "path";
    static final String COLUMN_NAME_STATUS = "status";
    static final String COLUMN_NAME_BRANCH = "branch";
    private String htmlDisplayName;
    private RequestProcessor.Task repoload;
    private final VersioningPanel panel;
    private static final String[] zeros = new String[]{"", "00", "0", ""};

    SyncFileNode(SvnFileNode node, VersioningPanel _panel) {
        this(Children.LEAF, node, _panel);
    }

    private SyncFileNode(Children children, SvnFileNode node, VersioningPanel _panel) {
        super(children, Lookups.fixed((Object[])node.getLookupObjects()));
        this.node = node;
        this.panel = _panel;
        this.initProperties();
        this.refreshHtmlDisplayName();
    }

    public File getFile() {
        return this.node.getFile();
    }

    public FileInformation getFileInformation() {
        return this.node.getInformation();
    }

    public String getName() {
        return this.node.getName();
    }

    public Action getPreferredAction() {
        if ((this.node.getInformation().getStatus() & 0x4040) != 0) {
            return SystemAction.get(ResolveConflictsAction.class);
        }
        return SystemAction.get(DiffAction.class);
    }

    public <T extends Node.Cookie> T getCookie(Class<T> klass) {
        FileObject fo = this.node.getFileObject();
        if (fo != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                if (fo.equals(dobj.getPrimaryFile())) {
                    return (T)dobj.getCookie(klass);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return (T)super.getCookie(klass);
    }

    private void initProperties() {
        if (this.node.getFile().isDirectory()) {
            this.setIconBaseWithExtension("org/openide/loaders/defaultFolder.gif");
        }
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new NameProperty());
        ps.put((Node.Property)new PathProperty());
        ps.put((Node.Property)new StatusProperty());
        ps.put((Node.Property)new BranchProperty());
        sheet.put(ps);
        this.setSheet(sheet);
    }

    private void refreshHtmlDisplayName() {
        FileInformation info = this.node.getInformation();
        int status = info.getStatus();
        if (status == 128) {
            status = 16448;
        }
        this.htmlDisplayName = Subversion.getInstance().getAnnotator().annotateNameHtml(this.node.getFile().getName(), info, null);
        this.fireDisplayNameChange(this.node.getName(), this.node.getName());
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public void refresh() {
        this.refreshHtmlDisplayName();
    }

    public void destroy() throws IOException {
        super.destroy();
        if (this.repoload != null) {
            this.repoload.cancel();
        }
    }

    private class StatusProperty
    extends SyncFileProperty {
        public StatusProperty() {
            super(SyncFileNode.COLUMN_NAME_STATUS, NbBundle.getMessage(SyncFileNode.class, (String)"BK2007"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2008"));
            String shortPath = SyncFileNode.COLUMN_NAME_PATH;
            String sortable = Integer.toString(SvnUtils.getComparableStatus(SyncFileNode.this.node.getInformation().getStatus()));
            this.setValue("sortkey", zeros[sortable.length()] + sortable + "\t" + shortPath + "\t" + SyncFileNode.this.getName());
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            FileInformation finfo = SyncFileNode.this.node.getInformation();
            finfo.getEntry(SyncFileNode.this.node.getFile());
            int mask = SyncFileNode.this.panel.getDisplayStatuses();
            return finfo.getStatusText(mask);
        }
    }

    private class NameProperty
    extends SyncFileProperty {
        public NameProperty() {
            super(SyncFileNode.COLUMN_NAME_NAME, NbBundle.getMessage(SyncFileNode.class, (String)"BK2005"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2006"));
            this.setValue("sortkey", SyncFileNode.this.getName());
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return SyncFileNode.this.getDisplayName();
        }
    }

    private class PathProperty
    extends SyncFileProperty {
        private String shortPath;
        private boolean reading;

        public PathProperty() {
            super(SyncFileNode.COLUMN_NAME_PATH, NbBundle.getMessage(SyncFileNode.class, (String)"BK2003"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2004"));
            this.setValue("sortkey", "\u65000\t" + SyncFileNode.this.getName());
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            if (this.shortPath == null && !this.reading) {
                this.reading = true;
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        if (PathProperty.this.shortPath != null) {
                            return;
                        }
                        try {
                            PathProperty.this.shortPath = SvnModuleConfig.getDefault().isRepositoryPathPrefixed() ? SvnUtils.getRepositoryUrl(SyncFileNode.this.node.getFile()).toString() : SvnUtils.getRelativePath(SyncFileNode.this.node.getFile());
                        }
                        catch (SVNClientException ex) {
                            if (WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) {
                                try {
                                    WorkingCopyAttributesCache.getInstance().logSuppressed(ex, SyncFileNode.this.node.getFile());
                                }
                                catch (SVNClientException sVNClientException) {}
                            }
                            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                        }
                        if (PathProperty.this.shortPath == null) {
                            PathProperty.this.shortPath = NbBundle.getMessage(SyncFileNode.class, (String)"LBL_Location_NotInRepository");
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PathProperty.this.setValue("sortkey", PathProperty.this.shortPath + "\t" + SyncFileNode.this.getName());
                                SyncFileNode.this.firePropertyChange(SyncFileNode.COLUMN_NAME_PATH, null, null);
                            }
                        });
                    }
                };
                SyncFileNode.this.repoload = Subversion.getInstance().getRequestProcessor().post(run);
            }
            return this.shortPath == null ? NbBundle.getMessage(SyncFileNode.class, (String)"LBL_RepositoryPath_LoadingProgress") : this.shortPath;
        }
    }

    private class BranchProperty
    extends SyncFileProperty {
        public BranchProperty() {
            super(SyncFileNode.COLUMN_NAME_BRANCH, NbBundle.getMessage(SyncFileNode.class, (String)"BK2001"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2002"));
        }

        public String getValue() {
            String copyName = SvnUtils.getCopy(SyncFileNode.this.node.getFile());
            return copyName == null ? "" : copyName;
        }
    }

    private abstract class SyncFileProperty
    extends PropertySupport.ReadOnly<String> {
        protected SyncFileProperty(String name, String displayName, String shortDescription) {
            super(name, String.class, displayName, shortDescription);
        }

        public String toString() {
            try {
                return ((String)this.getValue()).toString();
            }
            catch (Exception e) {
                Subversion.LOG.log(Level.INFO, null, e);
                return e.getLocalizedMessage();
            }
        }
    }
}

