/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.kenai.SvnKenaiAccessor;
import org.netbeans.modules.subversion.ui.diff.DiffSetupSource;
import org.netbeans.modules.subversion.ui.diff.Setup;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.modules.subversion.ui.update.RevertModifications;
import org.netbeans.modules.subversion.ui.update.RevertModificationsAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.netbeans.modules.versioning.util.VCSHyperlinkSupport;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

class SummaryView
implements MouseListener,
ComponentListener,
MouseMotionListener,
DiffSetupSource {
    private static final String SUMMARY_REVERT_PROPERTY = "Summary-Revert-";
    private final SearchHistoryPanel master;
    private JList resultsList;
    private JScrollPane scrollPane;
    private final List dispResults;
    private String message;
    private AttributeSet searchHiliteAttrs;
    private List<RepositoryRevision> results;
    private Map<String, VCSKenaiAccessor.KenaiUser> kenaiUsersMap = null;
    private VCSHyperlinkSupport linkerSupport = new VCSHyperlinkSupport();

    public SummaryView(SearchHistoryPanel master, List<RepositoryRevision> results) {
        this.master = master;
        this.results = results;
        this.dispResults = this.expandResults(results);
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getMimeLookup((String)"text/x-java").lookup(FontColorSettings.class);
        this.searchHiliteAttrs = fcs.getFontColors("highlight-search");
        this.message = master.getCriteria().getCommitMessage();
        this.resultsList = new JList(new SummaryListModel());
        this.resultsList.setFixedCellHeight(-1);
        this.resultsList.addMouseListener(this);
        this.resultsList.addMouseMotionListener(this);
        this.resultsList.setCellRenderer(new SummaryCellRenderer());
        this.resultsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SummaryView.class, (String)"ACSN_SummaryView_List"));
        this.resultsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SummaryView.class, (String)"ACSD_SummaryView_List"));
        this.scrollPane = new JScrollPane(this.resultsList, 22, 31);
        master.addComponentListener(this);
        this.resultsList.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.resultsList.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SummaryView.this.onPopup(Utils.getPositionForPopup((JList)SummaryView.this.resultsList));
            }
        });
        if (results.size() > 0) {
            boolean isKenaiRepository;
            SVNUrl url = results.get(0).getRepositoryRootUrl();
            boolean bl = isKenaiRepository = url != null && SvnKenaiAccessor.getInstance().isKenai(url.toString());
            if (isKenaiRepository) {
                this.kenaiUsersMap = new HashMap<String, VCSKenaiAccessor.KenaiUser>();
                for (RepositoryRevision repositoryRevision : results) {
                    VCSKenaiAccessor.KenaiUser kenaiUser;
                    String author = repositoryRevision.getLog().getAuthor();
                    if (author == null || author.equals("") || this.kenaiUsersMap.keySet().contains(author) || (kenaiUser = SvnKenaiAccessor.getInstance().forName(author, url.toString())) == null) continue;
                    this.kenaiUsersMap.put(author, kenaiUser);
                }
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int[] selection = this.resultsList.getSelectedIndices();
        this.resultsList.setModel(new SummaryListModel());
        this.resultsList.setSelectedIndices(selection);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private List expandResults(List<RepositoryRevision> results) {
        ArrayList<Object> newResults = new ArrayList<Object>(results.size());
        for (RepositoryRevision repositoryRevision : results) {
            newResults.add(repositoryRevision);
            List<RepositoryRevision.Event> events = repositoryRevision.getEvents();
            for (RepositoryRevision.Event event : events) {
                newResults.add(event);
            }
        }
        return newResults;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int idx = this.resultsList.locationToIndex(e.getPoint());
        if (idx == -1) {
            return;
        }
        Rectangle rect = this.resultsList.getCellBounds(idx, idx);
        Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
        Rectangle diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.diffPrevious(idx);
        }
        if ((diffBounds = (Rectangle)this.resultsList.getClientProperty(SUMMARY_REVERT_PROPERTY + idx)) != null && diffBounds.contains(p)) {
            this.revertModifications(new int[]{idx});
        }
        this.linkerSupport.mouseClicked(p, idx);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.resultsList.setCursor(Cursor.getPredefinedCursor(0));
        this.resultsList.setToolTipText("");
        int idx = this.resultsList.locationToIndex(e.getPoint());
        if (idx == -1) {
            return;
        }
        Rectangle rect = this.resultsList.getCellBounds(idx, idx);
        Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
        Rectangle diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        diffBounds = (Rectangle)this.resultsList.getClientProperty(SUMMARY_REVERT_PROPERTY + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        this.linkerSupport.mouseMoved(p, (JComponent)this.resultsList, idx);
    }

    @Override
    public Collection<Setup> getSetups() {
        int[] sel;
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes.length == 0) {
            return this.master.getSetups(this.results.toArray(new RepositoryRevision[this.results.size()]), new RepositoryRevision.Event[0]);
        }
        HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> revisions = new HashSet<RepositoryRevision>();
        for (int i : sel = this.resultsList.getSelectedIndices()) {
            Object revCon = this.dispResults.get(i);
            if (revCon instanceof RepositoryRevision) {
                revisions.add((RepositoryRevision)revCon);
                continue;
            }
            events.add((RepositoryRevision.Event)revCon);
        }
        return this.master.getSetups(revisions.toArray(new RepositoryRevision[revisions.size()]), events.toArray(new RepositoryRevision.Event[events.size()]));
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    private boolean isMixedSelection(List dispResults, int[] selection) {
        if (selection.length < 1) {
            return false;
        }
        Class<?> c = dispResults.get(selection[0]).getClass();
        for (int i = 0; i < selection.length; ++i) {
            if (c.equals(dispResults.get(selection[i]).getClass())) continue;
            return true;
        }
        return false;
    }

    private void onPopup(MouseEvent e) {
        this.onPopup(e.getPoint());
    }

    private void onPopup(Point p) {
        boolean diffToPrevEnabled;
        ArrayList<RepositoryRevision.Event> drevList;
        boolean revisionSelected;
        int[] sel = this.resultsList.getSelectedIndices();
        if (sel.length == 0) {
            int idx = this.resultsList.locationToIndex(p);
            if (idx == -1) {
                return;
            }
            this.resultsList.setSelectedIndex(idx);
            sel = new int[]{idx};
        }
        final int[] selection = sel;
        JPopupMenu menu = new JPopupMenu();
        Object previousRevision = null;
        RepositoryRevision container = null;
        Object revCon = this.dispResults.get(selection[0]);
        boolean noExDeletedExistingFiles = true;
        boolean missingFile = false;
        boolean oneRevisionMultiselected = true;
        boolean deleted = false;
        if (revCon instanceof RepositoryRevision) {
            revisionSelected = true;
            container = (RepositoryRevision)this.dispResults.get(selection[0]);
            drevList = new ArrayList(0);
            oneRevisionMultiselected = true;
            noExDeletedExistingFiles = true;
        } else {
            revisionSelected = false;
            drevList = new ArrayList<RepositoryRevision.Event>(selection.length);
            for (int i = 0; i < selection.length; ++i) {
                if (!(this.dispResults.get(selection[i]) instanceof RepositoryRevision.Event)) {
                    revisionSelected = true;
                    continue;
                }
                RepositoryRevision.Event event = (RepositoryRevision.Event)this.dispResults.get(selection[i]);
                drevList.add(event);
                File file = event.getFile();
                if (!deleted && file != null && !file.exists() && event.getChangedPath().getAction() == 'D') {
                    deleted = true;
                }
                if (!missingFile && event.getFile() == null) {
                    missingFile = true;
                }
                if (oneRevisionMultiselected && i > 0 && ((RepositoryRevision.Event)drevList.get(0)).getLogInfoHeader().getLog().getRevision().getNumber() != ((RepositoryRevision.Event)drevList.get(0)).getLogInfoHeader().getLog().getRevision().getNumber()) {
                    oneRevisionMultiselected = false;
                }
                if (file == null || !file.exists() || event.getChangedPath().getAction() != 'D') continue;
                noExDeletedExistingFiles = false;
            }
            container = ((RepositoryRevision.Event)drevList.get(0)).getLogInfoHeader();
        }
        final RepositoryRevision.Event[] drev = drevList.toArray(new RepositoryRevision.Event[drevList.size()]);
        long revision = container.getLog().getRevision().getNumber();
        final boolean rollbackToEnabled = !deleted && !missingFile && !revisionSelected && oneRevisionMultiselected;
        final boolean rollbackChangeEnabled = !missingFile && oneRevisionMultiselected && (drev.length == 0 || noExDeletedExistingFiles);
        final boolean viewEnabled = selection.length == 1 && !revisionSelected && drev[0].getFile() != null && !drev[0].getFile().isDirectory() && drev[0].getChangedPath().getAction() != 'D';
        boolean bl = diffToPrevEnabled = selection.length == 1;
        if (revision > 1L) {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious", previousRevision)){
                {
                    super(x0);
                    this.setEnabled(diffToPrevEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SummaryView.this.diffPrevious(selection[0]);
                }
            }));
        }
        menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackChange")){
            {
                super(x0);
                this.setEnabled(rollbackChangeEnabled);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SummaryView.this.revertModifications(selection);
            }
        }));
        if (!revisionSelected) {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackTo", (Object)revision)){
                {
                    super(x0);
                    this.setEnabled(rollbackToEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            SummaryView.rollback(drev);
                        }
                    });
                }
            }));
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View")){
                {
                    super(x0);
                    this.setEnabled(viewEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            SummaryView.this.view(selection[0], false);
                        }
                    });
                }
            }));
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_ShowAnnotations")){
                {
                    super(x0);
                    this.setEnabled(viewEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            SummaryView.this.view(selection[0], true);
                        }
                    });
                }
            }));
        }
        menu.show(this.resultsList, p.x, p.y);
    }

    static void rollback(RepositoryRevision.Event event) {
        SummaryView.rollback(new RepositoryRevision.Event[]{event});
    }

    static void rollback(final RepositoryRevision.Event[] events) {
        SVNUrl repository = events[0].getLogInfoHeader().getRepositoryRootUrl();
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repository);
        SvnProgressSupport support = new SvnProgressSupport(){

            @Override
            public void perform() {
                for (RepositoryRevision.Event event : events) {
                    this.rollback(event);
                }
            }

            private void rollback(RepositoryRevision.Event event) {
                File file = event.getFile();
                if (event.getChangedPath().getAction() == 'D') {
                    if (file.exists()) {
                        try {
                            SvnClient client = Subversion.getInstance().getClient(false);
                            client.remove(new File[]{file}, true);
                        }
                        catch (SVNClientException ex) {
                            Subversion.LOG.log(Level.SEVERE, null, ex);
                        }
                        Subversion.getInstance().getStatusCache().refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                    }
                    return;
                }
                File parent = file.getParentFile();
                parent.mkdirs();
                SVNUrl repoUrl = event.getLogInfoHeader().getRepositoryRootUrl();
                SVNUrl fileUrl = repoUrl.appendPath(event.getChangedPath().getPath());
                try {
                    File oldFile = VersionsCache.getInstance().getFileRevision(repoUrl, fileUrl, Long.toString(event.getLogInfoHeader().getLog().getRevision().getNumber()), event.getFile().getName());
                    for (int i = 1; i < 7 && !file.delete(); ++i) {
                        try {
                            Thread.sleep(i * 34);
                            continue;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    FileUtil.copyFile((FileObject)FileUtil.toFileObject((File)oldFile), (FileObject)FileUtil.toFileObject((File)parent), (String)file.getName(), (String)"");
                }
                catch (IOException e) {
                    if (SummaryView.refersToDirectory(e)) {
                        Subversion.LOG.log(Level.FINE, null, e);
                        this.getLogger().logError(NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView.refersToDirectory", (Object)fileUrl));
                    }
                    Subversion.LOG.log(Level.SEVERE, null, e);
                }
            }
        };
        support.start(rp, repository, NbBundle.getMessage(SummaryView.class, (String)"MSG_Rollback_Progress"));
    }

    private static boolean refersToDirectory(Exception ex) {
        boolean dir = false;
        for (Throwable t = ex; t != null && !(dir = t.getMessage().contains("refers to a directory")); t = t.getCause()) {
        }
        return dir;
    }

    private void revertModifications(int[] selection) {
        HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> revisions = new HashSet<RepositoryRevision>();
        for (int idx : selection) {
            Object o = this.dispResults.get(idx);
            if (o instanceof RepositoryRevision) {
                revisions.add((RepositoryRevision)o);
                continue;
            }
            events.add((RepositoryRevision.Event)o);
        }
        SummaryView.revert(this.master, revisions.toArray(new RepositoryRevision[revisions.size()]), events.toArray(new RepositoryRevision.Event[events.size()]));
    }

    static void revert(final SearchHistoryPanel master, final RepositoryRevision[] revisions, final RepositoryRevision.Event[] events) {
        SVNUrl url;
        try {
            url = master.getSearchRepositoryRootUrl();
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(url);
        SvnProgressSupport support = new SvnProgressSupport(){

            @Override
            public void perform() {
                SummaryView.revertImpl(master, revisions, events, this);
            }
        };
        support.start(rp, url, NbBundle.getMessage(SummaryView.class, (String)"MSG_Revert_Progress"));
    }

    private static void revertImpl(SearchHistoryPanel master, RepositoryRevision[] revisions, RepositoryRevision.Event[] events, SvnProgressSupport progress) {
        Context ctx;
        RevertModifications.RevisionInterval revisionInterval;
        SVNUrl url;
        try {
            url = master.getSearchRepositoryRootUrl();
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(url, url, SVNRevision.HEAD);
        for (RepositoryRevision revision : revisions) {
            revisionInterval = new RevertModifications.RevisionInterval((SVNRevision)revision.getLog().getRevision());
            ctx = new Context(master.getRoots());
            RevertModificationsAction.performRevert(revisionInterval, false, false, ctx, progress);
        }
        for (RepositoryRevision.Event event : events) {
            if (event.getFile() == null) continue;
            revisionInterval = new RevertModifications.RevisionInterval((SVNRevision)event.getLogInfoHeader().getLog().getRevision());
            ctx = new Context(event.getFile());
            RevertModificationsAction.performRevert(revisionInterval, false, false, ctx, progress);
        }
    }

    private void view(int idx, boolean showAnnotations) {
        Object o = this.dispResults.get(idx);
        if (o instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event drev = (RepositoryRevision.Event)o;
            File originFile = drev.getFile();
            SVNRevision.Number rev = drev.getLogInfoHeader().getLog().getRevision();
            SVNUrl repoUrl = drev.getLogInfoHeader().getRepositoryRootUrl();
            SVNUrl fileUrl = repoUrl.appendPath(drev.getChangedPath().getPath());
            SvnUtils.openInRevision(originFile, repoUrl, fileUrl, (SVNRevision)rev, (SVNRevision)rev, showAnnotations);
        }
    }

    private void diffPrevious(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event drev = (RepositoryRevision.Event)o;
            this.master.showDiff(drev);
        } else {
            RepositoryRevision container = (RepositoryRevision)o;
            this.master.showDiff(container);
        }
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    private static class HyperlinkLabel
    extends JLabel {
        public HyperlinkLabel() {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void set(String text, Color foreground, Color background) {
            StringBuilder sb = new StringBuilder(100);
            if (foreground.equals(UIManager.getColor("List.foreground"))) {
                sb.append("<html><a href=\"\">");
                sb.append(text);
                sb.append("</a>");
            } else {
                sb.append("<html><a href=\"\" style=\"color:");
                sb.append("rgb(");
                sb.append(foreground.getRed());
                sb.append(",");
                sb.append(foreground.getGreen());
                sb.append(",");
                sb.append(foreground.getBlue());
                sb.append(")");
                sb.append("\">");
                sb.append(text);
                sb.append("</a>");
            }
            this.setText(sb.toString());
            this.setBackground(background);
        }
    }

    private class SummaryCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final String FIELDS_SEPARATOR = "        ";
        private RevisionRenderer cr = new RevisionRenderer();
        private ChangepathRenderer rr = new ChangepathRenderer();

        private SummaryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof RepositoryRevision) {
                return this.cr.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
            return this.rr.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }

        private class ChangepathRenderer
        extends DefaultListCellRenderer {
            private ChangepathRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                RepositoryRevision.Event revisionEvent = (RepositoryRevision.Event)value;
                StringBuilder sb = new StringBuilder();
                sb.append(SummaryCellRenderer.FIELDS_SEPARATOR);
                sb.append(String.valueOf(revisionEvent.getChangedPath().getAction()));
                sb.append(SummaryCellRenderer.FIELDS_SEPARATOR);
                sb.append(revisionEvent.getChangedPath().getPath());
                Component renderer = super.getListCellRendererComponent((JList<?>)list, sb.toString(), index, isSelected, isSelected);
                if (renderer instanceof JLabel) {
                    ((JLabel)renderer).setToolTipText(sb.toString());
                }
                return renderer;
            }
        }

        private class RevisionRenderer
        extends JPanel
        implements ListCellRenderer {
            private static final double DARKEN_FACTOR = 0.95;
            private Style selectedStyle;
            private Style normalStyle;
            private Style filenameStyle;
            private Style indentStyle;
            private Style noindentStyle;
            private Style hiliteStyle;
            private Style issueHyperlinkStyle;
            private final Style authorStyle;
            private Color selectionBackground;
            private Color selectionForeground;
            private JTextPane textPane = new JTextPane();
            private JPanel actionsPane = new JPanel();
            private DateFormat defaultFormat;
            private int index;
            private HyperlinkLabel diffLink;
            private HyperlinkLabel revertLink;

            public RevisionRenderer() {
                this.selectionBackground = new JList().getSelectionBackground();
                this.selectionForeground = new JList().getSelectionForeground();
                this.selectedStyle = this.textPane.addStyle("selected", null);
                StyleConstants.setForeground(this.selectedStyle, this.selectionForeground);
                StyleConstants.setBackground(this.selectedStyle, this.selectionBackground);
                this.normalStyle = this.textPane.addStyle("normal", null);
                StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
                this.filenameStyle = this.textPane.addStyle("filename", this.normalStyle);
                StyleConstants.setBold(this.filenameStyle, true);
                this.indentStyle = this.textPane.addStyle("indent", null);
                StyleConstants.setLeftIndent(this.indentStyle, 50.0f);
                this.noindentStyle = this.textPane.addStyle("noindent", null);
                StyleConstants.setLeftIndent(this.noindentStyle, 0.0f);
                this.defaultFormat = DateFormat.getDateTimeInstance();
                this.issueHyperlinkStyle = this.textPane.addStyle("issuehyperlink", this.normalStyle);
                StyleConstants.setForeground(this.issueHyperlinkStyle, Color.BLUE);
                StyleConstants.setUnderline(this.issueHyperlinkStyle, true);
                this.authorStyle = this.textPane.addStyle("author", this.normalStyle);
                StyleConstants.setForeground(this.authorStyle, Color.BLUE);
                this.hiliteStyle = this.textPane.addStyle("hilite", this.normalStyle);
                Color c = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Background);
                if (c != null) {
                    StyleConstants.setBackground(this.hiliteStyle, c);
                }
                if ((c = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Foreground)) != null) {
                    StyleConstants.setForeground(this.hiliteStyle, c);
                }
                this.setLayout(new BorderLayout());
                this.add(this.textPane);
                this.add((Component)this.actionsPane, "Last");
                this.actionsPane.setLayout(new FlowLayout(4, 2, 5));
                this.diffLink = new HyperlinkLabel();
                this.diffLink.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
                this.actionsPane.add(this.diffLink);
                this.revertLink = new HyperlinkLabel();
                this.actionsPane.add(this.revertLink);
                this.textPane.setBorder(null);
            }

            public Color darker(Color c) {
                return new Color(Math.max((int)((double)c.getRed() * 0.95), 0), Math.max((int)((double)c.getGreen() * 0.95), 0), Math.max((int)((double)c.getBlue() * 0.95), 0));
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Style style;
                Color backgroundColor;
                Color foregroundColor;
                RepositoryRevision revision = (RepositoryRevision)value;
                StyledDocument sd = this.textPane.getStyledDocument();
                if (isSelected) {
                    foregroundColor = this.selectionForeground;
                    backgroundColor = this.selectionBackground;
                    style = this.selectedStyle;
                } else {
                    foregroundColor = UIManager.getColor("List.foreground");
                    backgroundColor = UIManager.getColor("List.background");
                    backgroundColor = this.darker(backgroundColor);
                    style = this.normalStyle;
                }
                this.textPane.setBackground(backgroundColor);
                this.actionsPane.setBackground(backgroundColor);
                this.index = index;
                Lookup.Result hpResult = Lookup.getDefault().lookupResult(VCSHyperlinkProvider.class);
                Collection hpInstances = hpResult.allInstances();
                try {
                    int idx;
                    String commitMessage;
                    VCSKenaiAccessor.KenaiUser kenaiUser;
                    sd.remove(0, sd.getLength());
                    sd.setParagraphAttributes(0, sd.getLength(), this.noindentStyle, false);
                    sd.insertString(0, Long.toString(revision.getLog().getRevision().getNumber()), style);
                    sd.setCharacterAttributes(0, sd.getLength(), this.filenameStyle, false);
                    sd.insertString(sd.getLength(), SummaryCellRenderer.FIELDS_SEPARATOR, style);
                    String author = revision.getLog().getAuthor();
                    VCSHyperlinkSupport.StyledDocumentHyperlink l = (VCSHyperlinkSupport.StyledDocumentHyperlink)SummaryView.this.linkerSupport.getLinker(VCSHyperlinkSupport.AuthorLinker.class, index);
                    if (l == null && SummaryView.this.kenaiUsersMap != null && author != null && !author.equals("") && (kenaiUser = (VCSKenaiAccessor.KenaiUser)SummaryView.this.kenaiUsersMap.get(author)) != null) {
                        l = new VCSHyperlinkSupport.AuthorLinker(kenaiUser, this.authorStyle, sd, author);
                        SummaryView.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l, index);
                    }
                    if (l != null) {
                        l.insertString(sd, isSelected ? style : null);
                    } else {
                        sd.insertString(sd.getLength(), author, style);
                    }
                    Date date = revision.getLog().getDate();
                    if (date != null) {
                        sd.insertString(sd.getLength(), SummaryCellRenderer.FIELDS_SEPARATOR + this.defaultFormat.format(date), style);
                    }
                    if ((commitMessage = revision.getLog().getMessage()) == null) {
                        commitMessage = "";
                    }
                    if (commitMessage.endsWith("\n")) {
                        commitMessage = commitMessage.substring(0, commitMessage.length() - 1);
                    }
                    sd.insertString(sd.getLength(), "\n", style);
                    l = (VCSHyperlinkSupport.StyledDocumentHyperlink)SummaryView.this.linkerSupport.getLinker(VCSHyperlinkSupport.IssueLinker.class, index);
                    if (l == null) {
                        for (VCSHyperlinkProvider hp : hpInstances) {
                            l = VCSHyperlinkSupport.IssueLinker.create((VCSHyperlinkProvider)hp, (Style)this.issueHyperlinkStyle, (File)SummaryView.this.master.getRoots()[0], (StyledDocument)sd, (String)commitMessage);
                            if (l == null) continue;
                            SummaryView.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l, index);
                            break;
                        }
                    }
                    if (l != null) {
                        l.insertString(sd, style);
                    } else {
                        sd.insertString(sd.getLength(), commitMessage, style);
                    }
                    int msglen = commitMessage.length();
                    int doclen = sd.getLength();
                    if (SummaryView.this.message != null && !isSelected && (idx = commitMessage.indexOf(SummaryView.this.message)) != -1) {
                        sd.setCharacterAttributes(doclen - msglen + idx, SummaryView.this.message.length(), this.hiliteStyle, true);
                    }
                    this.resizePane(commitMessage, list.getFontMetrics(list.getFont()));
                    if (isSelected) {
                        sd.setCharacterAttributes(0, Integer.MAX_VALUE, style, false);
                    }
                }
                catch (BadLocationException e) {
                    Subversion.LOG.log(Level.SEVERE, null, e);
                }
                this.actionsPane.setVisible(true);
                this.diffLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_Diff"), foregroundColor, backgroundColor);
                this.revertLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_Revert"), foregroundColor, backgroundColor);
                return this;
            }

            private void resizePane(String text, FontMetrics fm) {
                int width;
                if (text == null) {
                    text = "";
                }
                if ((width = SummaryView.this.master.getWidth()) > 0) {
                    Rectangle2D rect = fm.getStringBounds(text, this.textPane.getGraphics());
                    int nlc = -1;
                    int i = 0;
                    while (i != -1) {
                        i = text.indexOf(10, i + 1);
                        ++nlc;
                    }
                    int lines = (int)(rect.getWidth() / (double)(width - 80) + 1.0);
                    int ph = fm.getHeight() * (lines + ++nlc) + 0;
                    this.textPane.setPreferredSize(new Dimension(width - 50, ph));
                }
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (this.index == -1) {
                    return;
                }
                Rectangle apb = this.actionsPane.getBounds();
                Rectangle bounds = this.diffLink.getBounds();
                bounds.setBounds(bounds.x, bounds.y + apb.y, bounds.width, bounds.height);
                SummaryView.this.resultsList.putClientProperty("Summary-Diff-" + this.index, bounds);
                bounds = this.revertLink.getBounds();
                bounds.setBounds(bounds.x, bounds.y + apb.y, bounds.width, bounds.height);
                SummaryView.this.resultsList.putClientProperty(SummaryView.SUMMARY_REVERT_PROPERTY + this.index, bounds);
                SummaryView.this.linkerSupport.computeBounds(this.textPane, this.index);
            }
        }
    }

    private class SummaryListModel
    extends AbstractListModel {
        private SummaryListModel() {
        }

        @Override
        public int getSize() {
            return SummaryView.this.dispResults.size();
        }

        @Override
        public Object getElementAt(int index) {
            return SummaryView.this.dispResults.get(index);
        }
    }
}

