/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.java.source.parsing.ClasspathInfoProvider;
import org.netbeans.modules.javafx2.editor.FXMLCompletionItem;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.NbBundle;

public class FXMLCompletion
implements CompletionProvider {
    private static final String MIME_TYPE = "text/x-java";
    private static final String FX_BASE_CLASS = "javafx.scene.Node";

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType == 1) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(), component);
        }
        return null;
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    private static List<DocumentElement> getPathToRoot(Document bdoc, int caretOffset) {
        ArrayList<DocumentElement> result = new ArrayList<DocumentElement>();
        try {
            DocumentModel model = DocumentModel.getDocumentModel((Document)bdoc);
            if (model != null) {
                DocumentElement root = model.getRootElement();
                for (DocumentElement current = model.getLeafElementForOffset(caretOffset); current != null && current != root; current = current.getParentElement()) {
                    result.add(current);
                }
                result.add(root);
            }
        }
        catch (DocumentModelException ex) {
            Logger.getLogger(FXMLCompletion.class.getName()).log(Level.FINE, null, ex);
        }
        return result;
    }

    private static List<String> getAvailableProperties(Document doc, String prefix, String className, CompletionResultSet resultSet) throws ParseException, InterruptedException, ExecutionException {
        ArrayList<String> result = new ArrayList<String>();
        Future f = ParserManager.parseWhenScanFinished((String)MIME_TYPE, (UserTask)FXMLCompletion.getAllPropertiesTask(doc, prefix, className, result));
        if (!f.isDone()) {
            if (resultSet != null) {
                resultSet.setWaitText(NbBundle.getMessage(FXMLCompletion.class, (String)"scanning-in-progress"));
            }
            f.get();
        }
        return result;
    }

    private static List<String> getAvailableClasses(Document doc, String prefix, CompletionResultSet resultSet) throws ParseException, InterruptedException, ExecutionException {
        ArrayList<String> result = new ArrayList<String>();
        Future f = ParserManager.parseWhenScanFinished((String)MIME_TYPE, (UserTask)FXMLCompletion.getAllClassesTask(doc, prefix, result));
        if (!f.isDone()) {
            if (resultSet != null) {
                resultSet.setWaitText(NbBundle.getMessage(FXMLCompletion.class, (String)"scanning-in-progress"));
            }
            f.get();
        }
        return result;
    }

    private static UserTask getAllPropertiesTask(Document doc, final String prefix, final String className, final List<String> res) {
        final ClasspathInfo cpInfo = ClasspathInfo.create((Document)doc);
        class AllPropertiesTask
        extends UserTask
        implements ClasspathInfoProvider {
            AllPropertiesTask() {
            }

            public void run(ResultIterator resultIterator) throws Exception {
                Parser.Result result = resultIterator.getParserResult();
                ClassIndex index = cpInfo.getClassIndex();
                CompilationInfo info = CompilationInfo.get((Parser.Result)result);
                Elements elems = info.getElements();
                TypeElement fxBaseElem = elems.getTypeElement(FXMLCompletion.FX_BASE_CLASS);
                if (fxBaseElem == null) {
                    throw new IllegalStateException("Cannot find class javafx.scene.Node on classpath!");
                }
                Types types = info.getTypes();
                DeclaredType fxBaseClassType = types.getDeclaredType(fxBaseElem, new TypeMirror[0]);
                LinkedList<TypeElement> myTypes = new LinkedList<TypeElement>();
                for (ElementHandle handle : index.getDeclaredTypes(className, ClassIndex.NameKind.SIMPLE_NAME, EnumSet.allOf(ClassIndex.SearchScope.class))) {
                    TypeElement te = (TypeElement)handle.resolve(info);
                    if (te == null || !types.isSubtype(types.getDeclaredType(te, new TypeMirror[0]), fxBaseClassType)) continue;
                    myTypes.add(te);
                }
                LinkedList<TypeElement> superTypes = new LinkedList<TypeElement>();
                for (TypeElement myType : myTypes) {
                    while (myType != null) {
                        TypeMirror tm = myType.getSuperclass();
                        if (tm != null) {
                            TypeElement superType = (TypeElement)types.asElement(tm);
                            if (superType != null) {
                                superTypes.add(superType);
                            }
                            myType = superType;
                            continue;
                        }
                        myType = null;
                    }
                }
                myTypes.addAll(superTypes);
                for (TypeElement myType : myTypes) {
                    List<? extends Element> children = myType.getEnclosedElements();
                    for (Element element : children) {
                        String name = element.getSimpleName().toString();
                        if (!name.startsWith("set") || name.length() <= 3 || !(name = Character.toLowerCase(name.charAt(3)) + name.substring(4)).startsWith(prefix)) continue;
                        res.add(name);
                    }
                }
            }

            public ClasspathInfo getClasspathInfo() {
                return cpInfo;
            }
        }
        return new AllPropertiesTask();
    }

    private static UserTask getAllClassesTask(Document doc, final String prefix, final List<String> res) {
        final ClasspathInfo cpInfo = ClasspathInfo.create((Document)doc);
        class AllClassesTask
        extends UserTask
        implements ClasspathInfoProvider {
            AllClassesTask() {
            }

            public void run(ResultIterator resultIterator) throws Exception {
                Parser.Result result = resultIterator.getParserResult();
                ClassIndex index = cpInfo.getClassIndex();
                CompilationInfo info = CompilationInfo.get((Parser.Result)result);
                Elements elems = info.getElements();
                TypeElement fxBaseElem = elems.getTypeElement(FXMLCompletion.FX_BASE_CLASS);
                if (fxBaseElem == null) {
                    throw new IllegalStateException("Cannot find class javafx.scene.Node on classpath!");
                }
                Types types = info.getTypes();
                if (prefix != null && prefix.length() > 2) {
                    DeclaredType fxBaseClassType = types.getDeclaredType(fxBaseElem, new TypeMirror[0]);
                    for (ElementHandle handle : index.getDeclaredTypes(prefix, ClassIndex.NameKind.PREFIX, EnumSet.allOf(ClassIndex.SearchScope.class))) {
                        TypeElement te = (TypeElement)handle.resolve(info);
                        if (te == null || !types.isSubtype(types.getDeclaredType(te, new TypeMirror[0]), fxBaseClassType)) continue;
                        res.add(te.getSimpleName().toString());
                    }
                } else {
                    LinkedList<ElementHandle> toExplore = new LinkedList<ElementHandle>();
                    toExplore.add(ElementHandle.create((Element)fxBaseElem));
                    while (!toExplore.isEmpty()) {
                        ElementHandle current = (ElementHandle)toExplore.remove(0);
                        for (ElementHandle eh : index.getElements(current, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.allOf(ClassIndex.SearchScope.class))) {
                            TypeElement te = (TypeElement)eh.resolve(info);
                            String name = te.getSimpleName().toString();
                            if ((prefix == null || name.startsWith(prefix)) && name.length() > 0) {
                                res.add(name);
                            }
                            toExplore.add(eh);
                        }
                    }
                }
            }

            public ClasspathInfo getClasspathInfo() {
                return cpInfo;
            }
        }
        return new AllClassesTask();
    }

    static class Query
    extends AsyncCompletionQuery {
        List<FXMLCompletionItem> results;

        Query() {
        }

        protected void query(final CompletionResultSet resultSet, final Document document, final int caretOffset) {
            this.results = new ArrayList<FXMLCompletionItem>();
            document.render(new Runnable(){

                @Override
                public void run() {
                    TokenHierarchy h = TokenHierarchy.get((Document)document);
                    TokenSequence ts = h.tokenSequence();
                    if (ts == null) {
                        return;
                    }
                    try {
                        ts.move(caretOffset);
                        if (ts.moveNext()) {
                            String className;
                            Token t = ts.token();
                            List path = FXMLCompletion.getPathToRoot(document, caretOffset);
                            String prefix = "";
                            if (t.id() == XMLTokenId.TAG) {
                                if (ts.offset() < caretOffset) {
                                    prefix = ((Object)t.text()).toString().substring(1, caretOffset - ts.offset());
                                }
                                if (((Object)t.text()).toString().startsWith("<")) {
                                    if (path.size() == 2 || path.size() > 2 && ((DocumentElement)path.get(1)).getName().equals("children")) {
                                        List classes = FXMLCompletion.getAvailableClasses(document, prefix, resultSet);
                                        for (String cls : classes) {
                                            Query.this.results.add(new FXMLCompletionItem(ts.offset(), "<" + cls));
                                        }
                                    }
                                    if (path.size() > 2 && !((DocumentElement)path.get(1)).getName().equals("children")) {
                                        className = ((DocumentElement)path.get(1)).getName();
                                        List properties = FXMLCompletion.getAvailableProperties(document, prefix, className, resultSet);
                                        for (String prop : properties) {
                                            Query.this.results.add(new FXMLCompletionItem(ts.offset(), "<" + prop));
                                        }
                                    }
                                }
                            }
                            if (t.id() == XMLTokenId.ARGUMENT) {
                                if (ts.offset() < caretOffset) {
                                    prefix = ((Object)t.text()).toString().substring(0, caretOffset - ts.offset());
                                }
                                if (path.size() > 0) {
                                    className = ((DocumentElement)path.get(0)).getName();
                                    List props = FXMLCompletion.getAvailableProperties(document, prefix, className, resultSet);
                                    for (String prop : props) {
                                        Query.this.results.add(new FXMLCompletionItem(ts.offset(), prop));
                                    }
                                }
                            }
                        }
                    }
                    catch (ParseException e) {
                        Logger.getLogger(FXMLCompletion.class.getName()).log(Level.FINE, null, e);
                    }
                    catch (InterruptedException e) {
                        Logger.getLogger(FXMLCompletion.class.getName()).log(Level.FINE, null, e);
                    }
                    catch (ExecutionException e) {
                        Logger.getLogger(FXMLCompletion.class.getName()).log(Level.FINE, null, e);
                    }
                }
            });
            if (resultSet != null) {
                resultSet.addAllItems(this.results);
                resultSet.finish();
            }
        }
    }
}

