/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.projectsupport.utilities;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.spi.ProjectUtilitiesProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class ProjectUtilitiesProviderImpl
extends ProjectUtilitiesProvider {
    private Set<ChangeListener> listeners;

    public Icon getIcon(Lookup.Provider project) {
        return ProjectUtilities.getProjectIcon((Lookup.Provider)((Project)project));
    }

    public Lookup.Provider getMainProject() {
        return ProjectUtilities.getMainProject();
    }

    public String getDisplayName(Lookup.Provider project) {
        return ProjectUtilities.getProjectName((Lookup.Provider)((Project)project));
    }

    public FileObject getProjectDirectory(Lookup.Provider project) {
        return ((Project)project).getProjectDirectory();
    }

    public Lookup.Provider[] getOpenedProjects() {
        return ProjectUtilities.getOpenedProjects();
    }

    public boolean hasSubprojects(Lookup.Provider project) {
        return ProjectUtilities.hasSubprojects((Project)project);
    }

    public void fetchSubprojects(Lookup.Provider project, Set<Lookup.Provider> subprojects) {
        ProjectUtilities.fetchSubprojects((Project)project, subprojects);
    }

    public Lookup.Provider getProject(FileObject fobj) {
        return FileOwnerQuery.getOwner((FileObject)fobj);
    }

    public synchronized void addOpenProjectsListener(ChangeListener listener) {
        this.listeners().add(listener);
    }

    public synchronized void removeOpenProjectsListener(ChangeListener listener) {
        if (this.hasListeners()) {
            this.listeners.remove(listener);
        }
        if (!this.hasListeners()) {
            this.listeners = null;
        }
    }

    private synchronized Set<ChangeListener> listeners() {
        if (!this.hasListeners()) {
            this.listeners = new HashSet<ChangeListener>();
        }
        return this.listeners;
    }

    private synchronized boolean hasListeners() {
        return this.listeners != null;
    }

    public ProjectUtilitiesProviderImpl() {
        OpenProjects.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProjectUtilitiesProviderImpl projectUtilitiesProviderImpl = ProjectUtilitiesProviderImpl.this;
                synchronized (projectUtilitiesProviderImpl) {
                    if (!ProjectUtilitiesProviderImpl.this.hasListeners()) {
                        return;
                    }
                    if ("openProjects".equals(evt.getPropertyName())) {
                        for (ChangeListener listener : ProjectUtilitiesProviderImpl.this.listeners) {
                            listener.stateChanged(new ChangeEvent(evt));
                        }
                    }
                }
            }
        });
    }
}

