/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.options;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.netbeans.modules.versioning.DelegatingVCS;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningConfig;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.options.GeneralOptionsPanelController;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class GeneralOptionsPanel
extends JPanel
implements ActionListener {
    private final GeneralOptionsPanelController controller;
    private JButton btnAdd;
    private JButton btnRemove;
    private JComboBox cmbVersioningSystems;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JList lstDisconnectedFolders;

    GeneralOptionsPanel(GeneralOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.cmbVersioningSystems.setRenderer(new Renderer());
        this.cmbVersioningSystems.addActionListener(this);
        this.btnRemove.addActionListener(this);
        this.btnAdd.addActionListener(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    private void fillDisconnectedFolders() {
        if (this.cmbVersioningSystems.getSelectedItem() instanceof VersioningSystem) {
            File[] disconnected = VersioningConfig.getDefault().getDisconnectedRoots((VersioningSystem)this.cmbVersioningSystems.getSelectedItem());
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (File f : disconnected) {
                model.addElement(f.getAbsolutePath());
            }
            this.lstDisconnectedFolders.setModel(model);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cmbVersioningSystems = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstDisconnectedFolders = new JList();
        this.btnRemove = new JButton();
        this.jLabel2 = new JLabel();
        this.btnAdd = new JButton();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_OptionsPanel.disconnectedFolders.title")));
        this.jLabel1.setLabelFor(this.cmbVersioningSystems);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.jLabel1.text"));
        this.jScrollPane1.setViewportView(this.lstDisconnectedFolders);
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.btnRemove.text"));
        this.btnRemove.setToolTipText(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.btnRemove.TTtext"));
        this.jLabel2.setLabelFor(this.lstDisconnectedFolders);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.btnAdd.text"));
        this.btnAdd.setToolTipText(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.btnAdd.toolTipText"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 354, Short.MAX_VALUE).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbVersioningSystems, -2, -1, -2))).addGap(190, 190, 190)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnRemove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAdd).addContainerGap(195, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cmbVersioningSystems, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnRemove).addComponent(this.btnAdd)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(111, Short.MAX_VALUE)));
    }

    void load() {
        this.fillVersioningSystems();
    }

    void store() {
    }

    boolean valid() {
        return true;
    }

    private void fillVersioningSystems() {
        LinkedList<VersioningSystem> systems = new LinkedList<VersioningSystem>();
        for (VersioningSystem system : Lookup.getDefault().lookupAll(VersioningSystem.class)) {
            if (system instanceof DelegatingVCS) {
                VersioningSystem delegate = ((DelegatingVCS)system).getDelegate();
                if (delegate == null) continue;
                systems.add(delegate);
                continue;
            }
            systems.add(system);
        }
        this.cmbVersioningSystems.setModel(new DefaultComboBoxModel<VersioningSystem>(systems.toArray(new VersioningSystem[systems.size()])));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cmbVersioningSystems) {
            this.fillDisconnectedFolders();
        } else if (e.getSource() == this.btnRemove) {
            if (this.cmbVersioningSystems.getSelectedItem() instanceof VersioningSystem && this.lstDisconnectedFolders.getSelectedValue() != null) {
                File f = new File((String)this.lstDisconnectedFolders.getSelectedValue());
                VersioningConfig.getDefault().connectRepository((VersioningSystem)this.cmbVersioningSystems.getSelectedItem(), f);
                this.fillDisconnectedFolders();
                this.refreshSystems();
            }
        } else if (e.getSource() == this.btnAdd && this.cmbVersioningSystems.getSelectedItem() instanceof VersioningSystem) {
            VersioningSystem vcs = (VersioningSystem)this.cmbVersioningSystems.getSelectedItem();
            File f = new FileChooserBuilder("VersioningOptions.disconnected").setTitle(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_DisconnectingFolder.title")).setDirectoriesOnly(true).setFileHiding(true).showOpenDialog();
            if (f != null && (f = vcs.getTopmostManagedAncestor(f)) != null) {
                VersioningConfig.getDefault().disconnectRepository(vcs, f);
                this.fillDisconnectedFolders();
                this.refreshSystems();
            }
        }
    }

    private void refreshSystems() {
        Utils.createTask(new Runnable(){

            @Override
            public void run() {
                VersioningManager.getInstance().versionedRootsChanged();
            }
        }).schedule(100);
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof VersioningSystem) {
                value = Utils.getDisplayName((VersioningSystem)value);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

