/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.util.NbPreferences;

public class VersioningConfig {
    private static final VersioningConfig INSTANCE = new VersioningConfig();
    private static final Logger LOG = Logger.getLogger(VersioningConfig.class.getName());
    private final Map<String, Set<File>> allDisconnectedRepositories = VersioningConfig.initializeDisconnectedRepositories();
    private static final String SEP = "###";
    private static final String PREF_KEY = "disconnectedFolders";

    private VersioningConfig() {
    }

    public static VersioningConfig getDefault() {
        return INSTANCE;
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(VersioningConfig.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDisconnected(VersioningSystem vs, File repository) {
        boolean disconnected = false;
        String className = vs.getClass().getName();
        Map<String, Set<File>> map = this.allDisconnectedRepositories;
        synchronized (map) {
            Set<File> disconnectedRepositories = this.allDisconnectedRepositories.get(className);
            if (disconnectedRepositories != null) {
                for (File disconnectedRepository : disconnectedRepositories) {
                    if (!disconnectedRepository.equals(repository)) continue;
                    disconnected = true;
                    LOG.log(Level.FINE, "isDisconnected: Folder is disconnected from {0}: {1}, disconnected root: {2}", new Object[]{className, repository, disconnectedRepository});
                    break;
                }
            }
        }
        return disconnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectRepository(VersioningSystem vs, File repository) {
        String className = vs.getClass().getName();
        Map<String, Set<File>> map = this.allDisconnectedRepositories;
        synchronized (map) {
            Set<File> disconnectedRepos = this.allDisconnectedRepositories.get(className);
            if (disconnectedRepos != null) {
                boolean changed = false;
                Iterator<File> it = disconnectedRepos.iterator();
                while (it.hasNext()) {
                    File disconnectedRepository = it.next();
                    if (!disconnectedRepository.equals(repository)) continue;
                    LOG.log(Level.FINE, "connectRepository: Connecting repository to {0}: {1}", new Object[]{className, repository});
                    it.remove();
                    changed = true;
                    break;
                }
                if (changed) {
                    this.saveDisconnectedRepositories();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectRepository(VersioningSystem vs, File repository) {
        String className = vs.getClass().getName();
        Map<String, Set<File>> map = this.allDisconnectedRepositories;
        synchronized (map) {
            boolean added;
            Set<File> disconnectedRepos = this.allDisconnectedRepositories.get(className);
            if (disconnectedRepos == null) {
                disconnectedRepos = new HashSet<File>();
                this.allDisconnectedRepositories.put(className, disconnectedRepos);
            }
            if (!(added = disconnectedRepos.add(repository))) {
                LOG.log(Level.FINE, "disconnectRepository: Repository already disconnected for {0}: {1}", new Object[]{className, repository});
            } else {
                this.saveDisconnectedRepositories();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getDisconnectedRoots(VersioningSystem vs) {
        File[] files;
        String className = vs.getClass().getName();
        Map<String, Set<File>> map = this.allDisconnectedRepositories;
        synchronized (map) {
            Set<File> disconnectedRepos = this.allDisconnectedRepositories.get(className);
            files = disconnectedRepos == null ? new File[]{} : disconnectedRepos.toArray(new File[disconnectedRepos.size()]);
        }
        return files;
    }

    private static Map<String, Set<File>> initializeDisconnectedRepositories() {
        HashMap<String, Set<File>> disconnectedFolders = new HashMap<String, Set<File>>(5);
        List<String> list = Utils.getStringList(NbPreferences.forModule(VersioningConfig.class), PREF_KEY);
        for (String s : list) {
            String[] disconnectedFolder = s.split(SEP);
            if (disconnectedFolder.length != 2) continue;
            HashSet<File> files = (HashSet<File>)disconnectedFolders.get(disconnectedFolder[0]);
            if (files == null) {
                files = new HashSet<File>();
                disconnectedFolders.put(disconnectedFolder[0], files);
            }
            files.add(new File(disconnectedFolder[1]));
        }
        return disconnectedFolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDisconnectedRepositories() {
        LinkedList<String> list = new LinkedList<String>();
        Map<String, Set<File>> map = this.allDisconnectedRepositories;
        synchronized (map) {
            for (Map.Entry<String, Set<File>> e : this.allDisconnectedRepositories.entrySet()) {
                String vsKey = e.getKey();
                for (File f : e.getValue()) {
                    list.add(vsKey + SEP + f.getAbsolutePath());
                }
            }
        }
        Utils.put(NbPreferences.forModule(VersioningConfig.class), PREF_KEY, list);
    }
}

