/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.versioning.Accessor;
import org.netbeans.modules.versioning.FlatFolder;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public class Utils {
    private static final RequestProcessor vcsBlockingRequestProcessor = new RequestProcessor("Versioning long tasks", 1, false, false);
    private static FileSystem filesystem;
    private static File[] unversionedFolders;
    private static File tempDir;

    public static VCSContext contextForLookup(Lookup lookup) {
        Lookup.Result result = lookup.lookup(new Lookup.Template(Node.class));
        Collection nodes = result.allInstances();
        return VCSContext.forNodes(nodes.toArray(new Node[nodes.size()]));
    }

    public static VCSContext contextForFileObjects(Set<? extends FileObject> files) {
        HashSet<File> roots = new HashSet<File>(files.size());
        if (files instanceof NonRecursiveFolder) {
            FileObject folder = ((NonRecursiveFolder)files).getFolder();
            File file = FileUtil.toFile((FileObject)folder);
            if (file != null) {
                roots.add(new FlatFolder(file.getAbsolutePath()));
            }
        } else {
            for (FileObject fileObject : files) {
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file == null) continue;
                roots.add(file);
            }
        }
        return Accessor.IMPL.createContextForFiles(roots, files);
    }

    public static boolean isAncestorOrEqual(File ancestor, File file) {
        if (VersioningSupport.isFlat(ancestor)) {
            return ancestor.equals(file) || ancestor.equals(file.getParentFile()) && !file.isDirectory();
        }
        String filePath = file.getAbsolutePath();
        String ancestorPath = ancestor.getAbsolutePath();
        if (Utilities.isWindows() ? filePath.indexOf("~") < 0 && ancestorPath.indexOf("~") < 0 && filePath.length() < ancestorPath.length() : (Utilities.isMac() ? filePath.length() < ancestorPath.length() : !filePath.startsWith(ancestorPath))) {
            return false;
        }
        while (file != null) {
            if (file.equals(ancestor)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public static JMenuItem toMenuItem(Action action) {
        JMenuItem item;
        if (action instanceof Presenter.Menu) {
            item = ((Presenter.Menu)action).getMenuPresenter();
        } else {
            item = new JMenuItem();
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
        }
        return item;
    }

    public static File getTempFolder() {
        File dir;
        File tmpDir = Utils.getMainTempDir();
        while ((dir = new File(tmpDir, "vcs-" + Long.toString(System.currentTimeMillis()))).exists() || !dir.mkdirs()) {
        }
        dir.deleteOnExit();
        return FileUtil.normalizeFile((File)dir);
    }

    public static void deleteRecursively(File file) {
        Utils.deleteRecursively(file, Level.WARNING);
    }

    public static void deleteRecursively(File file, Level level) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return;
        }
        try {
            fo.delete();
        }
        catch (IOException e) {
            Logger.getLogger(Utils.class.getName()).log(level, "", e);
        }
    }

    public static boolean isLocalHistory(VersioningSystem system) {
        return system.getProperty("Boolean VCS.LocalHistory") != null;
    }

    public static Reader getDocumentReader(final Document doc) {
        final String[] str = new String[1];
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    str[0] = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException e) {
                    VersioningManager.LOG.log(Level.WARNING, null, e);
                }
            }
        };
        doc.render(run);
        return new StringReader(str[0]);
    }

    public static RequestProcessor.Task createTask(Runnable runnable) {
        return vcsBlockingRequestProcessor.create(runnable);
    }

    public static String getDisplayName(VersioningSystem system) {
        return (String)system.getProperty("String VCS.DisplayName");
    }

    public static String getMenuLabel(VersioningSystem system) {
        return (String)system.getProperty("String VCS.MenuLabel");
    }

    public static JSeparator createJSeparator() {
        JMenu menu = new JMenu();
        menu.addSeparator();
        return (JSeparator)menu.getPopupMenu().getComponent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFile(File file) {
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = file.isFile();
            return bl;
        }
        finally {
            Utils.logLasting(file, System.currentTimeMillis() - startTime, "Utils.isFile: java.io.File.isFile takes too much time ({0} ms): {1}, stacktrace:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(File file) {
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = file.exists();
            return bl;
        }
        finally {
            Utils.logLasting(file, System.currentTimeMillis() - startTime, "Utils.exists: java.io.File.exists takes too much time ({0} ms): {1}, stacktrace:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File file) {
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = file.canWrite();
            return bl;
        }
        finally {
            Utils.logLasting(file, System.currentTimeMillis() - startTime, "Utils.canWrite: java.io.File.canWrite takes too much time ({0} ms): {1}, stacktrace:");
        }
    }

    public static File[] getUnversionedFolders() {
        if (unversionedFolders == null) {
            File[] files;
            try {
                String uf = VersioningSupport.getPreferences().get("unversionedFolders", "");
                String ufProp = System.getProperty("versioning.unversionedFolders", "");
                StringBuilder sb = new StringBuilder(uf);
                String nbUserdir = System.getProperty("netbeans.user", "");
                if (!nbUserdir.isEmpty() && !Utils.isVersionUserdir()) {
                    if (sb.length() > 0) {
                        sb.append(';');
                    }
                    sb.append(nbUserdir);
                }
                if (!ufProp.isEmpty()) {
                    if (sb.length() > 0) {
                        sb.append(';');
                    }
                    sb.append(ufProp);
                }
                if (sb.length() == 0) {
                    files = new File[]{};
                } else {
                    String[] paths = sb.toString().split("\\;");
                    files = new File[paths.length];
                    int idx = 0;
                    for (String path : paths) {
                        files[idx++] = new File(path);
                    }
                }
            }
            catch (Exception e) {
                files = new File[]{};
                Logger.getLogger(Utils.class.getName()).log(Level.INFO, e.getMessage(), e);
            }
            unversionedFolders = files;
        }
        return unversionedFolders;
    }

    static boolean isVersionUserdir() {
        return "true".equals(System.getProperty("versioning.netbeans.user.versioned", "false"));
    }

    static FileSystem getRootFilesystem() {
        if (filesystem == null) {
            try {
                String userDir = System.getProperty("netbeans.user");
                FileObject fo = FileUtil.toFileObject((File)new File(userDir));
                filesystem = fo.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                VersioningManager.LOG.log(Level.WARNING, null, ex);
            }
        }
        return filesystem;
    }

    public static List<String> getStringList(Preferences prefs, String key) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            String[] keys = prefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                String k = keys[i];
                if (k == null || !k.startsWith(key)) continue;
                int idx = Integer.parseInt(k.substring(k.lastIndexOf(46) + 1));
                retval.add(idx + "." + prefs.get(k, null));
            }
            ArrayList<String> rv = new ArrayList<String>(retval.size());
            rv.addAll(retval);
            for (String s : retval) {
                int pos = s.indexOf(46);
                int index = Integer.parseInt(s.substring(0, pos));
                rv.set(index, s.substring(pos + 1));
            }
            return rv;
        }
        catch (Exception ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, null, ex);
            return new ArrayList<String>(0);
        }
    }

    public static void put(Preferences prefs, String key, List<String> value) {
        try {
            String[] keys = prefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                String k = keys[i];
                if (k == null || !k.startsWith(key + ".")) continue;
                prefs.remove(k);
            }
            int idx = 0;
            for (String s : value) {
                prefs.put(key + "." + idx++, s);
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, null, ex);
        }
    }

    private static synchronized File getMainTempDir() {
        block1: {
            File dir;
            if (tempDir != null) break block1;
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            while ((dir = new File(tmpDir, "vcs-" + Long.toString(System.currentTimeMillis()))).exists() || !dir.mkdirs()) {
            }
            tempDir = FileUtil.normalizeFile((File)dir);
            tempDir.deleteOnExit();
        }
        return tempDir;
    }

    private static void logLasting(File file, long last, String message) {
        boolean allowed = false;
        if (!$assertionsDisabled) {
            allowed = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (allowed && last > 1500L) {
            StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (StackTraceElement e : stElements) {
                if (i++ <= 1) continue;
                if (i == 8) {
                    sb.append("...\n");
                    break;
                }
                sb.append(e.toString()).append("\n");
            }
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, message, new String[]{Long.toString(last), file.getAbsolutePath()});
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, sb.toString());
        }
    }
}

