/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.diff.PatchAction;
import org.netbeans.modules.versioning.DelegatingVCS;
import org.netbeans.modules.versioning.InitMenuItem;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningConfig;
import org.netbeans.modules.versioning.VersioningMainMenu;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class ProjectMenuItem
extends AbstractAction
implements Presenter.Popup {
    public JMenuItem getPopupPresenter() {
        return new DynamicDummyItem();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private JComponent[] createItems() {
        ArrayList<JMenu> popups = new ArrayList<JMenu>();
        if (!VersioningManager.isInitialized()) {
            popups.add(InitMenuItem.create(NbBundle.getMessage(VersioningMainMenu.class, (String)"CTL_MenuItem_VersioningMenu")));
            popups.add(InitMenuItem.create(NbBundle.getMessage(VersioningMainMenu.class, (String)"CTL_MenuItem_LocalHistory")));
        } else {
            Node[] nodes = this.getActivatedNodes();
            if (nodes.length > 0) {
                LazyMenu menu;
                Set<VersioningSystem> owners = this.getOwnersForProjectNodes(nodes);
                if (owners.size() != 1) {
                    return new JComponent[0];
                }
                VersioningSystem owner = owners.iterator().next();
                VersioningSystem localHistory = this.getLocalHistory(nodes);
                if (owner == null || owner.getVCSAnnotator() != null) {
                    menu = new LazyMenu(nodes, owner);
                    popups.add(menu);
                }
                if (localHistory != null && localHistory.getVCSAnnotator() != null) {
                    menu = new LazyMenu(nodes, localHistory);
                    popups.add(menu);
                }
            }
        }
        return popups.toArray(new JComponent[popups.size()]);
    }

    private VersioningSystem getLocalHistory(Node[] nodes) {
        Set<File> rootFiles = this.getRootFilesForProjectNodes(nodes);
        VersioningSystem owner = null;
        for (File file : rootFiles) {
            VersioningSystem fileOwner = VersioningManager.getInstance().getLocalHistory(file);
            if (owner != null) {
                if (fileOwner == null || fileOwner == owner) continue;
                return null;
            }
            owner = fileOwner;
        }
        return owner;
    }

    private Set<VersioningSystem> getOwnersForProjectNodes(Node[] nodes) {
        Set<File> rootFiles = this.getRootFilesForProjectNodes(nodes);
        HashSet<VersioningSystem> owners = new HashSet<VersioningSystem>(2);
        boolean someUnversioned = false;
        for (File file : rootFiles) {
            VersioningSystem fileOwner = VersioningManager.getInstance().getOwner(file);
            if (fileOwner == null) {
                someUnversioned = true;
                continue;
            }
            owners.add(fileOwner);
        }
        if (owners.isEmpty() && someUnversioned) {
            owners.add(null);
        }
        return owners;
    }

    private JComponent[] createVersioningSystemItems(VersioningSystem owner, Node[] nodes, boolean displayConnectAction) {
        File root;
        VCSContext ctx = VCSContext.forNodes(nodes);
        Action[] actions = null;
        if (displayConnectAction && ctx.getRootFiles().size() == 1 && (root = owner.getTopmostManagedAncestor(ctx.getRootFiles().iterator().next())) != null) {
            VersioningSystem vs;
            VersioningSystem versioningSystem = vs = owner instanceof DelegatingVCS ? ((DelegatingVCS)owner).getDelegate() : owner;
            if (VersioningConfig.getDefault().isDisconnected(vs, root)) {
                String displayName = Utils.getMenuLabel(owner instanceof DelegatingVCS ? ((DelegatingVCS)owner).getDelegate() : owner);
                actions = new Action[]{new VersioningMainMenu.ConnectAction(vs, root, NbBundle.getMessage(ProjectMenuItem.class, (String)"CTL_ConnectAction.name.vcs", (Object)displayName))};
            }
        }
        if (actions == null) {
            if (owner instanceof DelegatingVCS) {
                actions = ((DelegatingVCS)owner).getInitActions(ctx, VCSAnnotator.ActionDestination.PopupMenu);
            } else if (actions == null) {
                VCSAnnotator an = owner.getVCSAnnotator();
                if (an == null) {
                    return null;
                }
                actions = an.getActions(ctx, VCSAnnotator.ActionDestination.PopupMenu);
            }
        }
        JComponent[] items = new JComponent[actions.length];
        int i = 0;
        for (Action action : actions) {
            if (action == null) {
                items[i++] = Utils.createJSeparator();
                continue;
            }
            JMenuItem item = this.createmenuItem(action);
            items[i++] = item;
        }
        return items;
    }

    private JMenuItem createmenuItem(Action action) {
        JMenuItem item;
        if (action instanceof Presenter.Menu) {
            item = ((Presenter.Menu)action).getMenuPresenter();
        } else {
            item = new JMenuItem();
            Actions.connect((JMenuItem)item, (Action)action, (boolean)true);
        }
        return item;
    }

    private Node[] getActivatedNodes() {
        return TopComponent.getRegistry().getActivatedNodes();
    }

    private Set<File> getRootFilesForProjectNodes(Node[] nodes) {
        HashSet<File> rootFiles = new HashSet<File>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project == null) continue;
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
            for (int j = 0; j < sourceGroups.length; ++j) {
                SourceGroup sourceGroup = sourceGroups[j];
                FileObject srcRootFo = sourceGroup.getRootFolder();
                File rootFile = FileUtil.toFile((FileObject)srcRootFo);
                if (rootFile == null) continue;
                rootFiles.add(rootFile);
            }
        }
        return rootFiles;
    }

    private class LazyMenu
    extends JMenu {
        private final Node[] nodes;
        private final VersioningSystem owner;
        boolean initialized;

        private LazyMenu(Node[] nodes, VersioningSystem owner) {
            super(owner == null ? NbBundle.getMessage(ProjectMenuItem.class, (String)"CTL_MenuItem_VersioningMenu") : Utils.getDisplayName(owner));
            this.nodes = nodes;
            this.owner = owner;
        }

        @Override
        public JPopupMenu getPopupMenu() {
            if (!this.initialized) {
                super.removeAll();
                if (this.owner == null) {
                    Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(VersioningSystem.class));
                    ArrayList vcs = new ArrayList(result.allInstances());
                    Collections.sort(vcs, new VersioningMainMenu.ByDisplayNameComparator());
                    for (VersioningSystem vs : vcs) {
                        if (vs.getProperty("Boolean VCS.LocalHistory") != null) continue;
                        this.addVersioningSystemItems(vs, this.nodes, true);
                    }
                    this.addSeparator();
                    this.add(ProjectMenuItem.this.createmenuItem((Action)SystemAction.get(PatchAction.class)));
                } else {
                    this.addVersioningSystemItems(this.owner, this.nodes, false);
                }
                this.initialized = true;
            }
            return super.getPopupMenu();
        }

        private void addVersioningSystemItems(VersioningSystem owner, Node[] nodes, boolean displayConnectAction) {
            JComponent[] items = ProjectMenuItem.this.createVersioningSystemItems(owner, nodes, displayConnectAction);
            if (items != null) {
                for (JComponent item : items) {
                    this.add(item);
                }
            }
        }
    }

    private class DynamicDummyItem
    extends JMenuItem
    implements DynamicMenuContent {
        private DynamicDummyItem() {
        }

        public JComponent[] getMenuPresenters() {
            return ProjectMenuItem.this.createItems();
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return ProjectMenuItem.this.createItems();
        }
    }
}

