/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.versioning.Accessor;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VCSVisibilityQuery;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.spi.queries.CollocationQueryImplementation;
import org.openide.util.ContextAwareAction;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class DelegatingVCS
extends VersioningSystem {
    private final Map<?, ?> map;
    private VersioningSystem delegate;
    private Set<String> metadataFolderNames;
    private final Object DELEGATE_LOCK = new Object();

    public static DelegatingVCS create(Map<?, ?> map) {
        return new DelegatingVCS(map);
    }

    private DelegatingVCS(Map<?, ?> map) {
        this.map = map;
        this.putProperty("String VCS.DisplayName", map.get("displayName"));
        this.putProperty("String VCS.MenuLabel", map.get("menuLabel"));
        VersioningManager.LOG.log(Level.FINE, "Created DelegatingVCS for : {0}", map.get("displayName"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersioningSystem getDelegate() {
        VersioningManager manager = VersioningManager.getInstance();
        Object object = this.DELEGATE_LOCK;
        synchronized (object) {
            if (this.delegate == null) {
                manager.flushNullOwners();
                this.delegate = (VersioningSystem)this.map.get("delegate");
                if (this.delegate != null) {
                    Accessor.IMPL.moveChangeListeners(this, this.delegate);
                } else {
                    VersioningManager.LOG.log(Level.WARNING, "Couldn't create delegate for : {0}", this.map.get("displayName"));
                }
            }
            return this.delegate;
        }
    }

    @Override
    public VCSVisibilityQuery getVisibilityQuery() {
        return this.getDelegate().getVisibilityQuery();
    }

    @Override
    public VCSInterceptor getVCSInterceptor() {
        return this.getDelegate().getVCSInterceptor();
    }

    @Override
    public VCSAnnotator getVCSAnnotator() {
        return this.getDelegate().getVCSAnnotator();
    }

    @Override
    public void getOriginalFile(File workingCopy, File originalFile) {
        this.getDelegate().getOriginalFile(workingCopy, originalFile);
    }

    @Override
    public CollocationQueryImplementation getCollocationQueryImplementation() {
        return this.getDelegate().getCollocationQueryImplementation();
    }

    @Override
    public File getTopmostManagedAncestor(File file) {
        if (!this.isAlive()) {
            if (this.getMetadataFolderNames().contains(file.getName()) && file.isDirectory()) {
                VersioningManager.LOG.log(Level.FINE, "will awake VCS {0} because of metadata folder {1}", new Object[]{this.getProperty("String VCS.DisplayName"), file});
                VersioningSystem vs = this.getDelegate();
                return vs != null ? vs.getTopmostManagedAncestor(file) : null;
            }
            if (this.hasMetadata(file)) {
                VersioningManager.LOG.log(Level.FINE, "will awake VCS {0} because {1} contains matadata", new Object[]{this.getProperty("String VCS.DisplayName"), file});
                VersioningSystem vs = this.getDelegate();
                return vs != null ? vs.getTopmostManagedAncestor(file) : null;
            }
        } else {
            return this.getDelegate().getTopmostManagedAncestor(file);
        }
        return null;
    }

    boolean isMetadataFile(File file) {
        return this.getMetadataFolderNames().contains(file.getName());
    }

    private Collection<String> getMetadataFolderNames() {
        if (this.metadataFolderNames == null) {
            String name;
            this.metadataFolderNames = new HashSet<String>();
            int i = 0;
            while ((name = (String)this.map.get("metadataFolderName" + i++)) != null) {
                if ((name = this.parseName(name)) == null) continue;
                this.metadataFolderNames.add(name);
            }
        }
        return this.metadataFolderNames;
    }

    Action[] getActions(VCSContext ctx, VCSAnnotator.ActionDestination actionDestination) {
        if (this.isAlive()) {
            VCSAnnotator annotator = this.getDelegate().getVCSAnnotator();
            return annotator != null ? annotator.getActions(ctx, actionDestination) : new Action[]{};
        }
        Action[] ia = this.getInitActions(ctx, VCSAnnotator.ActionDestination.MainMenu);
        Action[] ga = this.getGlobalActions(ctx, VCSAnnotator.ActionDestination.MainMenu);
        ArrayList<Action> l = new ArrayList<Action>(ia.length + ga.length + 1);
        l.addAll(Arrays.asList(ia));
        if (ga.length > 0 && ia.length > 0 && l.get(l.size() - 1) != null) {
            l.add(null);
        }
        l.addAll(Arrays.asList(ga));
        return l.toArray(new Action[l.size()]);
    }

    Action[] getGlobalActions(VCSContext ctx, VCSAnnotator.ActionDestination actionDestination) {
        assert (!this.isAlive());
        String category = (String)this.map.get("actionsCategory");
        List l = Utilities.actionsForPath((String)("Versioning/" + category + "/Actions/Global"));
        ArrayList<Action> ret = new ArrayList<Action>(l.size());
        for (Action action : l) {
            if (action instanceof ContextAwareAction) {
                ret.add(((ContextAwareAction)action).createContextAwareInstance(Lookups.singleton((Object)ctx)));
                continue;
            }
            ret.add(action);
        }
        return ret != null ? ret.toArray(new Action[ret.size()]) : new Action[]{};
    }

    Action[] getInitActions(VCSContext ctx, VCSAnnotator.ActionDestination actionDestination) {
        String category = (String)this.map.get("actionsCategory");
        List l = Utilities.actionsForPath((String)("Versioning/" + category + "/Actions/Unversioned"));
        ArrayList<Action> ret = new ArrayList<Action>(l.size());
        for (Action action : l) {
            if (action instanceof ContextAwareAction) {
                ret.add(((ContextAwareAction)action).createContextAwareInstance(Lookups.singleton((Object)ctx)));
                continue;
            }
            ret.add(action);
        }
        return ret.toArray(new Action[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAlive() {
        Object object = this.DELEGATE_LOCK;
        synchronized (object) {
            return this.delegate != null;
        }
    }

    private boolean hasMetadata(File file) {
        if (file == null) {
            return false;
        }
        for (String folderName : this.getMetadataFolderNames()) {
            for (File parent = file.isDirectory() ? file : file.getParentFile(); parent != null; parent = parent.getParentFile()) {
                boolean metadataFolder = new File(parent, folderName).exists();
                if (!metadataFolder) continue;
                VersioningManager.LOG.log(Level.FINER, "found metadata folder {0} for file {1}", new Object[]{metadataFolder, file});
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Object object = this.DELEGATE_LOCK;
        synchronized (object) {
            this.delegate = null;
        }
    }

    private String parseName(String name) {
        if (name == null) {
            return null;
        }
        int idx = name.indexOf(":");
        if (idx < 0) {
            return name;
        }
        String[] cmd = name.split(":");
        if (cmd.length != 4 || !cmd[1].contains("getenv")) {
            return name;
        }
        assert (cmd[3].equals("notnull") || cmd[3].equals("null"));
        boolean notnull = cmd[3].trim().equals("notnull");
        if (notnull) {
            return System.getenv(cmd[2]) != null ? cmd[0] : null;
        }
        return System.getenv(cmd[2]) == null ? cmd[0] : null;
    }
}

