/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.util.ArrayList;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.classfile.PlaceholderClassInfo;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.RecursiveMethodInstrumentor;
import org.netbeans.lib.profiler.instrumentation.RootMethods;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.lib.profiler.utils.Wildcards;

public class RecursiveMethodInstrumentor1
extends RecursiveMethodInstrumentor {
    public RecursiveMethodInstrumentor1(ProfilingSessionStatus status, ProfilerEngineSettings settings) {
        super(status, settings);
    }

    @Override
    Object[] getInitialMethodsToInstrument(String[] loadedClasses, int[] loadedClassLoaderIds, byte[][] cachedClassFileBytes, RootMethods roots) {
        DynamicClassInfo[] loadedClassInfos = this.preGetInitialMethodsToInstrument(loadedClasses, loadedClassLoaderIds, cachedClassFileBytes);
        this.rootMethods = roots;
        for (int j = 0; j < loadedClassInfos.length; ++j) {
            if (loadedClassInfos[j] == null) continue;
            String className = loadedClassInfos[j].getName();
            this.tryInstrumentSpawnedThreads(loadedClassInfos[j]);
            for (int rIdx = 0; rIdx < this.rootMethods.classNames.length; ++rIdx) {
                String rootClassName = this.rootMethods.classNames[rIdx];
                boolean isMatch = false;
                if (this.rootMethods.classesWildcard[rIdx]) {
                    if (Wildcards.matchesWildcard(rootClassName, className)) {
                        isMatch = true;
                    }
                } else if (className == rootClassName) {
                    isMatch = true;
                }
                if (!isMatch) continue;
                if (Wildcards.isPackageWildcard(rootClassName) || Wildcards.isMethodWildcard(this.rootMethods.methodNames[rIdx])) {
                    if (this.rootMethods.markerMethods[rIdx]) {
                        this.markAllMethodsMarker(loadedClassInfos[j]);
                    } else {
                        this.markAllMethodsRoot(loadedClassInfos[j]);
                    }
                    String[] methodNames = loadedClassInfos[j].getMethodNames();
                    String[] signatures = loadedClassInfos[j].getMethodSignatures();
                    for (int methodIdx = 0; methodIdx < methodNames.length; ++methodIdx) {
                        this.locateAndMarkMethodReachable(loadedClassInfos[j], methodNames[methodIdx], signatures[methodIdx], false, false, false);
                    }
                    continue;
                }
                this.markMethod(loadedClassInfos[j], rIdx);
                this.locateAndMarkMethodReachable(loadedClassInfos[j], this.rootMethods.methodNames[rIdx], this.rootMethods.methodSignatures[rIdx], false, false, false);
            }
        }
        this.locateAndMarkMethodReachable(RecursiveMethodInstrumentor1.javaClassForName("java/lang/ClassLoader", 0), "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", true, false, true);
        return this.createInstrumentedMethodPack();
    }

    @Override
    public Object[] getMethodsToInstrumentUponClassLoad(String className, int classLoaderId, boolean threadInCallGraph) {
        boolean normallyFilteredOut;
        className = className.replace('.', '/').intern();
        boolean isRootClass = false;
        for (int rIdx = 0; rIdx < this.rootMethods.classNames.length; ++rIdx) {
            String rootClassName = this.rootMethods.classNames[rIdx];
            if (this.rootMethods.classesWildcard[rIdx]) {
                if (!Wildcards.matchesWildcard(rootClassName, className)) continue;
                isRootClass = true;
                break;
            }
            if (className != rootClassName) continue;
            isRootClass = true;
            break;
        }
        boolean bl = normallyFilteredOut = !this.instrFilter.passesFilter(className);
        if (!isRootClass && normallyFilteredOut) {
            return null;
        }
        BaseClassInfo placeholder = RecursiveMethodInstrumentor1.loadedJavaClassOrExistingPlaceholderForName(className, classLoaderId);
        DynamicClassInfo clazz = RecursiveMethodInstrumentor1.javaClassForName(className, classLoaderId);
        if (clazz == null) {
            return null;
        }
        this.initInstrMethodData();
        boolean instrumentClinit = threadInCallGraph;
        if (!clazz.isLoaded()) {
            clazz.setLoaded(true);
            this.addToSubclassList(clazz, normallyFilteredOut ? null : clazz);
            for (int rIdx = 0; rIdx < this.rootMethods.classNames.length; ++rIdx) {
                String rootClassName = this.rootMethods.classNames[rIdx];
                boolean isMatch = false;
                if (this.rootMethods.classesWildcard[rIdx]) {
                    if (Wildcards.matchesWildcard(rootClassName, className)) {
                        isMatch = true;
                    }
                } else if (className == rootClassName) {
                    isMatch = true;
                }
                if (!isMatch) continue;
                if (Wildcards.isPackageWildcard(rootClassName) || Wildcards.isMethodWildcard(this.rootMethods.methodNames[rIdx])) {
                    if (this.rootMethods.markerMethods[rIdx]) {
                        this.markAllMethodsMarker(clazz);
                    } else {
                        this.markAllMethodsRoot(clazz);
                    }
                    String[] methodNames = clazz.getMethodNames();
                    String[] signatures = clazz.getMethodSignatures();
                    for (int methodIdx = 0; methodIdx < methodNames.length; ++methodIdx) {
                        this.locateAndMarkMethodReachable(clazz, methodNames[methodIdx], signatures[methodIdx], false, false, false);
                    }
                    continue;
                }
                this.markMethod(clazz, rIdx);
                this.locateAndMarkMethodReachable(clazz, this.rootMethods.methodNames[rIdx], this.rootMethods.methodSignatures[rIdx], false, false, false);
            }
            if (instrumentClinit) {
                this.instrumentClinit(clazz);
            }
            if (placeholder instanceof ReachableMethodPlaceholder1) {
                ((ReachableMethodPlaceholder1)placeholder).processReachableMethods(clazz);
            } else if (placeholder != null) {
                // empty if block
            }
            this.tryInstrumentSpawnedThreads(clazz);
            return this.createInstrumentedMethodPack();
        }
        return null;
    }

    @Override
    public Object[] getMethodsToInstrumentUponMethodInvocation(String className, int classLoaderId, String methodName, String methodSignature) {
        className = className.replace('.', '/').intern();
        methodName = methodName.intern();
        methodSignature = methodSignature.intern();
        this.initInstrMethodData();
        this.checkAndScanMethod(className, classLoaderId, methodName, methodSignature);
        return this.createInstrumentedMethodPack();
    }

    @Override
    public Object[] getMethodsToInstrumentUponReflectInvoke(String className, int classLoaderId, String methodName, String methodSignature) {
        DynamicClassInfo clazz = RecursiveMethodInstrumentor1.javaClassForName(className = className.replace('.', '/').intern(), classLoaderId);
        if (clazz == null) {
            return null;
        }
        if (!clazz.isLoaded()) {
            return null;
        }
        this.initInstrMethodData();
        methodName = methodName.intern();
        methodSignature = methodSignature.intern();
        this.locateAndMarkMethodReachable(clazz, methodName, methodSignature, false, false, false);
        return this.createInstrumentedMethodPack();
    }

    @Override
    protected void findAndMarkOverridingMethodsReachable(DynamicClassInfo superClass, DynamicClassInfo subClass) {
        String[] methodNames = superClass.getMethodNames();
        String[] methodSignatures = superClass.getMethodSignatures();
        for (int i = 0; i < methodNames.length; ++i) {
            if (!superClass.isMethodVirtual(i) || !superClass.isMethodReachable(i)) continue;
            this.locateAndMarkMethodReachable(subClass, methodNames[i], methodSignatures[i], true, false, false);
        }
    }

    @Override
    protected void processInvoke(DynamicClassInfo clazz, boolean virtualCall, int index) {
        byte[] savedCodeBytes = this.codeBytes;
        int savedOffset = this.offset;
        String[] cms = clazz.getRefMethodsClassNameAndSig(index);
        if (cms == null) {
            return;
        }
        String refClassName = cms[0];
        if (refClassName.startsWith("org/netbeans/lib/profiler/server/")) {
            return;
        }
        int loaderId = clazz.getLoaderId();
        BaseClassInfo refClazz = RecursiveMethodInstrumentor1.loadedJavaClassOrExistingPlaceholderForName(refClassName, loaderId);
        if (refClazz == null || refClazz instanceof PlaceholderClassInfo) {
            RecursiveMethodInstrumentor.ReachableMethodPlaceholder pci = refClazz == null ? new ReachableMethodPlaceholder1(refClassName, loaderId) : (RecursiveMethodInstrumentor.ReachableMethodPlaceholder)refClazz;
            pci.registerReachableMethod(cms[1], cms[2]);
            if (refClazz == null) {
                RecursiveMethodInstrumentor1.registerPlaceholder(pci);
            }
        } else {
            this.locateAndMarkMethodReachable((DynamicClassInfo)refClazz, cms[1], cms[2], virtualCall, true, true);
        }
        this.offset = savedOffset;
        this.codeBytes = savedCodeBytes;
    }

    @Override
    protected boolean tryInstrumentSpawnedThreads(DynamicClassInfo clazz) {
        if (this.instrumentSpawnedThreads && clazz.implementsInterface("java/lang/Runnable") && clazz.getName() != "java/lang/Thread") {
            boolean res = this.markMethodRoot(clazz, "run", "()V");
            this.locateAndMarkMethodReachable(clazz, "run", "()V", false, false, false);
            return res;
        }
        return false;
    }

    private void instrumentClinit(DynamicClassInfo clazz) {
        this.locateAndMarkMethodReachable(clazz, "<clinit>", "()V", false, false, false);
    }

    private void checkAndScanMethod(String className, int classLoaderId, String methodName, String methodSignature) {
        DynamicClassInfo clazz = RecursiveMethodInstrumentor1.javaClassForName(className, classLoaderId);
        if (clazz == null) {
            return;
        }
        int idx = clazz.getMethodIndex(methodName, methodSignature);
        if (idx == -1) {
            MiscUtils.internalError("can't find method " + methodName + methodSignature + " in class " + className);
        }
        if (clazz.isMethodUnscannable(idx)) {
            MiscUtils.internalError("got to scan unscannable method " + className + "." + methodName + methodSignature);
        }
        clazz.setMethodScanned(idx);
        this.scanMethod(clazz, idx);
    }

    private boolean locateAndMarkMethodReachable(DynamicClassInfo clazz, String methodName, String methodSignature, boolean virtualCall, boolean lookupInSuperIfNotFoundInThis, boolean checkSubclasses) {
        DynamicClassInfo superClazz;
        int i;
        ArrayList subclasses;
        if (clazz == null) {
            return false;
        }
        String className = clazz.getName();
        int idx = clazz.getMethodIndex(methodName, methodSignature);
        if (idx != -1) {
            if (clazz.isMethodReachable(idx)) {
                return true;
            }
            clazz.setMethodReachable(idx);
            if (!(clazz.isMethodStatic(idx) || clazz.isMethodPrivate(idx) || clazz.isMethodFinal(idx) || methodName == "<init>")) {
                clazz.setMethodVirtual(idx);
            }
            if (clazz.isMethodNative(idx) || clazz.isMethodAbstract(idx) || !clazz.isMethodRoot(idx) && !clazz.isMethodMarker(idx) && !this.instrFilter.passesFilter(className) || className == "java/lang/Object") {
                clazz.setMethodUnscannable(idx);
            } else {
                byte[] bytecode = clazz.getMethodBytecode(idx);
                if (this.dontInstrumentEmptyMethods && RecursiveMethodInstrumentor1.isEmptyMethod(bytecode) || this.dontScanGetterSetterMethods && RecursiveMethodInstrumentor1.isGetterSetterMethod(bytecode)) {
                    clazz.setMethodUnscannable(idx);
                } else if (this.isLeafMethod(bytecode)) {
                    clazz.setMethodLeaf(idx);
                }
            }
            if (!clazz.isLoaded()) {
                return true;
            }
            if (!clazz.isMethodUnscannable(idx)) {
                this.markClassAndMethodForInstrumentation(clazz, idx);
            }
        }
        if (checkSubclasses && (idx != -1 && clazz.isMethodVirtual(idx) || idx == -1 && virtualCall) && (subclasses = clazz.getSubclasses()) != null) {
            for (i = 0; i < subclasses.size(); ++i) {
                this.locateAndMarkMethodReachable((DynamicClassInfo)subclasses.get(i), methodName, methodSignature, virtualCall, false, false);
            }
        }
        if (idx != -1) {
            return true;
        }
        if (!lookupInSuperIfNotFoundInThis) {
            return false;
        }
        if (!clazz.isInterface() && (superClazz = clazz.getSuperClass()) != null && superClazz.getName() != clazz.getName() && this.locateAndMarkMethodReachable(superClazz, methodName, methodSignature, virtualCall, true, false)) {
            return true;
        }
        DynamicClassInfo[] interfaces = clazz.getSuperInterfaces();
        if (interfaces == null) {
            return false;
        }
        for (i = 0; i < interfaces.length; ++i) {
            DynamicClassInfo intfClazz = interfaces[i];
            if (intfClazz == null || !this.locateAndMarkMethodReachable(intfClazz, methodName, methodSignature, virtualCall, true, false)) continue;
            return true;
        }
        return false;
    }

    private DynamicClassInfo[] preGetInitialMethodsToInstrument(String[] loadedClasses, int[] loadedClassLoaderIds, byte[][] cachedClassFileBytes) {
        RecursiveMethodInstrumentor1.resetLoadedClassData();
        RecursiveMethodInstrumentor1.storeClassFileBytesForCustomLoaderClasses(loadedClasses, loadedClassLoaderIds, cachedClassFileBytes);
        this.initInstrMethodData();
        DynamicClassInfo[] loadedClassInfos = new DynamicClassInfo[loadedClasses.length];
        for (int i = 0; i < loadedClasses.length; ++i) {
            String className = loadedClasses[i].replace('.', '/').intern();
            DynamicClassInfo clazz = RecursiveMethodInstrumentor1.javaClassForName(className, loadedClassLoaderIds[i]);
            if (clazz == null) continue;
            clazz.setLoaded(true);
            this.addToSubclassList(clazz, clazz);
            loadedClassInfos[i] = clazz;
        }
        return loadedClassInfos;
    }

    protected class ReachableMethodPlaceholder1
    extends RecursiveMethodInstrumentor.ReachableMethodPlaceholder {
        public ReachableMethodPlaceholder1(String refClassName, int classLoaderId) {
            super(refClassName, classLoaderId);
        }

        public void processReachableMethods(DynamicClassInfo clazz) {
            int len = this.methodNamesAndSigs.size();
            for (int i = 0; i < len; i += 2) {
                RecursiveMethodInstrumentor1.this.locateAndMarkMethodReachable(clazz, (String)this.methodNamesAndSigs.get(i), (String)this.methodNamesAndSigs.get(i + 1), false, true, false);
            }
        }
    }
}

