/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.selectors;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.selectors.RepositoryFormPanel;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class RepositorySelectorBuilder
implements ItemListener,
ItemSelectable {
    private static final String EMPTY_PANEL = "empty panel";
    private static final String NEW_REPO_PANEL = "new repo panel";
    private Repository[] existingRepositories;
    private BugtrackingConnector[] bugtrackingConnectors;
    private JLabel label;
    private JComboBox combo;
    private final JComponent cardsPanel = new JPanel(new CardLayout());
    private boolean emptyPanelInitialized;
    private RepositoryFormPanel repositoryFormsPanel;
    private ChangeListener repositoryFormPanelListener;
    private boolean isValidData;
    private boolean repositoryFormVisible;
    private List<ChangeListener> changeListeners;
    private ChangeEvent changeEvent;
    private List<ResizeListener> resizeListeners;
    private List<ItemListener> selectionListeners;
    private String labelText = null;
    private boolean labelAbove = false;
    private boolean labelVisible = true;
    private boolean comboVisible = true;
    private boolean displayFormForExistingRepo = true;
    private String bugtrackingConnectorDisplayFormat;
    private String initialErrorMessage;
    private Repository repoToPreselect;

    public void setLabelVisible(boolean visible) {
        if (!visible && this.label != null) {
            throw new IllegalStateException("Cannot change visibility of an already created label.");
        }
        this.labelVisible = visible;
    }

    public void setLabelText(String text) {
        if (this.label == null) {
            this.labelText = text;
        } else {
            Mnemonics.setLocalizedText((JLabel)this.label, (String)text);
        }
    }

    public void setComboBoxVisible(boolean visible) {
        if (!visible && this.combo != null) {
            throw new IllegalStateException("Cannot change parameters of an already created combo-box.");
        }
        this.comboVisible = visible;
        if (!visible) {
            this.combo = null;
        }
    }

    public void setBugtrackingConnectorDisplayFormat(String format) {
        this.bugtrackingConnectorDisplayFormat = format;
    }

    public void setLabelAboveComboBox() {
        this.labelAbove = true;
    }

    public void setLabelNextToComboBox() {
        this.labelAbove = false;
    }

    public void setDisplayFormForExistingRepositories(boolean display) {
        this.displayFormForExistingRepo = display;
    }

    public void setExistingRepositories(Repository[] repositories) {
        if (this.combo != null) {
            throw new IllegalStateException("Cannot change parameters of an already created combo-box.");
        }
        if (repositories != null && repositories.length == 0) {
            repositories = null;
        }
        this.existingRepositories = repositories;
    }

    public void setBugtrackingConnectors(BugtrackingConnector[] connectors) {
        if (this.combo != null) {
            throw new IllegalStateException("Cannot change parameters of an already created combo-box.");
        }
        if (connectors != null && connectors.length == 0) {
            connectors = null;
        }
        this.bugtrackingConnectors = connectors;
    }

    public void setPreselectedRepository(Repository repository) {
        this.repoToPreselect = repository;
        if (this.combo != null) {
            this.combo.setSelectedItem(repository);
        }
    }

    public void setInitialErrorMessage(String errMsg) {
        this.initialErrorMessage = errMsg;
    }

    public JLabel getLabel() {
        if (this.labelVisible && this.label == null) {
            this.initializeLabel();
        }
        return this.label;
    }

    public JComboBox getComboBox() {
        if (this.comboVisible && this.combo == null) {
            this.initializeCombo();
        }
        return this.combo;
    }

    public JComponent getFormPanel() {
        if (!this.comboVisible && this.repositoryFormsPanel == null && this.repoToPreselect != null) {
            this.initializeCardsPanel();
        }
        return this.cardsPanel;
    }

    private void initializeLabel() {
        this.label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.label, (String)(this.labelText != null ? this.labelText : RepositorySelectorBuilder.getDefaultLabelText()));
        if (this.combo != null) {
            this.bindLabelToCombo();
        }
    }

    private void initializeCombo() {
        boolean hasBugtrackingConnectors;
        boolean hasExistingRepositories = this.existingRepositories != null && this.existingRepositories.length != 0;
        boolean bl = hasBugtrackingConnectors = this.bugtrackingConnectors != null && this.bugtrackingConnectors.length != 0;
        if (!hasExistingRepositories && !hasBugtrackingConnectors) {
            throw new IllegalStateException("No data for the combo-box.");
        }
        String newConnectionFormatString = this.bugtrackingConnectorDisplayFormat != null ? this.bugtrackingConnectorDisplayFormat : NbBundle.getMessage(ComboItemsRenderer.class, (String)"NewBugtrackingRepositoryConnection");
        this.combo = new JComboBox<Object>(RepositorySelectorBuilder.joinArrays(this.existingRepositories, RepositorySelectorBuilder.createRepositoryInfos(this.bugtrackingConnectors)));
        this.combo.setRenderer(new ComboItemsRenderer(this.combo.getRenderer(), newConnectionFormatString));
        if (this.repoToPreselect != null) {
            this.combo.setSelectedItem(this.repoToPreselect);
        }
        this.itemSelected(this.combo.getSelectedItem());
        this.combo.addItemListener(this);
        this.combo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositorySelectorBuilder.class, (String)"RepositorySelectorBuilder.combo.accessibleDescription"));
        if (this.label != null) {
            this.bindLabelToCombo();
        }
    }

    private void initializeCardsPanel() {
        if (!this.comboVisible && this.repositoryFormsPanel == null && this.repoToPreselect != null) {
            this.displayRepositoryForm(this.repoToPreselect, this.initialErrorMessage);
        }
    }

    private void bindLabelToCombo() {
        if (this.label != null && this.combo != null) {
            this.label.setLabelFor(this.combo);
        }
    }

    public JComponent createPanel() {
        JComponent upperPanel;
        this.label = this.getLabel();
        this.combo = this.getComboBox();
        this.initializeCardsPanel();
        if (this.label == null && this.combo == null) {
            RepositorySelectorBuilder.addInsetsToPanel(this.cardsPanel);
            return this.cardsPanel;
        }
        if (this.label != null && this.combo != null && this.labelAbove) {
            upperPanel = new JPanel();
            upperPanel.setLayout(new BoxLayout(upperPanel, 1));
            upperPanel.add(this.label);
            upperPanel.add(this.createVerticalStrut(upperPanel, this.label, this.combo, LayoutStyle.ComponentPlacement.RELATED));
            upperPanel.add(this.combo);
            this.label.setAlignmentX(0.0f);
            this.combo.setAlignmentX(0.0f);
        } else if (this.label != null && this.combo != null) {
            upperPanel = new JPanel();
            upperPanel.setLayout(new BoxLayout(upperPanel, 0));
            upperPanel.add(this.label);
            upperPanel.add(this.createHorizontalStrut(upperPanel, this.label, this.combo, LayoutStyle.ComponentPlacement.RELATED));
            upperPanel.add(this.combo);
            this.combo.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        } else if (this.label != null) {
            upperPanel = this.label;
        } else {
            assert (this.combo != null);
            upperPanel = this.combo;
        }
        AutoResizingPanel panel = new AutoResizingPanel();
        panel.setLayout(new BorderLayout(0, this.getSpace(panel, upperPanel, this.cardsPanel, LayoutStyle.ComponentPlacement.UNRELATED, 1)));
        panel.add((Component)upperPanel, "North");
        panel.add((Component)this.cardsPanel, "Center");
        panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositorySelectorBuilder.class, (String)"RepositorySelector.accessibleDescription"));
        RepositorySelectorBuilder.addInsetsToPanel(panel);
        this.addResizeListener(panel);
        return panel;
    }

    public DialogDescriptor createDialogDescriptor(String title) {
        return new ValidatingDialogDescriptor(title);
    }

    private static NewRepositoryInfo[] createRepositoryInfos(BugtrackingConnector[] connectors) {
        if (connectors == null) {
            return null;
        }
        NewRepositoryInfo[] result = new NewRepositoryInfo[connectors.length];
        for (int i = 0; i < connectors.length; ++i) {
            result[i] = new NewRepositoryInfo(connectors[i]);
        }
        return result;
    }

    public Repository getSelectedRepository() {
        Object selectedItem;
        if (this.combo != null && (selectedItem = this.combo.getSelectedItem()) instanceof Repository) {
            return (Repository)selectedItem;
        }
        return this.repositoryFormsPanel.getSelectedRepository();
    }

    public boolean isValidData() {
        return this.isValidData;
    }

    private static String getDefaultLabelText() {
        return RepositorySelectorBuilder.getText("LBL_SelectBugtrackingRepository");
    }

    private static void addInsetsToPanel(JComponent comp) {
        LayoutStyle layoutStyle = LayoutStyle.getInstance();
        comp.setBorder(BorderFactory.createEmptyBorder(layoutStyle.getContainerGap(comp, 1, null), layoutStyle.getContainerGap(comp, 7, null), layoutStyle.getContainerGap(comp, 5, null), layoutStyle.getContainerGap(comp, 3, null)));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.itemSelected(e.getItem());
        }
    }

    private void itemSelected(Object selectedItem) {
        if (selectedItem instanceof NewRepositoryInfo) {
            NewRepositoryInfo newRepoInfo = (NewRepositoryInfo)selectedItem;
            this.displayRepositoryForm(newRepoInfo);
        } else {
            assert (selectedItem instanceof Repository);
            if (this.displayFormForExistingRepo) {
                Repository repository = (Repository)selectedItem;
                this.displayRepositoryForm(repository);
            } else {
                this.displayEmptyPanel();
            }
        }
        this.fireSelectionChanged();
    }

    private void setDataValid(boolean valid) {
        boolean wasValid = this.isValidData;
        this.isValidData = valid;
        if (this.isValidData != wasValid) {
            this.fireDataValidityChanged();
        }
    }

    private void displayEmptyPanel() {
        if (!this.emptyPanelInitialized) {
            this.cardsPanel.add((Component)new JPanel(), EMPTY_PANEL);
            this.emptyPanelInitialized = true;
        }
        ((CardLayout)this.cardsPanel.getLayout()).show(this.cardsPanel, EMPTY_PANEL);
        if (this.repositoryFormVisible) {
            this.repositoryFormsPanel.removeChangeListener(this.repositoryFormPanelListener);
            this.repositoryFormVisible = false;
        }
        this.setDataValid(true);
    }

    private void displayRepositoryForm(NewRepositoryInfo newRepoInfo) {
        if (newRepoInfo.repository == null) {
            newRepoInfo.initializeRepository();
        }
        this.displayRepositoryForm(newRepoInfo.repository);
    }

    public void displayRepository(Repository repository) {
        boolean selectedInCombo;
        if (this.combo != null) {
            this.combo.setSelectedItem(repository);
            selectedInCombo = this.combo.getSelectedItem() == repository;
        } else {
            selectedInCombo = false;
        }
        if (!selectedInCombo) {
            this.displayRepositoryForm(repository);
        }
    }

    public void displayRepositoryForm(Repository repository) {
        this.displayRepositoryForm(repository, null);
    }

    public void displayRepositoryForm(Repository repository, String initialErrMsg) {
        this.makeSureRepositoryFormsPanelExists();
        boolean wasRepositoryFormVisible = this.repositoryFormVisible;
        boolean firstUsed = this.repositoryFormsPanel.displayForm(repository, initialErrMsg);
        ((CardLayout)this.cardsPanel.getLayout()).show(this.cardsPanel, NEW_REPO_PANEL);
        if (!wasRepositoryFormVisible) {
            this.repositoryFormsPanel.addChangeListener(this.repositoryFormPanelListener);
            this.setDataValid(this.repositoryFormsPanel.isValidData());
            this.repositoryFormVisible = true;
        }
        if (firstUsed) {
            this.notifyResizeListeners();
        }
    }

    private void makeSureRepositoryFormsPanelExists() {
        if (this.repositoryFormsPanel != null) {
            return;
        }
        this.repositoryFormsPanel = new RepositoryFormPanel();
        if (this.initialErrorMessage != null) {
            this.repositoryFormsPanel.displayErrorMessage(this.initialErrorMessage);
        }
        if (this.repositoryFormPanelListener == null) {
            this.repositoryFormPanelListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    RepositorySelectorBuilder.this.setDataValid(RepositorySelectorBuilder.this.repositoryFormsPanel.isValidData());
                }
            };
        }
        this.cardsPanel.add((Component)this.repositoryFormsPanel, NEW_REPO_PANEL);
    }

    private void fireDataValidityChanged() {
        if (this.changeListeners != null && !this.changeListeners.isEmpty()) {
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            for (ChangeListener l : this.changeListeners) {
                l.stateChanged(this.changeEvent);
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>(4);
        }
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(listener);
    }

    @Override
    public void addItemListener(ItemListener listener) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<ItemListener>(2);
        }
        this.selectionListeners.add(listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        if (this.selectionListeners == null) {
            return;
        }
        this.selectionListeners.remove(listener);
    }

    @Override
    public Object[] getSelectedObjects() {
        Repository[] repositoryArray;
        Repository selectedRepo = this.getSelectedRepository();
        if (selectedRepo != null) {
            Repository[] repositoryArray2 = new Repository[1];
            repositoryArray = repositoryArray2;
            repositoryArray2[0] = selectedRepo;
        } else {
            repositoryArray = null;
        }
        return repositoryArray;
    }

    private void fireSelectionChanged() {
        if (this.selectionListeners == null || this.selectionListeners.isEmpty()) {
            return;
        }
        ItemEvent event = new ItemEvent(this, 701, this.getSelectedRepository(), 1);
        for (ItemListener l : this.selectionListeners) {
            l.itemStateChanged(event);
        }
    }

    public void addResizeListener(ResizeListener l) {
        if (this.resizeListeners == null) {
            this.resizeListeners = new ArrayList<ResizeListener>(4);
        }
        this.resizeListeners.add(l);
    }

    public void removeResizeListener(ResizeListener l) {
        if (this.resizeListeners == null) {
            return;
        }
        this.resizeListeners.remove(l);
    }

    private void notifyResizeListeners() {
        if (this.resizeListeners != null && !this.resizeListeners.isEmpty()) {
            for (ResizeListener l : this.resizeListeners) {
                l.resizeMayBeNeeded();
            }
        }
    }

    private static String getText(String msgKey) {
        return NbBundle.getMessage(RepositorySelectorBuilder.class, (String)msgKey);
    }

    private Component createHorizontalStrut(JComponent parent, JComponent compA, JComponent compB, LayoutStyle.ComponentPlacement related) {
        return Box.createHorizontalStrut(this.getSpace(parent, compA, compB, related, 0));
    }

    private Component createVerticalStrut(JComponent parent, JComponent compA, JComponent compB, LayoutStyle.ComponentPlacement related) {
        return Box.createVerticalStrut(this.getSpace(parent, compA, compB, related, 1));
    }

    private int getSpace(JComponent parent, JComponent compA, JComponent compB, LayoutStyle.ComponentPlacement related, int horizontal) {
        return LayoutStyle.getInstance().getPreferredGap(compA, compB, related, horizontal == 0 ? 3 : 5, parent);
    }

    private static Object[] joinArrays(Object[] array1, Object[] array2) {
        if (array1 == null || array1.length == 0) {
            return array2;
        }
        if (array2 == null || array2.length == 0) {
            return array1;
        }
        Object[] result = new Object[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    private static final class ComboItemsRenderer
    implements ListCellRenderer {
        private final MessageFormat newConnectionFormat;
        private final ListCellRenderer defaultRenderer;

        private ComboItemsRenderer(ListCellRenderer defaultRenderer, String newConnectionFormatString) {
            this.defaultRenderer = defaultRenderer;
            this.newConnectionFormat = new MessageFormat(newConnectionFormatString);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text;
            if (value == null) {
                text = null;
            } else if (value instanceof Repository) {
                text = ((Repository)value).getDisplayName();
            } else if (value instanceof NewRepositoryInfo) {
                String connectorName = ((NewRepositoryInfo)value).connector.getDisplayName();
                text = this.newConnectionFormat.format(new Object[]{connectorName});
            } else {
                assert (false);
                text = "???";
            }
            return this.defaultRenderer.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
        }
    }

    private static final class NewRepositoryInfo {
        private final BugtrackingConnector connector;
        private Repository repository;

        private NewRepositoryInfo(BugtrackingConnector connector) {
            this.connector = connector;
        }

        Repository initializeRepository() {
            assert (this.repository == null);
            this.repository = this.connector.createRepository();
            return this.repository;
        }
    }

    public static interface ResizeListener {
        public void resizeMayBeNeeded();
    }

    private final class AutoResizingPanel
    extends JPanel
    implements ResizeListener {
        private Dimension requestedSize;

        AutoResizingPanel() {
        }

        AutoResizingPanel(LayoutManager lm) {
            super(lm);
        }

        @Override
        public void resizeMayBeNeeded() {
            this.expandWindowToFitNewConnectorForm();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void expandWindowToFitNewConnectorForm() {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window == null) {
                return;
            }
            Dimension currSize = this.getSize();
            Dimension prefSize = this.getPreferredSize();
            if (currSize.width >= prefSize.width && currSize.height >= prefSize.height) {
                return;
            }
            try {
                this.requestedSize = new Dimension(Math.max(currSize.width, prefSize.width), Math.max(currSize.height, prefSize.height));
                window.pack();
            }
            finally {
                this.requestedSize = null;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.requestedSize != null ? this.requestedSize : super.getPreferredSize();
        }
    }

    private final class ValidatingDialogDescriptor
    extends DialogDescriptor
    implements ChangeListener,
    ItemListener {
        ValidatingDialogDescriptor(String title) {
            super((Object)RepositorySelectorBuilder.this.createPanel(), title);
            RepositorySelectorBuilder.this.addChangeListener(this);
            this.updateStatus();
            RepositorySelectorBuilder.this.addItemListener(this);
            this.updateHelpId();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateStatus();
        }

        private void updateStatus() {
            this.setValid(RepositorySelectorBuilder.this.isValidData());
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.updateHelpId();
        }

        private void updateHelpId() {
            this.setHelpCtx(this.getHelpFor(RepositorySelectorBuilder.this.getSelectedRepository()));
        }

        private HelpCtx getHelpFor(Repository repository) {
            return repository != null ? repository.getController().getHelpCtx() : null;
        }
    }
}

