/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.bugtracking.util.TextUtils;

public final class StorageUtils {
    private StorageUtils() {
    }

    static DataOutputStream getDataOutputStream(File file, boolean append) throws IOException, InterruptedException {
        return new DataOutputStream(StorageUtils.getFileOutputStream(file, append));
    }

    static DataInputStream getDataInputStream(File file) throws IOException, InterruptedException {
        return new DataInputStream(StorageUtils.getFileInputStream(file));
    }

    static FileOutputStream getFileOutputStream(File file, boolean append) throws IOException, InterruptedException {
        int retry = 0;
        while (true) {
            try {
                return new FileOutputStream(file, append);
            }
            catch (IOException ioex) {
                if (++retry > 7) {
                    throw ioex;
                }
                Thread.sleep(retry * 30);
                continue;
            }
            break;
        }
    }

    static FileInputStream getFileInputStream(File file) throws IOException, InterruptedException {
        int retry = 0;
        while (true) {
            try {
                return new FileInputStream(file);
            }
            catch (IOException ioex) {
                if (++retry > 7) {
                    throw ioex;
                }
                Thread.sleep(retry * 30);
                continue;
            }
            break;
        }
    }

    static void copyStreams(OutputStream out, InputStream in) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while ((n = in.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
    }

    static File getNameSpaceFolder(File storage, String url) {
        File folder = new File(storage, TextUtils.encodeURL(url));
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    static DataOutputStream getQueryOutputStream(File queryFile) throws IOException, InterruptedException {
        return StorageUtils.getDataOutputStream(queryFile, false);
    }

    static DataInputStream getQueryInputStream(File queryFile) throws IOException, InterruptedException {
        if (!queryFile.exists()) {
            return null;
        }
        return StorageUtils.getDataInputStream(queryFile);
    }

    static class FileLocks {
        private static FileLocks instance;
        private final Map<String, FileLock> locks = new HashMap<String, FileLock>();

        FileLocks() {
        }

        private static synchronized FileLocks getInstance() {
            if (instance == null) {
                instance = new FileLocks();
            }
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static FileLock getLock(File file) {
            Map<String, FileLock> map = FileLocks.getInstance().locks;
            synchronized (map) {
                FileLock fl = FileLocks.getInstance().locks.get(file.getAbsolutePath());
                if (fl == null) {
                    FileLocks fileLocks = FileLocks.getInstance();
                    fileLocks.getClass();
                    fl = fileLocks.new FileLock(file);
                }
                FileLocks.getInstance().locks.put(file.getAbsolutePath(), fl);
                return fl;
            }
        }

        class FileLock {
            private final File file;

            public FileLock(File file) {
                this.file = file;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void release() {
                Map map = FileLocks.getInstance().locks;
                synchronized (map) {
                    FileLocks.getInstance().locks.remove(this.file.getAbsolutePath());
                }
            }
        }
    }
}

