/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.BugtrackingConfig;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCache;
import org.netbeans.modules.bugtracking.ui.issue.cache.StorageUtils;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.TextUtils;
import org.openide.util.RequestProcessor;

class IssueStorage {
    private static IssueStorage instance;
    private File storage;
    private static final String STORAGE_FILE = "storage";
    private static final String STORAGE_VERSION_1_0 = "1.0";
    private static final String STORAGE_VERSION_1_1 = "1.1";
    private static final String STORAGE_VERSION = "1.1";
    private String QUERY_ARCHIVED_SUFIX = ".qa";
    private String QUERY_SUFIX = ".q";
    private String ISSUE_SUFIX = ".i";

    private IssueStorage() {
    }

    public static IssueStorage getInstance() {
        if (instance == null) {
            instance = new IssueStorage();
            instance.initStorage();
        }
        return instance;
    }

    private void initStorage() {
        this.storage = this.getStorageRootFile();
        if (!this.storage.exists()) {
            this.storage.mkdirs();
        }
        this.writeStorage();
        RequestProcessor.Task t = BugtrackingManager.getInstance().getRequestProcessor().create(new Runnable(){

            @Override
            public void run() {
                IssueStorage.this.cleanup();
            }
        });
        t.schedule(0);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    long getReferenceTime(String nameSpace) throws IOException {
        long ex32;
        DataOutputStream os;
        long ret;
        StorageUtils.FileLocks.FileLock lock;
        block37: {
            File data;
            block34: {
                long l;
                DataInputStream is;
                block35: {
                    File folder = StorageUtils.getNameSpaceFolder(this.storage, nameSpace);
                    data = new File(folder, "data");
                    lock = StorageUtils.FileLocks.getLock(data);
                    StorageUtils.FileLocks.FileLock fileLock = lock;
                    // MONITORENTER : fileLock
                    File parentFile = data.getParentFile();
                    if (!parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    ret = -1L;
                    if (!data.exists()) break block34;
                    is = null;
                    is = StorageUtils.getDataInputStream(data);
                    l = ret = is.readLong();
                    if (!BugtrackingManager.LOG.isLoggable(Level.FINE)) break block35;
                    String dateString = ret > -1L ? new SimpleDateFormat().format(new Date(ret)) : "null";
                    BugtrackingManager.LOG.log(Level.FINE, "finished reading greference time {0} - {1}", new Object[]{nameSpace, dateString});
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (lock == null) return l;
                lock.release();
                return l;
                catch (EOFException ex2) {
                    long l2;
                    block36: {
                        BugtrackingManager.LOG.log(Level.SEVERE, data.getAbsolutePath(), ex2);
                        l2 = -1L;
                        if (!BugtrackingManager.LOG.isLoggable(Level.FINE)) break block36;
                        String dateString = ret > -1L ? new SimpleDateFormat().format(new Date(ret)) : "null";
                        {
                            catch (Throwable throwable) {
                                if (BugtrackingManager.LOG.isLoggable(Level.FINE)) {
                                    String dateString2 = ret > -1L ? new SimpleDateFormat().format(new Date(ret)) : "null";
                                    BugtrackingManager.LOG.log(Level.FINE, "finished reading greference time {0} - {1}", new Object[]{nameSpace, dateString2});
                                }
                                try {
                                    if (is == null) throw throwable;
                                    is.close();
                                    throw throwable;
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                        BugtrackingManager.LOG.log(Level.FINE, "finished reading greference time {0} - {1}", new Object[]{nameSpace, dateString});
                    }
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (lock == null) return l2;
                    lock.release();
                    return l2;
                    catch (InterruptedException ex32) {
                        BugtrackingManager.LOG.log(Level.WARNING, null, ex32);
                        IOException ioe = new IOException(ex32.getMessage());
                        ioe.initCause(ex32);
                        throw ioe;
                    }
                }
                {
                    catch (Throwable throwable) {
                        if (lock == null) throw throwable;
                        lock.release();
                        throw throwable;
                    }
                }
            }
            data.createNewFile();
            ret = System.currentTimeMillis();
            os = null;
            os = StorageUtils.getDataOutputStream(data, false);
            os.writeLong(ret);
            ex32 = ret;
            if (!BugtrackingManager.LOG.isLoggable(Level.FINE)) break block37;
            String dateString = ret > -1L ? new SimpleDateFormat().format(new Date(ret)) : "null";
            BugtrackingManager.LOG.log(Level.FINE, "finished writing greference time {0} - {1}", new Object[]{nameSpace, dateString});
        }
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (lock == null) return ex32;
        lock.release();
        return ex32;
        catch (InterruptedException ex2) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, ex2);
                IOException ioe = new IOException(ex2.getMessage());
                ioe.initCause(ex2);
                throw ioe;
            }
            catch (Throwable throwable) {
                if (BugtrackingManager.LOG.isLoggable(Level.FINE)) {
                    String dateString = ret > -1L ? new SimpleDateFormat().format(new Date(ret)) : "null";
                    BugtrackingManager.LOG.log(Level.FINE, "finished writing greference time {0} - {1}", new Object[]{nameSpace, dateString});
                }
                try {
                    if (os == null) throw throwable;
                    os.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void storeIssue(String nameSpace, IssueCache.IssueEntry entry) throws IOException {
        StorageUtils.FileLocks.FileLock lock;
        FilterOutputStream dos;
        InputStream is;
        block32: {
            assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
            BugtrackingManager.LOG.log(Level.FINE, "start storing issue {0} - {1}", new Object[]{nameSpace, entry.getId()});
            is = null;
            dos = null;
            lock = null;
            File issueFile = this.getIssueFile(StorageUtils.getNameSpaceFolder(this.storage, nameSpace), entry.getId());
            StorageUtils.FileLocks.FileLock fileLock = lock = StorageUtils.FileLocks.getLock(issueFile);
            // MONITORENTER : fileLock
            dos = this.getIssueOutputStream(issueFile);
            if (dos != null) break block32;
            // MONITOREXIT : fileLock
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (lock != null) {
                lock.release();
            }
            BugtrackingManager.LOG.log(Level.FINE, "finished storing issue {0} - {1}", new Object[]{nameSpace, entry.getId()});
            return;
        }
        ((DataOutputStream)dos).writeBoolean(entry.wasSeen());
        ((DataOutputStream)dos).writeLong(entry.getLastSeenModified());
        ((DataOutputStream)dos).writeInt(entry.getLastUnseenStatus());
        if (entry.getSeenAttributes() != null) {
            for (Map.Entry<String, String> e : entry.getSeenAttributes().entrySet()) {
                this.writeString((DataOutputStream)dos, e.getKey());
                this.writeString((DataOutputStream)dos, e.getValue());
            }
        }
        // MONITOREXIT : fileLock
        try {
            if (dos != null) {
                dos.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (lock != null) {
            lock.release();
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished storing issue {0} - {1}", new Object[]{nameSpace, entry.getId()});
        return;
        catch (InterruptedException ex) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, ex);
                IOException ioe = new IOException(ex.getMessage());
                ioe.initCause(ex);
                throw ioe;
            }
            catch (Throwable throwable) {
                try {
                    if (dos != null) {
                        dos.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (lock != null) {
                    lock.release();
                }
                BugtrackingManager.LOG.log(Level.FINE, "finished storing issue {0} - {1}", new Object[]{nameSpace, entry.getId()});
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void readIssue(String nameSpace, IssueCache.IssueEntry entry) throws IOException {
        StorageUtils.FileLocks.FileLock lock;
        FilterInputStream is;
        block24: {
            block25: {
                assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
                BugtrackingManager.LOG.log(Level.FINE, "start reading issue {0} - {1}", new Object[]{nameSpace, entry.getId()});
                is = null;
                lock = null;
                File issueFile = this.getIssueFile(StorageUtils.getNameSpaceFolder(this.storage, nameSpace), entry.getId());
                StorageUtils.FileLocks.FileLock fileLock = lock = StorageUtils.FileLocks.getLock(issueFile);
                // MONITORENTER : fileLock
                is = this.getIssueInputStream(issueFile);
                if (is != null) break block24;
                // MONITOREXIT : fileLock
                if (is == null) break block25;
                try {
                    is.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (lock != null) {
                lock.release();
            }
            BugtrackingManager.LOG.log(Level.FINE, "finished reading issue {0} - {1}", new Object[]{nameSpace, entry.getId()});
            return;
        }
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            boolean seen = ((DataInputStream)is).readBoolean();
            long lastModified = -1L;
            int lastStatus = 0;
            if (!"1.1".equals(STORAGE_VERSION_1_0)) {
                lastModified = ((DataInputStream)is).readLong();
                lastStatus = ((DataInputStream)is).readInt();
            }
            try {
                while (true) {
                    String key = IssueStorage.readString((DataInputStream)is);
                    String value = IssueStorage.readString((DataInputStream)is);
                    m.put(key, value);
                }
            }
            catch (EOFException e) {
                entry.setSeenAttributes(m);
                entry.setSeen(seen);
                entry.setLastSeenModified(lastModified);
                entry.setLastUnseenStatus(lastStatus);
                // MONITOREXIT : fileLock
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                if (lock != null) {
                    lock.release();
                }
                BugtrackingManager.LOG.log(Level.FINE, "finished reading issue {0} - {1}", new Object[]{nameSpace, entry.getId()});
                return;
            }
        }
        catch (InterruptedException ex) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, ex);
                IOException ioe = new IOException(ex.getMessage());
                ioe.initCause(ex);
                throw ioe;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (lock != null) {
                    lock.release();
                }
                BugtrackingManager.LOG.log(Level.FINE, "finished reading issue {0} - {1}", new Object[]{nameSpace, entry.getId()});
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<String> readQuery(String nameSpace, String queryName) throws IOException {
        List<String> list;
        File folder;
        StorageUtils.FileLocks.FileLock lock;
        FilterInputStream dis;
        block21: {
            assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
            BugtrackingManager.LOG.log(Level.FINE, "start reading query {0} - {1}", new Object[]{nameSpace, queryName});
            dis = null;
            lock = null;
            folder = StorageUtils.getNameSpaceFolder(this.storage, nameSpace);
            if (folder.exists()) break block21;
            List<String> list2 = Collections.emptyList();
            BugtrackingManager.LOG.log(Level.FINE, "finished reading query {0} - {1}", new Object[]{nameSpace, queryName});
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (lock != null) {
                lock.release();
            }
            return list2;
        }
        try {
            File f = this.getQueryFile(folder, queryName, false);
            StorageUtils.FileLocks.FileLock fileLock = lock = StorageUtils.FileLocks.getLock(f);
            synchronized (fileLock) {
                dis = StorageUtils.getQueryInputStream(f);
                list = this.readQuery((DataInputStream)dis);
            }
        }
        catch (Throwable throwable) {
            BugtrackingManager.LOG.log(Level.FINE, "finished reading query {0} - {1}", new Object[]{nameSpace, queryName});
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (lock != null) {
                lock.release();
            }
            throw throwable;
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished reading query {0} - {1}", new Object[]{nameSpace, queryName});
        if (dis != null) {
            try {
                dis.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (lock != null) {
            lock.release();
        }
        return list;
        {
            catch (InterruptedException ex) {
                BugtrackingManager.LOG.log(Level.WARNING, null, ex);
                IOException ioe = new IOException(ex.getMessage());
                ioe.initCause(ex);
                throw ioe;
            }
        }
    }

    private List<String> readQuery(DataInputStream dis) throws IOException {
        if (dis == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>();
        while (true) {
            String id = null;
            try {
                id = IssueStorage.readString(dis);
            }
            catch (EOFException e) {
                break;
            }
            ids.add(id);
        }
        return ids;
    }

    long getQueryTimestamp(String nameSpace, String name) {
        File folder = StorageUtils.getNameSpaceFolder(this.storage, nameSpace);
        File file = new File(folder, TextUtils.encodeURL(name) + this.QUERY_SUFIX);
        return file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    Map<String, Long> readArchivedQueryIssues(String nameSpace, String queryName) throws IOException {
        FilterInputStream dis;
        StorageUtils.FileLocks.FileLock lock;
        long ttl;
        long now;
        block24: {
            File folder;
            block23: {
                assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
                BugtrackingManager.LOG.log(Level.FINE, "start reading archived query issues {0} - {1}", new Object[]{nameSpace, queryName});
                now = System.currentTimeMillis();
                ttl = BugtrackingConfig.getInstance().getArchivedIssuesTTL() * 1000L * 60L * 60L * 24L;
                lock = null;
                dis = null;
                folder = StorageUtils.getNameSpaceFolder(this.storage, nameSpace);
                if (folder.exists()) break block23;
                Map<String, Long> map = Collections.emptyMap();
                BugtrackingManager.LOG.log(Level.FINE, "finished reading archived query issues {0} - {1}", new Object[]{nameSpace, queryName});
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (lock == null) return map;
                lock.release();
                return map;
            }
            File f = this.getQueryFile(folder, queryName, true);
            StorageUtils.FileLocks.FileLock fileLock = lock = StorageUtils.FileLocks.getLock(f);
            // MONITORENTER : fileLock
            dis = StorageUtils.getQueryInputStream(f);
            if (dis != null) break block24;
            Map<String, Long> map = Collections.emptyMap();
            // MONITOREXIT : fileLock
            BugtrackingManager.LOG.log(Level.FINE, "finished reading archived query issues {0} - {1}", new Object[]{nameSpace, queryName});
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (lock == null) return map;
            lock.release();
            return map;
        }
        Map<String, Long> ids = this.readArchivedQueryIssues((DataInputStream)dis);
        Iterator<String> it = ids.keySet().iterator();
        while (it.hasNext()) {
            String id = it.next();
            long ts = ids.get(id);
            if (ts >= now - ttl) continue;
            it.remove();
        }
        Map<String, Long> map = ids;
        // MONITOREXIT : fileLock
        {
            catch (InterruptedException ex) {
                BugtrackingManager.LOG.log(Level.WARNING, null, ex);
                IOException ioe = new IOException(ex.getMessage());
                ioe.initCause(ex);
                throw ioe;
            }
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished reading archived query issues {0} - {1}", new Object[]{nameSpace, queryName});
        if (dis != null) {
            try {
                dis.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (lock == null) return map;
        lock.release();
        return map;
        catch (Throwable throwable) {
            BugtrackingManager.LOG.log(Level.FINE, "finished reading archived query issues {0} - {1}", new Object[]{nameSpace, queryName});
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (lock == null) throw throwable;
            lock.release();
            throw throwable;
        }
    }

    private Map<String, Long> readArchivedQueryIssues(DataInputStream dis) throws IOException {
        if (dis == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> ids = new HashMap<String, Long>();
        while (true) {
            String id = null;
            long ts = -1L;
            try {
                id = IssueStorage.readString(dis);
                ts = dis.readLong();
                ids.put(id, ts);
            }
            catch (EOFException e) {
                return ids;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeQuery(String nameSpace, String queryName) throws IOException {
        block19: {
            assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
            BugtrackingManager.LOG.log(Level.FINE, "start removing query {0} - {1}", new Object[]{nameSpace, queryName});
            StorageUtils.FileLocks.FileLock lock = null;
            try {
                File folder = StorageUtils.getNameSpaceFolder(this.storage, nameSpace);
                File query = this.getQueryFile(folder, queryName, false);
                if (query.exists()) {
                    lock = StorageUtils.FileLocks.getLock(query);
                    try {
                        StorageUtils.FileLocks.FileLock fileLock = lock;
                        synchronized (fileLock) {
                            BugtrackingUtil.deleteRecursively(query);
                        }
                    }
                    finally {
                        if (lock != null) {
                            lock.release();
                        }
                    }
                }
                lock = null;
                File queryArchived = this.getQueryFile(folder, queryName, true);
                if (!queryArchived.exists()) break block19;
                lock = StorageUtils.FileLocks.getLock(queryArchived);
                try {
                    StorageUtils.FileLocks.FileLock fileLock = lock;
                    synchronized (fileLock) {
                        BugtrackingUtil.deleteRecursively(queryArchived);
                    }
                }
                finally {
                    if (lock != null) {
                        lock.release();
                    }
                }
            }
            catch (Throwable throwable) {
                BugtrackingManager.LOG.log(Level.FINE, "finished removing query {0} - {1}", new Object[]{nameSpace, queryName});
                throw throwable;
            }
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished removing query {0} - {1}", new Object[]{nameSpace, queryName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeQuery(String nameSpace, String queryName, String[] ids) throws IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
        BugtrackingManager.LOG.log(Level.FINE, "start storing query issues {0} - {1}", new Object[]{nameSpace, queryName});
        StorageUtils.FileLocks.FileLock lock = null;
        FilterOutputStream dos = null;
        try {
            File folder = StorageUtils.getNameSpaceFolder(this.storage, nameSpace);
            File f = this.getQueryFile(folder, queryName, false);
            StorageUtils.FileLocks.FileLock fileLock = lock = StorageUtils.FileLocks.getLock(f);
            synchronized (fileLock) {
                dos = StorageUtils.getQueryOutputStream(f);
                for (String id : ids) {
                    this.writeString((DataOutputStream)dos, id);
                }
                ((DataOutputStream)dos).flush();
            }
        }
        catch (InterruptedException ex) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, ex);
                IOException ioe = new IOException(ex.getMessage());
                ioe.initCause(ex);
                throw ioe;
            }
            catch (Throwable throwable) {
                BugtrackingManager.LOG.log(Level.FINE, "finished storing query issues {0} - {1}", new Object[]{nameSpace, queryName});
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (lock != null) {
                    lock.release();
                }
                throw throwable;
            }
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished storing query issues {0} - {1}", new Object[]{nameSpace, queryName});
        if (dos != null) {
            try {
                dos.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (lock != null) {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void storeArchivedQueryIssues(String nameSpace, String queryName, String[] ids) throws IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
        BugtrackingManager.LOG.log(Level.FINE, "start storing archived query issues {0} - {1}", new Object[]{nameSpace, queryName});
        long now = System.currentTimeMillis();
        Map<String, Long> archived = this.readArchivedQueryIssues(nameSpace, queryName);
        FilterOutputStream dos = null;
        StorageUtils.FileLocks.FileLock lock = null;
        try {
            File folder = StorageUtils.getNameSpaceFolder(this.storage, nameSpace);
            File f = this.getQueryFile(folder, queryName, true);
            StorageUtils.FileLocks.FileLock fileLock = lock = StorageUtils.FileLocks.getLock(f);
            synchronized (fileLock) {
                dos = StorageUtils.getQueryOutputStream(f);
                for (String id : ids) {
                    this.writeString((DataOutputStream)dos, id);
                    Long ts = archived.get(id);
                    if (ts != null && ts != -1L) {
                        ((DataOutputStream)dos).writeLong(ts);
                        continue;
                    }
                    ((DataOutputStream)dos).writeLong(now);
                }
                ((DataOutputStream)dos).flush();
            }
        }
        catch (InterruptedException ex) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, ex);
                IOException ioe = new IOException(ex.getMessage());
                ioe.initCause(ex);
                throw ioe;
            }
            catch (Throwable throwable) {
                try {
                    if (dos != null) {
                        dos.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (lock != null) {
                    lock.release();
                }
                BugtrackingManager.LOG.log(Level.FINE, "finished storing archived query issues {0} - {1}", new Object[]{nameSpace, queryName});
                throw throwable;
            }
        }
        try {
            if (dos != null) {
                dos.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (lock != null) {
            lock.release();
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished storing archived query issues {0} - {1}", new Object[]{nameSpace, queryName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        try {
            BugtrackingManager.LOG.log(Level.FINE, "starting bugtrackig storage cleanup");
            File root = this.getStorageRootFile();
            File[] repos = root.listFiles();
            if (repos == null) {
                return;
            }
            for (File repo : repos) {
                this.cleanup(repo);
            }
        }
        finally {
            BugtrackingManager.LOG.log(Level.FINE, "finnished bugtrackig storage cleanup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup(String namespace) {
        try {
            BugtrackingManager.LOG.log(Level.FINE, "starting bugtrackig storage cleanup for {0}", new Object[]{namespace});
            this.cleanup(StorageUtils.getNameSpaceFolder(this.storage, namespace));
        }
        catch (Throwable throwable) {
            BugtrackingManager.LOG.log(Level.FINE, "finnished bugtrackig storage cleanup for {0}", new Object[]{namespace});
            throw throwable;
        }
        BugtrackingManager.LOG.log(Level.FINE, "finnished bugtrackig storage cleanup for {0}", new Object[]{namespace});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void cleanup(File repo) {
        block35: {
            try {
                StorageUtils.FileLocks.FileLock lock;
                StorageUtils.FileLocks.FileLock fileLock;
                BugtrackingManager.LOG.log(Level.FINE, "starting bugtrackig storage cleanup for {0}", new Object[]{repo.getAbsoluteFile()});
                HashSet<String> livingIssues = new HashSet<String>();
                File[] queries = repo.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(IssueStorage.this.QUERY_SUFIX);
                    }
                });
                if (queries != null && queries.length > 0) {
                    for (File lq : queries) {
                        List<String> ids;
                        StorageUtils.FileLocks.FileLock lock2 = StorageUtils.FileLocks.getLock(lq);
                        try {
                            fileLock = lock2;
                            synchronized (fileLock) {
                                ids = this.readQuery(StorageUtils.getDataInputStream(lq));
                            }
                        }
                        finally {
                            if (lock2 != null) {
                                lock2.release();
                            }
                        }
                        if (ids == null || ids.size() == 0) continue;
                        livingIssues.addAll(ids);
                    }
                }
                if ((queries = repo.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(IssueStorage.this.QUERY_ARCHIVED_SUFIX);
                    }
                })) != null) {
                    for (File lq : queries) {
                        Map<String, Long> ids;
                        lock = StorageUtils.FileLocks.getLock(lq);
                        try {
                            fileLock = lock;
                            synchronized (fileLock) {
                                ids = this.readArchivedQueryIssues(StorageUtils.getDataInputStream(lq));
                            }
                        }
                        finally {
                            if (lock != null) {
                                lock.release();
                            }
                        }
                        if (ids == null || ids.size() == 0) continue;
                        livingIssues.addAll(ids.keySet());
                    }
                }
                BugtrackingManager.LOG.log(Level.FINER, "living query issues {0}", new Object[]{livingIssues});
                File[] issues = repo.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(IssueStorage.this.ISSUE_SUFIX);
                    }
                });
                if (issues == null) break block35;
                for (File issue : issues) {
                    lock = StorageUtils.FileLocks.getLock(issue);
                    try {
                        String id = issue.getName();
                        id = id.substring(0, id.length() - this.ISSUE_SUFIX.length());
                        StorageUtils.FileLocks.FileLock fileLock2 = lock;
                        synchronized (fileLock2) {
                            if (!livingIssues.contains(id)) {
                                BugtrackingManager.LOG.log(Level.FINE, "removing issue {0}", new Object[]{id});
                                issue.delete();
                            }
                        }
                    }
                    finally {
                        if (lock != null) {
                            lock.release();
                        }
                    }
                }
            }
            catch (IOException ex) {
                BugtrackingManager.LOG.log(Level.WARNING, null, ex);
                BugtrackingManager.LOG.log(Level.FINE, "finished bugtrackig storage cleanup for {0}", new Object[]{repo.getAbsoluteFile()});
            }
            catch (InterruptedException ex2) {
                BugtrackingManager.LOG.log(Level.WARNING, null, ex2);
                {
                    catch (Throwable throwable) {
                        BugtrackingManager.LOG.log(Level.FINE, "finished bugtrackig storage cleanup for {0}", new Object[]{repo.getAbsoluteFile()});
                        throw throwable;
                    }
                }
                BugtrackingManager.LOG.log(Level.FINE, "finished bugtrackig storage cleanup for {0}", new Object[]{repo.getAbsoluteFile()});
            }
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished bugtrackig storage cleanup for {0}", new Object[]{repo.getAbsoluteFile()});
    }

    private File getStorageRootFile() {
        String userDir = System.getProperty("netbeans.user");
        return new File(new File(userDir, "var"), "bugtracking");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStorage() {
        FilterOutputStream dos = null;
        try {
            dos = StorageUtils.getDataOutputStream(new File(this.storage, STORAGE_FILE), false);
            this.writeString((DataOutputStream)dos, "1.1");
            ((DataOutputStream)dos).flush();
        }
        catch (IOException e) {
            BugtrackingManager.LOG.log(Level.INFO, null, e);
        }
        catch (InterruptedException ie) {
            BugtrackingManager.LOG.log(Level.INFO, null, ie);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void writeString(DataOutputStream dos, String str) throws IOException {
        if (str != null) {
            dos.writeInt(str.length());
            dos.writeChars(str);
        } else {
            dos.writeInt(0);
        }
    }

    private static String readString(DataInputStream dis) throws IOException {
        int len = dis.readInt();
        if (len == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        while (len-- > 0) {
            char c = dis.readChar();
            sb.append(c);
        }
        return sb.toString();
    }

    private DataOutputStream getIssueOutputStream(File issueFile) throws IOException, InterruptedException {
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(StorageUtils.getFileOutputStream(issueFile, false)));
        ZipEntry entry = new ZipEntry(issueFile.getName());
        zos.putNextEntry(entry);
        return new DataOutputStream(zos);
    }

    private DataInputStream getIssueInputStream(File file) throws IOException, InterruptedException {
        if (!file.exists()) {
            return null;
        }
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(StorageUtils.getFileInputStream(file)));
        zis.getNextEntry();
        return new DataInputStream(zis);
    }

    private File getIssueFile(File folder, String id) {
        return new File(folder, id + this.ISSUE_SUFIX);
    }

    private File getQueryFile(File folder, String queryName, boolean archived) {
        return new File(folder, TextUtils.encodeURL(queryName) + (archived ? this.QUERY_ARCHIVED_SUFIX : this.QUERY_SUFIX));
    }
}

