/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.ui.issue.cache.StorageUtils;

public class IssueSettingsStorage {
    private static final String PROP_COLLAPSED_COMMENT_PREFIX = "collapsed.comment";
    private static IssueSettingsStorage instance;
    private final File storage = this.getStorageRootFile();

    private IssueSettingsStorage() {
        if (!this.storage.exists()) {
            this.storage.mkdirs();
        }
    }

    public static synchronized IssueSettingsStorage getInstance() {
        if (instance == null) {
            instance = new IssueSettingsStorage();
        }
        return instance;
    }

    private File getStorageRootFile() {
        String userDir = System.getProperty("netbeans.user");
        return new File(new File(userDir, "config"), "issue-tracking");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> loadCollapsedCommenst(String repoUrl, String id) {
        File file = this.getIssuePropertiesFile(repoUrl, id);
        StorageUtils.FileLocks.FileLock l = StorageUtils.FileLocks.getLock(file);
        try {
            Properties p = this.load(file, repoUrl, id);
            HashSet<Long> s = new HashSet<Long>();
            for (Object k : p.keySet()) {
                String key = k.toString();
                if (!key.startsWith(PROP_COLLAPSED_COMMENT_PREFIX) || !"true".equals(p.get(key))) continue;
                s.add(Long.parseLong(key.substring(PROP_COLLAPSED_COMMENT_PREFIX.length())));
            }
            HashSet<Long> hashSet = s;
            return hashSet;
        }
        catch (IOException ex) {
            BugtrackingManager.LOG.log(Level.WARNING, repoUrl + " " + id, ex);
        }
        finally {
            l.release();
        }
        return Collections.EMPTY_SET;
    }

    private Properties load(File file, String repoUrl, String id) throws IOException {
        Properties p = new Properties();
        if (!file.exists()) {
            file.createNewFile();
        }
        p.load(new FileInputStream(file));
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCollapsedComments(Collection<Long> collapsedComments, String repoUrl, String id) {
        File file = this.getIssuePropertiesFile(repoUrl, id);
        StorageUtils.FileLocks.FileLock l = StorageUtils.FileLocks.getLock(file);
        try {
            Properties p = this.load(file, repoUrl, id);
            this.clear(p, PROP_COLLAPSED_COMMENT_PREFIX);
            for (Long i : collapsedComments) {
                p.put(PROP_COLLAPSED_COMMENT_PREFIX + i, "true");
            }
            p.store(new FileOutputStream(file), "");
        }
        catch (IOException ex) {
            BugtrackingManager.LOG.log(Level.WARNING, repoUrl + " " + id, ex);
        }
        finally {
            l.release();
        }
    }

    private void clear(Properties p, String keyPrefix) {
        Iterator<Object> it = p.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (!key.startsWith(keyPrefix)) continue;
            it.remove();
        }
    }

    private File getIssuePropertiesFile(String repoUrl, String id) {
        return new File(StorageUtils.getNameSpaceFolder(this.storage, repoUrl), id);
    }
}

