/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.jira;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JButton;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.jira.DownloadPanel;
import org.netbeans.modules.bugtracking.jira.MissingJiraSupportPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class DownloadPlugin
implements ActionListener {
    private DownloadPanel panel = new DownloadPanel();
    private JButton install = new JButton(NbBundle.getMessage(DownloadPlugin.class, (String)"CTL_Action_Install"));
    private JButton cancel = new JButton(NbBundle.getMessage(DownloadPlugin.class, (String)"CTL_Action_Cancel"));

    public DownloadPlugin() {
        this.install.setEnabled(false);
        this.panel.licensePanel.setVisible(false);
        this.panel.acceptCheckBox.addActionListener(this);
    }

    void startDownload() {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DownloadPlugin.class, (String)"MSG_LookingForJira"));
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean ret;
                ph.start();
                try {
                    List units = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
                    for (UpdateUnit u : units) {
                        for (JiraModules modules : JiraModules.values()) {
                            if (!u.getCodeName().equals(modules.cnb)) continue;
                            List elements = u.getAvailableUpdates();
                            if (elements.isEmpty()) {
                                modules.installed = true;
                                continue;
                            }
                            modules.updateElement = (UpdateElement)u.getAvailableUpdates().get(0);
                        }
                        if (this.nullElements(false)) continue;
                    }
                    if (this.allInstaled()) {
                        DownloadPlugin.notifyError(NbBundle.getMessage(DownloadPlugin.class, (String)"MSG_AlreadyInstalled"), NbBundle.getMessage(DownloadPlugin.class, (String)"LBL_Error"));
                        return;
                    }
                }
                finally {
                    ph.finish();
                }
                if (this.nullElements(true)) {
                    if (BugtrackingManager.LOG.isLoggable(Level.FINE)) {
                        for (JiraModules module : JiraModules.values()) {
                            BugtrackingManager.LOG.log(Level.FINE, " + {0}, installed : {1}, found: {2}", new Object[]{module.cnb, module.installed, module.updateElement == null ? "false" : "true"});
                        }
                    }
                    DownloadPlugin.notifyError(NbBundle.getMessage(DownloadPlugin.class, (String)"MSG_JiraNotFound"), NbBundle.getMessage(DownloadPlugin.class, (String)"LBL_Error"));
                    return;
                }
                ((DownloadPlugin)DownloadPlugin.this).panel.licensePanel.setVisible(true);
                StringBuilder sb = new StringBuilder();
                if (JiraModules.JIRA.updateElement != null) {
                    sb.append(JiraModules.JIRA.updateElement.getLicence());
                }
                if (JiraModules.JIRA.updateElement != null && JiraModules.JAVAX_WSDL.updateElement != null) {
                    sb.append("\n\n");
                }
                if (JiraModules.JAVAX_WSDL.updateElement != null) {
                    sb.append(JiraModules.JAVAX_WSDL.updateElement.getLicence());
                }
                ((DownloadPlugin)DownloadPlugin.this).panel.licenseTextPane.setText(sb.toString());
                DownloadPlugin.this.panel.repaint();
                NotifyDescriptor descriptor = new NotifyDescriptor((Object)DownloadPlugin.this.panel, NbBundle.getMessage(DownloadPlugin.class, (String)"LBL_DownloadJira"), 2, -1, new Object[]{DownloadPlugin.this.install, DownloadPlugin.this.cancel}, (Object)DownloadPlugin.this.install);
                boolean bl = ret = DialogDisplayer.getDefault().notify(descriptor) == DownloadPlugin.this.install;
                if (!ret) {
                    this.resetElements();
                    return;
                }
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        DownloadPlugin.this.install();
                    }
                });
            }

            private boolean nullElements(boolean onlyInstalled) {
                for (JiraModules module : JiraModules.values()) {
                    if (onlyInstalled && module.installed || module.updateElement != null) continue;
                    return true;
                }
                return false;
            }

            private boolean allInstaled() {
                for (JiraModules module : JiraModules.values()) {
                    if (module.installed) continue;
                    return false;
                }
                return true;
            }

            private boolean resetElements() {
                for (JiraModules module : JiraModules.values()) {
                    module.installed = false;
                    module.updateElement = null;
                }
                return true;
            }
        });
    }

    private void install() {
        OperationSupport.Restarter rest = null;
        OperationContainer oc = null;
        for (JiraModules module : JiraModules.values()) {
            if (module.installed) continue;
            rest = null;
            try {
                InstallCancellable ic = new InstallCancellable();
                oc = OperationContainer.createForInstall();
                if (oc.canBeAdded(module.updateElement.getUpdateUnit(), module.updateElement)) {
                    oc.add(module.updateElement);
                } else {
                    if (module.updateElement.getUpdateUnit().isPending()) {
                        DownloadPlugin.notifyInDialog(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MSG_MissingClient_RestartNeeded"), NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_MissingClient_RestartNeeded"), 1, false);
                        return;
                    }
                    oc = OperationContainer.createForUpdate();
                    if (oc.canBeAdded(module.updateElement.getUpdateUnit(), module.updateElement)) {
                        oc.add(module.updateElement);
                    } else {
                        BugtrackingManager.LOG.warning("MissingClient: cannot install " + module.updateElement.toString());
                        if (module.updateElement.getUpdateUnit().getInstalled() != null) {
                            BugtrackingManager.LOG.warning("MissingClient: already installed " + module.updateElement.getUpdateUnit().getInstalled().toString());
                        }
                        DownloadPlugin.notifyInDialog(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MSG_MissingClient_InvalidOperation"), NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_MissingClient_InvalidOperation"), 0, false);
                        return;
                    }
                }
                InstallSupport.Validator v = ((InstallSupport)oc.getSupport()).doDownload(ProgressHandleFactory.createHandle((String)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_Downloading", (Object)module.updateElement.getDisplayName()), (Cancellable)ic), false);
                if (ic.cancelled) {
                    return;
                }
                InstallSupport.Installer i = ((InstallSupport)oc.getSupport()).doValidate(v, ProgressHandleFactory.createHandle((String)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_Validating", (Object)module.updateElement.getDisplayName()), (Cancellable)ic));
                if (ic.cancelled) {
                    return;
                }
                rest = ((InstallSupport)oc.getSupport()).doInstall(i, ProgressHandleFactory.createHandle((String)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_Installing", (Object)module.updateElement.getDisplayName()), (Cancellable)ic));
            }
            catch (OperationException e) {
                BugtrackingManager.LOG.log(Level.INFO, null, e);
                DownloadPlugin.notifyError(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MSG_MissingClient_UC_Unavailable"), NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_MissingClient_UC_Unavailable"));
            }
        }
        if (rest != null) {
            JButton restart = new JButton(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"CTL_Action_Restart"));
            JButton cancel = new JButton(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"CTL_Action_Cancel"));
            NotifyDescriptor descriptor = new NotifyDescriptor((Object)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MSG_NeedsRestart"), NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_DownloadJira"), 2, 3, new Object[]{restart, cancel}, (Object)restart);
            if (DialogDisplayer.getDefault().notify(descriptor) == restart) {
                try {
                    ((InstallSupport)oc.getSupport()).doRestart(rest, ProgressHandleFactory.createHandle((String)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_Restarting")));
                }
                catch (OperationException e) {
                    BugtrackingManager.LOG.log(Level.INFO, null, e);
                    DownloadPlugin.notifyError(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MSG_MissingClient_UC_Unavailable"), NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_MissingClient_UC_Unavailable"));
                }
            }
        }
    }

    private static void notifyError(String message, String title) {
        DownloadPlugin.notifyInDialog(message, title, 0, true);
    }

    private static void notifyInDialog(String message, String title, int messageType, boolean cancelVisible) {
        Object[] objectArray;
        if (cancelVisible) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = NotifyDescriptor.OK_OPTION;
            objectArray = objectArray2;
            objectArray2[1] = NotifyDescriptor.CANCEL_OPTION;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = NotifyDescriptor.OK_OPTION;
        }
        NotifyDescriptor nd = new NotifyDescriptor((Object)message, title, -1, messageType, objectArray, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notifyLater(nd);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.acceptCheckBox) {
            this.install.setEnabled(this.panel.acceptCheckBox.isSelected());
        }
    }

    private class InstallCancellable
    implements Cancellable {
        private boolean cancelled;

        private InstallCancellable() {
        }

        public boolean cancel() {
            this.cancelled = true;
            return true;
        }
    }

    private static enum JiraModules {
        ECLIPSE_MYLYN_MONITOR_DUMMY("org.eclipse.mylyn.monitor.ui.dummy"),
        JAVAX_WSDL("javax.wsdl"),
        JAVAX_MAIL("javax.mail"),
        JAVAX_ACTIVATION("javax.activation"),
        JAVAX_SERVLET("javax.servlet"),
        JAVAX_XML_SOAP("javax.xml.soap"),
        JAVAX_XML_RPC("javax.xml.rpc"),
        APACHE_COMMONS_DISCOVERY("org.apache.commons.discovery"),
        APACHE_AXIS("org.apache.axis"),
        ECLIPSE_MYLYN_COMMONS_SOAP("org.eclipse.mylyn.commons.soap"),
        CONNECTOR_COMMON_CORE("com.atlassian.connector.eclipse.commons.core"),
        CONNECTOR_JIRA_CORE("com.atlassian.connector.eclipse.jira.core"),
        JIRA("org.netbeans.modules.jira");

        String cnb;
        UpdateElement updateElement = null;
        boolean installed = false;

        private JiraModules(String cnb) {
            this.cnb = cnb;
        }
    }
}

