/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.issuetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.netbeans.modules.bugtracking.issuetable.IssueTable;
import org.netbeans.modules.bugtracking.issuetable.SummaryTextFilter;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.netbeans.modules.bugtracking.util.TextUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class QueryTableCellRenderer
extends DefaultTableCellRenderer {
    public static final String PROPERTY_FORMAT = "format";
    public static final String PROPERTY_HIGHLIGHT_PATTERN = "highlightPattern";
    private Query query;
    private IssueTable issueTable;
    private static final int VISIBLE_START_CHARS = 0;
    private static Icon seenValueIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/ui/resources/seen-value.png"));
    private static final MessageFormat issueNewFormat = QueryTableCellRenderer.getFormat("issueNewFormat");
    private static final MessageFormat issueObsoleteFormat = QueryTableCellRenderer.getFormat("issueObsoleteFormat");
    private static final MessageFormat issueModifiedFormat = QueryTableCellRenderer.getFormat("issueModifiedFormat");
    private static final String labelNew = NbBundle.getMessage(QueryTableCellRenderer.class, (String)"LBL_IssueStatusNew");
    private static final String labelModified = NbBundle.getMessage(QueryTableCellRenderer.class, (String)"LBL_IssueStatusModified");
    private static final String labelObsolete = NbBundle.getMessage(QueryTableCellRenderer.class, (String)"LBL_IssueStatusObsolete");
    private static final String msgNew = NbBundle.getMessage(QueryTableCellRenderer.class, (String)"MSG_IssueStatusNew");
    private static final String msgModified = NbBundle.getMessage(QueryTableCellRenderer.class, (String)"MSG_IssueStatusModified");
    private static final String msgObsolete = NbBundle.getMessage(QueryTableCellRenderer.class, (String)"MSG_IssueStatusObsolete");
    private static final Color unevenLineColor = new Color(15988477);
    private static final Color newHighlightColor = new Color(46080);
    private static final Color modifiedHighlightColor = new Color(255);
    private static final Color obsoleteHighlightColor = new Color(0x999999);

    public QueryTableCellRenderer(Query query, IssueTable issueTable) {
        this.query = query;
        this.issueTable = issueTable;
    }

    private static MessageFormat getFormat(String key) {
        String format = NbBundle.getMessage(IssueTable.class, (String)key);
        return new MessageFormat(format);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        renderer.setIcon(null);
        if (!this.query.isSaved()) {
            TableCellStyle style = QueryTableCellRenderer.getDefaultCellStyle(table, this.issueTable, (IssueNode.IssueProperty)value, isSelected, row);
            this.setStyleProperties(renderer, style);
            return renderer;
        }
        TableCellStyle style = null;
        if (value instanceof IssueNode.SeenProperty) {
            IssueNode.SeenProperty ps = (IssueNode.SeenProperty)value;
            renderer.setIcon(ps.getValue() == false ? seenValueIcon : null);
            renderer.setText("");
        }
        if (value instanceof IssueNode.IssueProperty) {
            style = QueryTableCellRenderer.getCellStyle(table, this.query, this.issueTable, (IssueNode.IssueProperty)value, isSelected, row);
        }
        this.setStyleProperties(renderer, style);
        return renderer;
    }

    public void setStyleProperties(JLabel renderer, TableCellStyle style) {
        if (style != null) {
            renderer.putClientProperty(PROPERTY_FORMAT, style.format);
            renderer.putClientProperty(PROPERTY_HIGHLIGHT_PATTERN, style.highlightPattern);
            renderer.setToolTipText(style.tooltip);
            QueryTableCellRenderer.setRowColors(style, renderer);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        QueryTableCellRenderer.processText(this);
        super.paintComponent(g);
    }

    public static void processText(JLabel label) {
        MessageFormat format = (MessageFormat)label.getClientProperty(PROPERTY_FORMAT);
        Pattern pattern = (Pattern)label.getClientProperty(PROPERTY_HIGHLIGHT_PATTERN);
        String s = QueryTableCellRenderer.computeFitText(label);
        if (format != null || pattern != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            s = TextUtils.escapeForHTMLLabel(s);
            if (format != null) {
                format.format(new Object[]{s}, sb, (FieldPosition)null);
            }
            if (pattern != null) {
                sb.append(QueryTableCellRenderer.highLight(s, pattern));
            }
            sb.append("</html>");
            s = sb.toString();
        }
        label.setText(s);
    }

    private static String computeFitText(JLabel label) {
        String sufix;
        FontMetrics fm;
        int sufixLength;
        String text = label.getText();
        if (text == null) {
            text = "";
        }
        if (text.length() <= 3) {
            return text;
        }
        Icon icon = label.getIcon();
        int iconWidth = icon != null ? icon.getIconWidth() : 0;
        int width = label.getSize().width - iconWidth;
        int desired = width - (sufixLength = (fm = label.getFontMetrics(label.getFont())).stringWidth(sufix = "..."));
        if (desired <= 0) {
            return text;
        }
        for (int i = 0; i <= text.length() - 1; ++i) {
            String prefix = text.substring(0, i);
            int swidth = fm.stringWidth(prefix);
            if (swidth < desired) continue;
            return prefix.length() > 0 ? prefix + sufix : text;
        }
        return text;
    }

    private static String highLight(String s, Pattern pattern) {
        int end;
        int start;
        Matcher matcher = pattern.matcher(s);
        int idx = 0;
        StringBuilder sb = new StringBuilder();
        while (matcher.find(idx) && (start = matcher.start()) != (end = matcher.end())) {
            sb.append(s.substring(idx, start));
            sb.append("<font bgcolor=\"FFB442\" color=\"black\">");
            sb.append(s.substring(start, end));
            sb.append("</font>");
            idx = matcher.end();
        }
        if (sb.length() > 0) {
            sb.append(idx < s.length() ? s.substring(idx, s.length()) : "");
            s = sb.toString();
        }
        return s;
    }

    public static TableCellStyle getCellStyle(JTable table, Query query, IssueTable issueTable, IssueNode.IssueProperty p, boolean isSelected, int row) {
        TableCellStyle style = QueryTableCellRenderer.getDefaultCellStyle(table, issueTable, p, isSelected, row);
        try {
            int status = -2;
            Issue issue = p.getIssue();
            if (!query.contains(issue)) {
                style.format = isSelected ? style.format : QueryTableCellRenderer.issueObsoleteFormat;
                style.background = isSelected ? QueryTableCellRenderer.obsoleteHighlightColor : style.background;
            } else {
                status = query.getIssueStatus(issue);
                if (!IssueCacheUtils.wasSeen(issue)) {
                    switch (status) {
                        case 4: {
                            style.format = isSelected ? style.format : QueryTableCellRenderer.issueNewFormat;
                            style.background = isSelected ? QueryTableCellRenderer.newHighlightColor : style.background;
                            break;
                        }
                        case 8: {
                            style.format = isSelected ? style.format : QueryTableCellRenderer.issueModifiedFormat;
                            style.background = isSelected ? QueryTableCellRenderer.modifiedHighlightColor : style.background;
                        }
                    }
                }
            }
            Object o = p.getValue();
            if (o instanceof String) {
                String s = (String)o;
                if (s == null) {
                    s = "";
                }
                s = TextUtils.escapeForHTMLLabel(s);
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                sb.append(s);
                if (!query.contains(issue)) {
                    sb.append("<br>").append(issueObsoleteFormat.format(new Object[]{labelObsolete}, new StringBuffer(), (FieldPosition)null));
                    sb.append(msgObsolete);
                } else {
                    if (status == -2) {
                        status = query.getIssueStatus(issue);
                    }
                    switch (status) {
                        case 4: {
                            sb.append("<br>").append(issueNewFormat.format(new Object[]{labelNew}, new StringBuffer(), (FieldPosition)null));
                            sb.append(msgNew);
                            break;
                        }
                        case 8: {
                            sb.append("<br>").append(issueModifiedFormat.format(new Object[]{labelModified}, new StringBuffer(), (FieldPosition)null));
                            sb.append(msgModified);
                            sb.append(IssueCacheUtils.getRecentChanges(issue));
                        }
                    }
                }
                sb.append("</html>");
                style.tooltip = sb.toString();
            }
        }
        catch (Exception ex) {
            BugtrackingManager.LOG.log(Level.WARNING, null, ex);
        }
        return style;
    }

    public static TableCellStyle getDefaultCellStyle(JTable table, IssueTable issueTable, IssueNode.IssueProperty p, boolean isSelected, int row) {
        return new TableCellStyle(null, isSelected ? table.getSelectionBackground() : QueryTableCellRenderer.getUnselectedBackground(row), isSelected ? Color.WHITE : table.getForeground(), null, QueryTableCellRenderer.getHightlightPattern(issueTable, p));
    }

    private static Pattern getHightlightPattern(IssueTable issueTable, IssueNode.IssueProperty p) {
        SummaryTextFilter f;
        if (p instanceof IssueNode.SummaryProperty && (f = issueTable.getSummaryFilter()) != null && f.isHighLightingOn()) {
            return f.getPattern();
        }
        return null;
    }

    private static Color getUnselectedBackground(int row) {
        return row % 2 != 0 ? unevenLineColor : Color.WHITE;
    }

    public static void setRowColors(TableCellStyle style, JComponent l) {
        if (style == null) {
            assert (false);
            return;
        }
        if (style.background != null) {
            l.setBackground(style.background);
        }
        if (style.foreground != null) {
            l.setForeground(style.foreground);
        }
    }

    public static class TableCellStyle {
        private MessageFormat format;
        private Color background;
        private Color foreground;
        private String tooltip;
        private Pattern highlightPattern;

        private TableCellStyle(MessageFormat format, Color background, Color foreground, String tooltip, Pattern highlightPattern) {
            this.background = background;
            this.foreground = foreground;
            this.tooltip = tooltip;
            this.format = format;
            this.highlightPattern = highlightPattern;
        }

        public Color getBackground() {
            return this.background;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public MessageFormat getFormat() {
            return this.format;
        }

        public Pattern getHighlightPattern() {
            return this.highlightPattern;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append("background=");
            sb.append(this.background);
            sb.append(", foreground=");
            sb.append(this.foreground);
            sb.append(", format=");
            sb.append(this.format != null ? this.format.toPattern() : null);
            sb.append(", tooltip=");
            sb.append(this.tooltip);
            sb.append("]");
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableCellStyle other = (TableCellStyle)obj;
            if (!(this.format == other.format || this.format != null && this.format.equals(other.format))) {
                return false;
            }
            if (!(this.background == other.background || this.background != null && this.background.equals(other.background))) {
                return false;
            }
            if (!(this.foreground == other.foreground || this.foreground != null && this.foreground.equals(other.foreground))) {
                return false;
            }
            return !(this.tooltip == null ? other.tooltip != null : !this.tooltip.equals(other.tooltip));
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

