/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.tree.TreePath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.util.Util;
import org.netbeans.modules.xml.wizard.impl.ExternalReferenceDataNode;
import org.netbeans.modules.xml.wizard.impl.ExternalReferenceDecorator;
import org.netbeans.modules.xml.wizard.impl.FolderNode;
import org.netbeans.modules.xml.wizard.impl.NamespaceChildren;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeTableView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

public class SchemaImportGUI
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private static final long serialVersionUID = -7568909683682244030L;
    private transient ExplorerManager explorerManager;
    private TemplateWizard templateWizard;
    private ExternalReferenceDecorator decorator;
    private Map registeredNodes;
    private FileObject primarySchema = null;
    private boolean first = false;
    private boolean removeFlag = false;
    private DefaultComboBoxModel nsModel;
    private DefaultComboBoxModel rootModel;
    private DefaultComboBoxModel namespaceModel;
    private JLabel locationLabel;
    private JPanel locationPanel;

    public SchemaImportGUI(TemplateWizard tw) {
        this.initComponents();
        this.initAccessibility();
        this.templateWizard = tw;
        this.registeredNodes = new HashMap();
        this.decorator = new ExternalReferenceDecorator(this);
        LocationView locationView = new LocationView();
        locationView.setDefaultActionAllowed(false);
        locationView.setPopupAllowed(false);
        locationView.setSelectionMode(1);
        locationView.setRootVisible(false);
        locationView.getAccessibleContext().setAccessibleName(this.locationLabel.getToolTipText());
        locationView.getAccessibleContext().setAccessibleDescription(this.locationLabel.getToolTipText());
        Node.Property[] columns = new Node.Property[]{new Column("name", String.class, true), new ImportColumn(this.referenceTypeName())};
        locationView.setProperties(columns);
        locationView.setTreePreferredWidth(200);
        locationView.setTableColumnPreferredWidth(0, 25);
        this.locationPanel.add((Component)((Object)locationView), "Center");
        this.explorerManager = new ExplorerManager();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.explorerManager.setRootContext(this.createRootNode());
    }

    private void initComponents() {
        this.locationPanel = new JPanel();
        this.locationLabel = new JLabel();
        this.setName(Util.THIS.getString(SchemaImportGUI.class, "PROP_schema_panel_name"));
        this.locationPanel.setBorder(BorderFactory.createEtchedBorder());
        this.locationPanel.setLayout(new BorderLayout());
        this.locationLabel.setLabelFor(this.locationPanel);
        this.locationLabel.setText(NbBundle.getMessage(SchemaImportGUI.class, (String)"LBL_SchemaPanel_Location"));
        this.locationLabel.setToolTipText(NbBundle.getMessage(SchemaImportGUI.class, (String)"TIP_SchemaPanel_Location"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.locationLabel, GroupLayout.Alignment.LEADING).addComponent(this.locationPanel, -1, 545, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.locationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.locationPanel, -2, 247, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void primarySchemaCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void initAccessibility() {
        Util util = Util.THIS;
        this.locationLabel.setDisplayedMnemonic(util.getChar(SchemaImportGUI.class, "PROP_schema_locationLabel_mne"));
    }

    protected Node createRootNode() {
        try {
            DataFolder folder = this.templateWizard.getTargetFolder();
            Project project = FileOwnerQuery.getOwner((FileObject)folder.getPrimaryFile());
            SubprojectProvider provider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
            Set refProjects = null;
            Iterator it = null;
            if (provider != null) {
                refProjects = provider.getSubprojects();
                it = refProjects.iterator();
            }
            Node[] rootNodes = new Node[1 + (refProjects == null ? 0 : refProjects.size())];
            LogicalViewProvider viewProvider = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
            rootNodes[0] = this.decorator.createExternalReferenceNode(viewProvider.createLogicalView());
            int rootIndex = 1;
            ArrayList<FileObject> projectRoots = new ArrayList<FileObject>();
            projectRoots.add(project.getProjectDirectory());
            if (refProjects != null) {
                while (it.hasNext()) {
                    Object o = it.next();
                    Project refPrj = (Project)o;
                    viewProvider = (LogicalViewProvider)refPrj.getLookup().lookup(LogicalViewProvider.class);
                    rootNodes[rootIndex++] = this.decorator.createExternalReferenceNode(viewProvider.createLogicalView());
                    projectRoots.add(refPrj.getProjectDirectory());
                }
            }
            FileObject[] roots = projectRoots.toArray(new FileObject[projectRoots.size()]);
            Children.Array fileChildren = new Children.Array();
            fileChildren.add(rootNodes);
            FolderNode byFilesNode = new FolderNode((Children)fileChildren);
            byFilesNode.setDisplayName(NbBundle.getMessage(SchemaImportGUI.class, (String)"LBL_SchemaPanel_Category_By_File"));
            NamespaceChildren nsChildren = new NamespaceChildren(roots, this.decorator);
            FolderNode byNsNode = new FolderNode((Children)nsChildren);
            byNsNode.setDisplayName(NbBundle.getMessage(SchemaImportGUI.class, (String)"LBL_SchemaPanel_Category_By_Namespace"));
            Children.Array categories = new Children.Array();
            categories.add(new Node[]{byFilesNode, byNsNode});
            AbstractNode rootNode = new AbstractNode((Children)categories);
            rootNode.setDisplayName(NbBundle.getMessage(SchemaImportGUI.class, (String)"CTL_SchemaPanel_Column_Name_name"));
            rootNode.setShortDescription(NbBundle.getMessage(SchemaImportGUI.class, (String)"CTL_SchemaPanel_Column_Desc_name"));
            return rootNode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public ExternalReferenceDataNode createExternalReferenceNode(Node original) {
        DataObject dobj = (DataObject)original.getLookup().lookup(DataObject.class);
        NodeSet set = (NodeSet)this.registeredNodes.get(dobj);
        if (set == null) {
            set = new NodeSet(this);
            this.registeredNodes.put(dobj, set);
        }
        ExternalReferenceDataNode erdn = new ExternalReferenceDataNode(original, this.decorator);
        set.add(erdn);
        if (set.isSelected() && erdn.canSelect()) {
            erdn.setSelected(true);
        }
        erdn.addPropertyChangeListener(this);
        return erdn;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String pname = event.getPropertyName();
        if ("selectedNodes".equals(pname)) {
            Node[] nodes = (Node[])event.getNewValue();
            if (nodes != null && nodes.length > 0 && nodes[0] instanceof ExternalReferenceDataNode) {
                ExternalReferenceDataNode node = (ExternalReferenceDataNode)nodes[0];
                this.validateInput(node);
            }
        } else if (pname.equals("prefix")) {
            ExternalReferenceDataNode erdn = (ExternalReferenceDataNode)((Object)event.getSource());
            String prefix = (String)event.getNewValue();
            DataObject dobj = (DataObject)erdn.getLookup().lookup(DataObject.class);
            NodeSet set = (NodeSet)this.registeredNodes.get(dobj);
            assert (set != null) : "node not created by customizer";
            if (set == null) {
                set = new NodeSet(this);
                set.add(erdn);
            }
            set.setPrefix(prefix);
            this.validateInput(erdn);
        } else if (pname.equals("selected")) {
            ExternalReferenceDataNode erdn = (ExternalReferenceDataNode)((Object)event.getSource());
            boolean selected = (Boolean)event.getNewValue();
            DataObject dobj = (DataObject)erdn.getLookup().lookup(DataObject.class);
            NodeSet set = (NodeSet)this.registeredNodes.get(dobj);
            assert (set != null) : "node not created by customizer";
            if (set == null) {
                set = new NodeSet(this);
                set.add(erdn);
            }
            set.setSelected(selected);
            this.validateInput(erdn);
        }
    }

    private void validateInput(ExternalReferenceDataNode erdn) {
        int selected;
        String msg = null;
        String ep = erdn.getPrefix();
        if (ep.length() == 0 || !this.isValidPrefix(erdn) && erdn.isSelected()) {
            msg = NbBundle.getMessage(SchemaImportGUI.class, (String)"LBL_SchemaPanel_InvalidPrefix");
        }
        if ((selected = this.countSelectedNodes()) < 0) {
            msg = "ERROR MSG";
        }
    }

    private boolean isValidPrefix(ExternalReferenceDataNode node) {
        DataObject dobj = (DataObject)node.getLookup().lookup(DataObject.class);
        NodeSet nodeSet = (NodeSet)this.registeredNodes.get(dobj);
        Collection sets = this.registeredNodes.values();
        for (NodeSet set : sets) {
            if (set.equals(nodeSet) || !set.isSelected()) continue;
            ExternalReferenceDataNode other = (ExternalReferenceDataNode)((Object)set.getNodes().get(0));
            if (!node.getPrefix().equals(other.getPrefix())) continue;
            return false;
        }
        return true;
    }

    public int countSelectedNodes() {
        int results = 0;
        Collection sets = this.registeredNodes.values();
        for (NodeSet set : sets) {
            List nodes = set.getNodes();
            if (nodes.size() <= 0) continue;
            ++results;
        }
        return results;
    }

    public boolean isPrimarySchemaSelected() {
        return this.rootModel.getSize() != 0;
    }

    protected List getSelectedNodes() {
        LinkedList results = new LinkedList();
        Collection sets = this.registeredNodes.values();
        for (NodeSet set : sets) {
            List nodes;
            if (!set.isSelected() || (nodes = set.getNodes()).size() <= 0) continue;
            results.add(nodes.get(0));
        }
        return results;
    }

    protected String referenceTypeName() {
        return NbBundle.getMessage(SchemaImportGUI.class, (String)"LBL_SchemaPanel_ImportCreator_Type");
    }

    private class SchemaComboItem {
        String name;
        FileObject value;

        public SchemaComboItem(String key, FileObject val) {
            this.name = key;
            this.value = val;
        }

        public FileObject getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }
    }

    private class LocationView
    extends TreeTableView {
        private static final long serialVersionUID = 1L;

        public LocationView() {
            this.tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ExternalReferenceDataNode erdn;
                    Object comp;
                    Node node;
                    TreePath path = LocationView.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (path != null && (node = Visualizer.findNode((Object)(comp = path.getLastPathComponent()))) instanceof ExternalReferenceDataNode && (erdn = (ExternalReferenceDataNode)node).canSelect()) {
                        boolean selected = !erdn.isSelected();
                        erdn.setSelected(selected);
                    }
                }
            });
        }
    }

    private static class NodeSet {
        private PropertyChangeListener listener;
        private List nodes;
        private boolean selected;

        public NodeSet(PropertyChangeListener listener) {
            this.listener = listener;
        }

        public void add(ExternalReferenceDataNode node) {
            if (this.nodes == null) {
                this.nodes = new LinkedList();
            }
            this.nodes.add(node);
        }

        public List getNodes() {
            return this.nodes;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setPrefix(String prefix) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                ExternalReferenceDataNode node = (ExternalReferenceDataNode)((Object)this.nodes.get(i));
                if (node.getPrefix().equals(prefix)) continue;
                node.removePropertyChangeListener(this.listener);
                node.setPrefix(prefix);
                node.addPropertyChangeListener(this.listener);
            }
        }

        public void setSelected(boolean select) {
            this.selected = select;
            for (int i = 0; i < this.nodes.size(); ++i) {
                ExternalReferenceDataNode node = (ExternalReferenceDataNode)((Object)this.nodes.get(i));
                if (!node.canSelect()) continue;
                node.removePropertyChangeListener(this.listener);
                node.setSelected(select);
                node.addPropertyChangeListener(this.listener);
            }
        }
    }

    protected class ImportColumn
    extends PropertySupport.ReadOnly {
        private String key;

        public ImportColumn(String name) {
            super("selected", Boolean.TYPE, name, NbBundle.getMessage(Column.class, (String)"CTL_SchemaPanel_Column_Desc_selected"));
            this.key = "selected";
            this.setValue("TreeColumnTTV", Boolean.FALSE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.key;
        }
    }

    protected class Column
    extends PropertySupport.ReadOnly {
        private String key;

        public Column(String key, Class type, boolean tree) {
            super(key, type, NbBundle.getMessage(Column.class, (String)("CTL_SchemaPanel_Column_Name_" + key)), NbBundle.getMessage(Column.class, (String)("CTL_SchemaPanel_Column_Desc_" + key)));
            this.key = key;
            this.setValue("TreeColumnTTV", tree);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.key;
        }
    }
}

