/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.ImagePanel;
import org.netbeans.lib.profiler.ui.components.VerticalLayout;
import org.netbeans.lib.profiler.ui.components.XPStyleBorder;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.TaskConfigurator;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.project.ProfilingSettingsSupport;
import org.netbeans.modules.profiler.api.project.ProjectContentsSupport;
import org.netbeans.modules.profiler.api.project.ProjectProfilingSupport;
import org.netbeans.modules.profiler.spi.TaskConfiguratorProvider;
import org.netbeans.modules.profiler.stp.AttachSettingsPanel;
import org.netbeans.modules.profiler.stp.DefaultSettingsConfigurator;
import org.netbeans.modules.profiler.stp.SettingsContainerPanel;
import org.netbeans.modules.profiler.stp.TaskChooser;
import org.netbeans.modules.profiler.stp.TaskPresenter;
import org.netbeans.modules.profiler.stp.Utils;
import org.netbeans.modules.profiler.stp.WelcomePanel;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SelectProfilingTask
extends JPanel
implements TaskChooser.Listener,
HelpCtx.Provider {
    private static final String SELECT_PROJECT_TO_ATTACH_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_SelectProjectToAttachString");
    public static final String EXTERNAL_APPLICATION_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_ExternalApplicationString");
    private static final String PROFILE_DIALOG_CAPTION = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_ProfileDialogCaption");
    private static final String ATTACH_DIALOG_CAPTION = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_AttachDialogCaption");
    private static final String MODIFY_DIALOG_CAPTION = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_ModifyDialogCaption");
    private static final String MONITOR_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_MonitorString");
    private static final String CPU_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_CpuString");
    private static final String MEMORY_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_MemoryString");
    private static final String ATTACH_LABEL_TEXT = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_AttachLabelText");
    private static final String RUN_BUTTON_TEXT = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_RunButtonText");
    private static final String ATTACH_BUTTON_TEXT = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_AttachButtonText");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_OkButtonText");
    private static final String CANCEL_BUTTON_TEXT = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_CancelButtonText");
    private static final String INIT_SESSION_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_InitSessionString");
    private static final String CHOOSER_COMBO_ACCESS_DESCR = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_ChooserComboAccessDescr");
    private static final String WORKDIR_INVALID_MSG = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_WorkDirInvalidMsg");
    public static Color BACKGROUND_COLOR;
    public static Color BACKGROUND_COLOR_INACTIVE;
    public static Color DARKLINK_COLOR;
    public static Color DARKLINK_COLOR_INACTIVE;
    private static SelectProfilingTask defaultInstance;
    private static SimpleFilter PROJECT_FILTER;
    private static SimpleFilter PROJECT_SUBPROJECTS_FILTER;
    private static final Image BACKGROUND_IMAGE;
    private static final Icon MONITOR_ICON;
    private static final Icon CPU_ICON;
    private static final Icon MEMORY_ICON;
    private static final Icon RUN_ICON;
    private static final Icon ATTACH_ICON;
    private AttachSettingsPanel attachSettingsPanel;
    private DialogDescriptor dd;
    private FileObject profiledFile;
    private JPanel taskChooserPanel;
    private JButton attachButton;
    private JButton cancelButton;
    private JButton modifyButton;
    private JButton runButton;
    private JButton submitButton;
    private JComboBox projectsChooserCombo;
    private JLabel projectsChooserLabel;
    private JPanel attachSettingsPanelContainer;
    private JPanel contentsPanel;
    private JPanel customSettingsPanelContainer;
    private JPanel extraSettingsPanel;
    private JPanel projectsChooserComboContainer;
    private JPanel projectsChooserPanel;
    private JSeparator attachSettingsPanelSeparator;
    private JSeparator customSettingsPanelSeparator;
    private JSeparator extraSettingsPanelSeparator;
    private JSeparator projectsChooserSeparator;
    private List<SimpleFilter> predefinedInstrFilterKeys;
    private Object lastAttachProject;
    private Lookup.Provider project;
    private SettingsConfigurator configurator;
    private SettingsContainerPanel settingsContainerPanel;
    private TaskChooser taskChooser;
    private TaskPresenter selectedTask;
    private TaskPresenter taskCPU;
    private TaskPresenter taskMemory;
    private TaskPresenter taskMonitor;
    private WeakReference<WelcomePanel> welcomePanelReference;
    private SimpleFilter[] predefinedInstrFilters;
    private boolean enableOverride;
    private boolean internalComboChange = false;
    private boolean isAttach;
    private boolean isModify;

    private SelectProfilingTask() {
        this.initClosedProjectHook();
        this.initComponents();
        this.initTasks();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectProfilingTask.this.initTaskChooserSize();
                SelectProfilingTask.this.initPreferredSize();
            }
        });
    }

    private static void initColors() {
        boolean textInverse;
        boolean inverseColors;
        Color systemBackgroundColor = UIUtils.getProfilerResultsBackground();
        int backgroundRed = systemBackgroundColor.getRed();
        int backgroundGreen = systemBackgroundColor.getGreen();
        int backgroundBlue = systemBackgroundColor.getBlue();
        boolean bl = inverseColors = backgroundRed < 18 || backgroundGreen < 18 || backgroundBlue < 18;
        if (inverseColors) {
            BACKGROUND_COLOR = UIUtils.getSafeColor((int)(backgroundRed + 11), (int)(backgroundGreen + 11), (int)(backgroundBlue + 11));
            BACKGROUND_COLOR_INACTIVE = UIUtils.getSafeColor((int)(backgroundRed + 18), (int)(backgroundGreen + 18), (int)(backgroundBlue + 18));
        } else {
            BACKGROUND_COLOR = UIUtils.getSafeColor((int)(backgroundRed - 11), (int)(backgroundGreen - 11), (int)(backgroundBlue - 11));
            BACKGROUND_COLOR_INACTIVE = UIUtils.getSafeColor((int)(backgroundRed - 18), (int)(backgroundGreen - 18), (int)(backgroundBlue - 18));
        }
        boolean bl2 = textInverse = BACKGROUND_COLOR_INACTIVE.getRed() - Color.DARK_GRAY.getRed() < 50;
        if (textInverse) {
            int darklinkExtent = Color.DARK_GRAY.getRed() - Color.BLACK.getRed();
            int darklinkInverse = Color.WHITE.getRed() - darklinkExtent;
            DARKLINK_COLOR = Color.WHITE;
            DARKLINK_COLOR_INACTIVE = UIUtils.getSafeColor((int)darklinkInverse, (int)darklinkInverse, (int)darklinkInverse);
        } else {
            DARKLINK_COLOR = Color.BLACK;
            DARKLINK_COLOR_INACTIVE = Color.DARK_GRAY;
        }
    }

    public static TaskConfigurator.Configuration selectAttachProfilerTask(Lookup.Provider project) {
        assert (!SwingUtilities.isEventDispatchThread());
        final SelectProfilingTask spt = SelectProfilingTask.getDefault();
        spt.setSubmitButton(spt.attachButton);
        spt.setupAttachProfiler(project);
        spt.dd = new DialogDescriptor((Object)spt, ATTACH_DIALOG_CAPTION, true, new Object[]{spt.attachButton, spt.cancelButton}, (Object)spt.attachButton, 0, null, null);
        final CountDownLatch latch = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dialog d = DialogDisplayer.getDefault().createDialog(spt.dd);
                d.pack();
                d.setVisible(true);
                latch.countDown();
            }
        });
        try {
            latch.await();
            TaskConfigurator.Configuration result = null;
            if (spt.dd.getValue() == spt.attachButton) {
                result = new TaskConfigurator.Configuration(spt.project, spt.createFinalSettings(), spt.getAttachSettings());
            }
            spt.cleanup();
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public static TaskConfigurator.Configuration selectModifyProfilingTask(Lookup.Provider project, FileObject profiledFile, boolean isAttach) {
        assert (!SwingUtilities.isEventDispatchThread());
        final SelectProfilingTask spt = SelectProfilingTask.getDefault();
        spt.setSubmitButton(spt.modifyButton);
        spt.setupModifyProfiling(project, profiledFile, isAttach);
        spt.dd = new DialogDescriptor((Object)spt, MessageFormat.format(MODIFY_DIALOG_CAPTION, Utils.getProjectName(project)), true, new Object[]{spt.modifyButton, spt.cancelButton}, (Object)spt.modifyButton, 0, null, null);
        final CountDownLatch latch = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dialog d = DialogDisplayer.getDefault().createDialog(spt.dd);
                d.pack();
                d.setVisible(true);
                latch.countDown();
            }
        });
        try {
            latch.await();
            TaskConfigurator.Configuration result = null;
            if (spt.dd.getValue() == spt.modifyButton) {
                result = new TaskConfigurator.Configuration(project, spt.createFinalSettings(), null);
            }
            spt.cleanup();
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public static TaskConfigurator.Configuration selectProfileProjectTask(Lookup.Provider project, FileObject profiledFile, boolean enableOverride) {
        assert (!SwingUtilities.isEventDispatchThread());
        final SelectProfilingTask spt = SelectProfilingTask.getDefault();
        spt.setSubmitButton(spt.runButton);
        spt.setupProfileProject(project, profiledFile, enableOverride);
        String targetName = Utils.getProjectName(project) + (profiledFile == null ? "" : ": " + profiledFile.getNameExt());
        spt.dd = new DialogDescriptor((Object)spt, MessageFormat.format(PROFILE_DIALOG_CAPTION, targetName), true, new Object[]{spt.runButton, spt.cancelButton}, (Object)spt.runButton, 0, null, null);
        final CountDownLatch latch = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dialog d = DialogDisplayer.getDefault().createDialog(spt.dd);
                d.getAccessibleContext().setAccessibleDescription(d.getTitle());
                d.pack();
                d.setVisible(true);
                latch.countDown();
            }
        });
        try {
            latch.await();
            TaskConfigurator.Configuration result = null;
            if (spt.dd.getValue() == spt.runButton) {
                String workDir;
                ProfilingSettings settings = spt.createFinalSettings();
                if (settings.getOverrideGlobalSettings() && (workDir = settings.getWorkingDir().trim()).length() != 0 && !new File(workDir).exists()) {
                    settings.setWorkingDir("");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)WORKDIR_INVALID_MSG, 2));
                }
                result = new TaskConfigurator.Configuration(project, settings, null);
            }
            spt.cleanup();
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public HelpCtx getHelpCtx() {
        return this.settingsContainerPanel.getHelpCtx();
    }

    @Override
    public void itemCollapsed(TaskChooser.Item item) {
    }

    @Override
    public void itemExpanded(TaskChooser.Item item) {
        this.selectedTask.selectProfilingSettings(((TaskPresenter)item).getSelectedProfilingSettings());
    }

    @Override
    public void itemWillCollapse(TaskChooser.Item item) {
    }

    @Override
    public void itemWillExpand(TaskChooser.Item item) {
        this.selectProfilingSettings(((TaskPresenter)item).getSelectedProfilingSettings());
    }

    static SelectProfilingTask getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new SelectProfilingTask();
        }
        return defaultInstance;
    }

    List<SimpleFilter> getPredefinedInstrFilterKeys() {
        return this.predefinedInstrFilterKeys;
    }

    boolean isPredefinedFilter(Object filter) {
        return this.predefinedInstrFilterKeys != null && this.predefinedInstrFilterKeys.indexOf(filter) != -1;
    }

    SimpleFilter getResolvedPredefinedFilter(SimpleFilter key) {
        int resolvedIndex = this.predefinedInstrFilterKeys.indexOf(key);
        if (resolvedIndex == -1) {
            return null;
        }
        if (this.predefinedInstrFilters[resolvedIndex] == null) {
            this.predefinedInstrFilters[resolvedIndex] = new SimpleFilter(key.getFilterName(), key.getFilterType(), ProjectContentsSupport.get((Lookup.Provider)this.project).getInstrumentationFilter(key == PROJECT_SUBPROJECTS_FILTER));
        }
        return this.predefinedInstrFilters[resolvedIndex];
    }

    void setSubmitButton(JButton submitButton) {
        this.submitButton = submitButton;
    }

    void disableSubmitButton() {
        if (this.submitButton != null) {
            this.submitButton.setEnabled(false);
        }
    }

    void enableSubmitButton() {
        if (this.submitButton != null) {
            this.submitButton.setEnabled(true);
        }
    }

    void synchronizeCurrentSettings() {
        if (this.configurator != null && this.configurator.getSettings() != null) {
            this.configurator.synchronizeSettings();
        }
    }

    void updateHelpCtx() {
        if (this.dd != null) {
            this.dd.setHelpCtx(this.getHelpCtx());
        }
    }

    private AttachSettings getAttachSettings() {
        return this.attachSettingsPanel.getSettings();
    }

    private TaskPresenter getTaskPresenter(ProfilingSettings profilingSettings) {
        if (profilingSettings == null) {
            return null;
        }
        if (ProfilingSettings.isMonitorSettings((ProfilingSettings)profilingSettings)) {
            return this.taskMonitor;
        }
        if (ProfilingSettings.isCPUSettings((ProfilingSettings)profilingSettings)) {
            return this.taskCPU;
        }
        if (ProfilingSettings.isMemorySettings((ProfilingSettings)profilingSettings)) {
            return this.taskMemory;
        }
        return null;
    }

    private WelcomePanel getWelcomePanel() {
        WelcomePanel welcomePanel;
        if (this.welcomePanelReference == null || this.welcomePanelReference.get() == null) {
            welcomePanel = new WelcomePanel();
            this.welcomePanelReference = new WeakReference<WelcomePanel>(welcomePanel);
        } else {
            welcomePanel = (WelcomePanel)this.welcomePanelReference.get();
        }
        return welcomePanel;
    }

    private void cleanup() {
        if (!this.projectsChooserPanel.isVisible() || this.projectsChooserCombo.getSelectedItem() != SELECT_PROJECT_TO_ATTACH_STRING) {
            this.storeCurrentSettings();
        }
        this.projectCleanup();
        ProjectContentsSupport.get((Lookup.Provider)this.project).reset();
        this.project = null;
        this.profiledFile = null;
        this.enableOverride = false;
        this.isAttach = false;
        this.isModify = false;
        this.contentsPanel.removeAll();
        this.customSettingsPanelContainer.removeAll();
        this.internalComboChange = true;
        this.projectsChooserCombo.removeAllItems();
        this.internalComboChange = false;
        this.submitButton = null;
        this.predefinedInstrFilters = null;
        this.predefinedInstrFilterKeys = null;
        this.dd = null;
        this.contentsPanel.setPreferredSize(this.contentsPanel.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfilingSettings createFinalSettings() {
        if (this.configurator != null) {
            ProfilingSettings profilingSettings;
            this.synchronizeCurrentSettings();
            ProgressHandle pHandle = ProgressHandleFactory.createHandle((String)INIT_SESSION_STRING);
            pHandle.setInitialDelay(0);
            pHandle.start();
            try {
                profilingSettings = this.configurator.createFinalSettings();
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(pHandle){
                    final /* synthetic */ ProgressHandle val$pHandle;
                    {
                        this.val$pHandle = progressHandle;
                    }

                    @Override
                    public void run() {
                        this.val$pHandle.finish();
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return profilingSettings;
        }
        return null;
    }

    private void initClosedProjectHook() {
        ProjectUtilities.addOpenProjectsListener((ChangeListener)new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Lookup.Provider[] openedProjects;
                for (Lookup.Provider openedProject : openedProjects = ProjectUtilities.getOpenedProjects()) {
                    if (SelectProfilingTask.this.lastAttachProject != openedProject) continue;
                    return;
                }
                SelectProfilingTask.this.lastAttachProject = null;
            }
        });
    }

    private void initComponents() {
        this.projectsChooserLabel = new JLabel(ATTACH_LABEL_TEXT);
        this.projectsChooserLabel.setBorder(BorderFactory.createEmptyBorder(6, 15, 6, 0));
        this.projectsChooserLabel.setOpaque(false);
        this.projectsChooserCombo = new JComboBox();
        this.projectsChooserCombo.setRenderer(org.netbeans.modules.profiler.ppoints.Utils.getProjectListRenderer());
        this.projectsChooserLabel.setLabelFor(this.projectsChooserCombo);
        this.projectsChooserCombo.getAccessibleContext().setAccessibleDescription(CHOOSER_COMBO_ACCESS_DESCR);
        this.projectsChooserComboContainer = new JPanel(new BorderLayout());
        this.projectsChooserComboContainer.setBorder(BorderFactory.createEmptyBorder(6, 10, 6, 10));
        this.projectsChooserComboContainer.setOpaque(false);
        this.projectsChooserComboContainer.add((Component)this.projectsChooserCombo, "Center");
        if (!UIUtils.isNimbus()) {
            this.projectsChooserSeparator = UIUtils.createHorizontalSeparator();
        }
        this.projectsChooserPanel = new JPanel(new BorderLayout());
        this.projectsChooserPanel.add((Component)this.projectsChooserLabel, "West");
        this.projectsChooserPanel.add((Component)this.projectsChooserComboContainer, "Center");
        if (this.projectsChooserSeparator != null) {
            this.projectsChooserPanel.add((Component)this.projectsChooserSeparator, "South");
        }
        this.taskChooser = new TaskChooser();
        this.taskChooser.addItemListener(this);
        this.taskChooserPanel = BACKGROUND_IMAGE != null ? new ImagePanel(BACKGROUND_IMAGE, 3) : new JPanel(null);
        this.taskChooserPanel.setLayout(new BorderLayout());
        this.taskChooserPanel.add((Component)this.taskChooser, "North");
        this.settingsContainerPanel = new SettingsContainerPanel();
        this.contentsPanel = new JPanel(new BorderLayout());
        this.customSettingsPanelSeparator = UIUtils.createHorizontalSeparator();
        this.customSettingsPanelContainer = new JPanel(new BorderLayout());
        this.attachSettingsPanel = new AttachSettingsPanel();
        this.attachSettingsPanelSeparator = UIUtils.createHorizontalSeparator();
        this.attachSettingsPanelContainer = new JPanel(new BorderLayout());
        this.attachSettingsPanelContainer.add((Component)this.attachSettingsPanel, "Center");
        this.attachSettingsPanelContainer.add((Component)this.attachSettingsPanelSeparator, "South");
        this.extraSettingsPanelSeparator = UIUtils.createHorizontalSeparator();
        this.extraSettingsPanel = new JPanel(new BorderLayout());
        this.extraSettingsPanel.add((Component)this.extraSettingsPanelSeparator, "North");
        this.extraSettingsPanel.add((Component)this.customSettingsPanelContainer, "Center");
        this.extraSettingsPanel.add((Component)this.attachSettingsPanelContainer, "South");
        this.runButton = UIUtils.isNimbus() ? new JButton(RUN_BUTTON_TEXT) : new JButton(RUN_BUTTON_TEXT, RUN_ICON);
        this.attachButton = UIUtils.isNimbus() ? new JButton(ATTACH_BUTTON_TEXT){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((SelectProfilingTask)SelectProfilingTask.this).runButton.getPreferredSize().height);
            }
        } : new JButton(ATTACH_BUTTON_TEXT, ATTACH_ICON){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((SelectProfilingTask)SelectProfilingTask.this).runButton.getPreferredSize().height);
            }
        };
        this.modifyButton = new JButton(OK_BUTTON_TEXT){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((SelectProfilingTask)SelectProfilingTask.this).runButton.getPreferredSize().height);
            }
        };
        this.cancelButton = new JButton(CANCEL_BUTTON_TEXT){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((SelectProfilingTask)SelectProfilingTask.this).runButton.getPreferredSize().height);
            }
        };
        this.setLayout(new BorderLayout());
        this.add((Component)this.projectsChooserPanel, "North");
        this.add((Component)this.taskChooserPanel, "West");
        this.add((Component)this.contentsPanel, "Center");
        this.add((Component)this.extraSettingsPanel, "South");
        this.projectsChooserPanel.setOpaque(true);
        this.projectsChooserPanel.setBackground(this.taskChooserPanel.getBackground());
        this.projectsChooserCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SelectProfilingTask.this.internalComboChange) {
                    return;
                }
                Object comboSelection = SelectProfilingTask.this.projectsChooserCombo.getSelectedItem();
                if (SelectProfilingTask.this.lastAttachProject != null) {
                    SelectProfilingTask.this.storeSettings(SelectProfilingTask.this.lastAttachProject == EXTERNAL_APPLICATION_STRING ? null : (Lookup.Provider)SelectProfilingTask.this.lastAttachProject);
                }
                if (comboSelection == null || comboSelection == SELECT_PROJECT_TO_ATTACH_STRING) {
                    return;
                }
                if (comboSelection != SELECT_PROJECT_TO_ATTACH_STRING && SelectProfilingTask.this.projectsChooserCombo.getItemAt(0) == SELECT_PROJECT_TO_ATTACH_STRING) {
                    SelectProfilingTask.this.projectsChooserCombo.removeItemAt(0);
                }
                if (comboSelection == EXTERNAL_APPLICATION_STRING) {
                    SelectProfilingTask.this.updateProject(null);
                    SelectProfilingTask.this.lastAttachProject = EXTERNAL_APPLICATION_STRING;
                } else if (comboSelection instanceof Lookup.Provider) {
                    SelectProfilingTask.this.updateProject((Lookup.Provider)comboSelection);
                    SelectProfilingTask.this.lastAttachProject = comboSelection;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelectProfilingTask.this.projectsChooserCombo.requestFocusInWindow();
                    }
                });
            }
        });
    }

    private void initPreferredSize() {
        Dimension preferredContentsSize = new Dimension(360, 215);
        Dimension monitorSettingsSize = DefaultSettingsConfigurator.SHARED_INSTANCE.getMonitorConfigurator().getBasicSettingsPanel().getPreferredSize();
        Dimension cpuSettingsSize = DefaultSettingsConfigurator.SHARED_INSTANCE.getCPUConfigurator().getBasicSettingsPanel().getPreferredSize();
        Dimension memorySettingsSize = DefaultSettingsConfigurator.SHARED_INSTANCE.getMemoryConfigurator().getBasicSettingsPanel().getPreferredSize();
        preferredContentsSize.setSize(Math.max(preferredContentsSize.width, monitorSettingsSize.width), Math.max(preferredContentsSize.height, monitorSettingsSize.height));
        preferredContentsSize.setSize(Math.max(preferredContentsSize.width, cpuSettingsSize.width), Math.max(preferredContentsSize.height, cpuSettingsSize.height));
        preferredContentsSize.setSize(Math.max(preferredContentsSize.width, memorySettingsSize.width), Math.max(preferredContentsSize.height, memorySettingsSize.height));
        this.settingsContainerPanel.setPreferredContentsSize(preferredContentsSize);
        Dimension finalSize = this.settingsContainerPanel.getPreferredSize();
        this.contentsPanel.setPreferredSize(finalSize);
    }

    private void initTaskChooserSize() {
        Dimension preferredTaskChooserSize = new Dimension(200, this.taskChooserPanel.getPreferredSize().height);
        int vgap = ((VerticalLayout)this.taskChooser.getLayout()).getVGap() * 2;
        int insets = XPStyleBorder.getBorderInsets().left + XPStyleBorder.getBorderInsets().right;
        Dimension monitorSettingsSize = this.taskMonitor.getSmallComponent().getPreferredSize();
        Dimension cpuSettingsSize = this.taskCPU.getSmallComponent().getPreferredSize();
        Dimension memorySettingsSize = this.taskMemory.getSmallComponent().getPreferredSize();
        preferredTaskChooserSize.setSize(Math.max(preferredTaskChooserSize.width, monitorSettingsSize.width + vgap + insets), preferredTaskChooserSize.height);
        preferredTaskChooserSize.setSize(Math.max(preferredTaskChooserSize.width, cpuSettingsSize.width + vgap + insets), preferredTaskChooserSize.height);
        preferredTaskChooserSize.setSize(Math.max(preferredTaskChooserSize.width, memorySettingsSize.width + vgap + insets), preferredTaskChooserSize.height);
        this.taskChooserPanel.setPreferredSize(preferredTaskChooserSize);
    }

    private void initTasks() {
        TaskPresenter.Context context = new TaskPresenter.Context(){

            @Override
            public void selectSettings(ProfilingSettings settings) {
                SelectProfilingTask.this.selectProfilingSettings(settings);
            }

            @Override
            public void refreshLayout() {
                SelectProfilingTask.this.taskChooser.refreshLayout();
            }
        };
        this.taskMonitor = new TaskPresenter(MONITOR_STRING, MONITOR_ICON, context);
        this.taskCPU = new TaskPresenter(CPU_STRING, CPU_ICON, context);
        this.taskMemory = new TaskPresenter(MEMORY_STRING, MEMORY_ICON, context);
        this.taskChooser.add(this.taskMonitor);
        this.taskChooser.add(this.taskCPU);
        this.taskChooser.add(this.taskMemory);
    }

    private void projectCleanup() {
        this.taskChooser.reset();
        this.taskMonitor.resetProfilingSettings();
        this.taskCPU.resetProfilingSettings();
        this.taskMemory.resetProfilingSettings();
        this.attachSettingsPanel.resetSettings();
        this.selectedTask = null;
        if (this.configurator != null) {
            this.configurator.reset();
        }
        this.configurator = null;
    }

    private void selectProfilingSettings(ProfilingSettings profilingSettings) {
        this.synchronizeCurrentSettings();
        TaskPresenter newSelectedTask = this.getTaskPresenter(profilingSettings);
        if (newSelectedTask == null || newSelectedTask != this.selectedTask) {
            JPanel newContentsPanel = null;
            if (newSelectedTask == null) {
                WelcomePanel welcomePanel;
                newContentsPanel = welcomePanel = this.getWelcomePanel();
            } else {
                if (newSelectedTask == this.taskMonitor) {
                    this.settingsContainerPanel.setContents(this.configurator.getMonitorConfigurator());
                } else if (newSelectedTask == this.taskCPU) {
                    this.settingsContainerPanel.setContents(this.configurator.getCPUConfigurator());
                } else if (newSelectedTask == this.taskMemory) {
                    this.settingsContainerPanel.setContents(this.configurator.getMemoryConfigurator());
                }
                newContentsPanel = this.settingsContainerPanel;
            }
            this.contentsPanel.removeAll();
            this.contentsPanel.add((Component)newContentsPanel, "Center");
            this.contentsPanel.doLayout();
            this.contentsPanel.repaint();
            this.selectedTask = newSelectedTask;
        }
        if (profilingSettings != null) {
            this.settingsContainerPanel.setShowingPreset(profilingSettings.isPreset());
            this.settingsContainerPanel.switchToBasicSettings();
            this.settingsContainerPanel.setCaption(profilingSettings.getSettingsName());
            this.selectedTask.selectProfilingSettings(profilingSettings);
            this.configurator.setSettings(profilingSettings);
        }
    }

    private void setupAttachProfiler(Lookup.Provider project) {
        if (project == null && this.lastAttachProject instanceof Lookup.Provider) {
            project = (Lookup.Provider)this.lastAttachProject;
        }
        this.profiledFile = null;
        this.enableOverride = false;
        this.isAttach = true;
        this.isModify = false;
        this.projectsChooserLabel.setEnabled(true);
        this.projectsChooserCombo.setEnabled(true);
        this.projectsChooserPanel.setVisible(true);
        this.attachSettingsPanel.setEnabled(true);
        this.attachSettingsPanelContainer.setVisible(true);
        if (this.lastAttachProject == null) {
            this.lastAttachProject = EXTERNAL_APPLICATION_STRING;
        }
        this.updateProjectsCombo(project != null ? project : this.lastAttachProject);
        this.updateProject(project);
    }

    private void setupModifyProfiling(Lookup.Provider project, FileObject profiledFile, boolean isAttach) {
        this.profiledFile = profiledFile;
        this.enableOverride = false;
        this.isAttach = isAttach;
        this.isModify = true;
        this.projectsChooserLabel.setEnabled(false);
        this.projectsChooserCombo.setEnabled(false);
        this.projectsChooserPanel.setVisible(isAttach);
        this.attachSettingsPanel.setEnabled(false);
        this.attachSettingsPanelContainer.setVisible(isAttach);
        if (isAttach) {
            this.updateProjectsCombo(project != null ? project : EXTERNAL_APPLICATION_STRING);
        }
        this.updateProject(project);
    }

    private void setupProfileProject(Lookup.Provider project, FileObject profiledFile, boolean enableOverride) {
        this.profiledFile = profiledFile;
        this.enableOverride = enableOverride;
        this.isAttach = false;
        this.isModify = false;
        this.projectsChooserPanel.setVisible(false);
        this.attachSettingsPanelContainer.setVisible(false);
        this.updateProject(project);
    }

    private void storeCurrentSettings() {
        this.storeSettings(this.project);
    }

    private void storeSettings(final Lookup.Provider targetProject) {
        this.synchronizeCurrentSettings();
        final ArrayList<ProfilingSettings> profilingSettings = new ArrayList<ProfilingSettings>();
        profilingSettings.addAll(this.taskMonitor.getProfilingSettings());
        profilingSettings.addAll(this.taskCPU.getProfilingSettings());
        profilingSettings.addAll(this.taskMemory.getProfilingSettings());
        final ProfilingSettings selectedProfilingSettings = this.selectedTask == null ? null : this.selectedTask.getSelectedProfilingSettings();
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            @Override
            public void run() {
                ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])profilingSettings.toArray(new ProfilingSettings[profilingSettings.size()]), (ProfilingSettings)selectedProfilingSettings, (Lookup.Provider)targetProject);
            }
        });
    }

    private static List<SimpleFilter> getProjectDefaultInstrFilters(Lookup.Provider project) {
        String projectSubprojectsFilterName;
        ArrayList<SimpleFilter> v = new ArrayList<SimpleFilter>();
        ProfilingSettingsSupport pss = ProfilingSettingsSupport.get((Lookup.Provider)project);
        String projectFilterName = pss.getProjectOnlyFilterName();
        if (projectFilterName != null) {
            PROJECT_FILTER.setFilterName(projectFilterName);
            v.add(PROJECT_FILTER);
        }
        if ((projectSubprojectsFilterName = pss.getProjectSubprojectsFilterName()) != null) {
            PROJECT_SUBPROJECTS_FILTER.setFilterName(projectSubprojectsFilterName);
            v.add(PROJECT_SUBPROJECTS_FILTER);
        }
        return v;
    }

    private void updateProject(final Lookup.Provider project) {
        Runnable projectUpdater = new Runnable(){

            @Override
            public void run() {
                SelectProfilingTask.this.projectCleanup();
                SelectProfilingTask.this.project = project;
                if (project != null) {
                    SelectProfilingTask.this.predefinedInstrFilterKeys = SelectProfilingTask.getProjectDefaultInstrFilters(project);
                    SelectProfilingTask.access$1602(SelectProfilingTask.this, new SimpleFilter[SelectProfilingTask.this.predefinedInstrFilterKeys.size()]);
                } else {
                    SelectProfilingTask.access$1602(SelectProfilingTask.this, null);
                    SelectProfilingTask.this.predefinedInstrFilterKeys = null;
                }
                if (SelectProfilingTask.this.projectsChooserPanel.isVisible() && SelectProfilingTask.this.projectsChooserCombo.getSelectedItem() == SELECT_PROJECT_TO_ATTACH_STRING) {
                    SelectProfilingTask.this.taskChooser.setEnabled(false);
                    SelectProfilingTask.this.contentsPanel.removeAll();
                    SelectProfilingTask.this.contentsPanel.add((Component)SelectProfilingTask.this.getWelcomePanel(), "Center");
                    SelectProfilingTask.this.contentsPanel.doLayout();
                    SelectProfilingTask.this.contentsPanel.repaint();
                } else {
                    TaskPresenter taskPresenter;
                    JPanel customSettings;
                    SelectProfilingTask.this.configurator = Utils.getSettingsConfigurator(project);
                    SelectProfilingTask.this.configurator.setContext(project, SelectProfilingTask.this.profiledFile, SelectProfilingTask.this.isAttach, SelectProfilingTask.this.isModify, SelectProfilingTask.this.enableOverride);
                    ProfilingSettingsSupport.SettingsCustomizer customizer = ProfilingSettingsSupport.get((Lookup.Provider)project).getSettingsCustomizer();
                    JPanel jPanel = customSettings = customizer == null ? null : customizer.getCustomSettingsPanel(SelectProfilingTask.this.isAttach, SelectProfilingTask.this.isModify);
                    if (customSettings != null) {
                        SelectProfilingTask.this.customSettingsPanelContainer.removeAll();
                        SelectProfilingTask.this.customSettingsPanelContainer.add((Component)customSettings, "North");
                        SelectProfilingTask.this.customSettingsPanelContainer.add((Component)SelectProfilingTask.this.customSettingsPanelSeparator, "South");
                        SelectProfilingTask.this.customSettingsPanelContainer.setVisible(true);
                    } else {
                        SelectProfilingTask.this.customSettingsPanelContainer.removeAll();
                        SelectProfilingTask.this.customSettingsPanelContainer.setVisible(false);
                    }
                    SelectProfilingTask.this.taskChooser.setEnabled(true);
                    ProfilingSettings[] profilingSettings = new ProfilingSettings[]{};
                    ProfilingSettings lastSelectedSettings = null;
                    ProfilingSettingsManager.ProfilingSettingsDescriptor profilingSettingsDescriptor = ProfilingSettingsManager.getProfilingSettings((Lookup.Provider)project);
                    profilingSettings = profilingSettingsDescriptor.getProfilingSettings();
                    lastSelectedSettings = profilingSettingsDescriptor.getLastSelectedProfilingSettings();
                    ArrayList<ProfilingSettings> monitorSettings = new ArrayList<ProfilingSettings>();
                    ArrayList<ProfilingSettings> cpuSettings = new ArrayList<ProfilingSettings>();
                    ArrayList<ProfilingSettings> memorySettings = new ArrayList<ProfilingSettings>();
                    for (ProfilingSettings settings : profilingSettings) {
                        if (ProfilingSettings.isMonitorSettings((ProfilingSettings)settings)) {
                            monitorSettings.add(settings);
                            continue;
                        }
                        if (ProfilingSettings.isCPUSettings((ProfilingSettings)settings)) {
                            cpuSettings.add(settings);
                            continue;
                        }
                        if (!ProfilingSettings.isMemorySettings((ProfilingSettings)settings)) continue;
                        memorySettings.add(settings);
                    }
                    SelectProfilingTask.this.taskMonitor.setProfilingSettings(monitorSettings);
                    SelectProfilingTask.this.taskCPU.setProfilingSettings(cpuSettings);
                    SelectProfilingTask.this.taskMemory.setProfilingSettings(memorySettings);
                    if (lastSelectedSettings == null) {
                        for (ProfilingSettings cpuSettingsPreset : cpuSettings) {
                            if (!cpuSettingsPreset.isPreset()) continue;
                            lastSelectedSettings = cpuSettingsPreset;
                        }
                    }
                    if (lastSelectedSettings != null && (taskPresenter = SelectProfilingTask.this.getTaskPresenter(lastSelectedSettings)) != null) {
                        SelectProfilingTask.this.taskChooser.expandImmediately(taskPresenter);
                    }
                    SelectProfilingTask.this.selectProfilingSettings(lastSelectedSettings);
                }
                if (SelectProfilingTask.this.attachSettingsPanelContainer.isVisible()) {
                    SelectProfilingTask.this.attachSettingsPanel.setSettings(project, SelectProfilingTask.this.projectsChooserCombo.getSelectedItem() != SELECT_PROJECT_TO_ATTACH_STRING);
                }
            }
        };
        CommonUtils.runInEventDispatchThread((Runnable)projectUpdater);
    }

    private void updateProjectsCombo(Object projectToSelect) {
        this.internalComboChange = true;
        Lookup.Provider[] projects = ProjectUtilities.getSortedProjects((Lookup.Provider[])SelectProfilingTask.getOpenedProjectsForAttach());
        if (projectToSelect == null) {
            this.projectsChooserCombo.addItem(SELECT_PROJECT_TO_ATTACH_STRING);
        }
        this.projectsChooserCombo.addItem(EXTERNAL_APPLICATION_STRING);
        for (Lookup.Provider project : projects) {
            this.projectsChooserCombo.addItem(project);
        }
        if (projectToSelect == null) {
            this.projectsChooserCombo.setSelectedIndex(0);
        } else {
            this.projectsChooserCombo.setSelectedItem(projectToSelect);
        }
        this.internalComboChange = false;
    }

    private static Lookup.Provider[] getOpenedProjectsForAttach() {
        Lookup.Provider[] projects = ProjectUtilities.getOpenedProjects();
        ArrayList<Lookup.Provider> projectsArray = new ArrayList<Lookup.Provider>(projects.length);
        for (int i = 0; i < projects.length; ++i) {
            if (!ProjectProfilingSupport.get((Lookup.Provider)projects[i]).isAttachSupported()) continue;
            projectsArray.add(projects[i]);
        }
        return projectsArray.toArray(new Lookup.Provider[projectsArray.size()]);
    }

    static /* synthetic */ SimpleFilter[] access$1602(SelectProfilingTask x0, SimpleFilter[] x1) {
        x0.predefinedInstrFilters = x1;
        return x1;
    }

    static {
        SelectProfilingTask.initColors();
        PROJECT_FILTER = new SimpleFilter(ProfilingSettingsSupport.get(null).getProjectOnlyFilterName(), 2, "");
        PROJECT_SUBPROJECTS_FILTER = new SimpleFilter(ProfilingSettingsSupport.get(null).getProjectSubprojectsFilterName(), 2, "");
        BACKGROUND_IMAGE = UIUtils.isNimbus() ? null : Icons.getImage((String)"StpIcons.StpGraphics");
        MONITOR_ICON = Icons.getIcon((String)"ProfilerIcons.Monitoring32");
        CPU_ICON = Icons.getIcon((String)"ProfilerIcons.Cpu32");
        MEMORY_ICON = Icons.getIcon((String)"ProfilerIcons.Memory32");
        RUN_ICON = Icons.getIcon((String)"GeneralIcons.ButtonRun");
        ATTACH_ICON = Icons.getIcon((String)"GeneralIcons.ButtonAttach");
    }

    public static class ConfiguratorProvider
    implements TaskConfiguratorProvider {
        public TaskConfigurator.Configuration configureAttachProfilerTask(Lookup.Provider project) {
            return SelectProfilingTask.selectAttachProfilerTask(project);
        }

        public TaskConfigurator.Configuration configureModifyProfilingTask(Lookup.Provider project, FileObject profiledFile, boolean isAttach) {
            return SelectProfilingTask.selectModifyProfilingTask(project, profiledFile, isAttach);
        }

        public TaskConfigurator.Configuration configureProfileProjectTask(Lookup.Provider project, FileObject profiledFile, boolean enableOverride) {
            return SelectProfilingTask.selectProfileProjectTask(project, profiledFile, enableOverride);
        }
    }

    static interface SettingsConfigurator {
        public SettingsContainerPanel.Contents getCPUConfigurator();

        public void setContext(Lookup.Provider var1, FileObject var2, boolean var3, boolean var4, boolean var5);

        public SettingsContainerPanel.Contents getMemoryConfigurator();

        public SettingsContainerPanel.Contents getMonitorConfigurator();

        public void setSettings(ProfilingSettings var1);

        public ProfilingSettings getSettings();

        public ProfilingSettings createFinalSettings();

        public void reset();

        public void synchronizeSettings();
    }
}

