/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.subversion;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.Utilities;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.spi.ProjectHudsonJobCreatorFactory;
import org.netbeans.modules.hudson.subversion.SubversionHyperlink;
import org.netbeans.modules.hudson.subversion.SvnUtils;
import org.openide.util.Exceptions;
import org.openide.windows.OutputListener;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HudsonSubversionSCM
implements HudsonSCM {
    private static final Logger LOG = Logger.getLogger(HudsonSubversionSCM.class.getName());

    public HudsonSCM.Configuration forFolder(File folder) {
        try {
            SvnUtils.Info info = SvnUtils.parseCheckout(folder.toURI().toURL());
            if (info == null) {
                return null;
            }
            final String urlS = info.module.toString();
            return new HudsonSCM.Configuration(){

                public void configure(Document doc) {
                    Element root = doc.getDocumentElement();
                    Element configXmlSCM = (Element)root.appendChild(doc.createElement("scm"));
                    configXmlSCM.setAttribute("class", "hudson.scm.SubversionSCM");
                    Element loc = (Element)configXmlSCM.appendChild(doc.createElement("locations")).appendChild(doc.createElement("hudson.scm.SubversionSCM_-ModuleLocation"));
                    loc.appendChild(doc.createElement("remote")).appendChild(doc.createTextNode(urlS));
                    loc.appendChild(doc.createElement("local")).appendChild(doc.createTextNode("."));
                    configXmlSCM.appendChild(doc.createElement("useUpdate")).appendChild(doc.createTextNode("false"));
                    HudsonSCM.Helper.addTrigger((Document)doc);
                }

                public ProjectHudsonJobCreatorFactory.ConfigurationStatus problems() {
                    return null;
                }
            };
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "inspecting configuration for " + folder, ex);
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public String translateWorkspacePath(HudsonJob job, String workspacePath, File localRoot) {
        try {
            String localModuleBase;
            SvnUtils.Info local = SvnUtils.parseCheckout(localRoot.toURI().toURL());
            if (local == null) {
                return null;
            }
            int slash = workspacePath.lastIndexOf(47);
            String workspaceDir = workspacePath.substring(0, slash + 1);
            String workspaceFile = workspacePath.substring(slash + 1);
            URL remoteCheckout = new URL(job.getUrl() + "ws/" + workspaceDir);
            SvnUtils.Info remote = SvnUtils.parseCheckout(remoteCheckout, job);
            if (remote == null) {
                LOG.log(Level.FINE, "no remote checkout found at {0}", remoteCheckout);
                return null;
            }
            if (!remote.repository.getPath().equals(local.repository.getPath())) {
                LOG.log(Level.FINE, "repository mismatch between {0} and {1}", new Object[]{remote.repository, local.repository});
                return null;
            }
            String remoteModule = new URL(remote.module + "/" + workspaceFile).getPath();
            if (!remoteModule.startsWith(localModuleBase = new URL(local.module + "/").getPath())) {
                LOG.log(Level.FINE, "checkout mismatch between {0} and {1}", new Object[]{localModuleBase, remoteModule});
                return null;
            }
            String translatedPath = remoteModule.substring(localModuleBase.length());
            LOG.log(Level.FINE, "translated path as {0}", translatedPath);
            return translatedPath;
        }
        catch (Exception x) {
            LOG.log(Level.FINE, "cannot translate path", x);
            return null;
        }
    }

    public List<? extends HudsonJobChangeItem> parseChangeSet(final HudsonJobBuild build) {
        Element changeSet;
        try {
            changeSet = XMLUtil.findElement((Element)new ConnectionBuilder().job(build.getJob()).url(build.getUrl() + "api/xml?tree=changeSet[kind,items[user,msg,paths[file,editType],revision],revisions[module]]").parseXML().getDocumentElement(), (String)"changeSet", null);
        }
        catch (IOException x) {
            LOG.log(Level.WARNING, "could not parse changelog for {0}: {1}", new Object[]{build, x});
            return Collections.emptyList();
        }
        if (!"svn".equals(Utilities.xpath((String)"kind", (Element)changeSet))) {
            return null;
        }
        class SubversionItem
        implements HudsonJobChangeItem {
            final Element itemXML;

            SubversionItem(Element xml) {
                this.itemXML = xml;
            }

            public String getUser() {
                return Utilities.xpath((String)"user", (Element)this.itemXML);
            }

            public String getMessage() {
                return Utilities.xpath((String)"msg", (Element)this.itemXML);
            }

            public Collection<? extends HudsonJobChangeItem.HudsonJobChangeFile> getFiles() {
                class SubversionFile
                implements HudsonJobChangeItem.HudsonJobChangeFile {
                    final Element fileXML;

                    SubversionFile(Element xml) {
                        this.fileXML = xml;
                    }

                    public String getName() {
                        return Utilities.xpath((String)"file", (Element)this.fileXML);
                    }

                    public HudsonJobChangeItem.HudsonJobChangeFile.EditType getEditType() {
                        return HudsonJobChangeItem.HudsonJobChangeFile.EditType.valueOf((String)Utilities.xpath((String)"editType", (Element)this.fileXML));
                    }

                    public OutputListener hyperlink() {
                        int endRev;
                        int startRev;
                        String module = Utilities.xpath((String)"revision/module", (Element)changeSet);
                        String rev = Utilities.xpath((String)"revision", (Element)itemXML);
                        if (module == null || !module.startsWith("http") || rev == null) {
                            return null;
                        }
                        int r = Integer.parseInt(rev);
                        String path = this.getName();
                        switch (this.getEditType()) {
                            case edit: {
                                startRev = r - 1;
                                endRev = r;
                                break;
                            }
                            case add: {
                                startRev = 0;
                                endRev = r;
                                break;
                            }
                            case delete: {
                                startRev = r - 1;
                                endRev = 0;
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        return new SubversionHyperlink(module, path, startRev, endRev, build.getJob());
                    }
                }
                ArrayList<SubversionFile> files = new ArrayList<SubversionFile>();
                NodeList nl = this.itemXML.getElementsByTagName("path");
                for (int i = 0; i < nl.getLength(); ++i) {
                    files.add(new SubversionFile((Element)nl.item(i)));
                }
                return files;
            }
        }
        ArrayList<SubversionItem> items = new ArrayList<SubversionItem>();
        NodeList nl = changeSet.getElementsByTagName("item");
        for (int i = 0; i < nl.getLength(); ++i) {
            items.add(new SubversionItem((Element)nl.item(i)));
        }
        return items;
    }
}

