/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.screen.display.GaugeDisplayPresenterElement;
import org.netbeans.modules.vmd.midp.screen.display.ItemDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.property.ResourcePropertyEditor;

public class GaugeDisplayPresenter
extends ItemDisplayPresenter {
    private JPanel panel;
    private GaugeDisplayPresenterElement gauge = new GaugeDisplayPresenterElement();

    public GaugeDisplayPresenter() {
        this.panel = new JPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                GaugeDisplayPresenter.this.gauge.setPanel(this);
                GaugeDisplayPresenter.this.gauge.paintGauge(g);
            }
        };
        this.panel.setOpaque(false);
        this.panel.setPreferredSize(new Dimension(200, 40));
        this.setContentComponent(this.panel);
        this.panel.repaint();
        this.panel.revalidate();
    }

    @Override
    public void reload(ScreenDeviceInfo deviceInfo) {
        super.reload(deviceInfo);
        this.gauge.setSize(this.panel.getSize());
        PropertyValue pv = this.getComponent().readProperty("interactive");
        if (PropertyValue.Kind.VALUE.equals((Object)pv.getKind())) {
            this.gauge.setInteractive(MidpTypes.getBoolean(pv));
        }
        pv = this.getComponent().readProperty("maxValue");
        int maxValue = 1;
        if (PropertyValue.Kind.VALUE.equals((Object)pv.getKind())) {
            maxValue = MidpTypes.getInteger(pv);
        }
        if (maxValue < 0) {
            maxValue = 1;
        }
        this.gauge.setMaxValue(maxValue);
        pv = this.getComponent().readProperty("value");
        int value = 0;
        if (PropertyValue.Kind.VALUE.equals((Object)pv.getKind())) {
            value = MidpTypes.getInteger(pv);
        }
        if (value < 0) {
            value = 0;
        } else if (value > maxValue) {
            value = maxValue;
        }
        this.gauge.setValue(value);
        this.panel.repaint();
    }

    @Override
    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        ResourcePropertyEditor gaugePropertyEditor = new ResourcePropertyEditor("value", this.getComponent());
        ArrayList<ScreenPropertyDescriptor> descriptors = new ArrayList<ScreenPropertyDescriptor>();
        descriptors.addAll(super.getPropertyDescriptors());
        descriptors.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.panel, (ScreenPropertyEditor)gaugePropertyEditor));
        return descriptors;
    }
}

