/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.resource.elements;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.resources.ImageCD;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ImageEditorElement
extends PropertyEditorResourceElement
implements Runnable,
CleanUp {
    private static final String[] EXTENSIONS = new String[]{"png", "gif", "jpg", "jpeg"};
    private long componentID;
    private boolean doNotFireEvent;
    private String lastDir;
    private ImagePreview imagePreview;
    private Image image;
    private DefaultComboBoxModel comboBoxModel;
    private Map<String, FileObject> paths;
    private final AtomicBoolean requiresModelUpdate = new AtomicBoolean(false);
    private PropertyEditorResourceElement.DesignComponentWrapper wrapper;
    private WeakReference<DesignDocument> documentReferences;
    private JButton chooserButton;
    private JLabel heightLabel;
    private JTextField heightTextField;
    private JLabel pathLabel;
    private JComboBox pathTextComboBox;
    private JLabel previewLabel;
    private JPanel previewPanel;
    private JProgressBar progressBar;
    private JLabel sizeLabel;
    private JTextField sizeTextField;
    private JLabel widthLabel;
    private JTextField widthTextField;

    public ImageEditorElement() {
        this.paths = new HashMap<String, FileObject>();
        this.comboBoxModel = new DefaultComboBoxModel();
        this.initComponents();
        this.progressBar.setVisible(false);
        this.imagePreview = new ImagePreview();
        this.previewPanel.add((Component)this.imagePreview, "Center");
    }

    @Override
    public void clean(DesignComponent component) {
        this.imagePreview = null;
        this.image = null;
        this.comboBoxModel = null;
        if (this.paths != null) {
            this.paths.clear();
            this.paths = null;
        }
        this.wrapper = null;
        this.documentReferences = null;
        this.removeAll();
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public TypeID getTypeID() {
        return ImageCD.TYPEID;
    }

    @Override
    public List<String> getPropertyValueNames() {
        return Arrays.asList("resourcePath");
    }

    @Override
    public void setDesignComponent(DesignComponent component) {
        this.init(component.getDocument());
        super.setDesignComponent(component);
    }

    @Override
    public void setDesignComponentWrapper(PropertyEditorResourceElement.DesignComponentWrapper wrapper) {
        this.wrapper = wrapper;
        if (this.documentReferences == null || this.documentReferences.get() == null) {
            return;
        }
        if (wrapper == null) {
            this.setText(null);
            this.setAllEnabled(false);
            return;
        }
        this.componentID = wrapper.getComponentID();
        final String[] _pathText = new String[1];
        final DesignComponent component = wrapper.getComponent();
        if (component != null) {
            if (!component.getType().equals((Object)this.getTypeID())) {
                throw new IllegalArgumentException("Passed component must have typeID " + this.getTypeID() + " instead passed " + component.getType());
            }
            this.componentID = component.getComponentID();
            component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    PropertyValue propertyValue = component.readProperty("resourcePath");
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType(propertyValue)) {
                        _pathText[0] = MidpTypes.getString(propertyValue);
                    }
                }
            });
        }
        if (wrapper.hasChanges()) {
            Map<String, PropertyValue> changes = wrapper.getChanges();
            for (String propertyName : changes.keySet()) {
                PropertyValue propertyValue = changes.get(propertyName);
                if (!"resourcePath".equals(propertyName)) continue;
                _pathText[0] = MidpTypes.getString(propertyValue);
            }
        }
        this.setAllEnabled(true);
        this.setText(_pathText[0]);
    }

    private void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.addImage(text);
    }

    private void addImage(String path) {
        this.doNotFireEvent = true;
        if (this.comboBoxModel.getIndexOf(path) == -1) {
            this.comboBoxModel.addElement(path);
            this.sortComboBoxContent();
        }
        this.pathTextComboBox.setSelectedItem(path);
        this.doNotFireEvent = false;
        this.updatePreview();
    }

    private void sortComboBoxContent() {
        int size = this.pathTextComboBox.getItemCount();
        ArrayList list = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.pathTextComboBox.getItemAt(i));
        }
        Collections.sort(list, PropertyEditorResourceElement.StringComparator.instance);
        this.pathTextComboBox.removeAllItems();
        for (Object object : list) {
            this.pathTextComboBox.addItem(object);
        }
    }

    public void setAllEnabled(boolean isEnabled) {
        this.pathLabel.setEnabled(isEnabled);
        this.pathTextComboBox.setEnabled(isEnabled);
        this.previewLabel.setEnabled(isEnabled);
        this.previewPanel.setEnabled(isEnabled);
        this.widthLabel.setEnabled(isEnabled);
        this.widthTextField.setEnabled(isEnabled);
        this.heightLabel.setEnabled(isEnabled);
        this.heightTextField.setEnabled(isEnabled);
        this.sizeLabel.setEnabled(isEnabled);
        this.sizeTextField.setEnabled(isEnabled);
        this.chooserButton.setEnabled(isEnabled);
    }

    public void updateModel(DesignDocument document) {
        boolean isEnabled = this.pathTextComboBox.isEnabled();
        this.pathTextComboBox.setEnabled(false);
        this.doNotFireEvent = true;
        this.comboBoxModel.removeAllElements();
        this.doNotFireEvent = false;
        this.paths.clear();
        Map<FileObject, String> fileMap = MidpProjectSupport.getImagesForProject(document, false);
        for (Map.Entry<FileObject, String> entry : fileMap.entrySet()) {
            this.checkFile(entry.getKey(), entry.getValue());
        }
        if (isEnabled) {
            this.pathTextComboBox.setEnabled(true);
        }
    }

    private void checkFile(FileObject fo, String relativePath) {
        for (String ext : EXTENSIONS) {
            if (!ext.equals(fo.getExt().toLowerCase())) continue;
            String path = this.convertFile(fo, relativePath, false);
            if (path == null) break;
            this.addImage(path);
            break;
        }
    }

    private void updatePreview() {
        String relativePath = (String)this.pathTextComboBox.getSelectedItem();
        FileObject fo = this.paths.get(relativePath);
        BufferedImage bufferedImage = null;
        try {
            if (fo != null) {
                bufferedImage = ImageIO.read(fo.getInputStream());
            }
        }
        catch (IOException ex) {
            System.out.print(ex.getMessage());
        }
        if (bufferedImage != null) {
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            this.widthTextField.setText(String.valueOf(width));
            this.heightTextField.setText(String.valueOf(height));
            StringBuffer str = new StringBuffer();
            str.append(fo.getSize());
            str.append(' ');
            str.append(NbBundle.getMessage(ImageEditorElement.class, (String)"LBL_Size_Bytes"));
            this.sizeTextField.setText(str.toString());
            this.image = bufferedImage;
        } else {
            this.image = null;
            this.widthTextField.setText(null);
            this.heightTextField.setText(null);
            this.sizeTextField.setText(null);
        }
        this.previewPanel.invalidate();
        this.previewPanel.validate();
        this.previewPanel.repaint();
    }

    private FileObject getSourceFolder() {
        if (this.documentReferences != null && this.documentReferences.get() == null) {
            return null;
        }
        Project project = ProjectUtils.getProject((DesignDocument)((DesignDocument)this.documentReferences.get()));
        if (project == null) {
            if (this.documentReferences != null && this.documentReferences.get() != null) {
                project = ProjectUtils.getProject((DesignDocument)((DesignDocument)this.documentReferences.get()));
            }
            if (project == null) {
                throw Debug.illegalState((Object[])new Object[]{"Current project is null"});
            }
        }
        String projectID = ProjectUtils.getProjectID((Project)project);
        return ((SourceGroup)ProjectUtils.getSourceGroups((String)projectID).iterator().next()).getRootFolder();
    }

    private String convertFile(FileObject fo, String relPath, boolean needCopy) {
        String relativePath;
        FileObject sourceFolder = this.getSourceFolder();
        String sourcePath = FileUtil.toFile((FileObject)sourceFolder).getAbsolutePath();
        File file = FileUtil.toFile((FileObject)fo);
        if (file == null) {
            relativePath = !fo.getPath().startsWith("/", 0) ? "/" + fo.getPath() : fo.getPath();
        } else {
            String fullPath = file.getAbsolutePath();
            if (fullPath.contains(sourcePath)) {
                int i;
                fullPath = fo.getPath();
                relativePath = !fullPath.substring(i = fullPath.indexOf(sourcePath) + sourcePath.length() + 1).startsWith("/") ? "/" + fullPath.substring(i) : fullPath.substring(i);
            } else if (needCopy) {
                File possible = new File(sourcePath + File.separator + fo.getNameExt());
                if (possible.exists()) {
                    return null;
                }
                try {
                    fo = fo.copy(sourceFolder, fo.getName(), fo.getExt());
                }
                catch (IOException ex) {
                    Debug.warning((Object[])new Object[]{"SVGImageEditorElement.convertFile()", "can't copy file", fullPath, ex});
                }
                relativePath = "/" + fo.getNameExt();
            } else {
                relativePath = relPath;
            }
        }
        this.paths.put(relativePath, fo);
        return relativePath;
    }

    public void init(DesignDocument document) {
        this.documentReferences = new WeakReference<DesignDocument>(document);
    }

    @Override
    public void run() {
        if (this.documentReferences == null || this.documentReferences.get() == null) {
            return;
        }
        DesignDocument document = (DesignDocument)this.documentReferences.get();
        if (document != null) {
            this.updateModel(document);
        }
        this.showProgressBar(false);
        this.setDesignComponentWrapper(this.wrapper);
        this.requiresModelUpdate.set(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.requiresModelUpdate.getAndSet(true)) {
            return;
        }
        this.showProgressBar(true);
        new Thread(this).start();
    }

    private void showProgressBar(final boolean isShowing) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageEditorElement.this.progressBar.setVisible(isShowing);
            }
        });
    }

    @Override
    public void removeNotify() {
        this.paths.clear();
        this.wrapper = null;
        super.removeNotify();
    }

    private void initComponents() {
        this.pathLabel = new JLabel();
        this.previewLabel = new JLabel();
        this.previewPanel = new JPanel();
        this.widthLabel = new JLabel();
        this.widthTextField = new JTextField();
        this.heightLabel = new JLabel();
        this.heightTextField = new JTextField();
        this.chooserButton = new JButton();
        this.pathTextComboBox = new JComboBox();
        this.sizeLabel = new JLabel();
        this.sizeTextField = new JTextField();
        this.progressBar = new JProgressBar();
        this.pathLabel.setLabelFor(this.pathTextComboBox);
        Mnemonics.setLocalizedText((JLabel)this.pathLabel, (String)NbBundle.getMessage(ImageEditorElement.class, (String)"ImageEditorElement.pathLabel.text"));
        this.pathLabel.setEnabled(false);
        this.previewLabel.setText(NbBundle.getMessage(ImageEditorElement.class, (String)"ImageEditorElement.previewLabel.text"));
        this.previewLabel.setEnabled(false);
        this.previewPanel.setEnabled(false);
        this.previewPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ImageEditorElement.this.previewPanelComponentResized(evt);
            }
        });
        this.previewPanel.setLayout(new BorderLayout());
        this.widthLabel.setLabelFor(this.widthTextField);
        Mnemonics.setLocalizedText((JLabel)this.widthLabel, (String)NbBundle.getMessage(ImageEditorElement.class, (String)"ImageEditorElement.widthLabel.text"));
        this.widthLabel.setEnabled(false);
        this.widthTextField.setEditable(false);
        this.widthTextField.setEnabled(false);
        this.heightLabel.setLabelFor(this.heightTextField);
        Mnemonics.setLocalizedText((JLabel)this.heightLabel, (String)NbBundle.getMessage(ImageEditorElement.class, (String)"ImageEditorElement.heightLabel.text"));
        this.heightLabel.setEnabled(false);
        this.heightTextField.setEditable(false);
        this.heightTextField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.chooserButton, (String)NbBundle.getMessage(ImageEditorElement.class, (String)"ImageEditorElement.chooserButton.text"));
        this.chooserButton.setEnabled(false);
        this.chooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageEditorElement.this.chooserButtonActionPerformed(evt);
            }
        });
        this.pathTextComboBox.setEditable(true);
        this.pathTextComboBox.setModel(this.comboBoxModel);
        this.pathTextComboBox.setEnabled(false);
        this.pathTextComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageEditorElement.this.pathTextComboBoxActionPerformed(evt);
            }
        });
        this.sizeLabel.setLabelFor(this.sizeTextField);
        Mnemonics.setLocalizedText((JLabel)this.sizeLabel, (String)NbBundle.getMessage(ImageEditorElement.class, (String)"ImageEditorElement.sizeLabel.text"));
        this.sizeLabel.setEnabled(false);
        this.sizeTextField.setEditable(false);
        this.sizeTextField.setEnabled(false);
        this.progressBar.setIndeterminate(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pathLabel).addContainerGap(289, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.previewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previewPanel, -1, 0, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.heightLabel).addComponent(this.widthLabel).addComponent(this.sizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.widthTextField, -1, 107, Short.MAX_VALUE).addComponent(this.heightTextField, -1, 107, Short.MAX_VALUE).addComponent(this.sizeTextField))).addComponent(this.progressBar, -2, -1, -2))).addComponent(this.pathTextComboBox, 0, 269, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chooserButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pathTextComboBox, -2, -1, -2).addComponent(this.chooserButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.widthLabel).addComponent(this.widthTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.heightLabel).addComponent(this.heightTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sizeTextField, -2, -1, -2).addComponent(this.sizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, -1, -2).addGap(3, 3, 3)).addComponent(this.previewLabel).addComponent(this.previewPanel, -1, 100, Short.MAX_VALUE))));
        this.widthTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSN_Width"));
        this.widthTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSD_Width"));
        this.heightTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSN_Height"));
        this.heightTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSD_Height"));
        this.chooserButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSN_Browse"));
        this.chooserButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSD_Browse"));
        this.pathTextComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImageEditorElement.class, (String)"ASCN_ImagePath"));
        this.pathTextComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImageEditorElement.class, (String)"ASCD_ImagePath"));
        this.sizeTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSN_Size"));
        this.sizeTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSD_Size"));
    }

    private void chooserButtonActionPerformed(ActionEvent evt) {
        Project project = ProjectUtils.getProject((DesignDocument)((DesignDocument)this.documentReferences.get()));
        JFileChooser chooser = new JFileChooser(this.lastDir != null ? this.lastDir : project.getProjectDirectory().getPath());
        chooser.setFileFilter(new ImageFilter());
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)chooser.getSelectedFile()));
            this.lastDir = chooser.getSelectedFile().getParentFile().getPath();
            String relativePath = this.convertFile(fo, null, true);
            if (relativePath != null) {
                this.setText(relativePath);
                this.pathTextComboBoxActionPerformed(null);
            } else {
                String message = NbBundle.getMessage(ImageEditorElement.class, (String)"MSG_FILE_EXIST");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
            }
        }
    }

    private void pathTextComboBoxActionPerformed(ActionEvent evt) {
        if (!this.doNotFireEvent) {
            String text = (String)this.pathTextComboBox.getSelectedItem();
            this.fireElementChanged(this.componentID, "resourcePath", MidpTypes.createStringValue(text != null ? text : ""));
            this.updatePreview();
        }
        this.repaint();
    }

    private void previewPanelComponentResized(ComponentEvent evt) {
        this.updatePreview();
    }

    private class ImagePreview
    extends JPanel {
        private static final int BORDER_EDGE_LENGTH = 10;
        private static final int IMAGE_GAP = 10;

        private ImagePreview() {
        }

        @Override
        public void paint(Graphics g) {
            if (ImageEditorElement.this.image != null) {
                int width = ImageEditorElement.this.image.getWidth(null);
                int height = ImageEditorElement.this.image.getHeight(null);
                int previewWidth = ImageEditorElement.this.imagePreview.getWidth() - 10;
                int previewHeight = ImageEditorElement.this.imagePreview.getHeight() - 10;
                if (width > previewWidth || height > previewHeight) {
                    g.drawImage(ImageEditorElement.this.image, 10, 10, previewWidth, previewHeight, 0, 0, width, height, null);
                } else {
                    int xOffset = (previewWidth - width + 10) / 2;
                    int yOffset = (previewHeight - height + 10) / 2;
                    g.drawImage(ImageEditorElement.this.image, xOffset, yOffset, null);
                }
            }
            g.setColor(Color.BLACK);
            int rightX = this.getWidth() - 1;
            int bottomY = this.getHeight() - 1;
            g.drawLine(0, 0, 0, 10);
            g.drawLine(0, 0, 10, 0);
            g.drawLine(rightX, 0, rightX, 10);
            g.drawLine(rightX, 0, rightX - 10, 0);
            g.drawLine(0, bottomY, 0, bottomY - 10);
            g.drawLine(0, bottomY, 10, bottomY);
            g.drawLine(rightX, bottomY, rightX, bottomY - 10);
            g.drawLine(rightX, bottomY, rightX - 10, bottomY);
        }
    }

    private static class ImageFilter
    extends FileFilter {
        private String description = NbBundle.getMessage(ImageEditorElement.class, (String)"DISP_Image_Files");

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String extension = ImageFilter.getExtension(file);
            for (String ext : EXTENSIONS) {
                if (!ext.equals(extension)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        private static String getExtension(File file) {
            String ext = null;
            String s = file.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }
}

