/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.items.GaugeCD;
import org.netbeans.modules.vmd.midp.propertyeditors.BooleanInplaceEditor;
import org.netbeans.modules.vmd.midp.propertyeditors.MidpPropertyEditorSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.util.NbBundle;

public final class PropertyEditorAlertIndicator
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private BooleanInplaceEditor inplaceEditor;
    private Boolean valueState;
    private boolean executeInsideWriteTransactionUsed = true;
    private String rbLabel;

    private PropertyEditorAlertIndicator(String rbLabel) {
        super(NbBundle.getMessage(PropertyEditorAlertIndicator.class, (String)"LBL_VALUE_ALERT_INDICATOR_UCLABEL"));
        this.rbLabel = rbLabel;
    }

    public static PropertyEditorAlertIndicator createInstance(String rbLabel) {
        return new PropertyEditorAlertIndicator(rbLabel);
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorAlertIndicator.class, (String)"LBL_VALUE_ALERT_INDICATOR_STR"));
        this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorAlertIndicator.class, (String)"ACSN_VALUE_ALERT_INDICATOR_STR"));
        this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorAlertIndicator.class, (String)"ACSD_VALUE_ALERT_INDICATOR_STR"));
        this.customEditor = new CustomEditor();
    }

    @Override
    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.customEditor != null) {
            this.customEditor.removeAll();
            this.customEditor = null;
        }
        this.radioButton = null;
        this.valueState = null;
        if (this.inplaceEditor != null) {
            this.inplaceEditor.cleanUp();
            this.inplaceEditor = null;
        }
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return false;
    }

    public boolean isPaintable() {
        PropertyValue propertyValue = (PropertyValue)this.getValue();
        return propertyValue.getKind() != PropertyValue.Kind.USERCODE;
    }

    public InplaceEditor getInplaceEditor() {
        if (this.inplaceEditor == null) {
            this.inplaceEditor = new BooleanInplaceEditor(this);
            PropertyValue propertyValue = (PropertyValue)this.getValue();
            DesignComponent value = propertyValue.getComponent();
            JCheckBox checkBox = (JCheckBox)this.inplaceEditor.getComponent();
            if (value != null) {
                checkBox.setSelected(true);
            }
            checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PropertyEditorAlertIndicator.this.executeInsideWriteTransactionUsed = true;
                    JCheckBox checkBox = (JCheckBox)PropertyEditorAlertIndicator.this.inplaceEditor.getComponent();
                    PropertyEditorAlertIndicator.this.valueState = checkBox.isSelected();
                    PropertyEditorAlertIndicator.this.setValue(PropertyEditorUserCode.NULL_VALUE);
                    PropertyEditorAlertIndicator.this.invokeSaveToModel();
                }
            });
        } else {
            PropertyValue propertyValue = (PropertyValue)this.getValue();
            DesignComponent value = propertyValue.getComponent();
            JCheckBox checkBox = (JCheckBox)this.inplaceEditor.getComponent();
            if (value != null) {
                checkBox.setSelected(true);
            } else {
                checkBox.setSelected(false);
            }
        }
        return this.inplaceEditor;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        if (this.inplaceEditor == null) {
            return;
        }
        JComponent _component = this.inplaceEditor.getComponent();
        _component.setSize(box.width, box.height);
        _component.doLayout();
        _component.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Graphics g = gfx.create(box.x, box.y, box.width, box.height);
        _component.setOpaque(false);
        _component.paint(g);
        g.dispose();
    }

    @Override
    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.isCurrentValueANull()) {
            return "false";
        }
        return "true";
    }

    @Override
    public void setTextForPropertyValue(String text) {
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public void updateState(PropertyValue value) {
        this.customEditor.setValue(value);
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    @Override
    public boolean isExecuteInsideWriteTransactionUsed() {
        return this.executeInsideWriteTransactionUsed;
    }

    public Object getDefaultValue() {
        this.executeInsideWriteTransactionUsed = false;
        return super.getDefaultValue();
    }

    public boolean executeInsideWriteTransaction() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        DesignComponent alertComponent = (DesignComponent)this.component.get();
        if (this.isCurrentValueAUserCodeType()) {
            this.removeGauge(alertComponent);
            return true;
        }
        if (this.valueState.booleanValue()) {
            if (alertComponent.readProperty("indicator").getComponent() != null) {
                return false;
            }
            ComponentProducer producer = DocumentSupport.getComponentProducer((DesignDocument)alertComponent.getDocument(), (String)GaugeCD.TYPEID.toString());
            if (producer == null) {
                throw new IllegalStateException("No producer for TypeID : " + GaugeCD.TYPEID);
            }
            DesignComponent gauge = producer.createComponent(alertComponent.getDocument()).getMainComponent();
            gauge.writeProperty("interactive", MidpTypes.createBooleanValue(false));
            gauge.writeProperty("usedByAlert", MidpTypes.createBooleanValue(true));
            gauge.writeProperty("label", PropertyValue.createNull());
            gauge.writeProperty("instanceName", InstanceNameResolver.createFromSuggested(gauge, "indicator"));
            PropertyValue newGauge = PropertyValue.createComponentReference((DesignComponent)gauge);
            PropertyEditorAlertIndicator.super.setValue(newGauge);
            alertComponent.addComponent(gauge);
            alertComponent.writeProperty("indicator", newGauge);
        } else {
            this.removeGauge(alertComponent);
        }
        return false;
    }

    private boolean removeGauge(DesignComponent ac) {
        DesignComponent gauge = ac.readProperty("indicator").getComponent();
        if (gauge == null) {
            ac.writeProperty("indicator", NULL_VALUE);
            PropertyEditorAlertIndicator.super.setValue(PropertyEditorAlertIndicator.NULL_VALUE);
            return false;
        }
        ac.writeProperty("indicator", PropertyValue.createNull());
        ac.getDocument().deleteComponent(gauge);
        PropertyEditorAlertIndicator.super.setValue(PropertyEditorAlertIndicator.NULL_VALUE);
        return false;
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        this.executeInsideWriteTransactionUsed = true;
        if (this.radioButton.isSelected()) {
            this.valueState = "true".equals(this.customEditor.getText()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            JCheckBox checkBox = (JCheckBox)this.inplaceEditor.getComponent();
            checkBox.setSelected(this.valueState);
            this.setValue(NULL_VALUE);
            this.invokeSaveToModel();
        }
    }

    @Override
    public boolean canWrite() {
        return MidpPropertyEditorSupport.singleSelectionEditAsTextOnly();
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener {
        private JCheckBox checkBox;

        public CustomEditor() {
            this.initComponents();
        }

        void cleanUp() {
            this.checkBox.removeActionListener(this);
            this.checkBox = null;
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.checkBox = new JCheckBox();
            if (PropertyEditorAlertIndicator.this.rbLabel != null) {
                Mnemonics.setLocalizedText((AbstractButton)this.checkBox, (String)PropertyEditorAlertIndicator.this.rbLabel);
            }
            this.checkBox.getAccessibleContext().setAccessibleName(this.checkBox.getText());
            this.checkBox.getAccessibleContext().setAccessibleDescription(this.checkBox.getText());
            this.checkBox.addActionListener(this);
            this.add((Component)this.checkBox, "Center");
        }

        public void setValue(PropertyValue value) {
            this.checkBox.setSelected(value != null && value.getComponent() != null);
        }

        public String getText() {
            return this.checkBox.isSelected() ? "true" : "false";
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PropertyEditorAlertIndicator.this.radioButton.setSelected(true);
        }
    }
}

