/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.analyzer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeleteSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ResourcesAnalyzerPanel
extends JPanel {
    private DesignDocument document;
    private Map<Long, String> resourceNames;
    private Map<Long, Icon> resourceIcons;
    private List<Long> resourceIDs;
    private Icon resourceIcon = new ImageIcon("org/netbeans/modules/vmd/midp/resources/components/resource_16.png");
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    private JList resourcesList;

    ResourcesAnalyzerPanel() {
        this.initComponents();
        this.resourceIDs = new ArrayList<Long>();
        this.resourceNames = new HashMap<Long, String>();
        this.resourceIcons = new HashMap<Long, Icon>();
        this.resourcesList.setCellRenderer(new ResourcesListRenderer());
    }

    void setUnusedResources(DesignDocument document, List<DesignComponent> resources) {
        Collections.sort(resources, new Comparator<DesignComponent>(){

            @Override
            public int compare(DesignComponent c1, DesignComponent c2) {
                int i = c1.getType().toString().compareToIgnoreCase(c2.getType().toString());
                if (i != 0) {
                    return i;
                }
                String s1 = InfoPresenter.getDisplayName((DesignComponent)c1);
                String s2 = InfoPresenter.getDisplayName((DesignComponent)c2);
                if (s1 != null) {
                    i = s1.compareToIgnoreCase(s2);
                    if (i != 0) {
                        return i;
                    }
                    return s1.compareTo(s2);
                }
                return s2 != null ? 1 : 0;
            }
        });
        if (resources.size() == this.resourceIDs.size()) {
            for (int i = 0; i < resources.size(); ++i) {
                if (resources.get(i).getComponentID() != this.resourceIDs.get(i).longValue()) continue;
                return;
            }
        }
        this.resourceIDs.clear();
        this.resourceNames.clear();
        this.resourceIcons.clear();
        this.document = document;
        ((DefaultListModel)this.resourcesList.getModel()).removeAllElements();
        if (resources.isEmpty()) {
            ((DefaultListModel)this.resourcesList.getModel()).addElement(NbBundle.getMessage(ResourcesAnalyzerPanel.class, (String)"ResourcesAnalyzer.nothing-found"));
            this.resourcesList.clearSelection();
        } else {
            for (DesignComponent resource : resources) {
                Image image;
                String resourceName;
                this.resourceIDs.add(resource.getComponentID());
                InfoPresenter info = (InfoPresenter)resource.getPresenter(InfoPresenter.class);
                if (info != null) {
                    resourceName = info.getDisplayName(InfoPresenter.NameType.PRIMARY);
                    image = info.getIcon(InfoPresenter.IconType.COLOR_16x16);
                } else {
                    Debug.warning((Object[])new Object[]{"Missing InfoPresenter for", resource});
                    resourceName = NbBundle.getMessage(ResourcesAnalyzerPanel.class, (String)"ResourcesAnalyzer.no-label");
                    image = null;
                }
                this.resourceNames.put(resource.getComponentID(), resourceName);
                this.resourceIcons.put(resource.getComponentID(), image != null ? new ImageIcon(image) : this.resourceIcon);
                ((DefaultListModel)this.resourcesList.getModel()).addElement(resource.getComponentID());
            }
            int size = this.resourcesList.getModel().getSize();
            if (size > 0) {
                this.resourcesList.setSelectionInterval(0, size - 1);
            }
        }
    }

    private void removeUnusedResources(final Object[] selectedElements) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                for (Object selected : selectedElements) {
                    if (!(selected instanceof Long)) continue;
                    DesignComponent resource = ResourcesAnalyzerPanel.this.document.getComponentByUID(((Long)selected).longValue());
                    if (resource != null) {
                        DeleteSupport.invokeDirectUserDeletion((DesignDocument)ResourcesAnalyzerPanel.this.document, Collections.singleton(resource), (boolean)false);
                    }
                    ((DefaultListModel)ResourcesAnalyzerPanel.this.resourcesList.getModel()).removeElement(selected);
                }
            }
        });
        if (this.resourcesList.getModel().getSize() == 0) {
            ((DefaultListModel)this.resourcesList.getModel()).addElement(NbBundle.getMessage(ResourcesAnalyzerPanel.class, (String)"ResourcesAnalyzer.nothing-found"));
        }
    }

    private void initComponents() {
        this.removeButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.resourcesList = new JList();
        this.setPreferredSize(new Dimension(400, 150));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ResourcesAnalyzerPanel.class, (String)"ResourcesAnalyzerPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResourcesAnalyzerPanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.resourcesList.setModel(new DefaultListModel());
        this.jScrollPane1.setViewportView(this.resourcesList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 237, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.removeButton).addContainerGap(125, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 150, Short.MAX_VALUE));
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.removeUnusedResources(this.resourcesList.getSelectedValues());
    }

    private class ResourcesListRenderer
    extends DefaultListCellRenderer {
        private ResourcesListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (ResourcesAnalyzerPanel.this.document != null && value instanceof Long) {
                renderer.setText((String)ResourcesAnalyzerPanel.this.resourceNames.get((Long)value));
                renderer.setIcon((Icon)ResourcesAnalyzerPanel.this.resourceIcons.get((Long)value));
            }
            return renderer;
        }
    }
}

