/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.java.navigation.JavaElement;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;
import org.netbeans.modules.java.navigation.Utils;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class JavaMembersModel
extends DefaultTreeModel {
    static Element[] EMPTY_ELEMENTS_ARRAY = new Element[0];
    private FileObject fileObject;
    private ElementHandle<?>[] elementHandles;
    private FilterModel filterModel;

    public JavaMembersModel(FileObject fileObject, ElementHandle<?>[] elements) {
        super(null);
        this.fileObject = fileObject;
        this.elementHandles = elements;
        this.update(elements);
        this.filterModel = new FilterModel(this);
    }

    FilterModel getFilterModel() {
        return this.filterModel;
    }

    public void update() {
        this.update(this.elementHandles);
    }

    private void update(final ElementHandle[] elementHandles) {
        if (elementHandles == null && elementHandles.length == 0) {
            return;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        ArrayList<Element> elementsList = new ArrayList<Element>(elementHandles.length);
                        for (ElementHandle elementHandle : elementHandles) {
                            Element element = elementHandle.resolve((CompilationInfo)compilationController);
                            if (element == null) continue;
                            elementsList.add(element);
                        }
                        Element[] elements = elementsList.toArray(EMPTY_ELEMENTS_ARRAY);
                        JavaMembersModel.this.update(elements, (CompilationInfo)compilationController);
                    }
                }, true);
                return;
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    private void update(Element[] elements, CompilationInfo compilationInfo) {
        if (elements == null && elements.length == 0) {
            return;
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (Element element : elements) {
            if (element.getKind() == ElementKind.PACKAGE) {
                root.add(new PackageTreeNode(this.fileObject, (PackageElement)element, compilationInfo, null));
                continue;
            }
            if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ENUM || element.getKind() == ElementKind.ANNOTATION_TYPE) {
                root.add(new TypeTreeNode(this.fileObject, (TypeElement)element, compilationInfo, null));
                continue;
            }
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                root.add(new ConstructorTreeNode(this.fileObject, (ExecutableElement)element, compilationInfo, null));
                continue;
            }
            if (element.getKind() == ElementKind.METHOD) {
                root.add(new MethodTreeNode(this.fileObject, (ExecutableElement)element, compilationInfo, null));
                continue;
            }
            if (element.getKind() == ElementKind.FIELD) {
                root.add(new FieldTreeNode(this.fileObject, (VariableElement)element, compilationInfo, null));
                continue;
            }
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            root.add(new EnumConstantTreeNode(this.fileObject, (VariableElement)element, compilationInfo, null));
        }
        this.setRoot(root);
    }

    private static boolean include(AbstractMembersTreeNode delegateNode, String pattern, String patternLowerCase) {
        ElementKind elementKind = delegateNode.getElementKind();
        if (elementKind == ElementKind.CLASS || elementKind == ElementKind.INTERFACE || elementKind == ElementKind.ENUM || elementKind == ElementKind.ANNOTATION_TYPE || elementKind == ElementKind.PACKAGE) {
            return true;
        }
        Set<Modifier> modifiers = delegateNode.getModifiers();
        if (elementKind == ElementKind.CONSTRUCTOR) {
            if (!JavaMembersAndHierarchyOptions.isShowConstructors()) {
                return false;
            }
            if (!(modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.PROTECTED) || modifiers.contains((Object)Modifier.PRIVATE) || JavaMembersAndHierarchyOptions.isShowPackage())) {
                return false;
            }
            if (modifiers.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected()) {
                return false;
            }
            if (modifiers.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate()) {
                return false;
            }
        } else if (elementKind == ElementKind.METHOD) {
            if (!JavaMembersAndHierarchyOptions.isShowMethods()) {
                return false;
            }
            if (!(modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.PROTECTED) || modifiers.contains((Object)Modifier.PRIVATE) || JavaMembersAndHierarchyOptions.isShowPackage())) {
                return false;
            }
            if (modifiers.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected()) {
                return false;
            }
            if (modifiers.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate()) {
                return false;
            }
            if (modifiers.contains((Object)Modifier.STATIC) && !JavaMembersAndHierarchyOptions.isShowStatic()) {
                return false;
            }
        } else if (elementKind == ElementKind.FIELD) {
            if (!JavaMembersAndHierarchyOptions.isShowFields()) {
                return false;
            }
            if (!(modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.PROTECTED) || modifiers.contains((Object)Modifier.PRIVATE) || JavaMembersAndHierarchyOptions.isShowPackage())) {
                return false;
            }
            if (modifiers.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected()) {
                return false;
            }
            if (modifiers.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate()) {
                return false;
            }
            if (modifiers.contains((Object)Modifier.STATIC) && !JavaMembersAndHierarchyOptions.isShowStatic()) {
                return false;
            }
        } else if (elementKind == ElementKind.ENUM_CONSTANT) {
            if (!JavaMembersAndHierarchyOptions.isShowEnumConstants()) {
                return false;
            }
            if (!(modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.PROTECTED) || modifiers.contains((Object)Modifier.PRIVATE) || JavaMembersAndHierarchyOptions.isShowPackage())) {
                return false;
            }
            if (modifiers.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected()) {
                return false;
            }
            if (modifiers.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate()) {
                return false;
            }
            if (modifiers.contains((Object)Modifier.STATIC) && !JavaMembersAndHierarchyOptions.isShowStatic()) {
                return false;
            }
        }
        return JavaMembersModel.patternMatch(delegateNode, pattern, patternLowerCase);
    }

    static boolean patternMatch(JavaElement javaToolsJavaElement, String pattern) {
        return JavaMembersModel.patternMatch(javaToolsJavaElement, pattern, pattern.toLowerCase());
    }

    static boolean patternMatch(JavaElement javaToolsJavaElement, String pattern, String patternLowerCase) {
        return Utils.patternMatch(javaToolsJavaElement, pattern, patternLowerCase);
    }

    static class FilterModel
    extends DefaultTreeModel {
        private JavaMembersModel javaMembersModel;
        private String pattern = "";
        private String patternLowerCase = "";

        FilterModel(JavaMembersModel javaMembersModel) {
            super(null);
            this.javaMembersModel = javaMembersModel;
        }

        void update() {
            final DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            TreeNode javaMembersModelRoot = (TreeNode)this.javaMembersModel.getRoot();
            int childCount = javaMembersModelRoot.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                AbstractMembersTreeNode delegateNode = (AbstractMembersTreeNode)javaMembersModelRoot.getChildAt(i);
                if (!JavaMembersModel.include(delegateNode, this.pattern, this.patternLowerCase)) continue;
                FilterNode filterNode = new FilterNode(delegateNode);
                filterNode.loadChildren();
                root.add(filterNode);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FilterModel.this.setRoot(root);
                }
            });
        }

        String getPattern() {
            return this.pattern;
        }

        void setPattern(String pattern) {
            this.pattern = pattern;
            this.patternLowerCase = pattern == null ? null : pattern.toLowerCase();
        }

        void fireTreeNodesChanged() {
            super.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode)this.getRoot()), null, null);
        }

        private class FilterNode
        extends DefaultMutableTreeNode
        implements JavaElement {
            private AbstractMembersTreeNode abstractMembersTreeNode;

            FilterNode(AbstractMembersTreeNode abstractMembersTreeNode) {
                this.abstractMembersTreeNode = abstractMembersTreeNode;
            }

            private void loadChildren() {
                int childCount = this.abstractMembersTreeNode.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    AbstractMembersTreeNode delegateNode = (AbstractMembersTreeNode)this.abstractMembersTreeNode.getChildAt(i);
                    if (!JavaMembersModel.include(delegateNode, FilterModel.this.pattern, FilterModel.this.patternLowerCase)) continue;
                    FilterNode filterNode = new FilterNode(delegateNode);
                    filterNode.loadChildren();
                    this.add(filterNode);
                }
            }

            @Override
            public String getName() {
                return this.abstractMembersTreeNode.getName();
            }

            @Override
            public Set<Modifier> getModifiers() {
                return this.abstractMembersTreeNode.getModifiers();
            }

            @Override
            public ElementKind getElementKind() {
                return this.abstractMembersTreeNode.getElementKind();
            }

            @Override
            public String getLabel() {
                return this.abstractMembersTreeNode.getLabel();
            }

            @Override
            public String getFQNLabel() {
                return this.abstractMembersTreeNode.getLabel();
            }

            @Override
            public Icon getIcon() {
                return this.abstractMembersTreeNode.getIcon();
            }

            @Override
            public String getTooltip() {
                return this.abstractMembersTreeNode.getTooltip();
            }

            @Override
            public ElementHandle getElementHandle() {
                return this.abstractMembersTreeNode.getElementHandle();
            }

            @Override
            public FileObject getFileObject() {
                return this.abstractMembersTreeNode.getFileObject();
            }

            @Override
            public ElementJavadoc getJavaDoc() {
                return this.abstractMembersTreeNode.getJavaDoc();
            }

            @Override
            public void gotoElement() {
                this.abstractMembersTreeNode.gotoElement();
            }

            @Override
            public String toString() {
                return this.abstractMembersTreeNode.toString();
            }
        }
    }

    class EnumConstantTreeNode
    extends AbstractMembersTreeNode {
        EnumConstantTreeNode(FileObject fileObject, VariableElement variableElement, CompilationInfo compilationInfo, AbstractMembersTreeNode owner) {
            super(fileObject, variableElement, compilationInfo, owner);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    class FieldTreeNode
    extends AbstractMembersTreeNode {
        FieldTreeNode(FileObject fileObject, VariableElement variableElement, CompilationInfo compilationInfo, AbstractMembersTreeNode owner) {
            super(fileObject, variableElement, compilationInfo, owner);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    class MethodTreeNode
    extends AbstractMembersTreeNode {
        MethodTreeNode(FileObject fileObject, ExecutableElement methodElement, CompilationInfo compilationInfo, AbstractMembersTreeNode owner) {
            super(fileObject, methodElement, compilationInfo, owner);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    class ConstructorTreeNode
    extends AbstractMembersTreeNode {
        ConstructorTreeNode(FileObject fileObject, ExecutableElement contructorElement, CompilationInfo compilationInfo, AbstractMembersTreeNode owner) {
            super(fileObject, contructorElement, compilationInfo, owner);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    class TypeTreeNode
    extends AbstractMembersTreeNode {
        private boolean inSuperClassRole;

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, AbstractMembersTreeNode owner) {
            this(fileObject, typeElement, compilationInfo, false, owner);
        }

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, boolean inSuperClassRole, AbstractMembersTreeNode owner) {
            super(fileObject, typeElement, compilationInfo, owner);
            this.inSuperClassRole = inSuperClassRole;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
            this.loadChildren(element, compilationInfo, 0);
        }

        protected int loadChildren(Element element, CompilationInfo compilationInfo, int index) {
            AbstractMembersTreeNode node;
            TypeElement typeElement = (TypeElement)element;
            List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
            for (Element element2 : enclosedElements) {
                node = null;
                if (element2.getKind() == ElementKind.CLASS || element2.getKind() == ElementKind.INTERFACE || element2.getKind() == ElementKind.ENUM) {
                    if (!JavaMembersAndHierarchyOptions.isShowInner() || JavaMembersAndHierarchyOptions.isShowInherited()) continue;
                    node = new TypeTreeNode(this.getFileObject(), (TypeElement)element2, compilationInfo, (AbstractMembersTreeNode)this);
                } else {
                    Set<Modifier> set = element2.getModifiers();
                    if (element2.getKind() == ElementKind.CONSTRUCTOR) {
                        ExecutableElement constructor = (ExecutableElement)element2;
                        node = new ConstructorTreeNode(this.getFileObject(), constructor, compilationInfo, (AbstractMembersTreeNode)this);
                    } else if (element2.getKind() == ElementKind.METHOD) {
                        ExecutableElement method = (ExecutableElement)element2;
                        node = new MethodTreeNode(this.getFileObject(), method, compilationInfo, (AbstractMembersTreeNode)this);
                    } else if (element2.getKind() == ElementKind.FIELD) {
                        VariableElement field = (VariableElement)element2;
                        node = new FieldTreeNode(this.getFileObject(), field, compilationInfo, (AbstractMembersTreeNode)this);
                    } else if (element2.getKind() == ElementKind.ENUM_CONSTANT) {
                        VariableElement enumConstant = (VariableElement)element2;
                        node = new EnumConstantTreeNode(this.getFileObject(), enumConstant, compilationInfo, (AbstractMembersTreeNode)this);
                    }
                }
                if (node == null) continue;
                this.insert(node, index++);
            }
            if (JavaMembersAndHierarchyOptions.isShowInherited()) {
                TypeElement typeElement2;
                TypeMirror superClassTypeMirror = typeElement.getSuperclass();
                if (superClassTypeMirror.getKind() != TypeKind.NONE && (typeElement2 = (TypeElement)((DeclaredType)typeElement.getSuperclass()).asElement()) != null && !typeElement2.getQualifiedName().toString().equals(Object.class.getName()) && !this.hasCycle(typeElement2)) {
                    this.insert(new TypeTreeNode(this.getFileObject(), typeElement2, compilationInfo, true, this), index++);
                }
                List<? extends TypeMirror> list = typeElement.getInterfaces();
                for (TypeMirror typeMirror : list) {
                    TypeElement anInterface = (TypeElement)((DeclaredType)typeMirror).asElement();
                    if (this.hasCycle(anInterface)) continue;
                    this.insert(new TypeTreeNode(this.getFileObject(), anInterface, compilationInfo, true, this), index++);
                }
            }
            if (JavaMembersAndHierarchyOptions.isShowInner() && !this.inSuperClassRole && JavaMembersAndHierarchyOptions.isShowInherited()) {
                for (Element element3 : enclosedElements) {
                    if (element3.getKind() != ElementKind.CLASS && element3.getKind() != ElementKind.INTERFACE && element3.getKind() != ElementKind.ENUM) continue;
                    node = new TypeTreeNode(this.getFileObject(), (TypeElement)element3, compilationInfo, (AbstractMembersTreeNode)this);
                    this.insert(node, index++);
                }
            }
            return index;
        }

        private boolean hasCycle(TypeElement type) {
            String binName = ElementUtilities.getBinaryName((TypeElement)type);
            for (AbstractMembersTreeNode node = this; node != null; node = node.getOwningTreeNode()) {
                if (!(node instanceof TypeTreeNode) || !binName.equals(node.getElementHandle().getBinaryName())) continue;
                return true;
            }
            return false;
        }
    }

    class PackageTreeNode
    extends AbstractMembersTreeNode {
        PackageTreeNode(FileObject fileObject, PackageElement packageElement, CompilationInfo compilationInfo, AbstractMembersTreeNode root) {
            super(fileObject, packageElement, compilationInfo, root);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    abstract class AbstractMembersTreeNode
    extends DefaultMutableTreeNode
    implements JavaElement {
        private FileObject fileObject;
        private ElementHandle<? extends Element> elementHandle;
        private ElementKind elementKind;
        private Set<Modifier> modifiers;
        private String name = "";
        private String label = "";
        private String FQNlabel = "";
        private String tooltip = null;
        private Icon icon = null;
        private ElementJavadoc javaDoc;
        private final AbstractMembersTreeNode owner;

        AbstractMembersTreeNode(FileObject fileObject, Element element, CompilationInfo compilationInfo, AbstractMembersTreeNode owner) {
            this.fileObject = fileObject;
            this.elementHandle = ElementHandle.create((Element)element);
            this.elementKind = element.getKind();
            this.modifiers = element.getModifiers();
            this.owner = owner;
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                this.setName(element.getEnclosingElement().getSimpleName().toString());
            } else {
                this.setName(element.getSimpleName().toString());
            }
            this.setIcon(ElementIcons.getElementIcon((ElementKind)element.getKind(), element.getModifiers()));
            this.setLabel(Utils.format(element));
            this.setFQNLabel(Utils.format(element, false, true));
            this.setToolTip(Utils.format(element, true, JavaMembersAndHierarchyOptions.isShowFQN()));
            this.loadChildren(element, compilationInfo);
        }

        public AbstractMembersTreeNode getOwningTreeNode() {
            return this.owner;
        }

        @Override
        public FileObject getFileObject() {
            return this.fileObject;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return this.modifiers;
        }

        protected void setName(String name) {
            this.name = name;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        protected void setLabel(String label) {
            this.label = label;
        }

        @Override
        public String getFQNLabel() {
            return this.FQNlabel;
        }

        protected void setFQNLabel(String FQNlabel) {
            this.FQNlabel = FQNlabel;
        }

        @Override
        public String getTooltip() {
            return this.tooltip;
        }

        protected void setToolTip(String tooltip) {
            this.tooltip = tooltip;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        protected void setIcon(Icon icon) {
            this.icon = icon;
        }

        protected void setElementHandle(ElementHandle<? extends Element> elementHandle) {
            this.elementHandle = elementHandle;
        }

        @Override
        public ElementJavadoc getJavaDoc() {
            if (this.javaDoc == null) {
                if (this.fileObject == null) {
                    return null;
                }
                JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
                if (javaSource != null) {
                    try {
                        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController compilationController) throws Exception {
                                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                Element element = AbstractMembersTreeNode.this.elementHandle.resolve((CompilationInfo)compilationController);
                                AbstractMembersTreeNode.this.setJavaDoc(ElementJavadoc.create((CompilationInfo)compilationController, (Element)element));
                            }
                        }, true);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
            }
            return this.javaDoc;
        }

        public void setJavaDoc(ElementJavadoc javaDoc) {
            this.javaDoc = javaDoc;
        }

        @Override
        public ElementHandle getElementHandle() {
            return this.elementHandle;
        }

        @Override
        public ElementKind getElementKind() {
            return this.elementKind;
        }

        @Override
        public void gotoElement() {
            this.openElementHandle();
        }

        protected abstract void loadChildren(Element var1, CompilationInfo var2);

        @Override
        public String toString() {
            return JavaMembersAndHierarchyOptions.isShowFQN() ? this.getFQNLabel() : this.getLabel();
        }

        protected void openElementHandle() {
            if (this.fileObject == null) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaMembersModel.class, (String)"MSG_CouldNotOpenElement", (Object)this.getFQNLabel()));
                return;
            }
            if (this.elementHandle == null) {
                return;
            }
            if (!ElementOpen.open((ClasspathInfo)ClasspathInfo.create((FileObject)this.fileObject), this.elementHandle)) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaMembersModel.class, (String)"MSG_CouldNotOpenElement", (Object)this.getFQNLabel()));
            }
        }
    }
}

