/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.websvc.api.jaxws.project.JaxWsBuildScriptExtensionProvider;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.jaxwsmodel.project.J2seBuildScriptExtensionProvider;
import org.netbeans.modules.websvc.jaxwsmodel.project.TransformerUtils;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class J2seJaxWsOpenHook
extends ProjectOpenedHook {
    Project prj;

    public J2seJaxWsOpenHook(Project prj) {
        this.prj = prj;
    }

    protected void projectOpened() {
        AntBuildExtender ext = (AntBuildExtender)this.prj.getLookup().lookup(AntBuildExtender.class);
        JaxWsBuildScriptExtensionProvider extProvider = (JaxWsBuildScriptExtensionProvider)this.prj.getLookup().lookup(JaxWsBuildScriptExtensionProvider.class);
        if (ext != null && extProvider != null) {
            FileObject jaxws_build = this.prj.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
            try {
                AntBuildExtender.Extension extension = ext.getExtension("jaxws");
                FileObject jaxWsFo = WSUtils.findJaxWsFileObject(this.prj);
                if (jaxws_build == null || extension == null) {
                    if (jaxWsFo != null && WSUtils.hasClients(jaxWsFo)) {
                        extProvider.addJaxWsExtension(ext);
                        this.addJaxWsApiEndorsed(this.prj);
                    }
                } else if (jaxWsFo == null || !WSUtils.hasClients(jaxWsFo)) {
                    extProvider.removeJaxWsExtension(ext);
                } else {
                    FileObject project_xml = this.prj.getProjectDirectory().getFileObject("nbproject/project.xml");
                    if (project_xml != null) {
                        this.removeCompileDependencies(this.prj, project_xml, ext);
                    }
                    this.addJaxWsApiEndorsed(this.prj);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void projectClosed() {
    }

    private void removeCompileDependencies(Project prj, FileObject project_xml, AntBuildExtender ext) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)project_xml)));
        String line = null;
        boolean isOldVersion = false;
        while ((line = br.readLine()) != null) {
            if (!line.contains("wsimport-client-compile")) continue;
            isOldVersion = true;
            break;
        }
        br.close();
        if (isOldVersion) {
            TransformerUtils.transformClients(prj.getProjectDirectory(), J2seBuildScriptExtensionProvider.JAX_WS_STYLESHEET_RESOURCE);
            AntBuildExtender.Extension extension = ext.getExtension("jaxws");
            if (extension != null) {
                extension.removeDependency("-do-compile", "wsimport-client-compile");
                extension.removeDependency("-do-compile-single", "wsimport-client-compile");
                ProjectManager.getDefault().saveProject(prj);
            }
        }
    }

    private void addJaxWsApiEndorsed(Project prj) throws IOException {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)prj).getSourceGroups("java");
        if (sourceGroups != null && sourceGroups.length > 0) {
            WSUtils.addJaxWsApiEndorsed(prj, sourceGroups[0].getRootFolder());
        }
    }
}

