/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ExpandEnhancedForLoop {
    public static ErrorDescription run(HintContext ctx) {
        TreePath tp = ctx.getPath();
        EnhancedForLoopTree efl = (EnhancedForLoopTree)tp.getLeaf();
        long statementStart = ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getInfo().getCompilationUnit(), efl.getStatement());
        int caret = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)ctx.getInfo().getFileObject());
        if ((long)caret >= statementStart) {
            return null;
        }
        TypeMirror expressionType = ctx.getInfo().getTrees().getTypeMirror(new TreePath(tp, efl.getExpression()));
        if (expressionType == null || expressionType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        ExecutableElement iterator = ExpandEnhancedForLoop.findIterable(ctx.getInfo());
        Types t = ctx.getInfo().getTypes();
        if (iterator == null || !t.isSubtype((DeclaredType)expressionType, t.erasure(iterator.getEnclosingElement().asType()))) {
            return null;
        }
        FixImpl fix = new FixImpl(ctx.getInfo().getFileObject(), TreePathHandle.create((TreePath)tp, (CompilationInfo)ctx.getInfo()));
        List<FixImpl> fixes = Collections.singletonList(fix);
        return ErrorDescriptionFactory.createErrorDescription((Severity)ctx.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(ExpandEnhancedForLoop.class, (String)"ERR_ExpandEhancedForLoop"), fixes, (FileObject)ctx.getInfo().getFileObject(), (int)caret, (int)caret);
    }

    private static ExecutableElement findIterable(CompilationInfo info) {
        TypeElement iterable = info.getElements().getTypeElement("java.lang.Iterable");
        if (iterable == null) {
            return null;
        }
        for (ExecutableElement ee : ElementFilter.methodsIn(iterable.getEnclosedElements())) {
            if (!ee.getParameters().isEmpty() || !ee.getSimpleName().contentEquals("iterator")) continue;
            return ee;
        }
        return null;
    }

    private static final class FixImpl
    implements Fix {
        private final FileObject file;
        private final TreePathHandle forLoop;

        public FixImpl(FileObject file, TreePathHandle forLoop) {
            this.file = file;
            this.forLoop = forLoop;
        }

        public String getText() {
            return NbBundle.getMessage(ExpandEnhancedForLoop.class, (String)"ERR_ExpandEhancedForLoop");
        }

        public ChangeInfo implement() throws Exception {
            JavaSource source = JavaSource.forFileObject((FileObject)this.file);
            ModificationResult mr = source.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy copy) throws Exception {
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath path = FixImpl.this.forLoop.resolve((CompilationInfo)copy);
                    if (path == null) {
                        return;
                    }
                    EnhancedForLoopTree efl = (EnhancedForLoopTree)path.getLeaf();
                    TypeMirror expressionType = copy.getTrees().getTypeMirror(new TreePath(path, efl.getExpression()));
                    if (expressionType == null || expressionType.getKind() != TypeKind.DECLARED) {
                        return;
                    }
                    ExecutableElement getIterator = ExpandEnhancedForLoop.findIterable((CompilationInfo)copy);
                    ExecutableType getIteratorType = (ExecutableType)copy.getTypes().asMemberOf((DeclaredType)expressionType, getIterator);
                    TypeMirror iteratorType = Utilities.resolveCapturedType((CompilationInfo)copy, getIteratorType.getReturnType());
                    TreeMaker make = copy.getTreeMaker();
                    Tree iteratorTypeTree = make.Type(iteratorType);
                    MethodInvocationTree getIteratorTree = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect(efl.getExpression(), (CharSequence)"iterator"), Collections.emptyList());
                    MethodInvocationTree getNextTree = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"it"), (CharSequence)"next"), Collections.emptyList());
                    MethodInvocationTree hasNextTree = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"it"), (CharSequence)"hasNext"), Collections.emptyList());
                    VariableTree orig = efl.getVariable();
                    VariableTree init = make.Variable(orig.getModifiers(), (CharSequence)"it", iteratorTypeTree, (ExpressionTree)getIteratorTree);
                    VariableTree value = make.Variable(orig.getModifiers(), (CharSequence)orig.getName(), orig.getType(), (ExpressionTree)getNextTree);
                    LinkedList<? extends StatementTree> statements = new LinkedList<StatementTree>();
                    statements.add(0, value);
                    if (efl.getStatement() != null) {
                        switch (efl.getStatement().getKind()) {
                            case BLOCK: {
                                BlockTree oldBlock = (BlockTree)efl.getStatement();
                                statements.addAll(oldBlock.getStatements());
                                break;
                            }
                            case EMPTY_STATEMENT: {
                                break;
                            }
                            default: {
                                statements.add(efl.getStatement());
                            }
                        }
                    }
                    BlockTree newBlock = make.Block(statements, false);
                    ForLoopTree forLoop = make.ForLoop(Collections.singletonList(init), (ExpressionTree)hasNextTree, Collections.emptyList(), (StatementTree)newBlock);
                    copy.rewrite((Tree)efl, (Tree)forLoop);
                }
            });
            mr.commit();
            return null;
        }
    }
}

