/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.perf;

import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.MatcherUtilities;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class ManualArrayCopy {
    public static ErrorDescription arrayCopy(HintContext ctx) {
        String length;
        String startTarget;
        String startSource;
        TypeMirror sourceType = ctx.getInfo().getTrees().getTypeMirror(ctx.getVariables().get("$arr"));
        TypeMirror targetType = ctx.getInfo().getTrees().getTypeMirror(ctx.getVariables().get("$tarr"));
        if (!ctx.getInfo().getTypes().isSubtype(sourceType, targetType) || sourceType.getKind() == TypeKind.ERROR) {
            return null;
        }
        boolean isSZero = MatcherUtilities.matches(ctx, ctx.getVariables().get("$s"), "0");
        if (ctx.getVariables().containsKey("$o1")) {
            if (isSZero) {
                startSource = "0";
                startTarget = "$o1";
                length = "$len";
            } else {
                startSource = "$s";
                startTarget = "$o1 + $s";
                length = "$len - $s";
            }
        } else if (ctx.getVariables().containsKey("$o2")) {
            if (isSZero) {
                startSource = "0";
                startTarget = "$o2";
                length = "$len";
            } else {
                startSource = "$s";
                startTarget = "$s + $o2";
                length = "$len - $s";
            }
        } else if (isSZero) {
            startSource = "0";
            startTarget = "0";
            length = "$len";
        } else {
            startSource = "$s";
            startTarget = "$s";
            length = "$len - $s";
        }
        String fix = String.format("java.lang.System.arraycopy($arr, %s, $tarr, %s, %s);", startSource, startTarget, length);
        return ManualArrayCopy.compute(ctx, "manual-array-copy", fix);
    }

    public static ErrorDescription collection(HintContext ctx) {
        return ManualArrayCopy.compute(ctx, "manual-array-copy-coll", "$coll.addAll(java.util.Arrays.asList($arr));");
    }

    private static ErrorDescription compute(HintContext ctx, String key, String to) {
        String fixDisplayName = NbBundle.getMessage(ManualArrayCopy.class, (String)("FIX_" + key));
        Fix fix = JavaFix.rewriteFix(ctx, fixDisplayName, ctx.getPath(), to, new String[0]);
        String displayName = NbBundle.getMessage(ManualArrayCopy.class, (String)("ERR_" + key));
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), displayName, fix);
    }
}

