/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.impl.refactoring.Configuration;
import org.netbeans.modules.java.hints.jackpot.impl.refactoring.ConfigurationRenderer;
import org.netbeans.modules.java.hints.jackpot.impl.refactoring.ConfigurationsComboModel;
import org.netbeans.modules.java.hints.jackpot.impl.refactoring.OptionsFilter;
import org.netbeans.modules.java.hints.jackpot.impl.refactoring.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.options.Bundle;
import org.netbeans.modules.java.hints.options.DepScanningSettings;
import org.netbeans.modules.java.hints.options.HintsPanelLogic;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.options.editor.spi.OptionsFilter;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class HintsPanel
extends JPanel {
    private static final String DELETE = "delete";
    private static final RequestProcessor WORKER = new RequestProcessor(HintsPanel.class.getName(), 1, false, false);
    private HintsPanelLogic logic;
    private DefaultTreeModel errorTreeModel;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Utilities.ClassPathBasedHintWrapper cpBased;
    private HintMetadata toSelect = null;
    DefaultMutableTreeNode extraNode = new DefaultMutableTreeNode(NbBundle.getMessage(HintsPanel.class, (String)"CTL_DepScanning"));
    private boolean hasNewHints;
    private boolean confirmed;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JButton cancelEdit;
    private JComboBox configCombo;
    private JLabel configLabel;
    private JPanel configurationsPanel;
    private JPanel customizerPanel;
    private JLabel descriptionLabel;
    private JPanel descriptionPanel;
    private JScrollPane descriptionScrollPane;
    private JEditorPane descriptionTextArea;
    private JPanel detailsPanel;
    private JButton editScriptButton;
    private JPanel editingButtons;
    private JTree errorTree;
    private JButton exportButton;
    private JButton importButton;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JButton newButton;
    private JButton okButton;
    private JButton openInEditor;
    private JPanel optionsPanel;
    private JLabel refactoringsLabel;
    private JButton saveButton;
    private JScrollPane scriptScrollPane;
    private JEditorPane scriptTextArea;
    private JLabel searchLabel;
    private JPanel searchPanel;
    private JTextField searchTextField;
    private JComboBox severityComboBox;
    private JLabel severityLabel;
    private JCheckBox toProblemCheckBox;
    private JPanel treePanel;
    private final Map<HintMetadata, TreePath> hint2Path = new HashMap<HintMetadata, TreePath>();

    HintsPanel(final @NullAllowed org.netbeans.modules.options.editor.spi.OptionsFilter filter) {
        this.cpBased = null;
        WORKER.post(new Runnable(){

            @Override
            public void run() {
                RulesManager.getInstance();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HintsPanel.this.removeAll();
                        HintsPanel.this.init(filter, true, true);
                        HintsPanel.this.buttonsPanel.setVisible(false);
                        HintsPanel.this.searchPanel.setVisible(false);
                        HintsPanel.this.configurationsPanel.setVisible(false);
                    }
                });
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(Bundle.LBL_Loading()), new GridBagConstraints());
    }

    public HintsPanel(Configuration preselected, Utilities.ClassPathBasedHintWrapper cpBased) {
        this.cpBased = cpBased;
        this.init(null, false, true);
        this.configCombo.setSelectedItem(preselected);
    }

    public HintsPanel(HintMetadata preselected, Utilities.ClassPathBasedHintWrapper cpBased) {
        this.cpBased = cpBased;
        this.init(null, false, false);
        this.select(preselected);
        this.configurationsPanel.setVisible(false);
    }

    public boolean hasNewHints() {
        return this.hasNewHints;
    }

    private void init(@NullAllowed org.netbeans.modules.options.editor.spi.OptionsFilter filter, boolean allHints, boolean showCheckBoxes) {
        this.initComponents();
        this.scriptScrollPane.setVisible(false);
        OptionsFilter f = null;
        if (!allHints && filter == null) {
            f = new OptionsFilter(this.searchTextField.getDocument(), new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        this.configCombo.setModel(new ConfigurationsComboModel(true));
        this.configCombo.setRenderer(new ConfigurationRenderer());
        if (allHints) {
            this.configCombo.setSelectedItem(null);
        }
        this.descriptionTextArea.setContentType("text/html");
        this.scriptTextArea.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/x-javahints"));
        this.scriptTextArea.setEditable(true);
        this.errorTree.setCellRenderer(showCheckBoxes ? new CheckBoxRenderer() : new JLabelRenderer());
        this.errorTree.setRootVisible(false);
        this.errorTree.setShowsRootHandles(true);
        this.errorTree.getSelectionModel().setSelectionMode(1);
        this.errorTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.handleClick(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handleClick(e);
            }

            private void handleClick(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DefaultMutableTreeNode o;
                    Point p = e.getPoint();
                    TreePath path = HintsPanel.this.errorTree.getPathForLocation(e.getPoint().x, e.getPoint().y);
                    if (path != null && (o = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof HintMetadata) {
                        HintMetadata hint = (HintMetadata)o.getUserObject();
                        if (hint.category.equals("custom")) {
                            JPopupMenu popup = new JPopupMenu();
                            popup.add(new JMenuItem(new RenameHint(o, hint, path)));
                            popup.add(new JMenuItem(new RemoveHint(o, hint)));
                            popup.show(HintsPanel.this.errorTree, e.getX(), e.getY());
                        }
                    }
                }
            }
        });
        this.errorTree.getInputMap().put(KeyStroke.getKeyStroke(127, 0), DELETE);
        this.errorTree.getActionMap().put(DELETE, new RemoveHint(null, null));
        this.toProblemCheckBox.setVisible(false);
        this.errorTreeModel = this.constructTM(allHints ? this.filterCustom(RulesManager.getInstance().allHints.keySet()) : Utilities.getBatchSupportedHints(this.cpBased).keySet(), allHints);
        if (filter != null) {
            filter.installFilteringModel(this.errorTree, (TreeModel)this.errorTreeModel, (OptionsFilter.Acceptor)new AcceptorImpl());
        } else if (f != null) {
            f.installFilteringModel(this.errorTree, this.errorTreeModel, new AcceptorImpl());
        } else {
            this.errorTree.setModel(this.errorTreeModel);
        }
        this.initialized.set(true);
        this.update();
        if (this.toSelect != null) {
            this.select(this.toSelect);
            this.toSelect = null;
        }
        boolean editEnabled = !allHints && FileUtil.getConfigFile((String)"org-netbeans-modules-java-hints/templates/HintSample.hint") != null;
        this.newButton.setVisible(editEnabled);
        this.importButton.setVisible(false);
        this.exportButton.setVisible(false);
        this.editScriptButton.setVisible(editEnabled);
        this.editingButtons.setVisible(false);
        this.severityComboBox.setVisible(allHints);
        this.severityLabel.setVisible(allHints);
        this.validate();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.treePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.errorTree = new EditableJTree();
        this.detailsPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.severityLabel = new JLabel();
        this.severityComboBox = new JComboBox();
        this.toProblemCheckBox = new JCheckBox();
        this.customizerPanel = new JPanel();
        this.descriptionPanel = new JPanel();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextArea = new JEditorPane();
        this.descriptionLabel = new JLabel();
        this.editingButtons = new JPanel();
        this.saveButton = new JButton();
        this.cancelEdit = new JButton();
        this.openInEditor = new JButton();
        this.scriptScrollPane = new JScrollPane();
        this.scriptTextArea = new JEditorPane();
        this.buttonsPanel = new JPanel();
        this.newButton = new JButton();
        this.importButton = new JButton();
        this.exportButton = new JButton();
        this.okButton = new JButton();
        this.editScriptButton = new JButton();
        this.cancelButton = new JButton();
        this.configurationsPanel = new JPanel();
        this.configLabel = new JLabel();
        this.configCombo = new JComboBox();
        this.searchPanel = new JPanel();
        this.refactoringsLabel = new JLabel();
        this.searchLabel = new JLabel();
        this.searchTextField = new JTextField();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(320);
        this.jSplitPane1.setOpaque(false);
        this.treePanel.setOpaque(false);
        this.treePanel.setLayout(new BorderLayout());
        this.errorTree.setEditable(true);
        this.jScrollPane1.setViewportView(this.errorTree);
        this.errorTree.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.errorTree.AccessibleContext.accessibleName"));
        this.errorTree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.errorTree.AccessibleContext.accessibleDescription"));
        this.treePanel.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.treePanel);
        this.detailsPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.detailsPanel.setOpaque(false);
        this.optionsPanel.setOpaque(false);
        this.optionsPanel.setLayout(new GridBagLayout());
        this.severityLabel.setLabelFor(this.severityComboBox);
        Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_ShowAs_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.optionsPanel.add((Component)this.severityLabel, gridBagConstraints);
        this.severityLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.severityLabel.AccessibleContext.accessibleDescription"));
        this.severityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.optionsPanel.add((Component)this.severityComboBox, new GridBagConstraints());
        this.severityComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"AN_Show_As_Combo"));
        this.severityComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"AD_Show_As_Combo"));
        Mnemonics.setLocalizedText((AbstractButton)this.toProblemCheckBox, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_InTasklist_CheckBox"));
        this.toProblemCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.toProblemCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.optionsPanel.add((Component)this.toProblemCheckBox, gridBagConstraints);
        this.customizerPanel.setOpaque(false);
        this.customizerPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.optionsPanel.add((Component)this.customizerPanel, gridBagConstraints);
        this.descriptionPanel.setOpaque(false);
        this.descriptionPanel.setLayout(new GridBagLayout());
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setPreferredSize(new Dimension(100, 50));
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.descriptionPanel.add((Component)this.descriptionScrollPane, gridBagConstraints);
        this.descriptionLabel.setLabelFor(this.descriptionTextArea);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_Description_Border"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.descriptionPanel.add((Component)this.descriptionLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.saveButton, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.saveButton.text"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.saveButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cancelEdit, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.cancelEdit.text"));
        this.cancelEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.cancelEditActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.openInEditor, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.openInEditor.text"));
        this.openInEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.openInEditorActionPerformed(evt);
            }
        });
        GroupLayout editingButtonsLayout = new GroupLayout(this.editingButtons);
        this.editingButtons.setLayout(editingButtonsLayout);
        editingButtonsLayout.setHorizontalGroup(editingButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, editingButtonsLayout.createSequentialGroup().addComponent(this.openInEditor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 125, Short.MAX_VALUE).addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelEdit)));
        editingButtonsLayout.setVerticalGroup(editingButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editingButtonsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.openInEditor).addComponent(this.cancelEdit).addComponent(this.saveButton)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.descriptionPanel.add((Component)this.editingButtons, gridBagConstraints);
        this.scriptTextArea.setEditable(false);
        this.scriptTextArea.setPreferredSize(new Dimension(100, 50));
        this.scriptScrollPane.setViewportView(this.scriptTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.descriptionPanel.add((Component)this.scriptScrollPane, gridBagConstraints);
        GroupLayout detailsPanelLayout = new GroupLayout(this.detailsPanel);
        this.detailsPanel.setLayout(detailsPanelLayout);
        detailsPanelLayout.setHorizontalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optionsPanel, -1, 426, Short.MAX_VALUE).addComponent(this.descriptionPanel, -1, 426, Short.MAX_VALUE));
        detailsPanelLayout.setVerticalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addComponent(this.optionsPanel, -1, 98, Short.MAX_VALUE).addGap(12, 12, 12).addComponent(this.descriptionPanel, -1, 176, Short.MAX_VALUE)));
        this.jSplitPane1.setRightComponent(this.detailsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.newButton.text"));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.newButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.importButton, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.importButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.exportButton, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.exportButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.okButton.text"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.okButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editScriptButton, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.editScriptButton.text"));
        this.editScriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.editScriptButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonsPanelLayout = new GroupLayout(this.buttonsPanel);
        this.buttonsPanel.setLayout(buttonsPanelLayout);
        buttonsPanelLayout.setHorizontalGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonsPanelLayout.createSequentialGroup().addComponent(this.newButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exportButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 167, Short.MAX_VALUE).addComponent(this.editScriptButton).addGap(35, 35, 35).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)));
        buttonsPanelLayout.setVerticalGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonsPanelLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newButton).addComponent(this.importButton).addComponent(this.exportButton).addComponent(this.editScriptButton).addComponent(this.cancelButton).addComponent(this.okButton))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.buttonsPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.configLabel.text"));
        this.configCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.configComboActionPerformed(evt);
            }
        });
        GroupLayout configurationsPanelLayout = new GroupLayout(this.configurationsPanel);
        this.configurationsPanel.setLayout(configurationsPanelLayout);
        configurationsPanelLayout.setHorizontalGroup(configurationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(configurationsPanelLayout.createSequentialGroup().addComponent(this.configLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configCombo, 0, 658, Short.MAX_VALUE)));
        configurationsPanelLayout.setVerticalGroup(configurationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(configurationsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configLabel).addComponent(this.configCombo, -2, -1, -2)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.configurationsPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.refactoringsLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.refactoringsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.searchLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.searchLabel.text"));
        GroupLayout searchPanelLayout = new GroupLayout(this.searchPanel);
        this.searchPanel.setLayout(searchPanelLayout);
        searchPanelLayout.setHorizontalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, searchPanelLayout.createSequentialGroup().addComponent(this.refactoringsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 508, Short.MAX_VALUE).addComponent(this.searchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchTextField, -2, 121, -2)));
        searchPanelLayout.setVerticalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchTextField, -2, -1, -2).addComponent(this.searchLabel).addComponent(this.refactoringsLabel))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.searchPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.AccessibleContext.accessibleDescription"));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.applyChanges();
        this.confirmed = true;
        this.getRootPane().getParent().setVisible(false);
    }

    private void configComboActionPerformed(ActionEvent evt) {
        if (this.configCombo.getSelectedItem() instanceof ActionListener) {
            ((ActionListener)this.configCombo.getSelectedItem()).actionPerformed(evt);
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        try {
            FileObject tempFO = FileUtil.getConfigFile((String)"org-netbeans-modules-java-hints/templates/HintSample.hint");
            FileObject folderFO = FileUtil.getConfigFile((String)"rules");
            if (folderFO == null) {
                folderFO = FileUtil.getConfigRoot().createFolder("rules");
            }
            DataFolder folder = (DataFolder)DataObject.find((FileObject)folderFO);
            DataObject template = DataObject.find((FileObject)tempFO);
            DataObject newIfcDO = template.createFromTemplate(folder, "Inspection");
            RulesManager.getInstance().reload();
            this.errorTreeModel = this.constructTM(Utilities.getBatchSupportedHints(this.cpBased).keySet(), false);
            this.errorTree.setModel(this.errorTreeModel);
            this.logic.errorTreeModel = this.errorTreeModel;
            this.select(this.getHintByName(newIfcDO.getPrimaryFile().getNameExt()));
            this.hasNewHints = true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void editScriptButtonActionPerformed(ActionEvent evt) {
        this.descriptionScrollPane.setVisible(false);
        this.scriptScrollPane.setVisible(true);
        this.editScriptButton.setVisible(false);
        this.editingButtons.setVisible(true);
        this.optionsPanel.setVisible(false);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_Script_Border"));
        DataObject dob = this.getDataObject(this.getSelectedHint());
        EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
        try {
            this.scriptTextArea.setDocument(ec.openDocument());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.newButton.setEnabled(false);
        this.searchTextField.setEnabled(false);
        this.configCombo.setEnabled(false);
        this.errorTree.setEnabled(false);
        this.okButton.setEnabled(false);
        this.validate();
    }

    private void cancelEditActionPerformed(ActionEvent evt) {
        this.descriptionScrollPane.setVisible(true);
        this.scriptScrollPane.setVisible(false);
        this.optionsPanel.setVisible(true);
        this.editingButtons.setVisible(false);
        this.editScriptButton.setVisible(true);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_Description_Border"));
        this.okButton.setEnabled(true);
        this.newButton.setEnabled(true);
        this.searchTextField.setEnabled(true);
        this.configCombo.setEnabled(true);
        this.errorTree.setEnabled(true);
        this.logic.valueChanged(null);
    }

    private void openInEditorActionPerformed(ActionEvent evt) {
        this.applyChanges();
        this.getRootPane().getParent().getParent().setVisible(false);
        DataObject dob = this.getDataObject(this.getSelectedHint());
        EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
        ec.open();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        HintMetadata selectedHint = this.getSelectedHint();
        String selectedHintId = selectedHint.id;
        DataObject dob = this.getDataObject(selectedHint);
        EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
        try {
            ec.saveDocument();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        RulesManager.getInstance().allHints.clear();
        RulesManager.getInstance().reload();
        this.errorTreeModel = this.constructTM(Utilities.getBatchSupportedHints(this.cpBased).keySet(), false);
        this.errorTree.setModel(this.errorTreeModel);
        this.select(this.getHintByName(selectedHintId));
        this.cancelEditActionPerformed(evt);
        this.hasNewHints = true;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.getRootPane().getParent().setVisible(false);
    }

    private HintMetadata getHintByName(String name) {
        for (HintMetadata hintMetadata : Utilities.getBatchSupportedHints(this.cpBased).keySet()) {
            if (!hintMetadata.id.startsWith(name)) continue;
            return hintMetadata;
        }
        return null;
    }

    synchronized void update() {
        if (!this.initialized.get()) {
            return;
        }
        if (this.logic != null) {
            this.logic.disconnect();
        }
        this.logic = new HintsPanelLogic();
        this.logic.connect(this.errorTree, this.errorTreeModel, this.severityLabel, this.severityComboBox, this.toProblemCheckBox, this.customizerPanel, this.descriptionTextArea, this.configCombo, this.editScriptButton);
    }

    void cancel() {
        if (!this.initialized.get()) {
            return;
        }
        this.logic.disconnect();
        this.logic = null;
    }

    boolean isChanged() {
        return this.logic != null ? this.logic.isChanged() : false;
    }

    void applyChanges() {
        if (!this.initialized.get()) {
            return;
        }
        this.logic.applyChanges();
        this.logic.disconnect();
        this.logic = null;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    static String getFileObjectLocalizedName(FileObject fo) {
        Object o = fo.getAttribute("SystemFileSystem.localizingBundle");
        if (o instanceof String) {
            String bundleName = (String)o;
            try {
                ResourceBundle rb = NbBundle.getBundle((String)bundleName);
                String localizedName = rb.getString(fo.getPath());
                return localizedName;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return fo.getPath();
    }

    private DefaultTreeModel constructTM(Collection<? extends HintMetadata> metadata, boolean allHints) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        TreeMap<HintsPanelLogic.HintCategory, TreeSet<HintMetadata>> cat2Hints = new TreeMap<HintsPanelLogic.HintCategory, TreeSet<HintMetadata>>(new Comparator<HintsPanelLogic.HintCategory>(){

            @Override
            public int compare(HintsPanelLogic.HintCategory o1, HintsPanelLogic.HintCategory o2) {
                return HintsPanel.compare(o1.displayName, o2.displayName);
            }
        });
        HashMap<String, HintsPanelLogic.HintCategory> cat2CatDesc = new HashMap<String, HintsPanelLogic.HintCategory>();
        for (HintMetadata hintMetadata : metadata) {
            TreeSet<HintMetadata> catNode;
            if (hintMetadata.options.contains((Object)HintMetadata.Options.NON_GUI)) continue;
            HintsPanelLogic.HintCategory cat = (HintsPanelLogic.HintCategory)cat2CatDesc.get(hintMetadata.category);
            if (cat == null) {
                cat = new HintsPanelLogic.HintCategory(hintMetadata.category);
                cat2CatDesc.put(hintMetadata.category, cat);
            }
            if ((catNode = (TreeSet<HintMetadata>)cat2Hints.get(cat)) == null) {
                catNode = new TreeSet<HintMetadata>(new Comparator<HintMetadata>(){

                    @Override
                    public int compare(HintMetadata o1, HintMetadata o2) {
                        return o1.displayName.compareToIgnoreCase(o2.displayName);
                    }
                });
                cat2Hints.put(cat, catNode);
            }
            catNode.add(hintMetadata);
        }
        for (Map.Entry entry : cat2Hints.entrySet()) {
            DefaultMutableTreeNode catNode = new DefaultMutableTreeNode(entry.getKey());
            for (HintMetadata hm : (Collection)entry.getValue()) {
                DefaultMutableTreeNode hmNode = new DefaultMutableTreeNode(hm);
                catNode.add(hmNode);
                this.hint2Path.put(hm, new TreePath(new Object[]{root, catNode, hmNode}));
            }
            root.add(catNode);
        }
        if (allHints) {
            root.add(this.extraNode);
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(root){

            @Override
            public void valueForPathChanged(TreePath path, Object newValue) {
                DefaultMutableTreeNode o = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (o.getUserObject() instanceof HintMetadata) {
                    try {
                        HintMetadata hint = (HintMetadata)o.getUserObject();
                        HintsPanel.this.getDataObject(hint).rename((String)newValue);
                        RulesManager.getInstance().allHints.clear();
                        RulesManager.getInstance().reload();
                        HintsPanel.this.errorTreeModel = HintsPanel.this.constructTM(Utilities.getBatchSupportedHints(HintsPanel.this.cpBased).keySet(), false);
                        HintsPanel.this.errorTree.setModel(HintsPanel.this.errorTreeModel);
                        HintsPanel.this.select(HintsPanel.this.getHintByName((String)newValue));
                        HintsPanel.this.hasNewHints = true;
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(HintsPanel.this.errorTree, NbBundle.getMessage(HintsPanel.class, (String)"ERR_CannotRename", (Object)newValue));
                        HintsPanel.this.errorTree.startEditingAtPath(path);
                    }
                }
            }
        };
        return defaultTreeModel;
    }

    void select(HintMetadata hm) {
        if (this.errorTree == null) {
            this.toSelect = hm;
            return;
        }
        TreePath path = this.hint2Path.get(hm);
        this.errorTree.setSelectionPath(path);
        this.errorTree.scrollPathToVisible(path);
    }

    private static int compare(String s1, String s2) {
        return HintsPanel.clearNonAlpha(s1).compareToIgnoreCase(HintsPanel.clearNonAlpha(s2));
    }

    private static String clearNonAlpha(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        for (char c : str.toCharArray()) {
            if (!Character.isLetter(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private DataObject getDataObject(HintMetadata selectedHint) {
        String fileName = selectedHint.id.indexOf(45) != -1 ? selectedHint.id.substring(0, selectedHint.id.lastIndexOf(45)) : selectedHint.id;
        FileObject fo = FileUtil.getConfigFile((String)("rules/" + fileName));
        try {
            return DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private Collection<? extends HintMetadata> filterCustom(Set<HintMetadata> keySet) {
        ArrayList<HintMetadata> list = new ArrayList<HintMetadata>();
        for (HintMetadata hint : keySet) {
            if ("custom".equals(hint.category)) continue;
            list.add(hint);
        }
        return list;
    }

    public Configuration getSelectedConfiguration() {
        return (Configuration)this.configCombo.getSelectedItem();
    }

    public HintMetadata getSelectedHint() {
        TreePath selectionPath = this.errorTree.getSelectionModel().getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)((MutableTreeNode)((TreeNode)selectionPath.getLastPathComponent()));
        if (lastPathComponent != null && lastPathComponent.getUserObject() instanceof HintMetadata) {
            return (HintMetadata)lastPathComponent.getUserObject();
        }
        return null;
    }

    private static class EditableJTree
    extends JTree {
        @Override
        public boolean isPathEditable(TreePath path) {
            DefaultMutableTreeNode o = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (o.getUserObject() instanceof HintMetadata) {
                HintMetadata hint = (HintMetadata)o.getUserObject();
                if (hint.category.equals("custom")) {
                    return true;
                }
            }
            return false;
        }
    }

    private class RenameHint
    extends AbstractAction {
        HintMetadata hint;
        DefaultMutableTreeNode node;
        TreePath path;

        public RenameHint(DefaultMutableTreeNode node, HintMetadata hint, TreePath path) {
            super(NbBundle.getMessage(RemoveHint.class, (String)"CTL_Rename"));
            this.hint = hint;
            this.node = node;
            this.path = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HintsPanel.this.errorTree.startEditingAtPath(this.path);
        }
    }

    private class RemoveHint
    extends AbstractAction {
        HintMetadata hint;
        DefaultMutableTreeNode node;

        public RemoveHint(DefaultMutableTreeNode node, HintMetadata hint) {
            super(NbBundle.getMessage(RemoveHint.class, (String)"CTL_Delete"));
            this.hint = hint;
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (this.hint == null) {
                    this.hint = HintsPanel.this.getSelectedHint();
                }
                if (0 == JOptionPane.showConfirmDialog(HintsPanel.this.errorTree, NbBundle.getMessage(HintsPanel.class, (String)"MSG_DeleteConfirmMessage", (Object)this.hint.displayName), NbBundle.getMessage(HintsPanel.class, (String)"MSG_DeleteConfirmTitle"), 0)) {
                    HintsPanel.this.getDataObject(this.hint).delete();
                    RulesManager.getInstance().allHints.clear();
                    RulesManager.getInstance().reload();
                    HintsPanel.this.errorTreeModel = HintsPanel.this.constructTM(Utilities.getBatchSupportedHints(HintsPanel.this.cpBased).keySet(), false);
                    HintsPanel.this.errorTree.setModel(HintsPanel.this.errorTreeModel);
                    HintsPanel.this.hasNewHints = true;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static final class AcceptorImpl
    implements OptionsFilter.Acceptor,
    OptionsFilter.Acceptor {
        private AcceptorImpl() {
        }

        @Override
        public boolean accept(Object originalTreeNode, String filterText) {
            if (filterText.isEmpty()) {
                return true;
            }
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)originalTreeNode;
            HintMetadata hm = (HintMetadata)n.getUserObject();
            filterText = filterText.toLowerCase();
            if (hm.displayName.toLowerCase().contains(filterText)) {
                return true;
            }
            if (hm.description.toLowerCase().contains(filterText)) {
                return true;
            }
            for (String string : hm.suppressWarnings) {
                if (!string.toLowerCase().contains(filterText)) continue;
                return true;
            }
            return false;
        }
    }

    class CheckBoxRenderer
    implements TreeCellRenderer {
        private JCheckBox renderer = new JCheckBox();
        private DefaultTreeCellRenderer dr = new DefaultTreeCellRenderer();

        CheckBoxRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.renderer.setBackground(selected ? this.dr.getBackgroundSelectionColor() : this.dr.getBackgroundNonSelectionColor());
            this.renderer.setForeground(selected ? this.dr.getTextSelectionColor() : this.dr.getTextNonSelectionColor());
            this.renderer.setFont(this.renderer.getFont().deriveFont(0));
            Object data = ((DefaultMutableTreeNode)value).getUserObject();
            if (data instanceof HintsPanelLogic.HintCategory) {
                HintsPanelLogic.HintCategory cat = (HintsPanelLogic.HintCategory)data;
                this.renderer.setText(cat.displayName);
                if (HintsPanel.this.logic != null) {
                    this.renderer.setSelected(HintsPanel.this.logic.isSelected((DefaultMutableTreeNode)value));
                }
            } else if (data instanceof HintMetadata) {
                HintMetadata treeRule = (HintMetadata)data;
                if (treeRule.options.contains((Object)HintMetadata.Options.QUERY)) {
                    this.renderer.setFont(this.renderer.getFont().deriveFont(2));
                }
                this.renderer.setText(treeRule.displayName);
                if (HintsPanel.this.logic != null) {
                    Preferences node = HintsPanel.this.logic.getCurrentPrefernces(treeRule.id);
                    this.renderer.setSelected(HintsSettings.isEnabled(treeRule, node));
                }
            } else {
                this.renderer.setText(value.toString());
                if (value == HintsPanel.this.extraNode && HintsPanel.this.logic != null) {
                    this.renderer.setSelected(HintsPanel.this.logic.getCurrentDependencyTracking() != DepScanningSettings.DependencyTracking.DISABLED);
                }
            }
            return this.renderer;
        }
    }

    class JLabelRenderer
    implements TreeCellRenderer {
        private JLabel renderer = new JLabel();
        private DefaultTreeCellRenderer dr = new DefaultTreeCellRenderer();

        JLabelRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.renderer.setBackground(selected ? this.dr.getBackgroundSelectionColor() : this.dr.getBackgroundNonSelectionColor());
            this.renderer.setForeground(selected ? this.dr.getTextSelectionColor() : this.dr.getTextNonSelectionColor());
            this.renderer.setFont(this.renderer.getFont().deriveFont(0));
            this.renderer.setOpaque(true);
            Object data = ((DefaultMutableTreeNode)value).getUserObject();
            if (data instanceof HintsPanelLogic.HintCategory) {
                HintsPanelLogic.HintCategory cat = (HintsPanelLogic.HintCategory)data;
                this.renderer.setText(cat.displayName);
            } else if (data instanceof HintMetadata) {
                HintMetadata treeRule = (HintMetadata)data;
                if (treeRule.options.contains((Object)HintMetadata.Options.QUERY)) {
                    this.renderer.setFont(this.renderer.getFont().deriveFont(2));
                }
                this.renderer.setText(treeRule.displayName);
            } else {
                this.renderer.setText(value.toString());
            }
            return this.renderer;
        }
    }
}

