/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Modifier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.java.hints.introduce.ErrorLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class IntroduceVariablePanel
extends JPanel {
    private static final int ACCESS_PUBLIC = 1;
    private static final int ACCESS_PROTECTED = 2;
    private static final int ACCESS_DEFAULT = 3;
    private static final int ACCESS_PRIVATE = 4;
    private boolean introduceConstant;
    private JButton btnOk;
    private JRadioButton accessDefault;
    private ButtonGroup accessGroup;
    private JRadioButton accessPrivate;
    private JRadioButton accessProtected;
    private JRadioButton accessPublic;
    private JCheckBox declareFinal;
    private JLabel errorLabel;
    private JLabel lblAccess;
    private JLabel lblName;
    private JTextField name;
    private JCheckBox replaceAll;
    private Set<Modifier> testAccess;

    public IntroduceVariablePanel(int numDuplicates, String defaultName, boolean introduceConstant, boolean variableRewrite, JButton btnOk) {
        this.btnOk = btnOk;
        this.initComponents();
        this.introduceConstant = introduceConstant;
        this.lblAccess.setVisible(introduceConstant);
        this.accessPublic.setVisible(introduceConstant);
        this.accessProtected.setVisible(introduceConstant);
        this.accessDefault.setVisible(introduceConstant);
        this.accessPrivate.setVisible(introduceConstant);
        Preferences pref = this.getPreferences(introduceConstant);
        if (numDuplicates == 1) {
            this.replaceAll.setEnabled(false);
            this.replaceAll.setSelected(false);
        } else {
            this.replaceAll.setEnabled(true);
            this.replaceAll.setText(this.replaceAll.getText() + " (" + numDuplicates + ")");
            this.replaceAll.setSelected(pref.getBoolean("replaceAll", true));
        }
        this.declareFinal.setEnabled(!introduceConstant);
        this.declareFinal.setSelected(introduceConstant ? true : pref.getBoolean("declareFinal", true));
        if (!introduceConstant) {
            int accessModifier = pref.getInt("accessModifier", 1);
            switch (accessModifier) {
                case 1: {
                    this.accessPublic.setSelected(true);
                    break;
                }
                case 2: {
                    this.accessProtected.setSelected(true);
                    break;
                }
                case 3: {
                    this.accessDefault.setSelected(true);
                    break;
                }
                case 4: {
                    this.accessPrivate.setSelected(true);
                }
            }
        }
        this.name.setText(defaultName);
        if (this.name != null && defaultName.trim().length() > 0 && !variableRewrite) {
            this.name.setCaretPosition(defaultName.length());
            this.name.setSelectionStart(0);
            this.name.setSelectionEnd(defaultName.length());
        }
        if (variableRewrite) {
            this.name.setEditable(false);
        }
    }

    private Preferences getPreferences(boolean introduceConstant) {
        return NbPreferences.forModule(IntroduceVariablePanel.class).node(introduceConstant ? "introduceConstant" : "introduceVariable");
    }

    private JLabel createErrorLabel() {
        ErrorLabel.Validator validator = new ErrorLabel.Validator(){

            @Override
            public String validate(String text) {
                if (null == text || text.length() == 0) {
                    return "";
                }
                if (!Utilities.isJavaIdentifier((String)text)) {
                    return IntroduceVariablePanel.this.getDefaultErrorMessage(text);
                }
                return null;
            }
        };
        final ErrorLabel errorLabel = new ErrorLabel(this.name.getDocument(), validator);
        errorLabel.addPropertyChangeListener("isValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                IntroduceVariablePanel.this.btnOk.setEnabled(errorLabel.isInputTextValid());
            }
        });
        return errorLabel;
    }

    String getDefaultErrorMessage(String inputText) {
        return "'" + inputText + "' is not a valid identifier";
    }

    private void initComponents() {
        this.accessGroup = new ButtonGroup();
        this.lblName = new JLabel();
        this.name = new JTextField();
        this.replaceAll = new JCheckBox();
        this.declareFinal = new JCheckBox();
        this.lblAccess = new JLabel();
        this.accessPublic = new JRadioButton();
        this.accessProtected = new JRadioButton();
        this.accessDefault = new JRadioButton();
        this.accessPrivate = new JRadioButton();
        this.errorLabel = this.createErrorLabel();
        this.lblName.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getBundle(IntroduceVariablePanel.class).getString("LBL_Name"));
        this.name.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.replaceAll, (String)NbBundle.getBundle(IntroduceVariablePanel.class).getString("LBL_ReplaceAll"));
        this.replaceAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.replaceAll.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.declareFinal, (String)NbBundle.getBundle(IntroduceVariablePanel.class).getString("LBL_DeclareFinal"));
        this.declareFinal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.declareFinal.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.lblAccess, (String)NbBundle.getMessage(IntroduceVariablePanel.class, (String)"LBL_Access"));
        this.accessGroup.add(this.accessPublic);
        this.accessPublic.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPublic, (String)NbBundle.getMessage(IntroduceVariablePanel.class, (String)"LBL_public"));
        this.accessPublic.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessPublic.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessProtected);
        Mnemonics.setLocalizedText((AbstractButton)this.accessProtected, (String)NbBundle.getMessage(IntroduceVariablePanel.class, (String)"LBL_protected"));
        this.accessProtected.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessProtected.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessDefault);
        Mnemonics.setLocalizedText((AbstractButton)this.accessDefault, (String)NbBundle.getMessage(IntroduceVariablePanel.class, (String)"LBL_Default"));
        this.accessDefault.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessDefault.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessPrivate);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPrivate, (String)NbBundle.getMessage(IntroduceVariablePanel.class, (String)"LBL_private"));
        this.accessPrivate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessPrivate.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"jLabel1");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel, -1, 474, Short.MAX_VALUE).addComponent(this.replaceAll).addComponent(this.declareFinal).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAccess).addComponent(this.lblName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.name, -1, 418, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.accessPublic).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessProtected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessPrivate))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblName).addComponent(this.name, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblAccess).addComponent(this.accessPublic).addComponent(this.accessProtected).addComponent(this.accessDefault).addComponent(this.accessPrivate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.declareFinal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 32, Short.MAX_VALUE).addComponent(this.errorLabel).addContainerGap()));
        this.name.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_Name"));
        this.replaceAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_ReplaceAllOccurences"));
        this.declareFinal.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_DeclareFinal"));
        this.accessPublic.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_Public"));
        this.accessProtected.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_Protected"));
        this.accessDefault.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_Default"));
        this.accessPrivate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_Private"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_Dialog"));
    }

    public String getVariableName() {
        return this.name.getText();
    }

    public boolean isReplaceAll() {
        boolean ret = this.replaceAll.isSelected();
        this.getPreferences(this.introduceConstant).putBoolean("replaceAll", ret);
        return ret;
    }

    public boolean isDeclareFinal() {
        boolean ret = this.declareFinal.isSelected();
        this.getPreferences(this.introduceConstant).putBoolean("declareFinal", ret);
        return ret;
    }

    public Set<Modifier> getAccess() {
        Set<Modifier> set;
        int val;
        if (this.testAccess != null) {
            return this.testAccess;
        }
        if (this.accessPublic.isSelected()) {
            val = 1;
            set = EnumSet.of(Modifier.PUBLIC);
        } else if (this.accessProtected.isSelected()) {
            val = 2;
            set = EnumSet.of(Modifier.PROTECTED);
        } else if (this.accessDefault.isSelected()) {
            val = 3;
            set = Collections.emptySet();
        } else {
            val = 4;
            set = EnumSet.of(Modifier.PRIVATE);
        }
        this.getPreferences(this.introduceConstant).putInt("accessModifier", val);
        return set;
    }

    void setVariableName(String name) {
        this.name.setText(name);
    }

    void setDeclareFinal(boolean declareFinal) {
        this.declareFinal.setSelected(declareFinal);
    }

    void setReplaceAll(boolean replaceAll) {
        this.replaceAll.setSelected(replaceAll);
    }

    void setAccess(Set<Modifier> access) {
        this.testAccess = access;
    }
}

