/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.awt.Color;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.JButton;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.api.java.source.support.SelectionAwareJavaSourceTaskFactory;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.JavaHintsPositionRefresher;
import org.netbeans.modules.java.hints.introduce.CopyFinder;
import org.netbeans.modules.java.hints.introduce.Flow;
import org.netbeans.modules.java.hints.introduce.IntroduceFieldPanel;
import org.netbeans.modules.java.hints.introduce.IntroduceKind;
import org.netbeans.modules.java.hints.introduce.IntroduceMethodPanel;
import org.netbeans.modules.java.hints.introduce.IntroduceParameterFix;
import org.netbeans.modules.java.hints.introduce.IntroduceVariablePanel;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Union2;

public class IntroduceHint
implements CancellableTask<CompilationInfo> {
    private AtomicBoolean cancel = new AtomicBoolean();
    private static final Set<TypeKind> NOT_ACCEPTED_TYPES = EnumSet.of(TypeKind.ERROR, TypeKind.NONE, TypeKind.OTHER, TypeKind.VOID, TypeKind.EXECUTABLE);
    private static final Set<JavaTokenId> WHITESPACES = EnumSet.of(JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.JAVADOC_COMMENT);
    private static final Set<ElementKind> LOCAL_VARIABLES = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);
    static final AttributeSet DUPE = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, Color.GRAY});

    static int[] ignoreWhitespaces(CompilationInfo ci, int start, int end) {
        TokenSequence ts = ci.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        if (ts == null) {
            return new int[]{start, end};
        }
        ts.move(start);
        if (ts.moveNext()) {
            boolean wasMoveNext = true;
            while (WHITESPACES.contains(ts.token().id()) && (wasMoveNext = ts.moveNext())) {
            }
            if (wasMoveNext && ts.offset() > start) {
                start = ts.offset();
            }
        }
        ts.move(end);
        while (ts.movePrevious() && WHITESPACES.contains(ts.token().id()) && ts.offset() < end) {
            end = ts.offset();
        }
        return new int[]{start, end};
    }

    static TreePath validateSelection(CompilationInfo ci, int start, int end) {
        return IntroduceHint.validateSelection(ci, start, end, NOT_ACCEPTED_TYPES);
    }

    public static TreePath validateSelection(CompilationInfo ci, int start, int end, Set<TypeKind> ignoredTypes) {
        for (TreePath tp = ci.getTreeUtilities().pathFor((start + end) / 2 + 1); tp != null; tp = tp.getParentPath()) {
            Tree leaf = tp.getLeaf();
            if (!ExpressionTree.class.isAssignableFrom(leaf.getKind().asInterface()) && (leaf.getKind() != Tree.Kind.VARIABLE || ((VariableTree)leaf).getInitializer() == null)) continue;
            long treeStart = ci.getTrees().getSourcePositions().getStartPosition(ci.getCompilationUnit(), leaf);
            long treeEnd = ci.getTrees().getSourcePositions().getEndPosition(ci.getCompilationUnit(), leaf);
            if (treeStart != (long)start || treeEnd != (long)end) continue;
            TypeMirror type = ci.getTrees().getTypeMirror(tp);
            if (type != null && type.getKind() == TypeKind.ERROR) {
                type = ci.getTrees().getOriginalType((ErrorType)type);
            }
            if (type == null || ignoredTypes.contains((Object)type.getKind()) || tp.getLeaf().getKind() == Tree.Kind.ASSIGNMENT || tp.getLeaf().getKind() == Tree.Kind.ANNOTATION) continue;
            if (!IntroduceHint.isInsideClass(tp)) {
                return null;
            }
            TreePath candidate = tp;
            for (tp = tp.getParentPath(); tp != null; tp = tp.getParentPath()) {
                switch (tp.getLeaf().getKind()) {
                    case VARIABLE: {
                        VariableTree vt = (VariableTree)tp.getLeaf();
                        if (vt.getInitializer() == leaf) {
                            return candidate;
                        }
                        return null;
                    }
                    case NEW_CLASS: {
                        NewClassTree nct = (NewClassTree)tp.getLeaf();
                        if (!nct.getIdentifier().equals(candidate.getLeaf())) break;
                        for (ExpressionTree expressionTree : nct.getArguments()) {
                            if (expressionTree != leaf) continue;
                            return candidate;
                        }
                        return null;
                    }
                }
                leaf = tp.getLeaf();
            }
            return candidate;
        }
        return null;
    }

    public static TreePathHandle validateSelectionForIntroduceMethod(CompilationInfo ci, int start, int end, int[] statementsSpan) {
        int[] span = IntroduceHint.ignoreWhitespaces(ci, Math.min(start, end), Math.max(start, end));
        if ((start = span[0]) >= (end = span[1])) {
            return null;
        }
        for (TreePath tp = ci.getTreeUtilities().pathFor((start + end) / 2 + 1); tp != null; tp = tp.getParentPath()) {
            Tree leaf = tp.getLeaf();
            if (!StatementTree.class.isAssignableFrom(leaf.getKind().asInterface())) continue;
            long treeStart = ci.getTrees().getSourcePositions().getStartPosition(ci.getCompilationUnit(), leaf);
            long treeEnd = ci.getTrees().getSourcePositions().getEndPosition(ci.getCompilationUnit(), leaf);
            if (treeStart != (long)start || treeEnd != (long)end) continue;
            List<? extends StatementTree> statements = CopyFinder.getStatements(tp);
            statementsSpan[0] = statements.indexOf(tp.getLeaf());
            statementsSpan[1] = statementsSpan[0];
            return TreePathHandle.create((TreePath)tp, (CompilationInfo)ci);
        }
        TreePath tpStart = ci.getTreeUtilities().pathFor(start);
        TreePath tpEnd = ci.getTreeUtilities().pathFor(end);
        if (tpStart.getLeaf() != tpEnd.getLeaf() || tpStart.getLeaf().getKind() != Tree.Kind.BLOCK && tpStart.getLeaf().getKind() != Tree.Kind.CASE) {
            return null;
        }
        int from = -1;
        int to = -1;
        List<? extends StatementTree> statements = tpStart.getLeaf().getKind() == Tree.Kind.BLOCK ? ((BlockTree)tpStart.getLeaf()).getStatements() : ((CaseTree)tpStart.getLeaf()).getStatements();
        int index = 0;
        for (StatementTree statementTree : statements) {
            long sStart = ci.getTrees().getSourcePositions().getStartPosition(ci.getCompilationUnit(), statementTree);
            if (sStart == (long)start && from == -1) {
                from = index;
            }
            if ((long)end < sStart && to == -1) {
                to = index - 1;
            }
            ++index;
        }
        if (from == -1) {
            return null;
        }
        if (to == -1) {
            to = statements.size() - 1;
        }
        if (to < from) {
            return null;
        }
        statementsSpan[0] = from;
        statementsSpan[1] = to;
        return TreePathHandle.create((TreePath)new TreePath(tpStart, statements.get(from)), (CompilationInfo)ci);
    }

    public void run(CompilationInfo info) {
        this.cancel.set(false);
        FileObject file = info.getFileObject();
        int[] selection = SelectionAwareJavaSourceTaskFactory.getLastSelection((FileObject)file);
        if (selection == null) {
            HintsController.setErrors((FileObject)info.getFileObject(), (String)IntroduceHint.class.getName(), Collections.emptyList());
        } else {
            HintsController.setErrors((FileObject)info.getFileObject(), (String)IntroduceHint.class.getName(), IntroduceHint.computeError(info, selection[0], selection[1], null, new EnumMap<IntroduceKind, String>(IntroduceKind.class), this.cancel));
            Document doc = info.getSnapshot().getSource().getDocument(false);
            long version = doc != null ? DocumentUtilities.getDocumentVersion((Document)doc) : 0L;
            JavaHintsPositionRefresher.introduceHintsUpdated(doc, version, selection[0], selection[1]);
        }
    }

    public void cancel() {
        this.cancel.set(true);
    }

    private static boolean isConstructor(CompilationInfo info, TreePath path) {
        Element e = info.getTrees().getElement(path);
        return e != null && e.getKind() == ElementKind.CONSTRUCTOR;
    }

    private static boolean isInAnnotationType(CompilationInfo info, TreePath path) {
        Element e = info.getTrees().getElement(path);
        if (e != null) {
            return (e = e.getEnclosingElement()) != null && e.getKind() == ElementKind.ANNOTATION_TYPE;
        }
        return false;
    }

    private static List<TreePath> findConstructors(CompilationInfo info, TreePath method) {
        LinkedList<TreePath> result = new LinkedList<TreePath>();
        TreePath parent = method.getParentPath();
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getLeaf().getKind())) {
            for (Tree tree : ((ClassTree)parent.getLeaf()).getMembers()) {
                TreePath tp = new TreePath(parent, tree);
                if (!IntroduceHint.isConstructor(info, tp)) continue;
                result.add(tp);
            }
        }
        return result;
    }

    private static boolean isInsideClass(TreePath tp) {
        while (tp != null) {
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
                return true;
            }
            tp = tp.getParentPath();
        }
        return false;
    }

    public static List<ErrorDescription> computeError(CompilationInfo info, int start, int end, Map<IntroduceKind, Fix> fixesMap, Map<IntroduceKind, String> errorMessage, AtomicBoolean cancel) {
        Fix introduceMethod;
        LinkedList<ErrorDescription> hints = new LinkedList<ErrorDescription>();
        LinkedList<Object> fixes = new LinkedList<Object>();
        TreePath resolved = IntroduceHint.validateSelection(info, start, end);
        if (resolved != null) {
            IntroduceFix variable;
            TreePathHandle h = TreePathHandle.create((TreePath)resolved, (CompilationInfo)info);
            TreePath method = IntroduceHint.findMethod(resolved);
            boolean variableRewrite = resolved.getLeaf().getKind() == Tree.Kind.VARIABLE;
            TreePath value = !variableRewrite ? resolved : new TreePath(resolved, ((VariableTree)resolved.getLeaf()).getInitializer());
            boolean isConstant = IntroduceHint.checkConstantExpression(info, value);
            boolean isVariable = IntroduceHint.findStatement(resolved) != null && method != null && !variableRewrite;
            Set duplicatesForVariable = isVariable ? SourceUtils.computeDuplicates((CompilationInfo)info, (TreePath)resolved, (TreePath)method, (AtomicBoolean)cancel) : null;
            Set duplicatesForConstant = SourceUtils.computeDuplicates((CompilationInfo)info, (TreePath)resolved, (TreePath)new TreePath(info.getCompilationUnit()), (AtomicBoolean)cancel);
            Scope scope = info.getTrees().getScope(resolved);
            boolean statik = scope != null ? info.getTreeUtilities().isStaticContext(scope) : false;
            String guessedName = Utilities.getName(resolved.getLeaf());
            if (guessedName == null) {
                guessedName = "name";
            }
            Scope s = info.getTrees().getScope(resolved);
            IntroduceFix introduceFix = isVariable ? new IntroduceFix(h, info.getJavaSource(), variableRewrite ? guessedName : Utilities.makeNameUnique(info, s, guessedName), duplicatesForVariable.size() + 1, IntroduceKind.CREATE_VARIABLE) : (variable = null);
            IntroduceFix constant = isConstant ? new IntroduceFix(h, info.getJavaSource(), variableRewrite ? guessedName : Utilities.makeNameUnique(info, s, Utilities.toConstantName(guessedName)), duplicatesForConstant.size() + 1, IntroduceKind.CREATE_CONSTANT) : null;
            IntroduceParameterFix parameter = isVariable ? new IntroduceParameterFix(h) : null;
            IntroduceFieldFix field = null;
            IntroduceExpressionBasedMethodFix methodFix = null;
            if (method != null && !IntroduceHint.isInAnnotationType(info, method)) {
                int[] initilizeIn = IntroduceHint.computeInitializeIn(info, resolved, duplicatesForConstant);
                if (statik) {
                    initilizeIn[0] = initilizeIn[0] & 0xFFFFFFFB;
                    initilizeIn[1] = initilizeIn[1] & 0xFFFFFFFB;
                }
                boolean allowFinalInCurrentMethod = false;
                if (IntroduceHint.isConstructor(info, method)) {
                    boolean bl = allowFinalInCurrentMethod = IntroduceHint.findConstructors(info, method).size() == 1;
                }
                if (resolved.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                    guessedName = Utilities.guessName(info, resolved, resolved.getParentPath());
                }
                field = new IntroduceFieldFix(h, info.getJavaSource(), guessedName, duplicatesForConstant.size() + 1, initilizeIn, statik, allowFinalInCurrentMethod);
                if (!variableRewrite) {
                    Element methodEl = info.getTrees().getElement(method);
                    HashMap<TypeMirror, TreePathHandle> typeVar2Def = new HashMap<TypeMirror, TreePathHandle>();
                    LinkedList<TreePathHandle> typeVars = new LinkedList<TreePathHandle>();
                    IntroduceHint.prepareTypeVars(method, info, typeVar2Def, typeVars);
                    ScanStatement scanner = new ScanStatement(info, resolved.getLeaf(), resolved.getLeaf(), typeVar2Def, Collections.<Tree, Iterable<TreePath>>emptyMap(), cancel);
                    if (methodEl != null && (methodEl.getKind() == ElementKind.METHOD || methodEl.getKind() == ElementKind.CONSTRUCTOR)) {
                        ExecutableElement ee = (ExecutableElement)methodEl;
                        scanner.localVariables.addAll(ee.getParameters());
                    }
                    scanner.scan(method, null);
                    LinkedList<TreePathHandle> params = new LinkedList<TreePathHandle>();
                    boolean error186980 = false;
                    for (VariableElement ve : scanner.usedLocalVariables.keySet()) {
                        TreePath path = info.getTrees().getPath(ve);
                        if (path == null) {
                            error186980 = true;
                            Logger.getLogger(IntroduceHint.class.getName()).warning("Cannot get TreePath for local variable " + ve + "\nfile=" + info.getFileObject().getPath());
                            continue;
                        }
                        params.add(TreePathHandle.create((TreePath)path, (CompilationInfo)info));
                    }
                    if (!error186980) {
                        HashSet exceptions = new HashSet(info.getTreeUtilities().getUncaughtExceptions(resolved));
                        HashSet<TypeMirrorHandle> exceptionHandles = new HashSet<TypeMirrorHandle>();
                        for (TypeMirror tm : exceptions) {
                            exceptionHandles.add(TypeMirrorHandle.create((TypeMirror)tm));
                        }
                        int duplicatesCount = CopyFinder.computeDuplicatesAndRemap(info, Collections.singletonList(resolved), new TreePath(info.getCompilationUnit()), scanner.usedLocalVariables.keySet(), cancel).size();
                        typeVars.retainAll(scanner.usedTypeVariables);
                        methodFix = new IntroduceExpressionBasedMethodFix(info.getJavaSource(), h, params, exceptionHandles, duplicatesCount, typeVars);
                    }
                }
            }
            if (fixesMap != null) {
                fixesMap.put(IntroduceKind.CREATE_VARIABLE, variable);
                fixesMap.put(IntroduceKind.CREATE_CONSTANT, constant);
                fixesMap.put(IntroduceKind.CREATE_FIELD, field);
                fixesMap.put(IntroduceKind.CREATE_METHOD, methodFix);
                fixesMap.put(IntroduceKind.CREATE_PARAMETER, parameter);
            }
            if (variable != null) {
                fixes.add(variable);
            }
            if (constant != null) {
                fixes.add(constant);
            }
            if (field != null) {
                fixes.add(field);
            }
            if (methodFix != null) {
                fixes.add(methodFix);
            }
            if (parameter != null) {
                fixes.add(parameter);
            }
        }
        if ((introduceMethod = IntroduceHint.computeIntroduceMethod(info, start, end, fixesMap, errorMessage, cancel)) != null) {
            fixes.add(introduceMethod);
            if (fixesMap != null) {
                fixesMap.put(IntroduceKind.CREATE_METHOD, introduceMethod);
            }
        }
        if (!fixes.isEmpty()) {
            int pos = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)info.getFileObject());
            String displayName = NbBundle.getMessage(IntroduceHint.class, (String)"HINT_Introduce");
            hints.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)displayName, fixes, (FileObject)info.getFileObject(), (int)pos, (int)pos));
        }
        return hints;
    }

    static Fix computeIntroduceMethod(CompilationInfo info, int start, int end, Map<IntroduceKind, Fix> fixesMap, Map<IntroduceKind, String> errorMessage, AtomicBoolean cancel) {
        boolean declareVariableForReturnValue;
        TreePathHandle returnAssignTo;
        TypeMirror returnType;
        int[] statements = new int[2];
        TreePathHandle h = IntroduceHint.validateSelectionForIntroduceMethod(info, start, end, statements);
        if (h == null) {
            errorMessage.put(IntroduceKind.CREATE_METHOD, "ERR_Invalid_Selection");
            return null;
        }
        TreePath block = h.resolve(info);
        TreePath method = IntroduceHint.findMethod(block);
        if (method == null) {
            errorMessage.put(IntroduceKind.CREATE_METHOD, "ERR_Invalid_Selection");
            return null;
        }
        if (method.getLeaf().getKind() == Tree.Kind.METHOD && ((MethodTree)method.getLeaf()).getParameters().contains(block.getLeaf())) {
            errorMessage.put(IntroduceKind.CREATE_METHOD, "ERR_Invalid_Selection");
            return null;
        }
        HashMap<TypeMirror, TreePathHandle> typeVar2Def = new HashMap<TypeMirror, TreePathHandle>();
        LinkedList<TreePathHandle> typeVars = new LinkedList<TreePathHandle>();
        IntroduceHint.prepareTypeVars(method, info, typeVar2Def, typeVars);
        Element methodEl = info.getTrees().getElement(method);
        List<? extends StatementTree> parentStatements = CopyFinder.getStatements(block);
        List<? extends StatementTree> statementsToWrap = parentStatements.subList(statements[0], statements[1] + 1);
        Flow.FlowResult flow = Flow.assignmentsForUse(info, method, cancel);
        if (flow == null || cancel.get()) {
            return null;
        }
        Map<Tree, Iterable<? extends TreePath>> assignmentsForUse = flow.getAssignmentsForUse();
        ScanStatement scanner = new ScanStatement(info, statementsToWrap.get(0), statementsToWrap.get(statementsToWrap.size() - 1), typeVar2Def, assignmentsForUse, cancel);
        HashSet exceptions = new HashSet();
        int index = 0;
        TypeMirror methodReturnType = info.getTypes().getNoType(TypeKind.VOID);
        if (methodEl != null && (methodEl.getKind() == ElementKind.METHOD || methodEl.getKind() == ElementKind.CONSTRUCTOR)) {
            ExecutableElement ee = (ExecutableElement)methodEl;
            scanner.localVariables.addAll(ee.getParameters());
            methodReturnType = ee.getReturnType();
        }
        scanner.scan(method, null);
        LinkedList<TreePath> pathsOfStatementsToWrap = new LinkedList<TreePath>();
        for (StatementTree statementTree : parentStatements) {
            TreePath path = new TreePath(block, statementTree);
            if (index >= statements[0] && index <= statements[1]) {
                exceptions.addAll(info.getTreeUtilities().getUncaughtExceptions(path));
                pathsOfStatementsToWrap.add(path);
            }
            ++index;
        }
        boolean exitsFromAllBranches = Utilities.exitsFromAllBranchers(info, new TreePath(block, statementsToWrap.get(statementsToWrap.size() - 1)));
        String string = scanner.verifyExits(exitsFromAllBranches);
        if (string != null) {
            errorMessage.put(IntroduceKind.CREATE_METHOD, string);
            return null;
        }
        LinkedHashMap mergedVariableUse = new LinkedHashMap(scanner.usedLocalVariables);
        for (Map.Entry e : scanner.usedAfterSelection.entrySet()) {
            if (cancel.get()) {
                return null;
            }
            Boolean usedLocal = (Boolean)mergedVariableUse.get(e.getKey());
            if (usedLocal == null && Flow.definitellyAssigned(info, (VariableElement)e.getKey(), pathsOfStatementsToWrap, cancel)) {
                mergedVariableUse.put(e.getKey(), true);
                continue;
            }
            mergedVariableUse.put(e.getKey(), usedLocal != Boolean.FALSE && (Boolean)e.getValue() != false);
        }
        if (cancel.get()) {
            return null;
        }
        LinkedHashSet additionalLocalVariables = new LinkedHashSet();
        LinkedHashSet paramsVariables = new LinkedHashSet();
        for (Map.Entry e : mergedVariableUse.entrySet()) {
            if (e.getValue() == null || ((Boolean)e.getValue()).booleanValue()) {
                additionalLocalVariables.add(e.getKey());
                continue;
            }
            paramsVariables.add(e.getKey());
            additionalLocalVariables.remove(e.getKey());
        }
        LinkedList<TreePathHandle> params = new LinkedList<TreePathHandle>();
        for (VariableElement ve : paramsVariables) {
            params.add(TreePathHandle.create((TreePath)info.getTrees().getPath(ve), (CompilationInfo)info));
        }
        additionalLocalVariables.removeAll(paramsVariables);
        additionalLocalVariables.removeAll(scanner.selectionLocalVariables);
        LinkedList<TypeMirrorHandle> additionaLocalTypes = new LinkedList<TypeMirrorHandle>();
        LinkedList<String> additionaLocalNames = new LinkedList<String>();
        for (VariableElement ve : additionalLocalVariables) {
            additionaLocalTypes.add(TypeMirrorHandle.create((TypeMirror)ve.asType()));
            additionaLocalNames.add(ve.getSimpleName().toString());
        }
        LinkedList<TreePathHandle> exits = new LinkedList<TreePathHandle>();
        for (TreePath tp : scanner.selectionExits) {
            if (!IntroduceHint.isInsideSameClass(tp, method)) continue;
            exits.add(TreePathHandle.create((TreePath)tp, (CompilationInfo)info));
        }
        int duplicatesCount = CopyFinder.computeDuplicatesAndRemap(info, pathsOfStatementsToWrap, new TreePath(info.getCompilationUnit()), scanner.usedLocalVariables.keySet(), cancel).size();
        if (!scanner.usedAfterSelection.isEmpty()) {
            VariableElement result = (VariableElement)scanner.usedAfterSelection.keySet().iterator().next();
            returnType = result.asType();
            returnAssignTo = TreePathHandle.create((TreePath)info.getTrees().getPath(result), (CompilationInfo)info);
            declareVariableForReturnValue = scanner.selectionLocalVariables.contains(result);
        } else if (!exits.isEmpty() && !exitsFromAllBranches) {
            returnType = info.getTypes().getPrimitiveType(TypeKind.BOOLEAN);
            returnAssignTo = null;
            declareVariableForReturnValue = false;
        } else if (exitsFromAllBranches && scanner.hasReturns) {
            returnType = methodReturnType;
            returnAssignTo = null;
            declareVariableForReturnValue = false;
        } else {
            returnType = info.getTypes().getNoType(TypeKind.VOID);
            returnAssignTo = null;
            declareVariableForReturnValue = false;
        }
        HashSet<TypeMirrorHandle> exceptionHandles = new HashSet<TypeMirrorHandle>();
        for (TypeMirror tm : exceptions) {
            exceptionHandles.add(TypeMirrorHandle.create((TypeMirror)tm));
        }
        typeVars.retainAll(scanner.usedTypeVariables);
        return new IntroduceMethodFix(info.getJavaSource(), h, params, additionaLocalTypes, additionaLocalNames, TypeMirrorHandle.create((TypeMirror)returnType), returnAssignTo, declareVariableForReturnValue, exceptionHandles, exits, exitsFromAllBranches, statements[0], statements[1], duplicatesCount, typeVars);
    }

    private static boolean isInsideSameClass(TreePath one, TreePath two) {
        Tree t;
        Object oneClass = null;
        ClassTree twoClass = null;
        while (one.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && one.getLeaf().getKind() != null) {
            t = one.getLeaf();
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) {
                oneClass = (ClassTree)t;
                break;
            }
            one = one.getParentPath();
        }
        while (two.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && two.getLeaf().getKind() != null) {
            t = two.getLeaf();
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) {
                twoClass = (ClassTree)t;
                break;
            }
            two = two.getParentPath();
        }
        return oneClass != null && oneClass.equals(twoClass);
    }

    static boolean checkConstantExpression(final CompilationInfo info, TreePath path) {
        class NotConstant
        extends Error {
            NotConstant() {
            }
        }
        try {
            new TreePathScanner<Void, Void>(){
                private final Set<Element> definedIn = new HashSet<Element>();

                @Override
                public Void visitIdentifier(IdentifierTree node, Void p) {
                    Element el = info.getTrees().getElement(this.getCurrentPath());
                    if (el == null) {
                        throw new NotConstant();
                    }
                    if (this.definedIn.contains(el)) {
                        return null;
                    }
                    if (el.getKind().isClass() || el.getKind().isInterface()) {
                        return null;
                    }
                    if (!el.getModifiers().contains((Object)Modifier.STATIC)) {
                        throw new NotConstant();
                    }
                    if (el.getKind() == ElementKind.FIELD && !el.getModifiers().contains((Object)Modifier.FINAL)) {
                        throw new NotConstant();
                    }
                    return (Void)super.visitIdentifier(node, p);
                }

                @Override
                public Void visitVariable(VariableTree node, Void p) {
                    this.definedIn.add(info.getTrees().getElement(this.getCurrentPath()));
                    return (Void)super.visitVariable(node, p);
                }

                @Override
                public Void visitMethod(MethodTree node, Void p) {
                    this.definedIn.add(info.getTrees().getElement(this.getCurrentPath()));
                    return (Void)super.visitMethod(node, p);
                }
            }.scan(path, (Void)null);
        }
        catch (NotConstant n) {
            return false;
        }
        return true;
    }

    private static TreePath findStatement(TreePath statementPath) {
        while (statementPath != null && (!StatementTree.class.isAssignableFrom(statementPath.getLeaf().getKind().asInterface()) || statementPath.getParentPath() != null && statementPath.getParentPath().getLeaf().getKind() != Tree.Kind.BLOCK)) {
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)statementPath.getLeaf().getKind())) {
                return null;
            }
            statementPath = statementPath.getParentPath();
        }
        return statementPath;
    }

    private static TreePath findMethod(TreePath path) {
        while (path != null) {
            if (path.getLeaf().getKind() == Tree.Kind.METHOD) {
                return path;
            }
            if (path.getLeaf().getKind() == Tree.Kind.BLOCK && path.getParentPath() != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getParentPath().getLeaf().getKind())) {
                return path;
            }
            path = path.getParentPath();
        }
        return null;
    }

    private static TreePath findClass(TreePath path) {
        while (path != null) {
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind())) {
                return path;
            }
            path = path.getParentPath();
        }
        return null;
    }

    private static boolean isParentOf(TreePath parent, TreePath path) {
        Tree parentLeaf = parent.getLeaf();
        while (path != null && path.getLeaf() != parentLeaf) {
            path = path.getParentPath();
        }
        return path != null;
    }

    private static boolean isParentOf(TreePath parent, List<? extends TreePath> candidates) {
        for (TreePath treePath : candidates) {
            if (IntroduceHint.isParentOf(parent, treePath)) continue;
            return false;
        }
        return true;
    }

    private static BlockTree findAddPosition(CompilationInfo info, TreePath original, Set<? extends TreePath> candidates, int[] outPosition) {
        TreePath statement = original;
        for (TreePath treePath : candidates) {
            int stPathStart;
            Tree leaf = treePath.getLeaf();
            int leafStart = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), leaf);
            if (leafStart >= (stPathStart = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), statement.getLeaf()))) continue;
            statement = treePath;
        }
        LinkedList<? extends TreePath> allCandidates = new LinkedList<TreePath>();
        allCandidates.add(original);
        allCandidates.addAll(candidates);
        statement = IntroduceHint.findStatement(statement);
        if (statement == null) {
            return null;
        }
        while (statement.getParentPath() != null && !IntroduceHint.isParentOf(statement.getParentPath(), allCandidates)) {
            statement = statement.getParentPath();
        }
        while (statement.getParentPath() != null && statement.getParentPath().getLeaf().getKind() != Tree.Kind.BLOCK) {
            statement = statement.getParentPath();
        }
        if (statement.getParentPath() == null) {
            return null;
        }
        BlockTree blockTree = (BlockTree)statement.getParentPath().getLeaf();
        StatementTree statementTree = (StatementTree)statement.getLeaf();
        int index = blockTree.getStatements().indexOf(statementTree);
        if (index == -1) {
            return null;
        }
        outPosition[0] = index;
        return blockTree;
    }

    private static int[] computeInitializeIn(CompilationInfo info, TreePath firstOccurrence, Set<TreePath> occurrences) {
        class Result
        extends RuntimeException {
            Result() {
            }

            @Override
            public synchronized Throwable fillInStackTrace() {
                return null;
            }
        }
        int[] result = new int[]{7, 7};
        boolean inOneMethod = true;
        Tree currentMethod = IntroduceHint.findMethod(firstOccurrence).getLeaf();
        for (TreePath occurrence : occurrences) {
            TreePath method = IntroduceHint.findMethod(occurrence);
            if (method != null && currentMethod == method.getLeaf()) continue;
            inOneMethod = false;
            break;
        }
        boolean referencesLocalvariables = false;
        try {
            class ReferencesLocalVariable
            extends TreePathScanner<Void, Void> {
                final /* synthetic */ CompilationInfo val$info;

                ReferencesLocalVariable(CompilationInfo compilationInfo) {
                    this.val$info = compilationInfo;
                }

                @Override
                public Void visitIdentifier(IdentifierTree node, Void p) {
                    Element e = this.val$info.getTrees().getElement(this.getCurrentPath());
                    if (e != null && LOCAL_VARIABLES.contains((Object)e.getKind())) {
                        throw new Result();
                    }
                    return null;
                }
            }
            new ReferencesLocalVariable(info).scan(firstOccurrence, null);
        }
        catch (Result r) {
            referencesLocalvariables = true;
        }
        if (!inOneMethod) {
            result[1] = 6;
        }
        if (referencesLocalvariables) {
            result[0] = 1;
            result[1] = 1;
        }
        return result;
    }

    private static List<ExpressionTree> realArguments(TreeMaker make, List<VariableElement> parameters) {
        LinkedList<ExpressionTree> realArguments = new LinkedList<ExpressionTree>();
        for (VariableElement p : parameters) {
            realArguments.add(make.Identifier((CharSequence)p.getSimpleName()));
        }
        return realArguments;
    }

    private static List<ExpressionTree> realArgumentsForTrees(TreeMaker make, List<Union2<VariableElement, TreePath>> parameters) {
        LinkedList<ExpressionTree> realArguments = new LinkedList<ExpressionTree>();
        for (Union2<VariableElement, TreePath> p : parameters) {
            if (p.hasFirst()) {
                realArguments.add(make.Identifier((CharSequence)((VariableElement)p.first()).getSimpleName()));
                continue;
            }
            realArguments.add((ExpressionTree)((TreePath)p.second()).getLeaf());
        }
        return realArguments;
    }

    private static List<VariableTree> createVariables(WorkingCopy copy, List<VariableElement> parameters) {
        TreeMaker make = copy.getTreeMaker();
        LinkedList<VariableTree> formalArguments = new LinkedList<VariableTree>();
        for (VariableElement p : parameters) {
            TypeMirror tm = p.asType();
            Tree type = make.Type(tm);
            Name formalArgName = p.getSimpleName();
            EnumSet<Modifier> formalArgMods = EnumSet.noneOf(Modifier.class);
            if (p.getModifiers().contains((Object)Modifier.FINAL)) {
                formalArgMods.add(Modifier.FINAL);
            }
            formalArguments.add(make.Variable(make.Modifiers(formalArgMods), (CharSequence)formalArgName, type, null));
        }
        return formalArguments;
    }

    private static List<ExpressionTree> typeHandleToTree(WorkingCopy copy, Set<TypeMirrorHandle> thrownTypes) {
        TreeMaker make = copy.getTreeMaker();
        LinkedList<ExpressionTree> thrown = new LinkedList<ExpressionTree>();
        for (TypeMirrorHandle h : thrownTypes) {
            TypeMirror t = h.resolve((CompilationInfo)copy);
            if (t == null) {
                return null;
            }
            thrown.add((ExpressionTree)make.Type(t));
        }
        return thrown;
    }

    static final OffsetsBag introduceBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(IntroduceHint.class);
        if (bag == null) {
            bag = new OffsetsBag(doc);
            doc.putProperty(IntroduceHint.class, bag);
        }
        return bag;
    }

    private static List<VariableElement> resolveVariables(CompilationInfo info, Collection<? extends TreePathHandle> handles) {
        LinkedList<VariableElement> vars = new LinkedList<VariableElement>();
        for (TreePathHandle treePathHandle : handles) {
            vars.add((VariableElement)treePathHandle.resolveElement(info));
        }
        return vars;
    }

    private static void prepareTypeVars(TreePath method, CompilationInfo info, Map<TypeMirror, TreePathHandle> typeVar2Def, List<TreePathHandle> typeVars) throws IllegalArgumentException {
        if (method.getLeaf().getKind() == Tree.Kind.METHOD) {
            MethodTree mt = (MethodTree)method.getLeaf();
            for (TypeParameterTree typeParameterTree : mt.getTypeParameters()) {
                TreePath def = new TreePath(method, typeParameterTree);
                TypeMirror type = info.getTrees().getTypeMirror(def);
                if (type == null || type.getKind() != TypeKind.TYPEVAR) continue;
                TreePathHandle tph = TreePathHandle.create((TreePath)def, (CompilationInfo)info);
                typeVar2Def.put(type, tph);
                typeVars.add(tph);
            }
        }
    }

    private static void removeFromParent(WorkingCopy parameter, TreePath what) throws IllegalAccessException {
        Tree newParent;
        TreeMaker make = parameter.getTreeMaker();
        Tree parentTree = what.getParentPath().getLeaf();
        Tree original = what.getLeaf();
        switch (parentTree.getKind()) {
            case BLOCK: {
                newParent = make.removeBlockStatement((BlockTree)parentTree, (StatementTree)original);
                break;
            }
            case CASE: {
                newParent = make.removeCaseStatement((CaseTree)parentTree, (StatementTree)original);
                break;
            }
            default: {
                throw new IllegalAccessException(parentTree.getKind().toString());
            }
        }
        parameter.rewrite(parentTree, newParent);
    }

    private static Tree resolveRewritten(Map<Tree, Tree> rewritten, Tree t) {
        while (rewritten.containsKey(t)) {
            t = rewritten.get(t);
        }
        return t;
    }

    private static void doReplaceInBlockCatchSingleStatement(WorkingCopy copy, Map<Tree, Tree> rewritten, TreePath firstLeaf, List<? extends StatementTree> newStatements) {
        Tree nueTree;
        TreeMaker make = copy.getTreeMaker();
        Tree toReplace = IntroduceHint.resolveRewritten(rewritten, firstLeaf.getParentPath().getLeaf());
        switch (toReplace.getKind()) {
            case BLOCK: {
                nueTree = make.Block(newStatements, ((BlockTree)toReplace).isStatic());
                break;
            }
            case CASE: {
                nueTree = make.Case(((CaseTree)toReplace).getExpression(), newStatements);
                break;
            }
            default: {
                assert (CopyFinder.getStatements(firstLeaf).size() == 1) : CopyFinder.getStatements(firstLeaf).toString();
                assert (newStatements.size() == 1) : newStatements.toString();
                toReplace = firstLeaf.getLeaf();
                nueTree = newStatements.get(0);
            }
        }
        copy.rewrite(toReplace, nueTree);
        rewritten.put(toReplace, nueTree);
    }

    public static final class HLFImpl
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            return new HighlightsLayer[]{HighlightsLayer.create((String)IntroduceHint.class.getName(), (ZOrder)ZOrder.TOP_RACK.forPosition(500), (boolean)true, (HighlightsContainer)IntroduceHint.introduceBag(context.getDocument()))};
        }
    }

    private static final class IntroduceExpressionBasedMethodFix
    implements Fix {
        private final JavaSource js;
        private final TreePathHandle expression;
        private final List<TreePathHandle> parameters;
        private final Set<TypeMirrorHandle> thrownTypes;
        private final int duplicatesCount;
        private final List<TreePathHandle> typeVars;

        public IntroduceExpressionBasedMethodFix(JavaSource js, TreePathHandle expression, List<TreePathHandle> parameters, Set<TypeMirrorHandle> thrownTypes, int duplicatesCount, List<TreePathHandle> typeVars) {
            this.js = js;
            this.expression = expression;
            this.parameters = parameters;
            this.thrownTypes = thrownTypes;
            this.duplicatesCount = duplicatesCount;
            this.typeVars = typeVars;
        }

        public String getText() {
            return NbBundle.getMessage(IntroduceHint.class, (String)"FIX_IntroduceMethod");
        }

        public String toString() {
            return "[IntroduceExpressionBasedMethodFix]";
        }

        public ChangeInfo implement() throws Exception {
            JButton btnOk = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
            JButton btnCancel = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
            IntroduceMethodPanel panel = new IntroduceMethodPanel("", this.duplicatesCount);
            panel.setOkButton(btnOk);
            String caption = NbBundle.getMessage(IntroduceHint.class, (String)"CAP_IntroduceMethod");
            DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
                return null;
            }
            final String name = panel.getMethodName();
            final Set<Modifier> access = panel.getAccess();
            final boolean replaceOther = panel.getReplaceOther();
            this.js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy copy) throws Exception {
                    TypeMirror returnType;
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath expression = IntroduceExpressionBasedMethodFix.this.expression.resolve((CompilationInfo)copy);
                    TypeMirror typeMirror = returnType = expression != null ? copy.getTrees().getTypeMirror(expression) : null;
                    if (expression == null || returnType == null) {
                        return;
                    }
                    returnType = Utilities.convertIfAnonymous(Utilities.resolveCapturedType((CompilationInfo)copy, returnType));
                    TreeMaker make = copy.getTreeMaker();
                    Tree returnTypeTree = make.Type(returnType);
                    List parameters = IntroduceHint.resolveVariables((CompilationInfo)copy, IntroduceExpressionBasedMethodFix.this.parameters);
                    List realArguments = IntroduceHint.realArguments(make, parameters);
                    MethodInvocationTree invocation = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.Identifier((CharSequence)name), realArguments);
                    Scope s = copy.getTrees().getScope(expression);
                    boolean isStatic = copy.getTreeUtilities().isStaticContext(s);
                    EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
                    if (isStatic) {
                        modifiers.add(Modifier.STATIC);
                    }
                    modifiers.addAll(access);
                    ModifiersTree mods = make.Modifiers(modifiers);
                    List formalArguments = IntroduceHint.createVariables(copy, parameters);
                    if (formalArguments == null) {
                        return;
                    }
                    List thrown = IntroduceHint.typeHandleToTree(copy, IntroduceExpressionBasedMethodFix.this.thrownTypes);
                    if (IntroduceExpressionBasedMethodFix.this.thrownTypes == null) {
                        return;
                    }
                    LinkedList<ReturnTree> methodStatements = new LinkedList<ReturnTree>();
                    methodStatements.add(make.Return((ExpressionTree)expression.getLeaf()));
                    LinkedList<TypeParameterTree> typeVars = new LinkedList<TypeParameterTree>();
                    for (TreePathHandle tph : IntroduceExpressionBasedMethodFix.this.typeVars) {
                        typeVars.add((TypeParameterTree)tph.resolve((CompilationInfo)copy).getLeaf());
                    }
                    MethodTree method = make.Method(mods, (CharSequence)name, returnTypeTree, typeVars, formalArguments, thrown, make.Block(methodStatements, false), null);
                    TreePath pathToClass = IntroduceHint.findClass(expression);
                    assert (pathToClass != null);
                    Tree parent = IntroduceHint.findMethod(expression).getLeaf();
                    ClassTree nueClass = null;
                    nueClass = parent.getKind() == Tree.Kind.METHOD ? GeneratorUtils.insertMethodAfter((WorkingCopy)copy, (TreePath)pathToClass, (MethodTree)method, (MethodTree)((MethodTree)parent)) : GeneratorUtilities.get((WorkingCopy)copy).insertClassMember((ClassTree)pathToClass.getLeaf(), (Tree)method);
                    copy.rewrite(pathToClass.getLeaf(), (Tree)nueClass);
                    Tree parentTree = expression.getParentPath().getLeaf();
                    Tree nueParent = copy.getTreeUtilities().translate(parentTree, Collections.singletonMap(expression.getLeaf(), invocation));
                    copy.rewrite(parentTree, nueParent);
                    if (replaceOther) {
                        Document doc = copy.getDocument();
                        for (CopyFinder.MethodDuplicateDescription methodDuplicateDescription : CopyFinder.computeDuplicatesAndRemap((CompilationInfo)copy, Collections.singletonList(expression), new TreePath(copy.getCompilationUnit()), parameters, new AtomicBoolean())) {
                            int startOff = (int)copy.getTrees().getSourcePositions().getStartPosition(copy.getCompilationUnit(), methodDuplicateDescription.firstLeaf.getLeaf());
                            int endOff = (int)copy.getTrees().getSourcePositions().getEndPosition(copy.getCompilationUnit(), methodDuplicateDescription.firstLeaf.getLeaf());
                            IntroduceHint.introduceBag(doc).clear();
                            IntroduceHint.introduceBag(doc).addHighlight(startOff, endOff, DUPE);
                            String title = NbBundle.getMessage(IntroduceHint.class, (String)"TTL_DuplicateMethodPiece");
                            String message = NbBundle.getMessage(IntroduceHint.class, (String)"MSG_DuplicateMethodPiece");
                            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, title, 0);
                            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) != NotifyDescriptor.YES_OPTION) continue;
                            LinkedList<Union2> dupeParameters = new LinkedList<Union2>();
                            for (VariableElement ve : parameters) {
                                if (methodDuplicateDescription.variablesRemapToTrees.containsKey(ve)) {
                                    dupeParameters.add(Union2.createSecond((Object)methodDuplicateDescription.variablesRemapToTrees.get(ve)));
                                    continue;
                                }
                                dupeParameters.add(Union2.createFirst((Object)ve));
                            }
                            List dupeRealArguments = IntroduceHint.realArgumentsForTrees(make, dupeParameters);
                            MethodInvocationTree dupeInvocation = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.Identifier((CharSequence)name), dupeRealArguments);
                            copy.rewrite(methodDuplicateDescription.firstLeaf.getLeaf(), (Tree)dupeInvocation);
                        }
                        IntroduceHint.introduceBag(doc).clear();
                    }
                }
            }).commit();
            return null;
        }
    }

    private static final class IntroduceMethodFix
    implements Fix {
        private JavaSource js;
        private TreePathHandle parentBlock;
        private List<TreePathHandle> parameters;
        private List<TypeMirrorHandle> additionalLocalTypes;
        private List<String> additionalLocalNames;
        private TypeMirrorHandle returnType;
        private TreePathHandle returnAssignTo;
        private boolean declareVariableForReturnValue;
        private Set<TypeMirrorHandle> thrownTypes;
        private List<TreePathHandle> exists;
        private boolean exitsFromAllBranches;
        private int from;
        private int to;
        private final int duplicatesCount;
        private final List<TreePathHandle> typeVars;

        public IntroduceMethodFix(JavaSource js, TreePathHandle parentBlock, List<TreePathHandle> parameters, List<TypeMirrorHandle> additionalLocalTypes, List<String> additionalLocalNames, TypeMirrorHandle returnType, TreePathHandle returnAssignTo, boolean declareVariableForReturnValue, Set<TypeMirrorHandle> thrownTypes, List<TreePathHandle> exists, boolean exitsFromAllBranches, int from, int to, int duplicatesCount, List<TreePathHandle> typeVars) {
            this.js = js;
            this.parentBlock = parentBlock;
            this.parameters = parameters;
            this.additionalLocalTypes = additionalLocalTypes;
            this.additionalLocalNames = additionalLocalNames;
            this.returnType = returnType;
            this.returnAssignTo = returnAssignTo;
            this.declareVariableForReturnValue = declareVariableForReturnValue;
            this.thrownTypes = thrownTypes;
            this.exists = exists;
            this.exitsFromAllBranches = exitsFromAllBranches;
            this.from = from;
            this.to = to;
            this.duplicatesCount = duplicatesCount;
            this.typeVars = typeVars;
        }

        public String getText() {
            return NbBundle.getMessage(IntroduceHint.class, (String)"FIX_IntroduceMethod");
        }

        public String toDebugString(CompilationInfo info) {
            return "[IntroduceMethod:" + this.from + ":" + this.to + "]";
        }

        public ChangeInfo implement() throws Exception {
            JButton btnOk = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
            JButton btnCancel = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
            IntroduceMethodPanel panel = new IntroduceMethodPanel("", this.duplicatesCount);
            panel.setOkButton(btnOk);
            String caption = NbBundle.getMessage(IntroduceHint.class, (String)"CAP_IntroduceMethod");
            DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
                return null;
            }
            final String name = panel.getMethodName();
            final Set<Modifier> access = panel.getAccess();
            final boolean replaceOther = panel.getReplaceOther();
            this.js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy copy) throws Exception {
                    VariableElement returnAssignTo;
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath firstStatement = IntroduceMethodFix.this.parentBlock.resolve((CompilationInfo)copy);
                    TypeMirror returnType = IntroduceMethodFix.this.returnType.resolve((CompilationInfo)copy);
                    if (firstStatement == null || returnType == null) {
                        return;
                    }
                    GeneratorUtilities.get((WorkingCopy)copy).importComments(firstStatement.getParentPath().getLeaf(), copy.getCompilationUnit());
                    Scope s = copy.getTrees().getScope(firstStatement);
                    boolean isStatic = copy.getTreeUtilities().isStaticContext(s);
                    List<? extends StatementTree> statements = CopyFinder.getStatements(firstStatement);
                    LinkedList<StatementTree> nueStatements = new LinkedList<StatementTree>();
                    nueStatements.addAll(statements.subList(0, IntroduceMethodFix.this.from));
                    final TreeMaker make = copy.getTreeMaker();
                    List parameters = IntroduceHint.resolveVariables((CompilationInfo)copy, IntroduceMethodFix.this.parameters);
                    List realArguments = IntroduceHint.realArguments(make, parameters);
                    LinkedList<StatementTree> methodStatements = new LinkedList<StatementTree>();
                    Iterator additionalType = IntroduceMethodFix.this.additionalLocalTypes.iterator();
                    Iterator additionalName = IntroduceMethodFix.this.additionalLocalNames.iterator();
                    while (additionalType.hasNext() && additionalName.hasNext()) {
                        TypeMirror tm = ((TypeMirrorHandle)additionalType.next()).resolve((CompilationInfo)copy);
                        if (tm == null) {
                            return;
                        }
                        Tree type = make.Type(tm);
                        methodStatements.add(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)additionalName.next(), type, null));
                    }
                    methodStatements.addAll(statements.subList(IntroduceMethodFix.this.from, IntroduceMethodFix.this.to + 1));
                    Tree returnTypeTree = make.Type(returnType);
                    ExpressionTree invocation = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.Identifier((CharSequence)name), realArguments);
                    Callable<ReturnTree> ret = null;
                    if (IntroduceMethodFix.this.returnAssignTo != null) {
                        returnAssignTo = (VariableElement)IntroduceMethodFix.this.returnAssignTo.resolveElement((CompilationInfo)copy);
                        if (returnAssignTo == null) {
                            return;
                        }
                    } else {
                        returnAssignTo = null;
                    }
                    if (returnAssignTo != null) {
                        ret = new Callable<ReturnTree>(){

                            @Override
                            public ReturnTree call() throws Exception {
                                return make.Return((ExpressionTree)make.Identifier((CharSequence)returnAssignTo.getSimpleName()));
                            }
                        };
                        if (IntroduceMethodFix.this.declareVariableForReturnValue) {
                            nueStatements.add(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)returnAssignTo.getSimpleName(), returnTypeTree, invocation));
                            invocation = null;
                        } else {
                            invocation = make.Assignment((ExpressionTree)make.Identifier((CharSequence)returnAssignTo.getSimpleName()), invocation);
                        }
                    }
                    if (!IntroduceMethodFix.this.exists.isEmpty()) {
                        TreePath handle = null;
                        handle = ((TreePathHandle)IntroduceMethodFix.this.exists.iterator().next()).resolve((CompilationInfo)copy);
                        if (handle == null) {
                            return;
                        }
                        assert (handle != null);
                        if (IntroduceMethodFix.this.exitsFromAllBranches && handle.getLeaf().getKind() == Tree.Kind.RETURN && returnAssignTo == null && returnType.getKind() != TypeKind.VOID) {
                            nueStatements.add(make.Return(invocation));
                        } else {
                            if (ret == null) {
                                ret = new Callable<ReturnTree>(){

                                    @Override
                                    public ReturnTree call() throws Exception {
                                        if (IntroduceMethodFix.this.exitsFromAllBranches) {
                                            return make.Return(null);
                                        }
                                        return make.Return((ExpressionTree)make.Literal((Object)true));
                                    }
                                };
                            }
                            for (TreePathHandle h : IntroduceMethodFix.this.exists) {
                                TreePath resolved = h.resolve((CompilationInfo)copy);
                                if (resolved == null) {
                                    return;
                                }
                                ReturnTree returnTree = ret.call();
                                GeneratorUtilities.get((WorkingCopy)copy).copyComments(resolved.getLeaf(), (Tree)returnTree, false);
                                GeneratorUtilities.get((WorkingCopy)copy).copyComments(resolved.getLeaf(), (Tree)returnTree, true);
                                copy.rewrite(resolved.getLeaf(), (Tree)returnTree);
                            }
                            StatementTree branch = null;
                            switch (handle.getLeaf().getKind()) {
                                case BREAK: {
                                    branch = make.Break((CharSequence)((BreakTree)handle.getLeaf()).getLabel());
                                    break;
                                }
                                case CONTINUE: {
                                    branch = make.Continue((CharSequence)((ContinueTree)handle.getLeaf()).getLabel());
                                    break;
                                }
                                case RETURN: {
                                    branch = make.Return(((ReturnTree)handle.getLeaf()).getExpression());
                                }
                            }
                            if (returnAssignTo != null || IntroduceMethodFix.this.exitsFromAllBranches) {
                                nueStatements.add(make.ExpressionStatement(invocation));
                                nueStatements.add(branch);
                            } else {
                                nueStatements.add(make.If((ExpressionTree)make.Parenthesized(invocation), branch, null));
                                methodStatements.add(make.Return((ExpressionTree)make.Literal((Object)false)));
                            }
                        }
                        invocation = null;
                    } else if (ret != null) {
                        methodStatements.add((StatementTree)ret.call());
                    }
                    if (invocation != null) {
                        nueStatements.add(make.ExpressionStatement(invocation));
                    }
                    nueStatements.addAll(statements.subList(IntroduceMethodFix.this.to + 1, statements.size()));
                    IdentityHashMap rewritten = new IdentityHashMap();
                    IntroduceHint.doReplaceInBlockCatchSingleStatement(copy, rewritten, firstStatement, nueStatements);
                    if (replaceOther) {
                        Document doc = copy.getDocument();
                        LinkedList<TreePath> statementsPaths = new LinkedList<TreePath>();
                        for (StatementTree statementTree : statements.subList(IntroduceMethodFix.this.from, IntroduceMethodFix.this.to + 1)) {
                            statementsPaths.add(new TreePath(firstStatement.getParentPath(), statementTree));
                        }
                        for (CopyFinder.MethodDuplicateDescription methodDuplicateDescription : CopyFinder.computeDuplicatesAndRemap((CompilationInfo)copy, statementsPaths, new TreePath(copy.getCompilationUnit()), parameters, new AtomicBoolean())) {
                            List<? extends StatementTree> parentStatements = CopyFinder.getStatements(new TreePath(new TreePath(methodDuplicateDescription.firstLeaf.getParentPath().getParentPath(), IntroduceHint.resolveRewritten(rewritten, methodDuplicateDescription.firstLeaf.getParentPath().getLeaf())), methodDuplicateDescription.firstLeaf.getLeaf()));
                            int startOff = (int)copy.getTrees().getSourcePositions().getStartPosition(copy.getCompilationUnit(), parentStatements.get(methodDuplicateDescription.dupeStart));
                            int endOff = (int)copy.getTrees().getSourcePositions().getEndPosition(copy.getCompilationUnit(), parentStatements.get(methodDuplicateDescription.dupeEnd));
                            IntroduceHint.introduceBag(doc).clear();
                            IntroduceHint.introduceBag(doc).addHighlight(startOff, endOff, DUPE);
                            String title = NbBundle.getMessage(IntroduceHint.class, (String)"TTL_DuplicateMethodPiece");
                            String message = NbBundle.getMessage(IntroduceHint.class, (String)"MSG_DuplicateMethodPiece");
                            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, title, 0);
                            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) != NotifyDescriptor.YES_OPTION) continue;
                            LinkedList<StatementTree> newStatements = new LinkedList<StatementTree>();
                            newStatements.addAll(parentStatements.subList(0, methodDuplicateDescription.dupeStart));
                            LinkedList<Union2> dupeParameters = new LinkedList<Union2>();
                            for (VariableElement ve : parameters) {
                                if (methodDuplicateDescription.variablesRemapToTrees.containsKey(ve)) {
                                    dupeParameters.add(Union2.createSecond((Object)methodDuplicateDescription.variablesRemapToTrees.get(ve)));
                                    continue;
                                }
                                dupeParameters.add(Union2.createFirst((Object)ve));
                            }
                            List dupeRealArguments = IntroduceHint.realArgumentsForTrees(make, dupeParameters);
                            ExpressionTree dupeInvocation = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.Identifier((CharSequence)name), dupeRealArguments);
                            if (returnAssignTo != null) {
                                VariableElement remappedElement;
                                TreePath remappedTree = methodDuplicateDescription.variablesRemapToTrees.containsKey(returnAssignTo) ? methodDuplicateDescription.variablesRemapToTrees.get(returnAssignTo) : null;
                                VariableElement variableElement = remappedElement = methodDuplicateDescription.variablesRemapToElement.containsKey(returnAssignTo) ? (VariableElement)methodDuplicateDescription.variablesRemapToElement.get(returnAssignTo) : null;
                                if (IntroduceMethodFix.this.declareVariableForReturnValue) {
                                    assert (remappedElement != null || remappedTree == null);
                                    Name name2 = remappedElement != null ? remappedElement.getSimpleName() : returnAssignTo.getSimpleName();
                                    newStatements.add(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)name2, returnTypeTree, invocation));
                                    dupeInvocation = null;
                                } else {
                                    ExpressionTree sel = remappedTree != null ? (ExpressionTree)remappedTree.getLeaf() : (remappedElement != null ? make.Identifier((CharSequence)remappedElement.getSimpleName()) : make.Identifier((CharSequence)returnAssignTo.getSimpleName()));
                                    dupeInvocation = make.Assignment(sel, dupeInvocation);
                                }
                            }
                            if (dupeInvocation != null) {
                                newStatements.add(make.ExpressionStatement(dupeInvocation));
                            }
                            newStatements.addAll(parentStatements.subList(methodDuplicateDescription.dupeEnd + 1, parentStatements.size()));
                            IntroduceHint.doReplaceInBlockCatchSingleStatement(copy, rewritten, methodDuplicateDescription.firstLeaf, newStatements);
                        }
                        IntroduceHint.introduceBag(doc).clear();
                    }
                    EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
                    if (isStatic) {
                        modifiers.add(Modifier.STATIC);
                    }
                    modifiers.addAll(access);
                    ModifiersTree mods = make.Modifiers(modifiers);
                    List formalArguments = IntroduceHint.createVariables(copy, parameters);
                    if (formalArguments == null) {
                        return;
                    }
                    List list = IntroduceHint.typeHandleToTree(copy, IntroduceMethodFix.this.thrownTypes);
                    if (IntroduceMethodFix.this.thrownTypes == null) {
                        return;
                    }
                    LinkedList<TypeParameterTree> typeVars = new LinkedList<TypeParameterTree>();
                    for (TreePathHandle tph : IntroduceMethodFix.this.typeVars) {
                        typeVars.add((TypeParameterTree)tph.resolve((CompilationInfo)copy).getLeaf());
                    }
                    MethodTree method = make.Method(mods, (CharSequence)name, returnTypeTree, typeVars, formalArguments, list, make.Block(methodStatements, false), null);
                    TreePath pathToClass = IntroduceHint.findClass(firstStatement);
                    assert (pathToClass != null);
                    Tree parent = IntroduceHint.findMethod(firstStatement).getLeaf();
                    ClassTree nueClass = null;
                    nueClass = parent.getKind() == Tree.Kind.METHOD ? GeneratorUtils.insertMethodAfter((WorkingCopy)copy, (TreePath)pathToClass, (MethodTree)method, (MethodTree)((MethodTree)parent)) : GeneratorUtilities.get((WorkingCopy)copy).insertClassMember((ClassTree)pathToClass.getLeaf(), (Tree)method);
                    copy.rewrite(pathToClass.getLeaf(), (Tree)nueClass);
                }
            }).commit();
            return null;
        }
    }

    private static final class IntroduceFieldFix
    implements Fix {
        private String guessedName;
        private TreePathHandle handle;
        private JavaSource js;
        private int numDuplicates;
        private int[] initilizeIn;
        private boolean statik;
        private boolean allowFinalInCurrentMethod;

        public IntroduceFieldFix(TreePathHandle handle, JavaSource js, String guessedName, int numDuplicates, int[] initilizeIn, boolean statik, boolean allowFinalInCurrentMethod) {
            this.handle = handle;
            this.js = js;
            this.guessedName = guessedName;
            this.numDuplicates = numDuplicates;
            this.initilizeIn = initilizeIn;
            this.statik = statik;
            this.allowFinalInCurrentMethod = allowFinalInCurrentMethod;
        }

        public String getText() {
            return NbBundle.getMessage(IntroduceHint.class, (String)"FIX_IntroduceField");
        }

        public String toString() {
            return "[IntroduceField:" + this.guessedName + ":" + this.numDuplicates + ":" + this.statik + ":" + this.allowFinalInCurrentMethod + ":" + Arrays.toString(this.initilizeIn) + "]";
        }

        public ChangeInfo implement() throws IOException, BadLocationException {
            JButton btnOk = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
            btnOk.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceHint.class, (String)"AD_IntrHint_OK"));
            JButton btnCancel = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
            btnCancel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceHint.class, (String)"AD_IntrHint_Cancel"));
            IntroduceFieldPanel panel = new IntroduceFieldPanel(this.guessedName, this.initilizeIn, this.numDuplicates, this.allowFinalInCurrentMethod, this.handle.getKind() == Tree.Kind.VARIABLE, btnOk);
            String caption = NbBundle.getMessage(IntroduceHint.class, (String)"CAP_IntroduceField");
            DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
                return null;
            }
            final String name = panel.getFieldName();
            final boolean replaceAll = panel.isReplaceAll();
            final boolean declareFinal = panel.isDeclareFinal();
            final Set<Modifier> access = panel.getAccess();
            final int initializeIn = panel.getInitializeIn();
            this.js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy parameter) throws Exception {
                    BlockTree nueBlock;
                    TreePath toRemoveFromParent;
                    VariableTree field;
                    boolean expressionStatementRewrite;
                    EnumSet<Modifier> mods;
                    TreePath pathToClass;
                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath resolved = IntroduceFieldFix.this.handle.resolve((CompilationInfo)parameter);
                    TypeMirror tm = parameter.getTrees().getTypeMirror(resolved);
                    if (resolved == null || tm == null) {
                        return;
                    }
                    tm = Utilities.convertIfAnonymous(Utilities.resolveCapturedType((CompilationInfo)parameter, tm));
                    for (pathToClass = resolved; pathToClass != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)pathToClass.getLeaf().getKind()); pathToClass = pathToClass.getParentPath()) {
                    }
                    if (pathToClass == null) {
                        return;
                    }
                    Tree original = resolved.getLeaf();
                    boolean variableRewrite = original.getKind() == Tree.Kind.VARIABLE;
                    ExpressionTree expression = !variableRewrite ? (ExpressionTree)resolved.getLeaf() : ((VariableTree)original).getInitializer();
                    EnumSet<Modifier> enumSet = mods = declareFinal ? EnumSet.of(Modifier.FINAL) : EnumSet.noneOf(Modifier.class);
                    if (IntroduceFieldFix.this.statik) {
                        mods.add(Modifier.STATIC);
                    }
                    mods.addAll(access);
                    TreeMaker make = parameter.getTreeMaker();
                    boolean isAnyOccurenceStatic = false;
                    if (replaceAll) {
                        for (TreePath p : SourceUtils.computeDuplicates((CompilationInfo)parameter, (TreePath)resolved, (TreePath)new TreePath(parameter.getCompilationUnit()), (AtomicBoolean)new AtomicBoolean())) {
                            parameter.rewrite(p.getLeaf(), (Tree)make.Identifier((CharSequence)name));
                            Scope occurenceScope = parameter.getTrees().getScope(p);
                            if (!parameter.getTreeUtilities().isStaticContext(occurenceScope)) continue;
                            isAnyOccurenceStatic = true;
                        }
                    }
                    if (!IntroduceFieldFix.this.statik && isAnyOccurenceStatic) {
                        mods.add(Modifier.STATIC);
                    }
                    ModifiersTree modsTree = make.Modifiers(mods);
                    Tree parentTree = resolved.getParentPath().getLeaf();
                    boolean bl = expressionStatementRewrite = parentTree.getKind() == Tree.Kind.EXPRESSION_STATEMENT;
                    if (!variableRewrite) {
                        field = make.Variable(modsTree, (CharSequence)name, make.Type(tm), initializeIn == 2 ? expression : null);
                        if (!expressionStatementRewrite) {
                            Tree nueParent = parameter.getTreeUtilities().translate(parentTree, Collections.singletonMap(resolved.getLeaf(), make.Identifier((CharSequence)name)));
                            parameter.rewrite(parentTree, nueParent);
                            toRemoveFromParent = null;
                        } else {
                            toRemoveFromParent = resolved.getParentPath();
                        }
                    } else {
                        VariableTree originalVar = (VariableTree)original;
                        field = make.Variable(modsTree, (CharSequence)name, originalVar.getType(), initializeIn == 2 ? expression : null);
                        toRemoveFromParent = resolved;
                    }
                    ClassTree nueClass = GeneratorUtils.insertClassMember((WorkingCopy)parameter, (TreePath)pathToClass, (Tree)field);
                    TreePath method = IntroduceHint.findMethod(resolved);
                    if (method == null) {
                        return;
                    }
                    if (initializeIn == 1) {
                        TreePath statementPath = resolved;
                        if ((statementPath = IntroduceHint.findStatement(statementPath)) == null) {
                            return;
                        }
                        ExpressionStatementTree assignment = make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)make.Identifier((CharSequence)name), expression));
                        if (!variableRewrite && !expressionStatementRewrite) {
                            BlockTree statements = (BlockTree)statementPath.getParentPath().getLeaf();
                            StatementTree statement = (StatementTree)statementPath.getLeaf();
                            int index = statements.getStatements().indexOf(statement);
                            if (index == -1) {
                                return;
                            }
                            LinkedList<? extends StatementTree> linkedList = new LinkedList<StatementTree>(statements.getStatements());
                            if (expression.getKind() == Tree.Kind.NEW_ARRAY) {
                                List<? extends ExpressionTree> initializers = ((NewArrayTree)expression).getInitializers();
                                expression = make.NewArray(make.Type(((ArrayType)tm).getComponentType()), Collections.emptyList(), initializers);
                            }
                            linkedList.add(index, assignment);
                            nueBlock = make.Block(linkedList, false);
                            parameter.rewrite((Tree)statements, (Tree)nueBlock);
                        } else {
                            parameter.rewrite(toRemoveFromParent.getLeaf(), (Tree)assignment);
                            toRemoveFromParent = null;
                        }
                    }
                    if (initializeIn == 4) {
                        for (TreePath constructor : IntroduceHint.findConstructors((CompilationInfo)parameter, method)) {
                            if (parameter.getTreeUtilities().isSynthetic(constructor)) {
                                LinkedList<ExpressionStatementTree> nueStatements = new LinkedList<ExpressionStatementTree>();
                                IdentifierTree reference = make.Identifier((CharSequence)name);
                                Element clazz = parameter.getTrees().getElement(pathToClass);
                                ModifiersTree modifiersTree = clazz.getKind() != ElementKind.ENUM ? make.Modifiers(EnumSet.of(Modifier.PUBLIC)) : make.Modifiers(Collections.EMPTY_SET);
                                nueStatements.add(make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)reference, expression)));
                                nueBlock = make.Block(nueStatements, false);
                                MethodTree nueConstr = make.Method(modifiersTree, (CharSequence)"<init>", null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), nueBlock, null);
                                nueClass = GeneratorUtils.insertClassMember((WorkingCopy)parameter, (TreePath)new TreePath(new TreePath(parameter.getCompilationUnit()), nueClass), (Tree)nueConstr);
                                nueClass = make.removeClassMember(nueClass, constructor.getLeaf());
                                break;
                            }
                            boolean hasParameterOfTheSameName = false;
                            MethodTree constr = (MethodTree)constructor.getLeaf();
                            for (VariableTree variableTree : constr.getParameters()) {
                                if (!name.equals(variableTree.getName().toString())) continue;
                                hasParameterOfTheSameName = true;
                                break;
                            }
                            IdentifierTree reference = hasParameterOfTheSameName ? make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)name) : make.Identifier((CharSequence)name);
                            ExpressionStatementTree expressionStatementTree = make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)reference, expression));
                            if (!variableRewrite && !expressionStatementRewrite || method.getLeaf() != constr) {
                                BlockTree origBody = constr.getBody();
                                LinkedList<? extends StatementTree> nueStatements = new LinkedList<StatementTree>();
                                List<? extends StatementTree> origStatements = origBody.getStatements();
                                StatementTree canBeSuper = origStatements.get(0);
                                if (!parameter.getTreeUtilities().isSynthetic(TreePath.getPath(constructor, (Tree)canBeSuper))) {
                                    nueStatements.add(canBeSuper);
                                }
                                nueStatements.add(expressionStatementTree);
                                nueStatements.addAll(origStatements.subList(1, origStatements.size()));
                                BlockTree nueBlock2 = make.Block(nueStatements, false);
                                parameter.rewrite((Tree)origBody, (Tree)nueBlock2);
                                continue;
                            }
                            parameter.rewrite(toRemoveFromParent.getLeaf(), (Tree)expressionStatementTree);
                            toRemoveFromParent = null;
                        }
                    }
                    if (toRemoveFromParent != null) {
                        IntroduceHint.removeFromParent(parameter, toRemoveFromParent);
                    }
                    parameter.rewrite(pathToClass.getLeaf(), (Tree)nueClass);
                }
            }).commit();
            return null;
        }
    }

    private static final class IntroduceFix
    implements Fix {
        private String guessedName;
        private TreePathHandle handle;
        private JavaSource js;
        private int numDuplicates;
        private IntroduceKind kind;

        public IntroduceFix(TreePathHandle handle, JavaSource js, String guessedName, int numDuplicates, IntroduceKind kind) {
            this.handle = handle;
            this.js = js;
            this.guessedName = guessedName;
            this.numDuplicates = numDuplicates;
            this.kind = kind;
        }

        public String toString() {
            return "[IntroduceFix:" + this.guessedName + ":" + this.numDuplicates + ":" + (Object)((Object)this.kind) + "]";
        }

        public String getKeyExt() {
            switch (this.kind) {
                case CREATE_CONSTANT: {
                    return "IntroduceConstant";
                }
                case CREATE_VARIABLE: {
                    return "IntroduceVariable";
                }
            }
            throw new IllegalStateException();
        }

        public String getText() {
            return NbBundle.getMessage(IntroduceHint.class, (String)("FIX_" + this.getKeyExt()));
        }

        public ChangeInfo implement() throws IOException, BadLocationException {
            JButton btnOk = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
            JButton btnCancel = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
            IntroduceVariablePanel panel = new IntroduceVariablePanel(this.numDuplicates, this.guessedName, this.kind == IntroduceKind.CREATE_CONSTANT, this.handle.getKind() == Tree.Kind.VARIABLE, btnOk);
            String caption = NbBundle.getMessage(IntroduceHint.class, (String)("CAP_" + this.getKeyExt()));
            DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
                return null;
            }
            final String name = panel.getVariableName();
            final boolean replaceAll = panel.isReplaceAll();
            final boolean declareFinal = panel.isDeclareFinal();
            final Set<Modifier> access = this.kind == IntroduceKind.CREATE_CONSTANT ? panel.getAccess() : null;
            this.js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy parameter) throws Exception {
                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath resolved = IntroduceFix.this.handle.resolve((CompilationInfo)parameter);
                    if (resolved == null) {
                        return;
                    }
                    TypeMirror tm = parameter.getTrees().getTypeMirror(resolved);
                    if (tm == null) {
                        return;
                    }
                    tm = Utilities.convertIfAnonymous(Utilities.resolveCapturedType((CompilationInfo)parameter, tm));
                    Tree original = resolved.getLeaf();
                    boolean variableRewrite = original.getKind() == Tree.Kind.VARIABLE;
                    ExpressionTree expression = !variableRewrite ? (ExpressionTree)resolved.getLeaf() : ((VariableTree)original).getInitializer();
                    TreeMaker make = parameter.getTreeMaker();
                    boolean expressionStatement = resolved.getParentPath().getLeaf().getKind() == Tree.Kind.EXPRESSION_STATEMENT;
                    switch (IntroduceFix.this.kind) {
                        case CREATE_CONSTANT: {
                            VariableTree constant;
                            TreePath pathToClass;
                            for (pathToClass = resolved; pathToClass != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)pathToClass.getLeaf().getKind()); pathToClass = pathToClass.getParentPath()) {
                            }
                            if (pathToClass == null) {
                                return;
                            }
                            EnumSet<Modifier> localAccess = EnumSet.of(Modifier.FINAL, Modifier.STATIC);
                            localAccess.addAll(access);
                            ModifiersTree mods = make.Modifiers(localAccess);
                            if (!variableRewrite) {
                                constant = make.Variable(mods, (CharSequence)name, make.Type(tm), expression);
                                if (expressionStatement) {
                                    IntroduceHint.removeFromParent(parameter, resolved.getParentPath());
                                }
                            } else {
                                VariableTree originalVar = (VariableTree)original;
                                constant = make.Variable(mods, (CharSequence)originalVar.getName(), originalVar.getType(), originalVar.getInitializer());
                                IntroduceHint.removeFromParent(parameter, resolved);
                                expressionStatement = true;
                            }
                            ClassTree nueClass = GeneratorUtils.insertClassMember((WorkingCopy)parameter, (TreePath)pathToClass, (Tree)constant);
                            parameter.rewrite(pathToClass.getLeaf(), (Tree)nueClass);
                            if (!replaceAll) break;
                            for (TreePath p : SourceUtils.computeDuplicates((CompilationInfo)parameter, (TreePath)resolved, (TreePath)new TreePath(parameter.getCompilationUnit()), (AtomicBoolean)new AtomicBoolean())) {
                                parameter.rewrite(p.getLeaf(), (Tree)make.Identifier((CharSequence)name));
                            }
                            break;
                        }
                        case CREATE_VARIABLE: {
                            int index;
                            BlockTree statements;
                            TreePath method = IntroduceHint.findMethod(resolved);
                            if (method == null) {
                                return;
                            }
                            if (replaceAll) {
                                Set candidates = SourceUtils.computeDuplicates((CompilationInfo)parameter, (TreePath)resolved, (TreePath)method, (AtomicBoolean)new AtomicBoolean());
                                for (TreePath p : candidates) {
                                    Tree leaf = p.getLeaf();
                                    parameter.rewrite(leaf, (Tree)make.Identifier((CharSequence)name));
                                }
                                int[] out = new int[1];
                                statements = IntroduceHint.findAddPosition((CompilationInfo)parameter, resolved, candidates, out);
                                if (statements == null) {
                                    return;
                                }
                                index = out[0];
                            } else {
                                int[] out = new int[1];
                                statements = IntroduceHint.findAddPosition((CompilationInfo)parameter, resolved, Collections.emptySet(), out);
                                if (statements == null) {
                                    return;
                                }
                                index = out[0];
                            }
                            LinkedList<? extends StatementTree> nueStatements = new LinkedList<StatementTree>(statements.getStatements());
                            ModifiersTree mods = make.Modifiers(declareFinal ? EnumSet.of(Modifier.FINAL) : EnumSet.noneOf(Modifier.class));
                            nueStatements.add(index, make.Variable(mods, (CharSequence)name, make.Type(tm), expression));
                            if (expressionStatement) {
                                nueStatements.remove(resolved.getParentPath().getLeaf());
                            }
                            BlockTree nueBlock = make.Block(nueStatements, false);
                            parameter.rewrite((Tree)statements, (Tree)nueBlock);
                        }
                    }
                    if (!expressionStatement) {
                        Tree origParent = resolved.getParentPath().getLeaf();
                        Tree newParent = parameter.getTreeUtilities().translate(origParent, Collections.singletonMap(resolved.getLeaf(), make.Identifier((CharSequence)name)));
                        parameter.rewrite(origParent, newParent);
                    }
                }
            }).commit();
            return null;
        }
    }

    private static final class ScanStatement
    extends TreePathScanner<Void, Void> {
        private static final int PHASE_BEFORE_SELECTION = 1;
        private static final int PHASE_INSIDE_SELECTION = 2;
        private static final int PHASE_AFTER_SELECTION = 3;
        private CompilationInfo info;
        private int phase = 1;
        private Tree firstInSelection;
        private Tree lastInSelection;
        private Set<VariableElement> localVariables = new HashSet<VariableElement>();
        private Map<VariableElement, Boolean> usedLocalVariables = new LinkedHashMap<VariableElement, Boolean>();
        private Set<VariableElement> selectionLocalVariables = new HashSet<VariableElement>();
        private Map<VariableElement, Boolean> usedAfterSelection = new LinkedHashMap<VariableElement, Boolean>();
        private Set<TreePath> selectionExits = new HashSet<TreePath>();
        private Set<Tree> treesSeensInSelection = new HashSet<Tree>();
        private final Map<TypeMirror, TreePathHandle> typeVar2Def;
        private final Map<Tree, Iterable<? extends TreePath>> assignmentsForUse;
        private Set<TreePathHandle> usedTypeVariables = new HashSet<TreePathHandle>();
        private boolean hasReturns = false;
        private boolean hasBreaks = false;
        private boolean hasContinues = false;
        private boolean secondPass = false;
        private boolean stopSecondPass = false;
        private final AtomicBoolean cancel;

        public ScanStatement(CompilationInfo info, Tree firstInSelection, Tree lastInSelection, Map<TypeMirror, TreePathHandle> typeVar2Def, Map<Tree, Iterable<? extends TreePath>> assignmentsForUse, AtomicBoolean cancel) {
            this.info = info;
            this.firstInSelection = firstInSelection;
            this.lastInSelection = lastInSelection;
            this.typeVar2Def = typeVar2Def;
            this.assignmentsForUse = assignmentsForUse;
            this.cancel = cancel;
        }

        @Override
        public Void scan(Tree tree, Void p) {
            if (this.stopSecondPass) {
                return null;
            }
            if (this.phase != 3) {
                if (tree == this.firstInSelection) {
                    this.phase = 2;
                }
                if (this.phase == 2) {
                    this.treesSeensInSelection.add(tree);
                }
            }
            if (this.secondPass && tree == this.firstInSelection) {
                this.stopSecondPass = true;
                return null;
            }
            super.scan(tree, p);
            if (tree == this.lastInSelection) {
                this.phase = 3;
            }
            return null;
        }

        @Override
        public Void visitVariable(VariableTree node, Void p) {
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            if (e != null && LOCAL_VARIABLES.contains((Object)e.getKind())) {
                switch (this.phase) {
                    case 1: {
                        this.localVariables.add((VariableElement)e);
                        break;
                    }
                    case 2: {
                        this.selectionLocalVariables.add((VariableElement)e);
                    }
                }
            }
            return (Void)super.visitVariable(node, p);
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Override
        public Void visitIdentifier(IdentifierTree node, Void p) {
            block9: {
                e = this.info.getTrees().getElement(this.getCurrentPath());
                if (e == null || !IntroduceHint.access$800().contains((Object)e.getKind())) break block9;
                switch (this.phase) {
                    case 2: {
                        if (!this.localVariables.contains(e) || this.usedLocalVariables.get(e) != null) break;
                        writes = this.assignmentsForUse.get(this.getCurrentPath().getLeaf());
                        definitellyAssignedInSelection /* !! */  = true;
                        if (writes == null) ** GOTO lbl14
                        for (TreePath w : writes) {
                            if (w != null && this.treesSeensInSelection.contains(w.getLeaf())) continue;
                            definitellyAssignedInSelection /* !! */  = false;
                            ** GOTO lbl15
                        }
                        ** GOTO lbl15
lbl14:
                        // 1 sources

                        definitellyAssignedInSelection /* !! */  = this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.ASSIGNMENT ? null : Boolean.valueOf(false);
lbl15:
                        // 3 sources

                        this.usedLocalVariables.put((VariableElement)e, definitellyAssignedInSelection /* !! */ );
                        break;
                    }
                    case 3: {
                        writes = this.assignmentsForUse.get(this.getCurrentPath().getLeaf());
                        assignedInSelection = false;
                        definitellyAssignedInSelection = true;
                        if (writes != null) {
                            for (TreePath w : writes) {
                                if (w != null && this.treesSeensInSelection.contains(w.getLeaf())) {
                                    assignedInSelection = true;
                                }
                                if (w != null && this.treesSeensInSelection.contains(w.getLeaf())) continue;
                                definitellyAssignedInSelection = false;
                            }
                        }
                        if (!assignedInSelection) break;
                        this.usedAfterSelection.put((VariableElement)e, definitellyAssignedInSelection);
                    }
                }
            }
            if (this.phase == 2 && (type = this.info.getTrees().getTypeMirror(this.getCurrentPath())) != null) {
                def = this.typeVar2Def.get(type);
                this.usedTypeVariables.add(def);
            }
            return (Void)super.visitIdentifier(node, p);
        }

        @Override
        public Void visitReturn(ReturnTree node, Void p) {
            if (this.phase == 2) {
                this.selectionExits.add(this.getCurrentPath());
                this.hasReturns = true;
            }
            return (Void)super.visitReturn(node, p);
        }

        @Override
        public Void visitBreak(BreakTree node, Void p) {
            if (this.phase == 2 && !this.treesSeensInSelection.contains(this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath()))) {
                this.selectionExits.add(this.getCurrentPath());
                this.hasBreaks = true;
            }
            return (Void)super.visitBreak(node, p);
        }

        @Override
        public Void visitContinue(ContinueTree node, Void p) {
            if (this.phase == 2 && !this.treesSeensInSelection.contains(this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath()))) {
                this.selectionExits.add(this.getCurrentPath());
                this.hasContinues = true;
            }
            return (Void)super.visitContinue(node, p);
        }

        @Override
        public Void visitWhileLoop(WhileLoopTree node, Void p) {
            super.visitWhileLoop(node, p);
            if (this.phase == 3 && !this.secondPass) {
                this.secondPass = true;
                this.scan((Tree)node.getCondition(), p);
                this.scan((Tree)node.getStatement(), p);
                this.secondPass = false;
                this.stopSecondPass = false;
            }
            return null;
        }

        @Override
        public Void visitForLoop(ForLoopTree node, Void p) {
            super.visitForLoop(node, p);
            if (this.phase == 3 && !this.secondPass) {
                this.secondPass = true;
                this.scan((Tree)node.getCondition(), p);
                this.scan(node.getUpdate(), p);
                this.scan((Tree)node.getStatement(), p);
                this.secondPass = false;
                this.stopSecondPass = false;
            }
            return null;
        }

        @Override
        public Void visitDoWhileLoop(DoWhileLoopTree node, Void p) {
            super.visitDoWhileLoop(node, p);
            if (this.phase == 3 && !this.secondPass) {
                this.secondPass = true;
                this.scan((Tree)node.getStatement(), p);
                this.secondPass = false;
                this.stopSecondPass = false;
            }
            return null;
        }

        private String verifyExits(boolean exitsFromAllBranches) {
            int i = 0;
            i += this.hasReturns ? 1 : 0;
            i += this.hasBreaks ? 1 : 0;
            if ((i += this.hasContinues ? 1 : 0) > 1) {
                return "ERR_Too_Many_Different_Exits";
            }
            if ((exitsFromAllBranches ? 0 : i) + this.usedAfterSelection.size() > 1) {
                return "ERR_Too_Many_Return_Values";
            }
            StatementTree breakOrContinueTarget = null;
            boolean returnValueComputed = false;
            TreePath returnValue = null;
            for (TreePath tp : this.selectionExits) {
                if (tp.getLeaf().getKind() == Tree.Kind.RETURN) {
                    Set candidates;
                    TreePath currentReturnValue;
                    if (exitsFromAllBranches) continue;
                    ReturnTree rt = (ReturnTree)tp.getLeaf();
                    TreePath treePath = currentReturnValue = rt.getExpression() != null ? new TreePath(tp, rt.getExpression()) : null;
                    if (!returnValueComputed) {
                        returnValue = currentReturnValue;
                        returnValueComputed = true;
                        continue;
                    }
                    if (!(returnValue != null && currentReturnValue != null ? (candidates = SourceUtils.computeDuplicates((CompilationInfo)this.info, (TreePath)returnValue, (TreePath)currentReturnValue, (AtomicBoolean)this.cancel)).size() != 1 || ((TreePath)candidates.iterator().next()).getLeaf() != rt.getExpression() : returnValue != currentReturnValue)) continue;
                    return "ERR_Different_Return_Values";
                }
                StatementTree target = this.info.getTreeUtilities().getBreakContinueTarget(tp);
                if (breakOrContinueTarget == null) {
                    breakOrContinueTarget = target;
                }
                if (breakOrContinueTarget == target) continue;
                return "ERR_Break_Mismatch";
            }
            return null;
        }
    }
}

