/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.lang.model.type.TypeMirror;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.WrongStringComparisonCustomizer;
import org.netbeans.modules.java.hints.introduce.CopyFinder;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WrongStringComparison
extends AbstractHint {
    private static final String TERNARY_NULL_CHECK = "ternary-null-check";
    private static final String STRING_LITERALS_FIRST = "string-literals-first";
    private static final String STRING_TYPE = "java.lang.String";
    private static final Set<Tree.Kind> TREE_KINDS = EnumSet.of(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO);
    private AtomicBoolean cancel = new AtomicBoolean();

    public WrongStringComparison() {
        super(true, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return TREE_KINDS;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo info, TreePath treePath) {
        TypeMirror rightType;
        this.cancel.set(false);
        Tree t = treePath.getLeaf();
        if (!this.getTreeKinds().contains((Object)t.getKind())) {
            return null;
        }
        BinaryTree bt = (BinaryTree)t;
        TreePath left = new TreePath(treePath, bt.getLeftOperand());
        TreePath right = new TreePath(treePath, bt.getRightOperand());
        Trees trees = info.getTrees();
        TypeMirror leftType = left == null ? null : trees.getTypeMirror(left);
        TypeMirror typeMirror = rightType = right == null ? null : trees.getTypeMirror(right);
        if (leftType != null && rightType != null && STRING_TYPE.equals(((Object)leftType).toString()) && STRING_TYPE.equals(((Object)rightType).toString())) {
            if (this.checkInsideGeneratedEquals(info, treePath, left.getLeaf(), right.getLeaf())) {
                return null;
            }
            FileObject file = info.getFileObject();
            TreePathHandle tph = TreePathHandle.create((TreePath)treePath, (CompilationInfo)info);
            ArrayList<Fix> fixes = new ArrayList<Fix>();
            boolean reverseOperands = false;
            if (bt.getLeftOperand().getKind() != Tree.Kind.STRING_LITERAL) {
                if (bt.getRightOperand().getKind() == Tree.Kind.STRING_LITERAL) {
                    if (this.getStringLiteralsFirst()) {
                        reverseOperands = true;
                    } else {
                        fixes.add(JavaFix.toEditorFix(new WrongStringComparisonFix(tph, WrongStringComparisonFix.Kind.NULL_CHECK)));
                    }
                } else {
                    fixes.add(JavaFix.toEditorFix(new WrongStringComparisonFix(tph, WrongStringComparisonFix.Kind.ternaryNullCheck(this.getTernaryNullCheck()))));
                }
            }
            fixes.add(JavaFix.toEditorFix(new WrongStringComparisonFix(tph, WrongStringComparisonFix.Kind.reverseOperands(reverseOperands))));
            return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(), Collections.unmodifiableList(fixes), (FileObject)info.getFileObject(), (int)((int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), t)), (int)((int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), t))));
        }
        return null;
    }

    @Override
    public void cancel() {
        this.cancel.set(true);
    }

    @Override
    public String getId() {
        return "Wrong_String_Comparison";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(WrongStringComparison.class, (String)"LBL_WrongStringComparison");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(WrongStringComparison.class, (String)"DSC_WrongStringComparison");
    }

    @Override
    public JComponent getCustomizer(Preferences node) {
        return new WrongStringComparisonCustomizer(node);
    }

    private boolean checkInsideGeneratedEquals(CompilationInfo info, TreePath treePath, Tree left, Tree right) {
        TreePath sourcePathParent = treePath.getParentPath();
        if (sourcePathParent.getLeaf().getKind() != Tree.Kind.CONDITIONAL_AND) {
            return false;
        }
        SourcePositions sp = info.getTrees().getSourcePositions();
        Scope s = info.getTrees().getScope(sourcePathParent);
        String leftText = info.getText().substring((int)sp.getStartPosition(info.getCompilationUnit(), left), (int)sp.getEndPosition(info.getCompilationUnit(), left) + 1);
        String rightText = info.getText().substring((int)sp.getStartPosition(info.getCompilationUnit(), right), (int)sp.getEndPosition(info.getCompilationUnit(), right) + 1);
        String code = leftText + " != " + rightText + " && (" + leftText + "== null || !" + leftText + ".equals(" + rightText + "))";
        ExpressionTree correct = info.getTreeUtilities().parseExpression(code, new SourcePositions[1]);
        info.getTreeUtilities().attributeTree((Tree)correct, s);
        TreePath correctPath = new TreePath(sourcePathParent.getParentPath(), correct);
        String originalCode = info.getText().substring((int)sp.getStartPosition(info.getCompilationUnit(), sourcePathParent.getLeaf()), (int)sp.getEndPosition(info.getCompilationUnit(), sourcePathParent.getLeaf()) + 1);
        ExpressionTree original = info.getTreeUtilities().parseExpression(originalCode, new SourcePositions[1]);
        info.getTreeUtilities().attributeTree((Tree)original, s);
        TreePath originalPath = new TreePath(sourcePathParent.getParentPath(), original);
        return CopyFinder.isDuplicate(info, originalPath, correctPath, this.cancel);
    }

    boolean getTernaryNullCheck() {
        return WrongStringComparison.getTernaryNullCheck(this.getPreferences(null));
    }

    boolean getStringLiteralsFirst() {
        return WrongStringComparison.getStringLiteralsFirst(this.getPreferences(null));
    }

    static boolean getTernaryNullCheck(Preferences p) {
        return p.getBoolean(TERNARY_NULL_CHECK, true);
    }

    static boolean getStringLiteralsFirst(Preferences p) {
        return p.getBoolean(STRING_LITERALS_FIRST, true);
    }

    static void setTernaryNullCheck(Preferences p, boolean selected) {
        p.putBoolean(TERNARY_NULL_CHECK, selected);
    }

    static void setStringLiteralsFirst(Preferences p, boolean selected) {
        p.putBoolean(STRING_LITERALS_FIRST, selected);
    }

    static class WrongStringComparisonFix
    extends JavaFix {
        protected final Kind kind;

        public WrongStringComparisonFix(TreePathHandle tph, Kind kind) {
            super(tph);
            this.kind = kind;
        }

        @Override
        public String getText() {
            switch (this.kind) {
                case REVERSE_OPERANDS: {
                    return NbBundle.getMessage(WrongStringComparison.class, (String)"FIX_WrongStringComparison_ReverseOperands");
                }
                case NO_NULL_CHECK: {
                    return NbBundle.getMessage(WrongStringComparison.class, (String)"FIX_WrongStringComparison_NoNullCheck");
                }
                case NULL_CHECK_TERNARY: {
                    return NbBundle.getMessage(WrongStringComparison.class, (String)"FIX_WrongStringComparison_TernaryNullCheck");
                }
            }
            return NbBundle.getMessage(WrongStringComparison.class, (String)"FIX_WrongStringComparison_NullCheck");
        }

        @Override
        protected void performRewrite(WorkingCopy copy, TreePath path, boolean canShowUI) {
            if (path != null) {
                ExpressionTree newTree;
                TreeMaker make = copy.getTreeMaker();
                BinaryTree oldTree = (BinaryTree)path.getLeaf();
                ExpressionTree left = oldTree.getLeftOperand();
                ExpressionTree right = oldTree.getRightOperand();
                if (this.kind == Kind.REVERSE_OPERANDS) {
                    MemberSelectTree rightEquals = make.MemberSelect(right, (CharSequence)"equals");
                    ExpressionTree rightEqualsLeft = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)rightEquals, Collections.singletonList(left));
                    newTree = rightEqualsLeft = this.matchSign(make, oldTree, rightEqualsLeft);
                } else {
                    MemberSelectTree leftEquals = make.MemberSelect(left, (CharSequence)"equals");
                    ExpressionTree leftEqualsRight = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)leftEquals, Collections.singletonList(right));
                    leftEqualsRight = this.matchSign(make, oldTree, leftEqualsRight);
                    if (this.kind == Kind.NO_NULL_CHECK) {
                        newTree = leftEqualsRight;
                    } else {
                        BinaryTree leftEqNull = make.Binary(Tree.Kind.EQUAL_TO, left, (ExpressionTree)make.Identifier((CharSequence)"null"));
                        BinaryTree rightEqNull = make.Binary(oldTree.getKind(), right, (ExpressionTree)make.Identifier((CharSequence)"null"));
                        if (this.kind == Kind.NULL_CHECK_TERNARY) {
                            newTree = make.ConditionalExpression((ExpressionTree)leftEqNull, (ExpressionTree)rightEqNull, leftEqualsRight);
                        } else {
                            BinaryTree leftNeNull = make.Binary(Tree.Kind.NOT_EQUAL_TO, left, (ExpressionTree)make.Identifier((CharSequence)"null"));
                            BinaryTree leftNeNullAndLeftEqualsRight = make.Binary(Tree.Kind.CONDITIONAL_AND, (ExpressionTree)leftNeNull, leftEqualsRight);
                            if (right.getKind() == Tree.Kind.STRING_LITERAL) {
                                newTree = leftNeNullAndLeftEqualsRight;
                            } else {
                                BinaryTree leftEqNullAndRightEqNull = make.Binary(Tree.Kind.CONDITIONAL_AND, (ExpressionTree)leftEqNull, (ExpressionTree)rightEqNull);
                                newTree = make.Binary(Tree.Kind.CONDITIONAL_OR, (ExpressionTree)make.Parenthesized((ExpressionTree)leftEqNullAndRightEqNull), (ExpressionTree)make.Parenthesized((ExpressionTree)leftNeNullAndLeftEqualsRight));
                            }
                        }
                        if (path.getParentPath().getLeaf().getKind() != Tree.Kind.PARENTHESIZED) {
                            newTree = make.Parenthesized(newTree);
                        }
                    }
                }
                copy.rewrite((Tree)oldTree, (Tree)newTree);
            }
        }

        ExpressionTree matchSign(TreeMaker make, BinaryTree oldTree, ExpressionTree et) {
            if (oldTree.getKind() == Tree.Kind.NOT_EQUAL_TO) {
                return make.Unary(Tree.Kind.LOGICAL_COMPLEMENT, et);
            }
            return et;
        }

        static enum Kind {
            REVERSE_OPERANDS,
            NO_NULL_CHECK,
            NULL_CHECK,
            NULL_CHECK_TERNARY;


            public static Kind ternaryNullCheck(boolean ternary) {
                return ternary ? NULL_CHECK_TERNARY : NULL_CHECK;
            }

            public static Kind reverseOperands(boolean reverseOperands) {
                return reverseOperands ? REVERSE_OPERANDS : NO_NULL_CHECK;
            }
        }
    }
}

