/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.LoggerNotStaticFinal;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class SystemOut {
    public static ErrorDescription checkSystemOut(HintContext ctx) {
        TreePath treePath = ctx.getPath();
        CompilationInfo compilationInfo = ctx.getInfo();
        return ErrorDescriptionFactory.forName(ctx, treePath, NbBundle.getMessage(SystemOut.class, (String)"MSG_SystemOut"), JavaFix.toEditorFix(new FixImpl(NbBundle.getMessage(LoggerNotStaticFinal.class, (String)"MSG_SystemOut_fix"), TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo))));
    }

    private static final class FixImpl
    extends JavaFix {
        private final String text;

        public FixImpl(String text, TreePathHandle loggerFieldHandle) {
            super(loggerFieldHandle);
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        protected void performRewrite(WorkingCopy wc, TreePath statementPath, boolean canShowUI) {
            TreePath blockPath = statementPath.getParentPath();
            while (!(blockPath.getLeaf() instanceof BlockTree)) {
                statementPath = blockPath;
                if ((blockPath = blockPath.getParentPath()) != null) continue;
                return;
            }
            BlockTree blockTree = (BlockTree)blockPath.getLeaf();
            List<? extends StatementTree> statements = blockTree.getStatements();
            ArrayList<StatementTree> newStatements = new ArrayList<StatementTree>();
            for (StatementTree statementTree : statements) {
                if (statementTree == statementPath.getLeaf()) continue;
                newStatements.add(statementTree);
            }
            BlockTree newBlockTree = wc.getTreeMaker().Block(newStatements, blockTree.isStatic());
            wc.rewrite((Tree)blockTree, (Tree)newBlockTree);
        }
    }
}

